/*
 * Decompiled with CFR 0.152.
 */
package org.joni.ast;

import java.util.Set;
import org.joni.WarnCallback;
import org.joni.constants.NodeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Node
implements NodeType {
    public Node parent;

    public abstract int getType();

    public final int getType2Bit() {
        return 1 << this.getType();
    }

    protected void setChild(Node node) {
    }

    protected Node getChild() {
        return null;
    }

    public void swap(Node node) {
        if (this.parent != null) {
            this.parent.setChild(node);
        }
        if (node.parent != null) {
            node.parent.setChild(this);
        }
        Node node2 = this.parent;
        this.parent = node.parent;
        node.parent = node2;
    }

    public void verifyTree(Set<Node> set, WarnCallback warnCallback) {
        if (!set.contains(this) && this.getChild() != null) {
            set.add(this);
            if (this.getChild().parent != this) {
                warnCallback.warn("broken link to child: " + this.getAddressName() + " -> " + this.getChild().getAddressName());
            }
            this.getChild().verifyTree(set, warnCallback);
        }
    }

    public abstract String getName();

    protected abstract String toString(int var1);

    public String getAddressName() {
        return this.getName() + ":0x" + Integer.toHexString(System.identityHashCode(this));
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<" + this.getAddressName() + ">");
        stringBuilder.append("\n  parent: " + (this.parent == null ? "NULL" : this.parent.getAddressName()));
        return stringBuilder + this.toString(0);
    }

    protected static String pad(Object object, int n) {
        if (object == null) {
            return "NULL";
        }
        StringBuilder stringBuilder = new StringBuilder("  ");
        for (int i = 0; i < n; ++i) {
            stringBuilder.append((CharSequence)stringBuilder);
        }
        return object.toString().replace("\n", "\n" + stringBuilder);
    }

    public final boolean isInvalidQuantifier() {
        return false;
    }

    public final boolean isAllowedInLookBehind() {
        return (this.getType2Bit() & 0x7EF) != 0;
    }

    public final boolean isSimple() {
        return (this.getType2Bit() & 0x1F) != 0;
    }
}

