/*
 * Decompiled with CFR 0.152.
 */
package org.joni.ast;

import java.util.Set;
import org.joni.UnsetAddrList;
import org.joni.WarnCallback;
import org.joni.ast.Node;
import org.joni.ast.StateNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CallNode
extends StateNode {
    public byte[] name;
    public int nameP;
    public int nameEnd;
    public int groupNum;
    public Node target;
    public UnsetAddrList unsetAddrList;

    public CallNode(byte[] byArray, int n, int n2, int n3) {
        this.name = byArray;
        this.nameP = n;
        this.nameEnd = n2;
        this.groupNum = n3;
    }

    @Override
    public int getType() {
        return 10;
    }

    @Override
    protected void setChild(Node node) {
        this.target = node;
    }

    @Override
    protected Node getChild() {
        return this.target;
    }

    public void setTarget(Node node) {
        this.target = node;
        node.parent = this;
    }

    @Override
    public String getName() {
        return "Call";
    }

    @Override
    public void verifyTree(Set<Node> set, WarnCallback warnCallback) {
        if (this.target == null || this.target.parent == this) {
            warnCallback.warn(this.getAddressName() + " doesn't point to a target or the target has been stolen");
        }
    }

    @Override
    public String toString(int n) {
        StringBuilder stringBuilder = new StringBuilder(super.toString(n));
        stringBuilder.append("\n  name: " + new String(this.name, this.nameP, this.nameEnd - this.nameP));
        stringBuilder.append("\n  groupNum: " + this.groupNum);
        stringBuilder.append("\n  target: " + CallNode.pad(this.target.getAddressName(), n + 1));
        stringBuilder.append("\n  unsetAddrList: " + CallNode.pad(this.unsetAddrList, n + 1));
        return stringBuilder.toString();
    }
}

