/*
 * Decompiled with CFR 0.152.
 */
package org.joni;

import java.util.IllegalFormatConversionException;
import java.util.Iterator;
import org.jcodings.Encoding;
import org.jcodings.util.BytesHash;
import org.joni.Analyser;
import org.joni.Matcher;
import org.joni.MatcherFactory;
import org.joni.MinMaxLen;
import org.joni.NameEntry;
import org.joni.OptAnchorInfo;
import org.joni.OptExactInfo;
import org.joni.OptMapInfo;
import org.joni.Option;
import org.joni.Region;
import org.joni.ScanEnvironment;
import org.joni.SearchAlgorithm;
import org.joni.Syntax;
import org.joni.WarnCallback;
import org.joni.constants.RegexState;
import org.joni.exception.InternalException;
import org.joni.exception.ValueException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Regex
implements RegexState {
    int[] code;
    int codeLength;
    boolean stackNeeded;
    Object[] operands;
    int operandLength;
    int state;
    int numMem;
    int numRepeat;
    int numNullCheck;
    int numCombExpCheck;
    int numCall;
    int captureHistory;
    int btMemStart;
    int btMemEnd;
    int stackPopLevel;
    int[] repeatRangeLo;
    int[] repeatRangeHi;
    public WarnCallback warnings;
    public MatcherFactory factory;
    final Encoding enc;
    int options;
    int userOptions;
    Object userObject;
    final int caseFoldFlag;
    BytesHash<NameEntry> nameTable;
    SearchAlgorithm searchAlgorithm;
    int thresholdLength;
    int anchor;
    int anchorDmin;
    int anchorDmax;
    int subAnchor;
    byte[] exact;
    int exactP;
    int exactEnd;
    byte[] map;
    int[] intMap;
    int[] intMapBackward;
    int dMin;
    int dMax;

    public Regex(byte[] byArray, int n, int n2, int n3, Encoding encoding2) {
        this(byArray, n, n2, n3, encoding2, Syntax.RUBY, WarnCallback.DEFAULT);
    }

    public Regex(byte[] byArray, int n, int n2, int n3, Encoding encoding2, Syntax syntax) {
        this(byArray, n, n2, n3, 0x40000000, encoding2, syntax, WarnCallback.DEFAULT);
    }

    public Regex(byte[] byArray, int n, int n2, int n3, Encoding encoding2, WarnCallback warnCallback) {
        this(byArray, n, n2, n3, encoding2, Syntax.RUBY, warnCallback);
    }

    public Regex(byte[] byArray, int n, int n2, int n3, Encoding encoding2, Syntax syntax, WarnCallback warnCallback) {
        this(byArray, n, n2, n3, 0x40000000, encoding2, syntax, warnCallback);
    }

    public Regex(byte[] byArray, int n, int n2, int n3, int n4, Encoding encoding2, Syntax syntax, WarnCallback warnCallback) {
        if ((n3 & 0x180) == 384) {
            throw new ValueException("invalid combination of options");
        }
        if ((n3 & 0x40) != 0) {
            n3 |= syntax.options;
            n3 &= 0xFFFFFFF7;
        } else {
            n3 |= syntax.options;
        }
        this.enc = encoding2;
        this.options = n3;
        this.caseFoldFlag = n4;
        this.warnings = warnCallback;
        new Analyser(new ScanEnvironment(this, syntax), byArray, n, n2).compile();
        this.warnings = null;
    }

    public Matcher matcher(byte[] byArray) {
        return this.matcher(byArray, 0, byArray.length);
    }

    public Matcher matcher(byte[] byArray, int n, int n2) {
        return this.factory.create(this, byArray, n, n2);
    }

    public int numberOfCaptures() {
        return this.numMem;
    }

    public int numberOfCaptureHistories() {
        return 0;
    }

    String nameTableToString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.nameTable != null) {
            stringBuilder.append("name table\n");
            for (NameEntry nameEntry : this.nameTable) {
                stringBuilder.append("  " + nameEntry + "\n");
            }
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    NameEntry nameFind(byte[] byArray, int n, int n2) {
        if (this.nameTable != null) {
            return this.nameTable.get(byArray, n, n2);
        }
        return null;
    }

    void renumberNameTable(int[] nArray) {
        if (this.nameTable != null) {
            for (NameEntry nameEntry : this.nameTable) {
                if (nameEntry.backNum > 1) {
                    for (int i = 0; i < nameEntry.backNum; ++i) {
                        nameEntry.backRefs[i] = nArray[nameEntry.backRefs[i]];
                    }
                    continue;
                }
                if (nameEntry.backNum != 1) continue;
                nameEntry.backRef1 = nArray[nameEntry.backRef1];
            }
        }
    }

    public int numberOfNames() {
        return this.nameTable == null ? 0 : this.nameTable.size();
    }

    void nameAdd(byte[] byArray, int n, int n2, int n3, Syntax syntax) {
        if (n2 - n <= 0) {
            throw new ValueException("group name is empty");
        }
        NameEntry nameEntry = null;
        if (this.nameTable == null) {
            this.nameTable = new BytesHash();
        } else {
            nameEntry = this.nameFind(byArray, n, n2);
        }
        if (nameEntry == null) {
            nameEntry = new NameEntry(byArray, n, n2);
            this.nameTable.putDirect(byArray, n, n2, nameEntry);
        } else if (nameEntry.backNum >= 1 && !syntax.allowMultiplexDefinitionName()) {
            throw new ValueException("multiplex defined name <%n>", new String(byArray, n, n2 - n));
        }
        nameEntry.addBackref(n3);
    }

    NameEntry nameToGroupNumbers(byte[] byArray, int n, int n2) {
        return this.nameFind(byArray, n, n2);
    }

    public int nameToBackrefNumber(byte[] byArray, int n, int n2, Region region) {
        NameEntry nameEntry = this.nameToGroupNumbers(byArray, n, n2);
        if (nameEntry == null) {
            throw new ValueException("undefined name <%n> reference", new String(byArray, n, n2 - n));
        }
        switch (nameEntry.backNum) {
            case 0: {
                throw new InternalException("internal parser error (bug)");
            }
            case 1: {
                return nameEntry.backRef1;
            }
        }
        if (region != null) {
            for (int i = nameEntry.backNum - 1; i >= 0; --i) {
                if (region.beg[nameEntry.backRefs[i]] == -1) continue;
                return nameEntry.backRefs[i];
            }
        }
        return nameEntry.backRefs[nameEntry.backNum - 1];
    }

    public Iterator<NameEntry> namedBackrefIterator() {
        return this.nameTable.iterator();
    }

    public boolean noNameGroupIsActive(Syntax syntax) {
        if (Option.isDontCaptureGroup(this.options)) {
            return false;
        }
        return this.numberOfNames() <= 0 || !syntax.captureOnlyNamedGroup() || Option.isCaptureGroup(this.options);
    }

    void setupBMSkipMap() {
        byte[] byArray = this.exact;
        int n = this.exactEnd;
        int n2 = this.exactP;
        int n3 = n - n2;
        if (n3 < 256) {
            int n4;
            if (this.map == null) {
                this.map = new byte[256];
            }
            for (n4 = 0; n4 < 256; ++n4) {
                this.map[n4] = (byte)n3;
            }
            for (n4 = 0; n4 < n3 - 1; ++n4) {
                this.map[byArray[n2 + n4] & 0xFF] = (byte)(n3 - 1 - n4);
            }
        } else {
            if (this.intMap == null) {
                this.intMap = new int[256];
            }
            for (int i = 0; i < n3 - 1; ++i) {
                this.intMap[byArray[n2 + i] & 0xFF] = n3 - 1 - i;
            }
        }
    }

    void setExactInfo(OptExactInfo optExactInfo) {
        if (optExactInfo.length == 0) {
            return;
        }
        this.exact = optExactInfo.s;
        this.exactP = 0;
        this.exactEnd = optExactInfo.length;
        if (optExactInfo.ignoreCase) {
            this.searchAlgorithm = this.enc.toLowerCaseTable() != null ? SearchAlgorithm.SLOW_IC_SB : new SearchAlgorithm.SLOW_IC(this);
        } else {
            boolean bl = this.enc.isReverseMatchAllowed(this.exact, this.exactP, this.exactEnd);
            if (optExactInfo.length >= 3 || optExactInfo.length >= 2 && bl) {
                this.setupBMSkipMap();
                this.searchAlgorithm = bl ? SearchAlgorithm.BM : SearchAlgorithm.BM_NOT_REV;
            } else {
                this.searchAlgorithm = this.enc.isSingleByte() ? SearchAlgorithm.SLOW_SB : SearchAlgorithm.SLOW;
            }
        }
        this.dMin = optExactInfo.mmd.min;
        this.dMax = optExactInfo.mmd.max;
        if (this.dMin != Integer.MAX_VALUE) {
            this.thresholdLength = this.dMin + (this.exactEnd - this.exactP);
        }
    }

    void setOptimizeMapInfo(OptMapInfo optMapInfo) {
        this.map = optMapInfo.map;
        this.searchAlgorithm = this.enc.isSingleByte() ? SearchAlgorithm.MAP_SB : SearchAlgorithm.MAP;
        this.dMin = optMapInfo.mmd.min;
        this.dMax = optMapInfo.mmd.max;
        if (this.dMin != Integer.MAX_VALUE) {
            this.thresholdLength = this.dMin + 1;
        }
    }

    void setSubAnchor(OptAnchorInfo optAnchorInfo) {
        this.subAnchor |= optAnchorInfo.leftAnchor & 2;
        this.subAnchor |= optAnchorInfo.rightAnchor & 0x20;
    }

    void clearOptimizeInfo() {
        this.searchAlgorithm = SearchAlgorithm.NONE;
        this.anchor = 0;
        this.anchorDmax = 0;
        this.anchorDmin = 0;
        this.subAnchor = 0;
        this.exact = null;
        this.exactEnd = 0;
        this.exactP = 0;
    }

    public String encStringToString(byte[] byArray, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder("\nPATTERN: /");
        if (this.enc.minLength() > 1) {
            for (int i = n; i < n2; i += this.enc.length(byArray, i, n2)) {
                int n3 = this.enc.mbcToCode(byArray, i, n2);
                if (n3 >= 128) {
                    try {
                        stringBuilder.append(String.format(" 0x%04x ", n3));
                    }
                    catch (IllegalFormatConversionException illegalFormatConversionException) {
                        stringBuilder.append(n3);
                    }
                    continue;
                }
                stringBuilder.append((char)n3);
            }
        } else {
            while (n < n2) {
                stringBuilder.append(new String(new byte[]{byArray[n]}));
                ++n;
            }
        }
        return stringBuilder.append("/").toString();
    }

    public String optimizeInfoToString() {
        String string2 = "";
        string2 = string2 + "optimize: " + this.searchAlgorithm.getName() + "\n";
        string2 = string2 + "  anchor:     " + OptAnchorInfo.anchorToString(this.anchor);
        if ((this.anchor & 0x18) != 0) {
            string2 = string2 + MinMaxLen.distanceRangeToString(this.anchorDmin, this.anchorDmax);
        }
        string2 = string2 + "\n";
        if (this.searchAlgorithm != SearchAlgorithm.NONE) {
            string2 = string2 + "  sub anchor: " + OptAnchorInfo.anchorToString(this.subAnchor) + "\n";
        }
        string2 = string2 + "dmin: " + this.dMin + " dmax: " + this.dMax + "\n";
        string2 = string2 + "threshold length: " + this.thresholdLength + "\n";
        if (this.exact != null) {
            string2 = string2 + "exact: [" + new String(this.exact, this.exactP, this.exactEnd - this.exactP) + "]: length: " + (this.exactEnd - this.exactP) + "\n";
        } else if (this.searchAlgorithm == SearchAlgorithm.MAP || this.searchAlgorithm == SearchAlgorithm.MAP_SB) {
            int n;
            int n2 = 0;
            for (n = 0; n < 256; ++n) {
                if (this.map[n] == 0) continue;
                ++n2;
            }
            string2 = string2 + "map: n = " + n2 + "\n";
            if (n2 > 0) {
                n = 0;
                string2 = string2 + "[";
                for (int i = 0; i < 256; ++i) {
                    if (this.map[i] == 0) continue;
                    if (n > 0) {
                        string2 = string2 + ", ";
                    }
                    ++n;
                    string2 = this.enc.maxLength() == 1 && this.enc.isPrint(i) ? string2 + (char)i : string2 + i;
                }
                string2 = string2 + "]\n";
            }
        }
        return string2;
    }

    public Encoding getEncoding() {
        return this.enc;
    }

    public int getOptions() {
        return this.options;
    }

    public void setUserOptions(int n) {
        this.userOptions = n;
    }

    public int getUserOptions() {
        return this.userOptions;
    }

    public void setUserObject(Object object) {
        this.userObject = object;
    }

    public Object getUserObject() {
        return this.userObject;
    }
}

