/*
 * Decompiled with CFR 0.152.
 */
package org.joni;

import org.jcodings.Encoding;
import org.joni.MinMaxLen;
import org.joni.OptAnchorInfo;
import org.joni.OptEnvironment;
import org.joni.OptMapInfo;

final class OptExactInfo {
    static final int OPT_EXACT_MAXLEN = 24;
    final MinMaxLen mmd = new MinMaxLen();
    final OptAnchorInfo anchor = new OptAnchorInfo();
    boolean reachEnd;
    boolean ignoreCase;
    int length;
    final byte[] s = new byte[24];
    private static final int COMP_EM_BASE = 20;

    OptExactInfo() {
    }

    boolean isFull() {
        return this.length >= 24;
    }

    void clear() {
        this.mmd.clear();
        this.anchor.clear();
        this.reachEnd = false;
        this.ignoreCase = false;
        this.length = 0;
        this.s[0] = 0;
    }

    void copy(OptExactInfo optExactInfo) {
        this.mmd.copy(optExactInfo.mmd);
        this.anchor.copy(optExactInfo.anchor);
        this.reachEnd = optExactInfo.reachEnd;
        this.ignoreCase = optExactInfo.ignoreCase;
        this.length = optExactInfo.length;
        System.arraycopy(optExactInfo.s, 0, this.s, 0, 24);
    }

    void concat(OptExactInfo optExactInfo, Encoding encoding2) {
        int n;
        if (!this.ignoreCase && optExactInfo.ignoreCase) {
            if (this.length >= optExactInfo.length) {
                return;
            }
            this.ignoreCase = true;
        }
        int n2 = 0;
        int n3 = n2 + optExactInfo.length;
        int n4 = this.length;
        while (n2 < n3 && n4 + (n = encoding2.length(optExactInfo.s, n2, n3)) <= 24) {
            for (int i = 0; i < n && n2 < n3; ++i) {
                this.s[n4++] = optExactInfo.s[n2++];
            }
        }
        this.length = n4;
        this.reachEnd = n2 == n3 ? optExactInfo.reachEnd : false;
        OptAnchorInfo optAnchorInfo = new OptAnchorInfo();
        optAnchorInfo.concat(this.anchor, optExactInfo.anchor, 1, 1);
        if (!optExactInfo.reachEnd) {
            optAnchorInfo.rightAnchor = 0;
        }
        this.anchor.copy(optAnchorInfo);
    }

    void concatStr(byte[] byArray, int n, int n2, boolean bl, Encoding encoding2) {
        int n3;
        int n4 = this.length;
        while (n < n2 && n4 < 24 && n4 + (n3 = encoding2.length(byArray, n, n2)) <= 24) {
            for (int i = 0; i < n3 && n < n2; ++i) {
                this.s[n4++] = byArray[n++];
            }
        }
        this.length = n4;
    }

    void altMerge(OptExactInfo optExactInfo, OptEnvironment optEnvironment) {
        int n;
        int n2;
        if (optExactInfo.length == 0 || this.length == 0) {
            this.clear();
            return;
        }
        if (!this.mmd.equal(optExactInfo.mmd)) {
            this.clear();
            return;
        }
        for (n = 0; n < this.length && n < optExactInfo.length && this.s[n] == optExactInfo.s[n]; n += n2) {
            int n3;
            n2 = optEnvironment.enc.length(this.s, n, this.length);
            for (n3 = 1; n3 < n2 && this.s[n + n3] == optExactInfo.s[n + n3]; ++n3) {
            }
            if (n3 < n2) break;
        }
        if (!optExactInfo.reachEnd || n < optExactInfo.length || n < this.length) {
            this.reachEnd = false;
        }
        this.length = n;
        this.ignoreCase |= optExactInfo.ignoreCase;
        this.anchor.altMerge(optExactInfo.anchor);
        if (!this.reachEnd) {
            this.anchor.rightAnchor = 0;
        }
    }

    void select(OptExactInfo optExactInfo, Encoding encoding2) {
        int n = this.length;
        int n2 = optExactInfo.length;
        if (n2 == 0) {
            return;
        }
        if (n == 0) {
            this.copy(optExactInfo);
            return;
        }
        if (n <= 2 && n2 <= 2) {
            n2 = OptMapInfo.positionValue(encoding2, this.s[0] & 0xFF);
            n = OptMapInfo.positionValue(encoding2, optExactInfo.s[0] & 0xFF);
            if (this.length > 1) {
                n += 5;
            }
            if (optExactInfo.length > 1) {
                n2 += 5;
            }
        }
        if (!this.ignoreCase) {
            n *= 2;
        }
        if (!optExactInfo.ignoreCase) {
            n2 *= 2;
        }
        if (this.mmd.compareDistanceValue(optExactInfo.mmd, n, n2) > 0) {
            this.copy(optExactInfo);
        }
    }

    int compare(OptMapInfo optMapInfo) {
        if (optMapInfo.value <= 0) {
            return -1;
        }
        int n = 20 * this.length * (this.ignoreCase ? 1 : 2);
        int n2 = 200 / optMapInfo.value;
        return this.mmd.compareDistanceValue(optMapInfo.mmd, n, n2);
    }
}

