/*
 * Decompiled with CFR 0.152.
 */
package org.joni;

import org.joni.constants.AnchorType;

final class OptAnchorInfo
implements AnchorType {
    int leftAnchor;
    int rightAnchor;

    OptAnchorInfo() {
    }

    void clear() {
        this.rightAnchor = 0;
        this.leftAnchor = 0;
    }

    void copy(OptAnchorInfo optAnchorInfo) {
        this.leftAnchor = optAnchorInfo.leftAnchor;
        this.rightAnchor = optAnchorInfo.rightAnchor;
    }

    void concat(OptAnchorInfo optAnchorInfo, OptAnchorInfo optAnchorInfo2, int n, int n2) {
        this.leftAnchor = optAnchorInfo.leftAnchor;
        if (n == 0) {
            this.leftAnchor |= optAnchorInfo2.leftAnchor;
        }
        this.rightAnchor = optAnchorInfo2.rightAnchor;
        if (n2 == 0) {
            this.rightAnchor |= optAnchorInfo.rightAnchor;
        }
    }

    boolean isSet(int n) {
        if ((this.leftAnchor & n) != 0) {
            return true;
        }
        return (this.rightAnchor & n) != 0;
    }

    void add(int n) {
        if (OptAnchorInfo.isLeftAnchor(n)) {
            this.leftAnchor |= n;
        } else {
            this.rightAnchor |= n;
        }
    }

    void remove(int n) {
        if (OptAnchorInfo.isLeftAnchor(n)) {
            this.leftAnchor &= ~n;
        } else {
            this.rightAnchor &= ~n;
        }
    }

    void altMerge(OptAnchorInfo optAnchorInfo) {
        this.leftAnchor &= optAnchorInfo.leftAnchor;
        this.rightAnchor &= optAnchorInfo.rightAnchor;
    }

    static boolean isLeftAnchor(int n) {
        return n != 8 && n != 16 && n != 32 && n != 1024 && n != 2048;
    }

    static String anchorToString(int n) {
        StringBuffer stringBuffer = new StringBuffer("[");
        if ((n & 1) != 0) {
            stringBuffer.append("begin-buf ");
        }
        if ((n & 2) != 0) {
            stringBuffer.append("begin-line ");
        }
        if ((n & 4) != 0) {
            stringBuffer.append("begin-pos ");
        }
        if ((n & 8) != 0) {
            stringBuffer.append("end-buf ");
        }
        if ((n & 0x10) != 0) {
            stringBuffer.append("semi-end-buf ");
        }
        if ((n & 0x20) != 0) {
            stringBuffer.append("end-line ");
        }
        if ((n & 0x4000) != 0) {
            stringBuffer.append("anychar-star ");
        }
        if ((n & 0x8000) != 0) {
            stringBuffer.append("anychar-star-pl ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

