/*
 * Decompiled with CFR 0.152.
 */
package org.joni;

import org.jcodings.Encoding;
import org.jcodings.IntHolder;
import org.joni.Option;
import org.joni.Regex;
import org.joni.Region;
import org.joni.SearchAlgorithm;

public abstract class Matcher
extends IntHolder {
    protected final Regex regex;
    protected final Encoding enc;
    protected final byte[] bytes;
    protected final int str;
    protected final int end;
    protected int msaStart;
    protected int msaOptions;
    protected final Region msaRegion;
    protected int msaBestLen;
    protected int msaBestS;
    protected int msaBegin;
    protected int msaEnd;
    int low;
    int high;

    public Matcher(Regex regex, byte[] byArray) {
        this(regex, byArray, 0, byArray.length);
    }

    public Matcher(Regex regex, byte[] byArray, int n, int n2) {
        this.regex = regex;
        this.enc = regex.enc;
        this.bytes = byArray;
        this.str = n;
        this.end = n2;
        this.msaRegion = regex.numMem == 0 ? null : new Region(regex.numMem + 1);
    }

    protected abstract int matchAt(int var1, int var2, int var3);

    protected abstract void stateCheckBuffInit(int var1, int var2, int var3);

    protected abstract void stateCheckBuffClear();

    public final Region getRegion() {
        return this.msaRegion;
    }

    public final Region getEagerRegion() {
        return this.msaRegion != null ? this.msaRegion : new Region(this.msaBegin, this.msaEnd);
    }

    public final int getBegin() {
        return this.msaBegin;
    }

    public final int getEnd() {
        return this.msaEnd;
    }

    protected final void msaInit(int n, int n2) {
        this.msaOptions = n;
        this.msaStart = n2;
        this.msaBestLen = -1;
    }

    public final int match(int n, int n2, int n3) {
        this.msaInit(n3, n);
        int n4 = this.enc.prevCharHead(this.bytes, this.str, n, this.end);
        return this.matchAt(n2, n, n4);
    }

    private boolean forwardSearchRange(byte[] byArray, int n, int n2, int n3, int n4, IntHolder intHolder) {
        int n5;
        int n6;
        int n7 = -1;
        if (this.regex.dMin > 0) {
            if (this.enc.isSingleByte()) {
                n6 += this.regex.dMin;
            } else {
                n5 = n6 + this.regex.dMin;
                for (n6 = n3; n6 < n5; n6 += this.enc.length(byArray, n6, n2)) {
                }
            }
        }
        block5: while ((n6 = this.regex.searchAlgorithm.search(this.regex, byArray, n6, n2, n4)) != -1 && n6 < n4) {
            if (n6 - this.regex.dMin < n3) {
                n7 = n6;
                n6 += this.enc.length(byArray, n6, n2);
                continue;
            }
            if (this.regex.subAnchor != 0) {
                switch (this.regex.subAnchor) {
                    case 2: {
                        if (n6 == n || this.enc.isNewLine(byArray, n5 = this.enc.prevCharHead(byArray, n7 != -1 ? n7 : n, n6, n2), n2)) break;
                        n7 = n6;
                        n6 += this.enc.length(byArray, n6, n2);
                        continue block5;
                    }
                    case 32: {
                        if (n6 == n2 || this.enc.isNewLine(byArray, n6, n2)) break;
                        n7 = n6;
                        n6 += this.enc.length(byArray, n6, n2);
                        continue block5;
                    }
                }
            }
            if (this.regex.dMax == 0) {
                this.low = n6;
                if (intHolder != null) {
                    intHolder.value = this.low > n3 ? this.enc.prevCharHead(byArray, n3, n6, n2) : this.enc.prevCharHead(byArray, n7 != -1 ? n7 : n, n6, n2);
                }
            } else if (this.regex.dMax != Integer.MAX_VALUE) {
                this.low = n6 - this.regex.dMax;
                if (this.low > n3) {
                    this.low = this.enc.rightAdjustCharHeadWithPrev(byArray, n3, this.low, n2, intHolder);
                    if (intHolder != null && intHolder.value == -1) {
                        intHolder.value = this.enc.prevCharHead(byArray, n7 != -1 ? n7 : n3, this.low, n2);
                    }
                } else if (intHolder != null) {
                    intHolder.value = this.enc.prevCharHead(byArray, n7 != -1 ? n7 : n, this.low, n2);
                }
            }
            this.high = n6 - this.regex.dMin;
            return true;
        }
        return false;
    }

    private boolean backwardSearchRange(byte[] byArray, int n, int n2, int n3, int n4, int n5) {
        n4 += this.regex.dMin;
        int n6 = n3;
        block4: while ((n6 = this.regex.searchAlgorithm.searchBackward(this.regex, byArray, n4, n5, n2, n6, n3, n4)) != -1) {
            if (this.regex.subAnchor != 0) {
                switch (this.regex.subAnchor) {
                    case 2: {
                        int n7;
                        if (n6 == n || this.enc.isNewLine(byArray, n7 = this.enc.prevCharHead(byArray, n, n6, n2), n2)) break;
                        n6 = n7;
                        continue block4;
                    }
                    case 32: {
                        if (n6 == n2 || this.enc.isNewLine(byArray, n6, n2)) break;
                        if ((n6 = this.enc.prevCharHead(byArray, n5, n6, n2)) != -1) continue block4;
                        return false;
                    }
                }
            }
            if (this.regex.dMax != Integer.MAX_VALUE) {
                this.low = n6 - this.regex.dMax;
                this.high = n6 - this.regex.dMin;
                this.high = this.enc.rightAdjustCharHead(byArray, n5, this.high, n2);
            }
            return true;
        }
        return false;
    }

    private boolean matchCheck(int n, int n2, int n3) {
        return this.matchAt(this.end, n2, n3) != -1 && !Option.isFindLongest(this.regex.options);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final int search(int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7 = n;
        int n8 = n2;
        if (n > this.end || n < this.str) {
            return -1;
        }
        if (this.regex.anchor != 0 && this.str < this.end) {
            if ((this.regex.anchor & 4) != 0) {
                n2 = n2 > n ? n + 1 : n;
            } else if ((this.regex.anchor & 1) != 0) {
                if (n2 > n) {
                    if (n != this.str) {
                        return -1;
                    }
                    n2 = this.str + 1;
                } else {
                    if (n2 > this.str) return -1;
                    n = this.str;
                    n2 = this.str;
                }
            } else if ((this.regex.anchor & 8) != 0) {
                n6 = this.end;
                n5 = n6;
                if (this.endBuf(n, n2, n5, n6)) {
                    return -1;
                }
            } else if ((this.regex.anchor & 0x10) != 0) {
                int n9 = this.enc.stepBack(this.bytes, this.str, this.end, this.end, 1);
                n6 = this.end;
                if (this.enc.isNewLine(this.bytes, n9, this.end) ? (n5 = n9) > this.str && n <= n5 && this.endBuf(n, n2, n5, n6) : this.endBuf(n, n2, n5 = this.end, n6)) {
                    return -1;
                }
            } else if ((this.regex.anchor & 0x8000) != 0) {
                n2 = n2 > n ? n + 1 : n;
            }
        } else if (this.str == this.end) {
            if (this.regex.thresholdLength != 0) return -1;
            int n10 = n = this.str;
            int n11 = -1;
            this.msaInit(n3, n);
            if (!this.matchCheck(this.end, n10, n11)) return this.mismatch();
            return this.match(n10);
        }
        this.msaInit(n3, n7);
        int n12 = n;
        if (n2 > n) {
            int n13 = n12 > this.str ? this.enc.prevCharHead(this.bytes, this.str, n12, this.end) : 0;
            if (this.regex.searchAlgorithm != SearchAlgorithm.NONE) {
                n5 = n2;
                if (this.regex.dMax != 0) {
                    if (this.regex.dMax == Integer.MAX_VALUE) {
                        n5 = this.end;
                    } else if ((n5 += this.regex.dMax) > this.end) {
                        n5 = this.end;
                    }
                }
                if (this.end - n < this.regex.thresholdLength) {
                    return this.mismatch();
                }
                if (this.regex.dMax != Integer.MAX_VALUE) {
                    do {
                        if (!this.forwardSearchRange(this.bytes, this.str, this.end, n12, n5, this)) {
                            return this.mismatch();
                        }
                        if (n12 < this.low) {
                            n12 = this.low;
                            n13 = this.value;
                        }
                        while (n12 <= this.high) {
                            if (this.matchCheck(n8, n12, n13)) {
                                return this.match(n12);
                            }
                            n13 = n12;
                            n12 += this.enc.length(this.bytes, n12, this.end);
                        }
                    } while (n12 < n2);
                    return this.mismatch();
                }
                if (!this.forwardSearchRange(this.bytes, this.str, this.end, n12, n5, null)) {
                    return this.mismatch();
                }
                if ((this.regex.anchor & 0x4000) != 0) {
                    do {
                        if (this.matchCheck(n8, n12, n13)) {
                            return this.match(n12);
                        }
                        n13 = n12;
                        n12 += this.enc.length(this.bytes, n12, this.end);
                        while (!this.enc.isNewLine(this.bytes, n13, this.end) && n12 < n2) {
                            n13 = n12;
                            n12 += this.enc.length(this.bytes, n12, this.end);
                        }
                    } while (n12 < n2);
                    return this.mismatch();
                }
            }
            do {
                if (this.matchCheck(n8, n12, n13)) {
                    return this.match(n12);
                }
                n13 = n12;
            } while ((n12 += this.enc.length(this.bytes, n12, this.end)) < n2);
            if (n12 != n2 || !this.matchCheck(n8, n12, n13)) return this.mismatch();
            return this.match(n12);
        }
        if (this.regex.searchAlgorithm != SearchAlgorithm.NONE) {
            n5 = n2 < this.end ? this.enc.leftAdjustCharHead(this.bytes, this.str, n2, this.end) : this.end;
            if (this.regex.dMax != Integer.MAX_VALUE && this.end - n2 >= this.regex.thresholdLength) {
                do {
                    if ((n6 = n12 + this.regex.dMax) > this.end) {
                        n6 = this.end;
                    }
                    if (!this.backwardSearchRange(this.bytes, this.str, this.end, n6, n2, n5)) {
                        return this.mismatch();
                    }
                    if (n12 > this.high) {
                        n12 = this.high;
                    }
                    while (n12 != -1 && n12 >= this.low) {
                        int n14 = this.enc.prevCharHead(this.bytes, this.str, n12, this.end);
                        if (this.matchCheck(n7, n12, n14)) {
                            return this.match(n12);
                        }
                        n12 = n14;
                    }
                } while (n12 >= n2);
                return this.mismatch();
            }
            if (this.end - n2 < this.regex.thresholdLength) {
                return this.mismatch();
            }
            n6 = n12;
            if (this.regex.dMax != 0) {
                n6 = this.regex.dMax == Integer.MAX_VALUE ? this.end : ((n6 += this.regex.dMax) > this.end ? this.end : this.enc.leftAdjustCharHead(this.bytes, n, n6, this.end));
            }
            if (!this.backwardSearchRange(this.bytes, this.str, this.end, n6, n2, n5)) {
                return this.mismatch();
            }
        }
        do {
            if (!this.matchCheck(n7, n12, n4 = this.enc.prevCharHead(this.bytes, this.str, n12, this.end))) continue;
            return this.match(n12);
        } while ((n12 = n4) >= n2);
        return this.mismatch();
    }

    private boolean endBuf(int n, int n2, int n3, int n4) {
        if (n4 - this.str < this.regex.anchorDmin) {
            return true;
        }
        if (n2 > n) {
            if (n3 - n > this.regex.anchorDmax) {
                n = n3 - this.regex.anchorDmax;
                n = n < this.end ? this.enc.rightAdjustCharHead(this.bytes, this.str, n, this.end) : this.enc.prevCharHead(this.bytes, this.str, this.end, this.end);
            }
            if (n4 - (n2 - 1) < this.regex.anchorDmin) {
                n2 = n4 - this.regex.anchorDmin + 1;
            }
            if (n >= n2) {
                return true;
            }
        } else {
            if (n3 - n2 > this.regex.anchorDmax) {
                n2 = n3 - this.regex.anchorDmax;
            }
            if (n4 - n < this.regex.anchorDmin) {
                n = n4 - this.regex.anchorDmin;
                n = this.enc.leftAdjustCharHead(this.bytes, this.str, n, this.end);
            }
            if (n2 > n) {
                return true;
            }
        }
        return false;
    }

    private int match(int n) {
        return n - this.str;
    }

    private int mismatch() {
        if (this.msaBestLen >= 0) {
            int n = this.msaBestS;
            return this.match(n);
        }
        return -1;
    }
}

