/*
 * Decompiled with CFR 0.152.
 */
package org.joni;

import org.jcodings.Encoding;
import org.joni.Analyser;
import org.joni.Regex;
import org.joni.ast.AnchorNode;
import org.joni.ast.BackRefNode;
import org.joni.ast.CClassNode;
import org.joni.ast.CTypeNode;
import org.joni.ast.CallNode;
import org.joni.ast.ConsAltNode;
import org.joni.ast.EncloseNode;
import org.joni.ast.Node;
import org.joni.ast.QuantifierNode;
import org.joni.ast.StringNode;
import org.joni.exception.ErrorMessages;
import org.joni.exception.InternalException;
import org.joni.exception.SyntaxException;

abstract class Compiler
implements ErrorMessages {
    protected final Analyser analyser;
    protected final Encoding enc;
    protected final Regex regex;

    protected Compiler(Analyser analyser) {
        this.analyser = analyser;
        this.regex = analyser.regex;
        this.enc = this.regex.enc;
    }

    final void compile() {
        this.prepare();
        this.compileTree(this.analyser.root);
        this.finish();
    }

    protected abstract void prepare();

    protected abstract void finish();

    protected abstract void compileAltNode(ConsAltNode var1);

    private void compileStringRawNode(StringNode stringNode) {
        if (stringNode.length() <= 0) {
            return;
        }
        this.addCompileString(stringNode.bytes, stringNode.p, 1, stringNode.length(), false);
    }

    private void compileStringNode(StringNode stringNode) {
        int n;
        StringNode stringNode2 = stringNode;
        if (stringNode2.length() <= 0) {
            return;
        }
        boolean bl = stringNode2.isAmbig();
        int n2 = n = stringNode2.p;
        int n3 = stringNode2.end;
        byte[] byArray = stringNode2.bytes;
        int n4 = this.enc.length(byArray, n2, n3);
        n2 += n4;
        int n5 = 1;
        while (n2 < n3) {
            int n6 = this.enc.length(byArray, n2, n3);
            if (n6 == n4) {
                ++n5;
            } else {
                this.addCompileString(byArray, n, n4, n5, bl);
                n = n2;
                n5 = 1;
                n4 = n6;
            }
            n2 += n6;
        }
        this.addCompileString(byArray, n, n4, n5, bl);
    }

    protected abstract void addCompileString(byte[] var1, int var2, int var3, int var4, boolean var5);

    protected abstract void compileCClassNode(CClassNode var1);

    protected abstract void compileCTypeNode(CTypeNode var1);

    protected abstract void compileAnyCharNode();

    protected abstract void compileCallNode(CallNode var1);

    protected abstract void compileBackrefNode(BackRefNode var1);

    protected abstract void compileCECQuantifierNode(QuantifierNode var1);

    protected abstract void compileNonCECQuantifierNode(QuantifierNode var1);

    protected abstract void compileOptionNode(EncloseNode var1);

    protected abstract void compileEncloseNode(EncloseNode var1);

    protected abstract void compileAnchorNode(AnchorNode var1);

    protected final void compileTree(Node node) {
        switch (node.getType()) {
            case 8: {
                ConsAltNode consAltNode = (ConsAltNode)node;
                do {
                    this.compileTree(consAltNode.car);
                } while ((consAltNode = consAltNode.cdr) != null);
                break;
            }
            case 9: {
                this.compileAltNode((ConsAltNode)node);
                break;
            }
            case 0: {
                StringNode stringNode = (StringNode)node;
                if (stringNode.isRaw()) {
                    this.compileStringRawNode(stringNode);
                    break;
                }
                this.compileStringNode(stringNode);
                break;
            }
            case 1: {
                this.compileCClassNode((CClassNode)node);
                break;
            }
            case 2: {
                this.compileCTypeNode((CTypeNode)node);
                break;
            }
            case 3: {
                this.compileAnyCharNode();
                break;
            }
            case 4: {
                this.compileBackrefNode((BackRefNode)node);
                break;
            }
            case 10: {
                this.compileCallNode((CallNode)node);
                break;
            }
            case 5: {
                this.compileNonCECQuantifierNode((QuantifierNode)node);
                break;
            }
            case 6: {
                EncloseNode encloseNode = (EncloseNode)node;
                if (encloseNode.isOption()) {
                    this.compileOptionNode(encloseNode);
                    break;
                }
                this.compileEncloseNode(encloseNode);
                break;
            }
            case 7: {
                this.compileAnchorNode((AnchorNode)node);
                break;
            }
            default: {
                this.newInternalException("internal parser error (bug)");
            }
        }
    }

    protected final void compileTreeNTimes(Node node, int n) {
        for (int i = 0; i < n; ++i) {
            this.compileTree(node);
        }
    }

    protected void newSyntaxException(String string2) {
        throw new SyntaxException(string2);
    }

    protected void newInternalException(String string2) {
        throw new InternalException(string2);
    }
}

