/*
 * Decompiled with CFR 0.152.
 */
package org.joni;

import org.jcodings.Encoding;
import org.joni.ScanEnvironment;
import org.joni.exception.ValueException;

public final class CodeRangeBuffer {
    private static final int INIT_MULTI_BYTE_RANGE_SIZE = 5;
    private static final int ALL_MULTI_BYTE_RANGE = Integer.MAX_VALUE;
    int[] p;
    int used;

    public CodeRangeBuffer(int[] nArray) {
        this.p = nArray;
        this.used = nArray[0] + 1;
    }

    public CodeRangeBuffer() {
        this.p = new int[5];
        this.writeCodePoint(0, 0);
    }

    public int[] getCodeRange() {
        return this.p;
    }

    private CodeRangeBuffer(CodeRangeBuffer codeRangeBuffer) {
        this.p = new int[codeRangeBuffer.p.length];
        System.arraycopy(codeRangeBuffer.p, 0, this.p, 0, this.p.length);
        this.used = codeRangeBuffer.used;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CodeRange");
        stringBuilder.append("\n  used: " + this.used);
        stringBuilder.append("\n  code point: " + this.p[0]);
        stringBuilder.append("\n  ranges: ");
        for (int i = 0; i < this.p[0]; ++i) {
            stringBuilder.append("[" + CodeRangeBuffer.rangeNumToString(this.p[i * 2 + 1]) + ".." + CodeRangeBuffer.rangeNumToString(this.p[i * 2 + 2]) + "]");
            if (i <= 0 || i % 6 != 0) continue;
            stringBuilder.append("\n          ");
        }
        return stringBuilder.toString();
    }

    private static String rangeNumToString(int n) {
        return "0x" + Integer.toString(n, 16);
    }

    public void expand(int n) {
        int n2 = this.p.length;
        while ((n2 <<= 1) < n) {
        }
        int[] nArray = new int[n2];
        System.arraycopy(this.p, 0, nArray, 0, this.used);
        this.p = nArray;
    }

    public void ensureSize(int n) {
        int n2;
        for (n2 = this.p.length; n2 < n; n2 <<= 1) {
        }
        if (this.p.length != n2) {
            int[] nArray = new int[n2];
            System.arraycopy(this.p, 0, nArray, 0, this.used);
            this.p = nArray;
        }
    }

    private void moveRight(int n, int n2, int n3) {
        if (n2 + n3 > this.p.length) {
            this.expand(n2 + n3);
        }
        System.arraycopy(this.p, n, this.p, n2, n3);
        if (n2 + n3 > this.used) {
            this.used = n2 + n3;
        }
    }

    protected void moveLeft(int n, int n2, int n3) {
        System.arraycopy(this.p, n, this.p, n2, n3);
    }

    private void moveLeftAndReduce(int n, int n2) {
        System.arraycopy(this.p, n, this.p, n2, this.used - n);
        this.used -= n - n2;
    }

    public void writeCodePoint(int n, int n2) {
        int n3 = n + 1;
        if (this.p.length < n3) {
            this.expand(n3);
        }
        this.p[n] = n2;
        if (this.used < n3) {
            this.used = n3;
        }
    }

    public CodeRangeBuffer clone() {
        return new CodeRangeBuffer(this);
    }

    public static CodeRangeBuffer addCodeRangeToBuff(CodeRangeBuffer codeRangeBuffer, int n, int n2) {
        int n3;
        int n4;
        int n5;
        if (n > n2) {
            int n6 = n;
            n = n2;
            n2 = n6;
        }
        if (codeRangeBuffer == null) {
            codeRangeBuffer = new CodeRangeBuffer();
        }
        int[] nArray = codeRangeBuffer.p;
        int n7 = nArray[0];
        int n8 = 0;
        int n9 = n7;
        while (n8 < n9) {
            n5 = n8 + n9 >>> 1;
            if (n > nArray[n5 * 2 + 2]) {
                n8 = n5 + 1;
                continue;
            }
            n9 = n5;
        }
        n5 = n8;
        n9 = n7;
        while (n5 < n9) {
            n4 = n5 + n9 >>> 1;
            if (n2 >= nArray[n4 * 2 + 1] - 1) {
                n5 = n4 + 1;
                continue;
            }
            n9 = n4;
        }
        n4 = n8 + 1 - n5;
        if (n7 + n4 > 10000) {
            throw new ValueException("too many multibyte code ranges are specified");
        }
        if (n4 != 1) {
            if (n > nArray[n8 * 2 + 1]) {
                n = nArray[n8 * 2 + 1];
            }
            if (n2 < nArray[(n5 - 1) * 2 + 2]) {
                n2 = nArray[(n5 - 1) * 2 + 2];
            }
        }
        if (n4 != 0 && n5 < n7) {
            n3 = 1 + n5 * 2;
            int n10 = 1 + (n8 + 1) * 2;
            int n11 = (n7 - n5) * 2;
            if (n4 > 0) {
                codeRangeBuffer.moveRight(n3, n10, n11);
            } else {
                codeRangeBuffer.moveLeftAndReduce(n3, n10);
            }
        }
        n3 = 1 + n8 * 2;
        codeRangeBuffer.writeCodePoint(n3, n);
        codeRangeBuffer.writeCodePoint(n3 + 1, n2);
        codeRangeBuffer.writeCodePoint(0, n7 += n4);
        return codeRangeBuffer;
    }

    public static CodeRangeBuffer addCodeRange(CodeRangeBuffer codeRangeBuffer, ScanEnvironment scanEnvironment, int n, int n2) {
        if (n > n2) {
            if (scanEnvironment.syntax.allowEmptyRangeInCC()) {
                return codeRangeBuffer;
            }
            throw new ValueException("empty range in char class");
        }
        return CodeRangeBuffer.addCodeRangeToBuff(codeRangeBuffer, n, n2);
    }

    protected static CodeRangeBuffer setAllMultiByteRange(Encoding encoding2, CodeRangeBuffer codeRangeBuffer) {
        return CodeRangeBuffer.addCodeRangeToBuff(codeRangeBuffer, encoding2.mbcodeStartPosition(), Integer.MAX_VALUE);
    }

    public static CodeRangeBuffer addAllMultiByteRange(Encoding encoding2, CodeRangeBuffer codeRangeBuffer) {
        if (!encoding2.isSingleByte()) {
            return CodeRangeBuffer.setAllMultiByteRange(encoding2, codeRangeBuffer);
        }
        return codeRangeBuffer;
    }

    public static CodeRangeBuffer notCodeRangeBuff(Encoding encoding2, CodeRangeBuffer codeRangeBuffer) {
        CodeRangeBuffer codeRangeBuffer2 = null;
        if (codeRangeBuffer == null) {
            return CodeRangeBuffer.setAllMultiByteRange(encoding2, codeRangeBuffer2);
        }
        int[] nArray = codeRangeBuffer.p;
        int n = nArray[0];
        if (n <= 0) {
            return CodeRangeBuffer.setAllMultiByteRange(encoding2, codeRangeBuffer2);
        }
        int n2 = encoding2.mbcodeStartPosition();
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            int n4 = nArray[i * 2 + 1];
            n3 = nArray[i * 2 + 2];
            if (n2 <= n4 - 1) {
                codeRangeBuffer2 = CodeRangeBuffer.addCodeRangeToBuff(codeRangeBuffer2, n2, n4 - 1);
            }
            if (n3 == Integer.MAX_VALUE) break;
            n2 = n3 + 1;
        }
        if (n3 < Integer.MAX_VALUE) {
            codeRangeBuffer2 = CodeRangeBuffer.addCodeRangeToBuff(codeRangeBuffer2, n3 + 1, Integer.MAX_VALUE);
        }
        return codeRangeBuffer2;
    }

    public static CodeRangeBuffer orCodeRangeBuff(Encoding encoding2, CodeRangeBuffer codeRangeBuffer, boolean bl, CodeRangeBuffer object, boolean bl2) {
        boolean bl3;
        Object object2;
        boolean bl4;
        CodeRangeBuffer codeRangeBuffer2 = null;
        if (codeRangeBuffer == null && object == null) {
            if (bl || bl2) {
                return CodeRangeBuffer.setAllMultiByteRange(encoding2, codeRangeBuffer2);
            }
            return null;
        }
        if (object == null) {
            boolean bl5 = bl;
            bl = bl2;
            bl4 = bl5;
            object2 = codeRangeBuffer;
            codeRangeBuffer = object;
            object = object2;
        }
        if (codeRangeBuffer == null) {
            if (bl) {
                return CodeRangeBuffer.setAllMultiByteRange(encoding2, codeRangeBuffer2);
            }
            if (!bl4) {
                return ((CodeRangeBuffer)object).clone();
            }
            return CodeRangeBuffer.notCodeRangeBuff(encoding2, (CodeRangeBuffer)object);
        }
        if (bl) {
            boolean bl6 = bl;
            bl = bl4;
            bl3 = bl6;
            object2 = codeRangeBuffer;
            codeRangeBuffer = object;
            object = object2;
        }
        if (!bl3 && !bl) {
            codeRangeBuffer2 = ((CodeRangeBuffer)object).clone();
        } else if (!bl) {
            codeRangeBuffer2 = CodeRangeBuffer.notCodeRangeBuff(encoding2, (CodeRangeBuffer)object);
        }
        object2 = ((CodeRangeBuffer)codeRangeBuffer).p;
        Object object3 = object2[0];
        for (int i = 0; i < object3; ++i) {
            Object object4 = object2[i * 2 + 1];
            Object object5 = object2[i * 2 + 2];
            codeRangeBuffer2 = CodeRangeBuffer.addCodeRangeToBuff(codeRangeBuffer2, (int)object4, (int)object5);
        }
        return codeRangeBuffer2;
    }

    public static CodeRangeBuffer andCodeRange1(CodeRangeBuffer codeRangeBuffer, int n, int n2, int[] nArray, int n3) {
        for (int i = 0; i < n3; ++i) {
            int n4 = nArray[i * 2 + 1];
            int n5 = nArray[i * 2 + 2];
            if (n4 < n) {
                if (n5 < n) continue;
                n = n5 + 1;
            } else if (n4 <= n2) {
                if (n5 < n2) {
                    if (n <= n4 - 1) {
                        codeRangeBuffer = CodeRangeBuffer.addCodeRangeToBuff(codeRangeBuffer, n, n4 - 1);
                    }
                    n = n5 + 1;
                } else {
                    n2 = n4 - 1;
                }
            } else {
                n = n4;
            }
            if (n > n2) break;
        }
        if (n <= n2) {
            codeRangeBuffer = CodeRangeBuffer.addCodeRangeToBuff(codeRangeBuffer, n, n2);
        }
        return codeRangeBuffer;
    }

    public static CodeRangeBuffer andCodeRangeBuff(CodeRangeBuffer codeRangeBuffer, boolean n, CodeRangeBuffer object, boolean n2) {
        CodeRangeBuffer codeRangeBuffer2;
        block9: {
            int n3;
            int[] nArray;
            Object object2;
            int n4;
            block8: {
                codeRangeBuffer2 = null;
                if (codeRangeBuffer == null) {
                    if (n != 0 && object != null) {
                        return ((CodeRangeBuffer)object).clone();
                    }
                    return null;
                }
                if (object == null) {
                    if (n2 != 0) {
                        return codeRangeBuffer.clone();
                    }
                    return null;
                }
                if (n != 0) {
                    n4 = n;
                    n = n2;
                    n2 = n4;
                    object2 = codeRangeBuffer;
                    codeRangeBuffer = object;
                    object = object2;
                }
                object2 = codeRangeBuffer.p;
                n4 = object2[0];
                nArray = ((CodeRangeBuffer)object).p;
                n3 = nArray[0];
                if (n2 != 0 || n != 0) break block8;
                block0: for (int i = 0; i < n4; ++i) {
                    int n5 = object2[i * 2 + 1];
                    int n6 = object2[i * 2 + 2];
                    for (int j = 0; j < n3; ++j) {
                        int n7 = nArray[j * 2 + 1];
                        int n8 = nArray[j * 2 + 2];
                        if (n7 > n6) continue block0;
                        if (n8 < n5) continue;
                        int n9 = n5 > n7 ? n5 : n7;
                        int n10 = n6 < n8 ? n6 : n8;
                        codeRangeBuffer2 = CodeRangeBuffer.addCodeRangeToBuff(codeRangeBuffer2, n9, n10);
                    }
                }
                break block9;
            }
            if (n != 0) break block9;
            for (int i = 0; i < n4; ++i) {
                int n11 = object2[i * 2 + 1];
                int n12 = object2[i * 2 + 2];
                codeRangeBuffer2 = CodeRangeBuffer.andCodeRange1(codeRangeBuffer2, n11, n12, nArray, n3);
            }
        }
        return codeRangeBuffer2;
    }
}

