/*
 * Decompiled with CFR 0.152.
 */
package org.joni;

import org.jcodings.Encoding;
import org.joni.BitSet;
import org.joni.Regex;
import org.joni.WarnCallback;
import org.joni.ast.CClassNode;
import org.joni.constants.OPCode;
import org.joni.exception.InternalException;

class ByteCodePrinter {
    int[] code;
    int codeLength;
    Object[] operands;
    int operantCount;
    Encoding enc;
    WarnCallback warnings;

    public ByteCodePrinter(Regex regex) {
        this.code = regex.code;
        this.codeLength = regex.codeLength;
        this.operands = regex.operands;
        this.operantCount = regex.operandLength;
        this.enc = regex.enc;
        this.warnings = regex.warnings;
    }

    public String byteCodeListToString() {
        return this.compiledByteCodeListToString();
    }

    private void pString(StringBuilder stringBuilder, int n, int n2) {
        stringBuilder.append(":");
        while (n-- > 0) {
            stringBuilder.append(new String(new byte[]{(byte)this.code[n2++]}));
        }
    }

    private void pLenString(StringBuilder stringBuilder, int n, int n2, int n3) {
        int n4 = n * n2;
        stringBuilder.append(":" + n + ":");
        while (n4-- > 0) {
            stringBuilder.append(new String(new byte[]{(byte)this.code[n3++]}));
        }
    }

    public int compiledByteCodeToString(StringBuilder stringBuilder, int n) {
        stringBuilder.append("[" + OPCode.OpCodeNames[this.code[n]]);
        int n2 = OPCode.OpCodeArgTypes[this.code[n]];
        int n3 = n++;
        if (n2 != -1) {
            switch (n2) {
                case 0: {
                    break;
                }
                case 1: {
                    stringBuilder.append(":(" + this.code[n] + ")");
                    ++n;
                    break;
                }
                case 2: {
                    stringBuilder.append(":(" + this.code[n] + ")");
                    ++n;
                    break;
                }
                case 3: {
                    stringBuilder.append(":" + this.code[n]);
                    ++n;
                    break;
                }
                case 4: {
                    stringBuilder.append(":" + this.code[n]);
                    ++n;
                    break;
                }
                case 5: {
                    stringBuilder.append(":" + this.code[n]);
                    ++n;
                    break;
                }
                case 6: {
                    stringBuilder.append(":" + this.code[n]);
                    n += 2;
                }
            }
        } else {
            switch (this.code[n++]) {
                case 2: 
                case 27: 
                case 28: 
                case 92: 
                case 93: {
                    this.pString(stringBuilder, 1, n++);
                    break;
                }
                case 3: {
                    this.pString(stringBuilder, 2, n);
                    n += 2;
                    break;
                }
                case 4: {
                    this.pString(stringBuilder, 3, n);
                    n += 3;
                    break;
                }
                case 5: {
                    this.pString(stringBuilder, 4, n);
                    n += 4;
                    break;
                }
                case 6: {
                    this.pString(stringBuilder, 5, n);
                    n += 5;
                    break;
                }
                case 7: {
                    int n4 = this.code[n];
                    this.pLenString(stringBuilder, n4, 1, ++n);
                    n += n4;
                    break;
                }
                case 8: {
                    this.pString(stringBuilder, 2, n);
                    n += 2;
                    break;
                }
                case 9: {
                    this.pString(stringBuilder, 4, n);
                    n += 4;
                    break;
                }
                case 10: {
                    this.pString(stringBuilder, 6, n);
                    n += 6;
                    break;
                }
                case 11: {
                    int n5 = this.code[n];
                    this.pLenString(stringBuilder, n5, 2, ++n);
                    n += n5 * 2;
                    break;
                }
                case 12: {
                    int n6 = this.code[n];
                    this.pLenString(stringBuilder, n6, 3, ++n);
                    n += n6 * 3;
                    break;
                }
                case 13: {
                    int n7 = this.code[n];
                    int n8 = this.code[++n];
                    ++n;
                    stringBuilder.append(":" + n7 + ":" + n8 + ":");
                    int n9 = n8 * n7;
                    while (n9-- > 0) {
                        stringBuilder.append(new String(new byte[]{(byte)this.code[n++]}));
                    }
                    break;
                }
                case 14: 
                case 105: {
                    byte[] byArray = new byte[6];
                    for (int i = 0; n + i < this.code.length && i < 6; ++i) {
                        byArray[i] = (byte)this.code[n + i];
                    }
                    int n10 = this.enc.length(byArray, 0, 6);
                    this.pString(stringBuilder, n10, n);
                    n += n10;
                    break;
                }
                case 15: 
                case 106: {
                    int n11 = this.code[n];
                    this.pLenString(stringBuilder, n11, 1, ++n);
                    n += n11;
                    break;
                }
                case 16: 
                case 96: {
                    BitSet bitSet = new BitSet();
                    System.arraycopy(this.code, n, bitSet.bits, 0, 8);
                    int n12 = bitSet.numOn();
                    n += 8;
                    stringBuilder.append(":" + n12);
                    break;
                }
                case 19: 
                case 97: {
                    BitSet bitSet = new BitSet();
                    System.arraycopy(this.code, n, bitSet.bits, 0, 8);
                    int n13 = bitSet.numOn();
                    n += 8;
                    stringBuilder.append(":" + n13);
                    break;
                }
                case 17: 
                case 20: {
                    int n14 = this.code[n];
                    int n15 = this.code[++n];
                    n += n14;
                    stringBuilder.append(":" + n15 + ":" + n14);
                    break;
                }
                case 18: 
                case 21: {
                    BitSet bitSet = new BitSet();
                    System.arraycopy(this.code, n, bitSet.bits, 0, 8);
                    int n16 = bitSet.numOn();
                    int n17 = this.code[n += 8];
                    int n18 = this.code[++n];
                    n += n17;
                    stringBuilder.append(":" + n16 + ":" + n18 + ":" + n17);
                    break;
                }
                case 22: {
                    CClassNode cClassNode = (CClassNode)this.operands[this.code[n]];
                    ++n;
                    int n19 = cClassNode.bs.numOn();
                    stringBuilder.append(":" + cClassNode + ":" + n19);
                    break;
                }
                case 44: {
                    int n20 = this.code[n];
                    ++n;
                    stringBuilder.append(":" + n20);
                    break;
                }
                case 45: 
                case 46: {
                    stringBuilder.append(" ");
                    int n21 = this.code[n];
                    ++n;
                    for (int i = 0; i < n21; ++i) {
                        int n22 = this.code[n];
                        ++n;
                        if (i > 0) {
                            stringBuilder.append(", ");
                        }
                        stringBuilder.append(n22);
                    }
                    break;
                }
                case 47: {
                    int n23 = this.code[n];
                    stringBuilder.append(":" + n23);
                    int n24 = this.code[++n];
                    stringBuilder.append(":" + n24);
                    stringBuilder.append(" ");
                    int n25 = this.code[++n];
                    ++n;
                    for (int i = 0; i < n25; ++i) {
                        int n26 = this.code[n];
                        ++n;
                        if (i > 0) {
                            stringBuilder.append(", ");
                        }
                        stringBuilder.append(n26);
                    }
                    break;
                }
                case 60: 
                case 61: {
                    int n27 = this.code[n];
                    int n28 = this.code[++n];
                    ++n;
                    stringBuilder.append(":" + n27 + ":" + n28);
                    break;
                }
                case 58: 
                case 59: {
                    int n29 = this.code[n];
                    stringBuilder.append(":(" + n29 + ")");
                    this.pString(stringBuilder, 1, ++n);
                    ++n;
                    break;
                }
                case 76: 
                case 104: {
                    int n30 = this.code[n];
                    ++n;
                    stringBuilder.append(":" + n30);
                    break;
                }
                case 77: {
                    int n31 = this.code[n];
                    int n32 = this.code[++n];
                    ++n;
                    stringBuilder.append(":" + n32 + ":(" + n31 + ")");
                    break;
                }
                case 81: 
                case 82: {
                    int n33 = this.code[n];
                    int n34 = this.code[++n];
                    ++n;
                    stringBuilder.append(":" + n33 + ":(" + n34 + ")");
                    break;
                }
                default: {
                    throw new InternalException("undefined code: " + this.code[--n]);
                }
            }
        }
        stringBuilder.append("]");
        return n;
    }

    private String compiledByteCodeListToString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("code length: " + this.codeLength + "\n");
        int n = 0;
        int n2 = 0;
        int n3 = this.codeLength;
        while (n2 < n3) {
            ++n;
            if (n2 > 0) {
                stringBuilder.append(n % 5 == 0 ? "\n" : " ");
            }
            n2 = this.compiledByteCodeToString(stringBuilder, n2);
        }
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }
}

