/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport.proxy;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.ParameterTypes;
import org.jruby.javasupport.proxy.JavaProxyClass;
import org.jruby.javasupport.proxy.JavaProxyInvocationHandler;
import org.jruby.javasupport.proxy.JavaProxyMethod;
import org.jruby.javasupport.proxy.JavaProxyReflectionObject;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaProxyConstructor
extends JavaProxyReflectionObject
implements ParameterTypes {
    private final Constructor<?> proxyConstructor;
    private final Class<?>[] apparentParameterTypes;
    private final JavaProxyClass declaringProxyClass;

    JavaProxyConstructor(Ruby runtime2, JavaProxyClass pClass, Constructor<?> constructor2) {
        super(runtime2, runtime2.getJavaSupport().getJavaModule().fastGetClass("JavaProxyConstructor"));
        this.declaringProxyClass = pClass;
        this.proxyConstructor = constructor2;
        Class<?>[] parameterTypes = constructor2.getParameterTypes();
        int len = parameterTypes.length - 1;
        this.apparentParameterTypes = new Class[len];
        System.arraycopy(parameterTypes, 0, this.apparentParameterTypes, 0, len);
    }

    @Override
    public Class<?>[] getParameterTypes() {
        return this.apparentParameterTypes;
    }

    @Override
    public Class<?>[] getExceptionTypes() {
        return this.proxyConstructor.getExceptionTypes();
    }

    @Override
    public boolean isVarArgs() {
        return this.proxyConstructor.isVarArgs();
    }

    @JRubyMethod(name={"declaring_class"})
    public JavaProxyClass getDeclaringClass() {
        return this.declaringProxyClass;
    }

    public Object newInstance(Object[] args2, JavaProxyInvocationHandler handler) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (args2.length != this.apparentParameterTypes.length) {
            throw new IllegalArgumentException("wrong number of parameters");
        }
        Object[] realArgs = new Object[args2.length + 1];
        System.arraycopy(args2, 0, realArgs, 0, args2.length);
        realArgs[args2.length] = handler;
        return this.proxyConstructor.newInstance(realArgs);
    }

    public static RubyClass createJavaProxyConstructorClass(Ruby runtime2, RubyModule javaProxyModule) {
        RubyClass result = javaProxyModule.defineClassUnder("JavaProxyConstructor", runtime2.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        JavaProxyReflectionObject.registerRubyMethods(runtime2, result);
        result.defineAnnotatedMethods(JavaProxyConstructor.class);
        return result;
    }

    @JRubyMethod
    public RubyFixnum arity() {
        return this.getRuntime().newFixnum(this.getParameterTypes().length);
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof JavaProxyConstructor && this.proxyConstructor == ((JavaProxyConstructor)other).proxyConstructor;
    }

    @Override
    public int hashCode() {
        return this.proxyConstructor.hashCode();
    }

    protected String nameOnInspection() {
        return this.getDeclaringClass().nameOnInspection();
    }

    @Override
    public IRubyObject inspect() {
        StringBuilder result = new StringBuilder();
        result.append(this.nameOnInspection());
        Class<?>[] parameterTypes = this.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            result.append(parameterTypes[i].getName());
            if (i >= parameterTypes.length - 1) continue;
            result.append(',');
        }
        result.append(")>");
        return this.getRuntime().newString(result.toString());
    }

    @JRubyMethod
    public RubyArray argument_types() {
        return this.buildRubyArray(this.getParameterTypes());
    }

    @JRubyMethod(frame=true, rest=true)
    public RubyObject new_instance2(IRubyObject[] args2, Block unusedBlock) {
        Arity.checkArgumentCount(this.getRuntime(), args2, 2, 2);
        final IRubyObject self = args2[0];
        final Ruby runtime2 = self.getRuntime();
        RubyArray constructor_args = (RubyArray)args2[1];
        Class<?>[] parameterTypes = this.getParameterTypes();
        int count2 = (int)constructor_args.length().getLongValue();
        Object[] converted = new Object[count2];
        for (int i = 0; i < count2; ++i) {
            IRubyObject ith = constructor_args.aref(this.getRuntime().newFixnum(i));
            converted[i] = ith.toJava(parameterTypes[i]);
        }
        JavaProxyInvocationHandler handler = new JavaProxyInvocationHandler(){

            public IRubyObject getOrig() {
                return self;
            }

            public Object invoke(Object proxy2, JavaProxyMethod m, Object[] nargs) throws Throwable {
                String name2 = m.getName();
                DynamicMethod method2 = self.getMetaClass().searchMethod(name2);
                int v = method2.getArity().getValue();
                IRubyObject[] newArgs = new IRubyObject[nargs.length];
                int i = nargs.length;
                while (--i >= 0) {
                    newArgs[i] = JavaUtil.convertJavaToUsableRubyObject(runtime2, nargs[i]);
                }
                if (v < 0 || v == newArgs.length) {
                    return RuntimeHelpers.invoke(runtime2.getCurrentContext(), self, name2, newArgs).toJava(m.getReturnType());
                }
                RubyClass superClass = self.getMetaClass().getSuperClass();
                return RuntimeHelpers.invokeAs(runtime2.getCurrentContext(), superClass, self, name2, newArgs, Block.NULL_BLOCK).toJava(m.getReturnType());
            }
        };
        try {
            return JavaObject.wrap(this.getRuntime(), this.newInstance(converted, handler));
        }
        catch (Exception e) {
            RaiseException ex = this.getRuntime().newArgumentError("Constructor invocation failed: " + e.getMessage());
            ex.initCause(e);
            throw ex;
        }
    }

    public JavaObject newInstance(final IRubyObject self, Object[] args2) {
        final Ruby runtime2 = self.getRuntime();
        JavaProxyInvocationHandler handler = new JavaProxyInvocationHandler(){

            public IRubyObject getOrig() {
                return self;
            }

            public Object invoke(Object proxy2, JavaProxyMethod m, Object[] nargs) throws Throwable {
                String name2 = m.getName();
                DynamicMethod method2 = self.getMetaClass().searchMethod(name2);
                int v = method2.getArity().getValue();
                IRubyObject[] newArgs = new IRubyObject[nargs.length];
                int i = nargs.length;
                while (--i >= 0) {
                    newArgs[i] = JavaUtil.convertJavaToUsableRubyObject(runtime2, nargs[i]);
                }
                if (v < 0 || v == newArgs.length) {
                    return RuntimeHelpers.invoke(runtime2.getCurrentContext(), self, name2, newArgs).toJava(m.getReturnType());
                }
                RubyClass superClass = self.getMetaClass().getSuperClass();
                return RuntimeHelpers.invokeAs(runtime2.getCurrentContext(), superClass, self, name2, newArgs, Block.NULL_BLOCK).toJava(m.getReturnType());
            }
        };
        try {
            return JavaObject.wrap(this.getRuntime(), this.newInstance(args2, handler));
        }
        catch (Throwable t) {
            while (t.getCause() != null) {
                t = t.getCause();
            }
            RaiseException ex = this.getRuntime().newArgumentError("Constructor invocation failed: " + t.getMessage());
            ex.initCause(t);
            throw ex;
        }
    }

    @JRubyMethod(required=1, optional=1, frame=true)
    public RubyObject new_instance(IRubyObject[] args2, Block block) {
        Object result;
        RubyProc proc2;
        int size2 = Arity.checkArgumentCount(this.getRuntime(), args2, 1, 2) - 1;
        if (args2[size2] instanceof RubyProc) {
            proc2 = (RubyProc)args2[size2];
        } else {
            proc2 = this.getRuntime().newProc(Block.Type.PROC, block);
            ++size2;
        }
        RubyArray constructor_args = (RubyArray)args2[0];
        Class<?>[] parameterTypes = this.getParameterTypes();
        int count2 = (int)constructor_args.length().getLongValue();
        Object[] converted = new Object[count2];
        for (int i = 0; i < count2; ++i) {
            IRubyObject ith = constructor_args.aref(this.getRuntime().newFixnum(i));
            converted[i] = ith.toJava(parameterTypes[i]);
        }
        final JavaProxyConstructor recv2 = this;
        JavaProxyInvocationHandler handler = new JavaProxyInvocationHandler(){

            public IRubyObject getOrig() {
                return null;
            }

            public Object invoke(Object proxy2, JavaProxyMethod method2, Object[] nargs) throws Throwable {
                int length2 = nargs == null ? 0 : nargs.length;
                IRubyObject[] rubyArgs = new IRubyObject[length2 + 2];
                rubyArgs[0] = JavaObject.wrap(recv2.getRuntime(), proxy2);
                rubyArgs[1] = method2;
                for (int i = 0; i < length2; ++i) {
                    rubyArgs[i + 2] = JavaUtil.convertJavaToRuby(JavaProxyConstructor.this.getRuntime(), nargs[i]);
                }
                IRubyObject call_result = proc2.call(JavaProxyConstructor.this.getRuntime().getCurrentContext(), rubyArgs);
                Object converted_result = call_result.toJava(method2.getReturnType());
                return converted_result;
            }
        };
        try {
            result = this.newInstance(converted, handler);
        }
        catch (Exception e) {
            RaiseException ex = this.getRuntime().newArgumentError("Constructor invocation failed: " + e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        return JavaObject.wrap(this.getRuntime(), result);
    }
}

