/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jffi;

import com.kenai.jffi.CallingConvention;
import com.kenai.jffi.Function;
import com.kenai.jffi.HeapInvocationBuffer;
import com.kenai.jffi.InvocationBuffer;
import com.kenai.jffi.Library;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.NativeType;
import org.jruby.ext.ffi.Type;
import org.jruby.ext.ffi.jffi.DefaultMethodFactory;
import org.jruby.ext.ffi.jffi.DynamicLibrary;
import org.jruby.ext.ffi.jffi.FFIUtil;
import org.jruby.ext.ffi.jffi.FunctionInvoker;
import org.jruby.ext.ffi.jffi.Invocation;
import org.jruby.ext.ffi.jffi.ParameterMarshaller;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"FFI::VariadicInvoker"}, parent="Object")
public class VariadicInvoker
extends RubyObject {
    private final CallingConvention convention;
    private final Library library;
    private final long address;
    private final FunctionInvoker functionInvoker;
    private final com.kenai.jffi.Type returnType;

    public static RubyClass createVariadicInvokerClass(Ruby runtime2, RubyModule module) {
        RubyClass result = module.defineClassUnder("VariadicInvoker", runtime2.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        result.defineAnnotatedMethods(VariadicInvoker.class);
        result.defineAnnotatedConstants(VariadicInvoker.class);
        return result;
    }

    private VariadicInvoker(Ruby runtime2, IRubyObject klazz, Library library2, long address2, FunctionInvoker functionInvoker, com.kenai.jffi.Type returnType, CallingConvention convention) {
        super(runtime2, (RubyClass)klazz);
        this.library = library2;
        this.address = address2;
        this.functionInvoker = functionInvoker;
        this.returnType = returnType;
        this.convention = convention;
    }

    public final Arity getArity() {
        return Arity.OPTIONAL;
    }

    @JRubyMethod(name={"__new"}, meta=true, required=4)
    public static VariadicInvoker newInvoker(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        long address2;
        Library library2;
        CallingConvention conv2 = "stdcall".equals(args2[3].toString()) ? CallingConvention.STDCALL : CallingConvention.STDCALL;
        try {
            library2 = args2[0] instanceof DynamicLibrary ? ((DynamicLibrary)args2[0]).getNativeLibrary() : Library.getCachedInstance(args2[0].toString(), 1);
            address2 = args2[1] instanceof DynamicLibrary.Symbol ? ((DynamicLibrary.Symbol)args2[1]).getAddress() : library2.getSymbolAddress(args2[1].toString());
        }
        catch (UnsatisfiedLinkError ex) {
            throw context.getRuntime().newLoadError(ex.getMessage());
        }
        if (!(args2[2] instanceof Type)) {
            throw context.getRuntime().newTypeError("invalid return type");
        }
        Type returnType = (Type)args2[2];
        FunctionInvoker functionInvoker = DefaultMethodFactory.getFunctionInvoker(returnType);
        return new VariadicInvoker(recv2.getRuntime(), recv2, library2, address2, functionInvoker, FFIUtil.getFFIType(returnType), conv2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"invoke"})
    public IRubyObject invoke(ThreadContext context, IRubyObject typesArg, IRubyObject paramsArg) {
        IRubyObject[] types = ((RubyArray)typesArg).toJavaArrayMaybeUnsafe();
        IRubyObject[] params2 = ((RubyArray)paramsArg).toJavaArrayMaybeUnsafe();
        com.kenai.jffi.Type[] ffiParamTypes = new com.kenai.jffi.Type[types.length];
        ParameterMarshaller[] marshallers = new ParameterMarshaller[types.length];
        block8: for (int i = 0; i < types.length; ++i) {
            Type type2 = (Type)types[i];
            switch (NativeType.valueOf(type2)) {
                case CHAR: 
                case SHORT: 
                case INT: {
                    ffiParamTypes[i] = com.kenai.jffi.Type.SINT32;
                    marshallers[i] = DefaultMethodFactory.getMarshaller(NativeType.INT);
                    continue block8;
                }
                case UCHAR: 
                case USHORT: 
                case UINT: {
                    ffiParamTypes[i] = com.kenai.jffi.Type.UINT32;
                    marshallers[i] = DefaultMethodFactory.getMarshaller(NativeType.UINT);
                    continue block8;
                }
                case FLOAT: 
                case DOUBLE: {
                    ffiParamTypes[i] = com.kenai.jffi.Type.DOUBLE;
                    marshallers[i] = DefaultMethodFactory.getMarshaller(NativeType.DOUBLE);
                    continue block8;
                }
                default: {
                    ffiParamTypes[i] = FFIUtil.getFFIType(type2);
                    marshallers[i] = DefaultMethodFactory.getMarshaller((Type)types[i], CallingConvention.DEFAULT, null);
                }
            }
        }
        Invocation invocation = new Invocation(context);
        try {
            Function function = new Function(this.address, this.returnType, ffiParamTypes, this.convention);
            HeapInvocationBuffer args2 = new HeapInvocationBuffer(function);
            for (int i = 0; i < marshallers.length; ++i) {
                marshallers[i].marshal(invocation, (InvocationBuffer)args2, params2[i]);
            }
            IRubyObject iRubyObject = this.functionInvoker.invoke(context.getRuntime(), function, args2);
            return iRubyObject;
        }
        finally {
            invocation.finish();
        }
    }
}

