/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.dataflow.analyses;

import java.util.BitSet;
import java.util.List;
import java.util.ListIterator;
import org.jruby.compiler.ir.dataflow.DataFlowProblem;
import org.jruby.compiler.ir.dataflow.DataFlowVar;
import org.jruby.compiler.ir.dataflow.FlowGraphNode;
import org.jruby.compiler.ir.dataflow.analyses.LiveVariablesProblem;
import org.jruby.compiler.ir.instructions.IR_Instr;
import org.jruby.compiler.ir.operands.Variable;
import org.jruby.compiler.ir.representations.BasicBlock;
import org.jruby.compiler.ir.representations.CFG;

public class LiveVariableNode
extends FlowGraphNode {
    private BitSet _in;
    private BitSet _out;
    private BitSet _tmp;
    private int _setSize;

    public LiveVariableNode(DataFlowProblem prob, BasicBlock n) {
        super(prob, n);
    }

    public void init() {
        this._setSize = this._prob.getDFVarsCount();
        this._in = new BitSet(this._setSize);
    }

    public void buildDataFlowVars(IR_Instr i) {
        LiveVariablesProblem lvp = (LiveVariablesProblem)this._prob;
        Variable v = i.getResult();
        if (v != null && lvp.getDFVar(v) == null) {
            lvp.addDFVar(v);
        }
    }

    public void initSolnForNode() {
        this._tmp = new BitSet(this._setSize);
    }

    public void compute_MEET(CFG.CFG_Edge edge, FlowGraphNode pred2) {
        this._tmp.or(((LiveVariableNode)pred2)._in);
    }

    public boolean applyTransferFunction() {
        LiveVariablesProblem lvp = (LiveVariablesProblem)this._prob;
        this._out = (BitSet)this._tmp.clone();
        List<IR_Instr> instrs = this._bb.getInstrs();
        ListIterator<IR_Instr> it = instrs.listIterator(instrs.size());
        while (it.hasPrevious()) {
            IR_Instr i = it.previous();
            Variable v = i.getResult();
            if (v != null) {
                DataFlowVar dv = lvp.getDFVar(v);
                this._tmp.clear(dv._id);
            }
            for (Variable x : i.getUsedVariables()) {
                DataFlowVar dv = lvp.getDFVar(x);
                if (dv == null) continue;
                this._tmp.set(dv._id);
            }
        }
        if (this._tmp.equals(this._in)) {
            return false;
        }
        this._in = this._tmp;
        return true;
    }

    public String toString() {
        int i;
        StringBuffer buf = new StringBuffer();
        buf.append("\tVars Live on Entry: ");
        int count2 = 0;
        for (i = 0; i < this._in.size(); ++i) {
            if (!this._in.get(i)) continue;
            buf.append(' ').append(i);
            if (++count2 % 10 != 0) continue;
            buf.append("\t\n");
        }
        if (count2 % 10 != 0) {
            buf.append("\t\t");
        }
        buf.append("\n\tVars Live on Exit: ");
        count2 = 0;
        for (i = 0; i < this._out.size(); ++i) {
            if (!this._out.get(i)) continue;
            buf.append(' ').append(i);
            if (++count2 % 10 != 0) continue;
            buf.append("\t\n");
        }
        if (count2 % 10 != 0) {
            buf.append("\t\t");
        }
        return buf.append('\n').toString();
    }

    void markDeadInstructions() {
        LiveVariablesProblem lvp = (LiveVariablesProblem)this._prob;
        this._tmp = (BitSet)this._out.clone();
        List<IR_Instr> instrs = this._bb.getInstrs();
        ListIterator<IR_Instr> it = instrs.listIterator(instrs.size());
        while (it.hasPrevious()) {
            IR_Instr i = it.previous();
            Variable v = i.getResult();
            if (v != null) {
                DataFlowVar dv = lvp.getDFVar(v);
                if (!this._tmp.get(dv._id) && !i.hasSideEffects()) {
                    i.markDead();
                } else if (this._tmp.get(dv._id)) {
                    this._tmp.clear(dv._id);
                }
            }
            if (i.isDead()) continue;
            for (Variable x : i.getUsedVariables()) {
                DataFlowVar dv = lvp.getDFVar(x);
                if (dv == null) continue;
                this._tmp.set(dv._id);
            }
        }
    }
}

