/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlipNode
extends Node {
    private final Node beginNode;
    private final Node endNode;
    private final boolean exclusive;
    private final int location;

    public FlipNode(ISourcePosition position, Node beginNode, Node endNode, boolean exclusive2, int location) {
        super(position);
        assert (beginNode != null) : "beginNode is not null";
        assert (endNode != null) : "endNode is not null";
        this.beginNode = beginNode;
        this.endNode = endNode;
        this.exclusive = exclusive2;
        this.location = location;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.FLIPNODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitFlipNode(this);
    }

    public Node getBeginNode() {
        return this.beginNode;
    }

    public Node getEndNode() {
        return this.endNode;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public int getDepth() {
        return this.location >> 16;
    }

    public int getIndex() {
        return this.location & 0xFFFF;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.beginNode, this.endNode);
    }

    @Override
    public IRubyObject interpret(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        DynamicScope scope = context.getCurrentScope();
        IRubyObject nil = runtime2.getNil();
        int index2 = this.getIndex();
        DynamicScope flipScope = scope.getFlipScope();
        flipScope.growIfNeeded();
        IRubyObject result = flipScope.getValueDepthZeroOrNil(index2, nil);
        if (this.exclusive) {
            if (result == null || !result.isTrue()) {
                result = FlipNode.trueIfTrue(runtime2, this.beginNode.interpret(runtime2, context, self, aBlock));
                flipScope.setValueDepthZero(result, index2);
                return result;
            }
            if (this.endNode.interpret(runtime2, context, self, aBlock).isTrue()) {
                flipScope.setValueDepthZero(runtime2.getFalse(), index2);
            }
            return runtime2.getTrue();
        }
        if (result == null || !result.isTrue()) {
            if (this.beginNode.interpret(runtime2, context, self, aBlock).isTrue()) {
                flipScope.setValueDepthZero(FlipNode.falseIfTrue(runtime2, this.endNode.interpret(runtime2, context, self, aBlock)), index2);
                return runtime2.getTrue();
            }
            return runtime2.getFalse();
        }
        if (this.endNode.interpret(runtime2, context, self, aBlock).isTrue()) {
            flipScope.setValueDepthZero(runtime2.getFalse(), index2);
        }
        return runtime2.getTrue();
    }

    private static RubyBoolean trueIfTrue(Ruby runtime2, IRubyObject truish) {
        return truish.isTrue() ? runtime2.getTrue() : runtime2.getFalse();
    }

    private static RubyBoolean falseIfTrue(Ruby runtime2, IRubyObject truish) {
        return truish.isTrue() ? runtime2.getFalse() : runtime2.getTrue();
    }
}

