/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.provider.jna;

import com.kenai.jaffl.MemoryIO;
import com.kenai.jaffl.NativeLong;
import com.kenai.jaffl.Pointer;
import com.kenai.jaffl.provider.jna.BufferMemoryIO;
import com.kenai.jaffl.provider.jna.JNAPointer;
import com.kenai.jaffl.provider.jna.PointerMemoryIO;
import com.kenai.jaffl.struct.Struct;
import com.kenai.jaffl.struct.StructUtil;
import com.kenai.jaffl.util.EnumMapper;
import com.sun.jna.DefaultTypeMapper;
import com.sun.jna.FromNativeContext;
import com.sun.jna.ToNativeContext;
import com.sun.jna.TypeConverter;

public class JNATypeMapper
extends DefaultTypeMapper {
    public JNATypeMapper() {
        this.addTypeConverter(Pointer.class, new PointerConverter());
        this.addTypeConverter(Struct.class, new StructConverter());
        this.addTypeConverter(Enum.class, new EnumConverter());
        this.addTypeConverter(NativeLong.class, new NativeLongConverter());
    }

    private static final class NativeLongConverter
    implements TypeConverter {
        private NativeLongConverter() {
        }

        public Object fromNative(Object nativeValue, FromNativeContext context) {
            return NativeLong.valueOf(((Number)nativeValue).longValue());
        }

        public Class nativeType() {
            return NativeLong.SIZE == 32 ? Integer.class : Long.class;
        }

        public Object toNative(Object value2, ToNativeContext context) {
            if (NativeLong.SIZE == 32) {
                return value2 != null ? ((NativeLong)value2).intValue() : 0;
            }
            return value2 != null ? ((NativeLong)value2).longValue() : 0L;
        }
    }

    private static final class EnumConverter
    implements TypeConverter {
        private EnumConverter() {
        }

        public Object fromNative(Object nativeValue, FromNativeContext context) {
            return nativeValue != null ? EnumMapper.getInstance().valueOf((Integer)nativeValue, context.getTargetType()) : Integer.valueOf(0);
        }

        public Class nativeType() {
            return Integer.class;
        }

        public Object toNative(Object value2, ToNativeContext context) {
            return value2 != null ? Integer.valueOf(EnumMapper.getInstance().intValue((Enum)value2)) : null;
        }
    }

    private static final class StructConverter
    implements TypeConverter {
        private StructConverter() {
        }

        public Object fromNative(Object nativeValue, FromNativeContext context) {
            Struct s;
            if (nativeValue == null) {
                return null;
            }
            try {
                s = (Struct)context.getTargetType().newInstance();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            s.useMemory(new PointerMemoryIO((com.sun.jna.Pointer)nativeValue));
            return s;
        }

        public Class nativeType() {
            return com.sun.jna.Pointer.class;
        }

        public Object toNative(Object value2, ToNativeContext context) {
            if (value2 == null) {
                return null;
            }
            MemoryIO io2 = StructUtil.getMemoryIO((Struct)value2);
            if (io2 instanceof PointerMemoryIO) {
                return ((PointerMemoryIO)io2).getNativeMemory();
            }
            if (io2 instanceof BufferMemoryIO) {
                return ((BufferMemoryIO)io2).getByteBuffer();
            }
            throw new RuntimeException("Unsupported structm MemoryIO");
        }
    }

    private static final class PointerConverter
    implements TypeConverter {
        private PointerConverter() {
        }

        public Object fromNative(Object nativeValue, FromNativeContext context) {
            return nativeValue != null ? new JNAPointer((com.sun.jna.Pointer)nativeValue) : null;
        }

        public Class nativeType() {
            return com.sun.jna.Pointer.class;
        }

        public Object toNative(Object value2, ToNativeContext context) {
            return value2 != null ? ((JNAPointer)value2).getNativePointer() : null;
        }
    }
}

