/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import java.lang.reflect.Modifier;
import java.util.List;
import jruby.objectweb.asm.ClassWriter;
import jruby.objectweb.asm.Label;
import jruby.objectweb.asm.MethodVisitor;
import jruby.objectweb.asm.Opcodes;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JavaMethodDescriptor;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.compiler.impl.StandardASMCompiler;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.CompiledMethod;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.Framing;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.internal.runtime.methods.Scoping;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CompiledBlockCallback;
import org.jruby.runtime.CompiledBlockCallback19;
import org.jruby.runtime.MethodFactory;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JRubyClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvocationMethodFactory
extends MethodFactory
implements Opcodes {
    private static final boolean DEBUG = false;
    private static final String COMPILED_SUPER_CLASS = CodegenUtils.p(CompiledMethod.class);
    private static final String COMPILED_CALL_SIG = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject[].class));
    private static final String COMPILED_CALL_SIG_BLOCK = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject[].class, Block.class));
    private static final String COMPILED_CALL_SIG_ZERO_BLOCK = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, Block.class));
    private static final String COMPILED_CALL_SIG_ZERO = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class));
    private static final String COMPILED_CALL_SIG_ONE_BLOCK = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject.class, Block.class));
    private static final String COMPILED_CALL_SIG_ONE = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject.class));
    private static final String COMPILED_CALL_SIG_TWO_BLOCK = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject.class, IRubyObject.class, Block.class));
    private static final String COMPILED_CALL_SIG_TWO = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject.class, IRubyObject.class));
    private static final String COMPILED_CALL_SIG_THREE_BLOCK = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class));
    private static final String COMPILED_CALL_SIG_THREE = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
    private static final String BLOCK_CALL_SIG = CodegenUtils.sig(RubyKernel.IRUBY_OBJECT, CodegenUtils.params(ThreadContext.class, RubyKernel.IRUBY_OBJECT, IRubyObject.class));
    private static final String BLOCK_CALL_SIG19 = CodegenUtils.sig(RubyKernel.IRUBY_OBJECT, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject[].class, Block.class));
    private static final String JAVA_SUPER_SIG = CodegenUtils.sig(Void.TYPE, CodegenUtils.params(RubyModule.class, Visibility.class));
    public static final int THIS_INDEX = 0;
    public static final int THREADCONTEXT_INDEX = 1;
    public static final int RECEIVER_INDEX = 2;
    public static final int CLASS_INDEX = 3;
    public static final int NAME_INDEX = 4;
    public static final int ARGS_INDEX = 5;
    public static final int BLOCK_INDEX = 6;
    protected final JRubyClassLoader classLoader;
    private boolean seenUndefinedClasses = false;
    private boolean haveWarnedUser = false;

    public InvocationMethodFactory(ClassLoader classLoader) {
        this.classLoader = classLoader instanceof JRubyClassLoader ? (JRubyClassLoader)classLoader : new JRubyClassLoader(classLoader);
    }

    @Override
    public DynamicMethod getCompiledMethodLazily(RubyModule implementationClass, String method2, Arity arity2, Visibility visibility, StaticScope scope, Object scriptObject, CallConfiguration callConfig) {
        return new CompiledMethod.LazyCompiledMethod(implementationClass, method2, arity2, visibility, scope, scriptObject, callConfig, new InvocationMethodFactory(this.classLoader));
    }

    @Override
    public DynamicMethod getCompiledMethod(RubyModule implementationClass, String method2, Arity arity2, Visibility visibility, StaticScope scope, Object scriptObject, CallConfiguration callConfig) {
        String sup = COMPILED_SUPER_CLASS;
        Class<?> scriptClass = scriptObject.getClass();
        String mname = scriptClass.getName() + "Invoker" + method2 + arity2;
        JRubyClassLoader jRubyClassLoader = this.classLoader;
        synchronized (jRubyClassLoader) {
            Class generatedClass = this.tryClass(mname, scriptClass);
            try {
                if (generatedClass == null) {
                    boolean framed;
                    String typePath = CodegenUtils.p(scriptClass);
                    String mnamePath = typePath + "Invoker" + method2 + arity2;
                    int dotIndex = typePath.lastIndexOf(47);
                    ClassWriter cw = this.createCompiledCtor(mnamePath, typePath.substring(dotIndex + 1) + "#" + method2.substring(method2.lastIndexOf(36) + 1), sup);
                    SkinnyMethodAdapter mv = null;
                    String signature = null;
                    boolean specificArity = false;
                    if (scope.getRestArg() >= 0 || scope.getOptionalArgs() > 0 || scope.getRequiredArgs() > 3) {
                        signature = COMPILED_CALL_SIG_BLOCK;
                        mv = new SkinnyMethodAdapter(cw.visitMethod(1, "call", signature, null, null));
                    } else {
                        int i;
                        specificArity = true;
                        mv = new SkinnyMethodAdapter(cw.visitMethod(1, "call", COMPILED_CALL_SIG_BLOCK, null, null));
                        mv.start();
                        mv.aload(0);
                        mv.aload(1);
                        mv.aload(4);
                        mv.aload(5);
                        mv.pushInt(scope.getRequiredArgs());
                        mv.invokestatic(CodegenUtils.p(JavaMethod.class), "checkArgumentCount", CodegenUtils.sig(Void.TYPE, JavaMethod.class, ThreadContext.class, String.class, IRubyObject[].class, Integer.TYPE));
                        mv.aload(0);
                        mv.aload(1);
                        mv.aload(2);
                        mv.aload(3);
                        mv.aload(4);
                        for (i = 0; i < scope.getRequiredArgs(); ++i) {
                            mv.aload(5);
                            mv.ldc(i);
                            mv.arrayload();
                        }
                        mv.aload(6);
                        switch (scope.getRequiredArgs()) {
                            case 0: {
                                signature = COMPILED_CALL_SIG_ZERO_BLOCK;
                                break;
                            }
                            case 1: {
                                signature = COMPILED_CALL_SIG_ONE_BLOCK;
                                break;
                            }
                            case 2: {
                                signature = COMPILED_CALL_SIG_TWO_BLOCK;
                                break;
                            }
                            case 3: {
                                signature = COMPILED_CALL_SIG_THREE_BLOCK;
                            }
                        }
                        mv.invokevirtual(mnamePath, "call", signature);
                        mv.areturn();
                        mv.end();
                        switch (scope.getRequiredArgs()) {
                            case 0: {
                                signature = COMPILED_CALL_SIG_ZERO;
                                break;
                            }
                            case 1: {
                                signature = COMPILED_CALL_SIG_ONE;
                                break;
                            }
                            case 2: {
                                signature = COMPILED_CALL_SIG_TWO;
                                break;
                            }
                            case 3: {
                                signature = COMPILED_CALL_SIG_THREE;
                            }
                        }
                        mv = new SkinnyMethodAdapter(cw.visitMethod(1, "call", signature, null, null));
                        mv.start();
                        mv.aload(0);
                        mv.aload(1);
                        mv.aload(2);
                        mv.aload(3);
                        mv.aload(4);
                        for (i = 1; i <= scope.getRequiredArgs(); ++i) {
                            mv.aload(4 + i);
                        }
                        mv.getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
                        switch (scope.getRequiredArgs()) {
                            case 0: {
                                signature = COMPILED_CALL_SIG_ZERO_BLOCK;
                                break;
                            }
                            case 1: {
                                signature = COMPILED_CALL_SIG_ONE_BLOCK;
                                break;
                            }
                            case 2: {
                                signature = COMPILED_CALL_SIG_TWO_BLOCK;
                                break;
                            }
                            case 3: {
                                signature = COMPILED_CALL_SIG_THREE_BLOCK;
                            }
                        }
                        mv.invokevirtual(mnamePath, "call", signature);
                        mv.areturn();
                        mv.end();
                        mv = new SkinnyMethodAdapter(cw.visitMethod(1, "call", signature, null, null));
                    }
                    mv.visitCode();
                    Label line = new Label();
                    mv.visitLineNumber(0, line);
                    if (!callConfig.isNoop()) {
                        if (specificArity) {
                            this.invokeCallConfigPre(mv, COMPILED_SUPER_CLASS, scope.getRequiredArgs(), true, callConfig);
                        } else {
                            this.invokeCallConfigPre(mv, COMPILED_SUPER_CLASS, -1, true, callConfig);
                        }
                    }
                    Label tryBegin = new Label();
                    Label tryEnd = new Label();
                    Label doFinally = new Label();
                    Label doReturnFinally = new Label();
                    Label doRedoFinally = new Label();
                    Label catchReturnJump = new Label();
                    Label catchRedoJump = new Label();
                    boolean heapScoped = callConfig.scoping() == Scoping.Full;
                    boolean bl = framed = callConfig.framing() == Framing.Full;
                    if (heapScoped) {
                        mv.trycatch(tryBegin, tryEnd, catchReturnJump, CodegenUtils.p(JumpException.ReturnJump.class));
                    }
                    if (framed) {
                        mv.trycatch(tryBegin, tryEnd, catchRedoJump, CodegenUtils.p(JumpException.RedoJump.class));
                    }
                    if (framed || heapScoped) {
                        mv.trycatch(tryBegin, tryEnd, doFinally, null);
                    }
                    if (heapScoped) {
                        mv.trycatch(catchReturnJump, doReturnFinally, doFinally, null);
                    }
                    if (framed) {
                        mv.trycatch(catchRedoJump, doRedoFinally, doFinally, null);
                    }
                    if (framed || heapScoped) {
                        mv.label(tryBegin);
                    }
                    mv.aload(0);
                    mv.getfield(mnamePath, "$scriptObject", CodegenUtils.ci(Object.class));
                    mv.checkcast(typePath);
                    mv.aload(1);
                    mv.aload(2);
                    if (specificArity) {
                        for (int i = 0; i < scope.getRequiredArgs(); ++i) {
                            mv.aload(5 + i);
                        }
                        mv.aload(5 + scope.getRequiredArgs());
                        mv.invokestatic(typePath, method2, StandardASMCompiler.getStaticMethodSignature(typePath, scope.getRequiredArgs()));
                    } else {
                        mv.aload(5);
                        mv.aload(6);
                        mv.invokestatic(typePath, method2, StandardASMCompiler.getStaticMethodSignature(typePath, 4));
                    }
                    if (framed || heapScoped) {
                        mv.label(tryEnd);
                    }
                    if (!callConfig.isNoop()) {
                        this.invokeCallConfigPost(mv, COMPILED_SUPER_CLASS, callConfig);
                    }
                    mv.visitInsn(176);
                    if (heapScoped) {
                        mv.label(catchReturnJump);
                        mv.aload(0);
                        mv.swap();
                        mv.aload(1);
                        mv.swap();
                        mv.invokevirtual(COMPILED_SUPER_CLASS, "handleReturn", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, JumpException.ReturnJump.class));
                        mv.label(doReturnFinally);
                        if (!callConfig.isNoop()) {
                            this.invokeCallConfigPost(mv, COMPILED_SUPER_CLASS, callConfig);
                        }
                        mv.areturn();
                    }
                    if (framed) {
                        mv.label(catchRedoJump);
                        mv.pop();
                        mv.aload(1);
                        mv.invokevirtual(CodegenUtils.p(ThreadContext.class), "getRuntime", CodegenUtils.sig(Ruby.class, new Class[0]));
                        mv.invokevirtual(CodegenUtils.p(Ruby.class), "newRedoLocalJumpError", CodegenUtils.sig(RaiseException.class, new Class[0]));
                        mv.label(doRedoFinally);
                        if (!callConfig.isNoop()) {
                            this.invokeCallConfigPost(mv, COMPILED_SUPER_CLASS, callConfig);
                        }
                        mv.athrow();
                    }
                    if (framed || heapScoped) {
                        mv.label(doFinally);
                        if (!callConfig.isNoop()) {
                            this.invokeCallConfigPost(mv, COMPILED_SUPER_CLASS, callConfig);
                        }
                        mv.athrow();
                    }
                    generatedClass = this.endCall(cw, mv, mname);
                }
                CompiledMethod compiledMethod = (CompiledMethod)generatedClass.newInstance();
                compiledMethod.init(implementationClass, arity2, visibility, scope, scriptObject, callConfig);
                return compiledMethod;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw implementationClass.getRuntime().newLoadError(e.getMessage());
            }
        }
    }

    @Override
    public DynamicMethod getAnnotatedMethod(RubyModule implementationClass, List<JavaMethodDescriptor> descs) {
        JavaMethodDescriptor desc1 = descs.get(0);
        String javaMethodName = desc1.name;
        JRubyClassLoader jRubyClassLoader = this.classLoader;
        synchronized (jRubyClassLoader) {
            try {
                Class c = this.getAnnotatedMethodClass(descs);
                DescriptorInfo info = new DescriptorInfo(descs);
                JavaMethod ic = (JavaMethod)c.getConstructor(RubyModule.class, Visibility.class).newInstance(new Object[]{implementationClass, desc1.anno.visibility()});
                ic.setArity(Arity.OPTIONAL);
                ic.setJavaName(javaMethodName);
                ic.setSingleton(desc1.isStatic);
                ic.setCallConfig(CallConfiguration.getCallConfig(info.isFrame(), info.isScope(), info.isBacktrace()));
                return ic;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw implementationClass.getRuntime().newLoadError(e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class getAnnotatedMethodClass(List<JavaMethodDescriptor> descs) throws Exception {
        JavaMethodDescriptor desc1 = descs.get(0);
        if (descs.size() == 1) {
            return this.getAnnotatedMethodClass(desc1);
        }
        if (!Modifier.isPublic(desc1.getDeclaringClass().getModifiers())) {
            System.err.println("warning: binding non-public class" + desc1.declaringClassName + "; reflected handles won't work");
        }
        String javaMethodName = desc1.name;
        String generatedClassName = CodegenUtils.getAnnotatedBindingClassName(javaMethodName, desc1.declaringClassName, desc1.isStatic, desc1.actualRequired, desc1.optional, true, desc1.anno.frame());
        if (RubyInstanceConfig.FULL_TRACE_ENABLED) {
            generatedClassName = generatedClassName + "_DBG";
        }
        String generatedClassPath = generatedClassName.replace('.', '/');
        JRubyClassLoader jRubyClassLoader = this.classLoader;
        synchronized (jRubyClassLoader) {
            Class c = this.tryClass(generatedClassName, desc1.getDeclaringClass());
            DescriptorInfo info = new DescriptorInfo(descs);
            if (c == null) {
                Class superClass = null;
                superClass = info.getMin() == -1 ? JavaMethod.JavaMethodN.class : (info.isRest() ? (info.isBlock() ? JavaMethod.BLOCK_REST_METHODS[info.getMin()][info.getMax()] : JavaMethod.REST_METHODS[info.getMin()][info.getMax()]) : (info.isBlock() ? JavaMethod.BLOCK_METHODS[info.getMin()][info.getMax()] : JavaMethod.METHODS[info.getMin()][info.getMax()]));
                if (superClass == null) {
                    throw new RuntimeException("invalid multi combination");
                }
                String superClassString = CodegenUtils.p(superClass);
                int dotIndex = desc1.declaringClassName.lastIndexOf(46);
                ClassWriter cw = this.createJavaMethodCtor(generatedClassPath, desc1.declaringClassName.substring(dotIndex + 1) + "#" + desc1.name, superClassString);
                for (JavaMethodDescriptor desc : descs) {
                    int specificArity = -1;
                    if (desc.optional == 0 && !desc.rest) {
                        if (desc.required == 0) {
                            specificArity = desc.actualRequired <= 3 ? desc.actualRequired : -1;
                        } else if (desc.required >= 0 && desc.required <= 3) {
                            specificArity = desc.required;
                        }
                    }
                    boolean hasBlock = desc.hasBlock;
                    SkinnyMethodAdapter mv = null;
                    mv = this.beginMethod(cw, "call", specificArity, hasBlock);
                    mv.visitCode();
                    Label line = new Label();
                    mv.visitLineNumber(0, line);
                    this.createAnnotatedMethodInvocation(desc, mv, superClassString, specificArity, hasBlock);
                    this.endMethod(mv);
                }
                c = this.endClass(cw, generatedClassName);
            }
            return c;
        }
    }

    @Override
    public DynamicMethod getAnnotatedMethod(RubyModule implementationClass, JavaMethodDescriptor desc) {
        String javaMethodName = desc.name;
        JRubyClassLoader jRubyClassLoader = this.classLoader;
        synchronized (jRubyClassLoader) {
            try {
                Class c = this.getAnnotatedMethodClass(desc);
                JavaMethod ic = (JavaMethod)c.getConstructor(RubyModule.class, Visibility.class).newInstance(new Object[]{implementationClass, desc.anno.visibility()});
                ic.setArity(Arity.fromAnnotation(desc.anno, desc.actualRequired));
                ic.setJavaName(javaMethodName);
                ic.setSingleton(desc.isStatic);
                ic.setCallConfig(CallConfiguration.getCallConfigByAnno(desc.anno));
                return ic;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw implementationClass.getRuntime().newLoadError(e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class getAnnotatedMethodClass(JavaMethodDescriptor desc) throws Exception {
        String javaMethodName = desc.name;
        if (!Modifier.isPublic(desc.getDeclaringClass().getModifiers())) {
            System.err.println("warning: binding non-public class " + desc.declaringClassName + "; reflected handles won't work");
        }
        String generatedClassName = CodegenUtils.getAnnotatedBindingClassName(javaMethodName, desc.declaringClassName, desc.isStatic, desc.actualRequired, desc.optional, false, desc.anno.frame());
        if (RubyInstanceConfig.FULL_TRACE_ENABLED) {
            generatedClassName = generatedClassName + "_DBG";
        }
        String generatedClassPath = generatedClassName.replace('.', '/');
        JRubyClassLoader jRubyClassLoader = this.classLoader;
        synchronized (jRubyClassLoader) {
            Class c = this.tryClass(generatedClassName, desc.getDeclaringClass());
            if (c == null) {
                int specificArity = -1;
                if (desc.optional == 0 && !desc.rest) {
                    if (desc.required == 0) {
                        specificArity = desc.actualRequired <= 3 ? desc.actualRequired : -1;
                    } else if (desc.required >= 0 && desc.required <= 3) {
                        specificArity = desc.required;
                    }
                }
                boolean block = desc.hasBlock;
                String superClass = CodegenUtils.p(this.selectSuperClass(specificArity, block));
                int dotIndex = desc.declaringClassName.lastIndexOf(46);
                ClassWriter cw = this.createJavaMethodCtor(generatedClassPath, desc.declaringClassName.substring(dotIndex + 1) + "#" + desc.name, superClass);
                SkinnyMethodAdapter mv = null;
                mv = this.beginMethod(cw, "call", specificArity, block);
                mv.visitCode();
                Label line = new Label();
                mv.visitLineNumber(0, line);
                this.createAnnotatedMethodInvocation(desc, mv, superClass, specificArity, block);
                this.endMethod(mv);
                c = this.endClass(cw, generatedClassName);
            }
            return c;
        }
    }

    @Override
    public CompiledBlockCallback getBlockCallback(String method2, Object scriptObject) {
        Class<?> typeClass = scriptObject.getClass();
        String typePathString = CodegenUtils.p(typeClass);
        String mname = typeClass.getName() + "BlockCallback$" + method2 + "xx1";
        String mnamePath = typePathString + "BlockCallback$" + method2 + "xx1";
        JRubyClassLoader jRubyClassLoader = this.classLoader;
        synchronized (jRubyClassLoader) {
            Class c = this.tryClass(mname);
            try {
                if (c == null) {
                    ClassWriter cw = this.createBlockCtor(mnamePath, typeClass);
                    SkinnyMethodAdapter mv = this.startBlockCall(cw);
                    mv.aload(0);
                    mv.getfield(mnamePath, "$scriptObject", CodegenUtils.ci(typeClass));
                    mv.aload(1);
                    mv.aload(2);
                    mv.aload(3);
                    mv.invokestatic(typePathString, method2, CodegenUtils.sig(RubyKernel.IRUBY_OBJECT, "L" + typePathString + ";", ThreadContext.class, RubyKernel.IRUBY_OBJECT, IRubyObject.class));
                    mv.areturn();
                    mv.visitMaxs(2, 3);
                    c = this.endCall(cw, mv, mname);
                }
                CompiledBlockCallback ic = (CompiledBlockCallback)c.getConstructor(Object.class).newInstance(scriptObject);
                return ic;
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    @Override
    public CompiledBlockCallback19 getBlockCallback19(String method2, Object scriptObject) {
        Class<?> typeClass = scriptObject.getClass();
        String typePathString = CodegenUtils.p(typeClass);
        String mname = typeClass.getName() + "BlockCallback$" + method2 + "xx1";
        String mnamePath = typePathString + "BlockCallback$" + method2 + "xx1";
        JRubyClassLoader jRubyClassLoader = this.classLoader;
        synchronized (jRubyClassLoader) {
            Class c = this.tryClass(mname);
            try {
                if (c == null) {
                    ClassWriter cw = this.createBlockCtor19(mnamePath, typeClass);
                    SkinnyMethodAdapter mv = this.startBlockCall19(cw);
                    mv.aload(0);
                    mv.getfield(mnamePath, "$scriptObject", CodegenUtils.ci(typeClass));
                    mv.aload(1);
                    mv.aload(2);
                    mv.aload(3);
                    mv.aload(4);
                    mv.invokestatic(typePathString, method2, CodegenUtils.sig(IRubyObject.class, "L" + typePathString + ";", ThreadContext.class, IRubyObject.class, IRubyObject[].class, Block.class));
                    mv.areturn();
                    mv.visitMaxs(2, 3);
                    c = this.endCall(cw, mv, mname);
                }
                CompiledBlockCallback19 ic = (CompiledBlockCallback19)c.getConstructor(Object.class).newInstance(scriptObject);
                return ic;
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    private SkinnyMethodAdapter startBlockCall(ClassWriter cw) {
        SkinnyMethodAdapter mv = new SkinnyMethodAdapter(cw.visitMethod(4113, "call", BLOCK_CALL_SIG, null, null));
        mv.visitCode();
        Label line = new Label();
        mv.visitLineNumber(0, line);
        return mv;
    }

    private SkinnyMethodAdapter startBlockCall19(ClassWriter cw) {
        SkinnyMethodAdapter mv = new SkinnyMethodAdapter(cw.visitMethod(4113, "call", BLOCK_CALL_SIG19, null, null));
        mv.visitCode();
        Label line = new Label();
        mv.visitLineNumber(0, line);
        return mv;
    }

    private ClassWriter createBlockCtor(String namePath, Class fieldClass) throws Exception {
        ClassWriter cw = new ClassWriter(3);
        cw.visit(RubyInstanceConfig.JAVA_VERSION, 33, namePath, null, CodegenUtils.p(CompiledBlockCallback.class), null);
        cw.visitField(18, "$scriptObject", CodegenUtils.ci(fieldClass), null, null);
        SkinnyMethodAdapter mv = new SkinnyMethodAdapter(cw.visitMethod(1, "<init>", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(Object.class)), null, null));
        mv.start();
        mv.aload(0);
        mv.invokespecial(CodegenUtils.p(CompiledBlockCallback.class), "<init>", CodegenUtils.sig(Void.TYPE, new Class[0]));
        mv.aload(0);
        mv.aload(1);
        mv.checkcast(CodegenUtils.p(fieldClass));
        mv.putfield(namePath, "$scriptObject", CodegenUtils.ci(fieldClass));
        mv.voidreturn();
        mv.end();
        return cw;
    }

    private ClassWriter createBlockCtor19(String namePath, Class fieldClass) throws Exception {
        ClassWriter cw = new ClassWriter(3);
        cw.visit(RubyInstanceConfig.JAVA_VERSION, 33, namePath, null, CodegenUtils.p(Object.class), new String[]{CodegenUtils.p(CompiledBlockCallback19.class)});
        cw.visitField(18, "$scriptObject", CodegenUtils.ci(fieldClass), null, null);
        SkinnyMethodAdapter mv = new SkinnyMethodAdapter(cw.visitMethod(1, "<init>", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(Object.class)), null, null));
        mv.start();
        mv.aload(0);
        mv.invokespecial(CodegenUtils.p(Object.class), "<init>", CodegenUtils.sig(Void.TYPE, new Class[0]));
        mv.aload(0);
        mv.aload(1);
        mv.checkcast(CodegenUtils.p(fieldClass));
        mv.putfield(namePath, "$scriptObject", CodegenUtils.ci(fieldClass));
        mv.voidreturn();
        mv.end();
        return cw;
    }

    public void prepareAnnotatedMethod(RubyModule implementationClass, JavaMethod javaMethod, JavaMethodDescriptor desc) {
        String javaMethodName = desc.name;
        javaMethod.setArity(Arity.fromAnnotation(desc.anno, desc.actualRequired));
        javaMethod.setJavaName(javaMethodName);
        javaMethod.setSingleton(desc.isStatic);
        javaMethod.setCallConfig(CallConfiguration.getCallConfigByAnno(desc.anno));
    }

    private void checkArity(JRubyMethod jrubyMethod, SkinnyMethodAdapter method2, int specificArity) {
        Label arityError = new Label();
        Label noArityError = new Label();
        switch (specificArity) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return;
            }
        }
        boolean checkArity = false;
        if (jrubyMethod.rest()) {
            if (jrubyMethod.required() > 0) {
                method2.aload(5);
                method2.arraylength();
                method2.ldc(jrubyMethod.required());
                method2.if_icmplt(arityError);
                checkArity = true;
            }
        } else if (jrubyMethod.optional() > 0) {
            if (jrubyMethod.required() > 0) {
                method2.aload(5);
                method2.arraylength();
                method2.ldc(jrubyMethod.required());
                method2.if_icmplt(arityError);
            }
            method2.aload(5);
            method2.arraylength();
            method2.ldc(jrubyMethod.required() + jrubyMethod.optional());
            method2.if_icmpgt(arityError);
            checkArity = true;
        } else {
            method2.aload(5);
            method2.arraylength();
            method2.ldc(jrubyMethod.required());
            method2.if_icmpne(arityError);
            checkArity = true;
        }
        if (checkArity) {
            method2.go_to(noArityError);
            method2.label(arityError);
            method2.aload(1);
            method2.invokevirtual(CodegenUtils.p(ThreadContext.class), "getRuntime", CodegenUtils.sig(Ruby.class, new Class[0]));
            method2.aload(5);
            method2.ldc(jrubyMethod.required());
            method2.ldc(jrubyMethod.required() + jrubyMethod.optional());
            method2.invokestatic(CodegenUtils.p(Arity.class), "checkArgumentCount", CodegenUtils.sig(Integer.TYPE, Ruby.class, IRubyObject[].class, Integer.TYPE, Integer.TYPE));
            method2.pop();
            method2.label(noArityError);
        }
    }

    private ClassWriter createCompiledCtor(String namePath, String shortPath, String sup) throws Exception {
        ClassWriter cw = new ClassWriter(3);
        cw.visit(RubyInstanceConfig.JAVA_VERSION, 33, namePath, null, sup, null);
        cw.visitSource(shortPath, null);
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, sup, "<init>", "()V");
        Label line = new Label();
        mv.visitLineNumber(0, line);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        return cw;
    }

    private ClassWriter createJavaMethodCtor(String namePath, String shortPath, String sup) throws Exception {
        ClassWriter cw = new ClassWriter(3);
        cw.visit(RubyInstanceConfig.JAVA_VERSION, 33, namePath, null, sup, null);
        cw.visitSource(namePath.replace('.', '/') + ".gen", null);
        MethodVisitor mv = cw.visitMethod(1, "<init>", JAVA_SUPER_SIG, null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(183, sup, "<init>", JAVA_SUPER_SIG);
        Label line = new Label();
        mv.visitLineNumber(0, line);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        return cw;
    }

    private void invokeCallConfigPre(SkinnyMethodAdapter mv, String superClass, int specificArity, boolean block, CallConfiguration callConfig) {
        if (callConfig.isNoop()) {
            return;
        }
        this.prepareForPre(mv, specificArity, block, callConfig);
        mv.invokevirtual(superClass, this.getPreMethod(callConfig), this.getPreSignature(callConfig));
    }

    private void invokeCallConfigPost(SkinnyMethodAdapter mv, String superClass, CallConfiguration callConfig) {
        if (callConfig.isNoop()) {
            return;
        }
        mv.aload(1);
        mv.invokestatic(superClass, InvocationMethodFactory.getPostMethod(callConfig), CodegenUtils.sig(Void.TYPE, CodegenUtils.params(ThreadContext.class)));
    }

    private void prepareForPre(SkinnyMethodAdapter mv, int specificArity, boolean block, CallConfiguration callConfig) {
        if (callConfig.isNoop()) {
            return;
        }
        mv.aload(0);
        mv.aload(1);
        switch (callConfig.framing()) {
            case Full: {
                mv.aload(2);
                mv.aload(4);
                this.loadBlockForPre(mv, specificArity, block);
                break;
            }
            case Backtrace: {
                mv.aload(4);
                break;
            }
            case None: {
                break;
            }
            default: {
                throw new RuntimeException("Unknown call configuration");
            }
        }
    }

    private String getPreMethod(CallConfiguration callConfig) {
        switch (callConfig) {
            case FrameFullScopeFull: {
                return "preFrameAndScope";
            }
            case FrameFullScopeDummy: {
                return "preFrameAndDummyScope";
            }
            case FrameFullScopeNone: {
                return "preFrameOnly";
            }
            case FrameBacktraceScopeFull: {
                return "preBacktraceAndScope";
            }
            case FrameBacktraceScopeDummy: {
                return "preBacktraceDummyscope";
            }
            case FrameBacktraceScopeNone: {
                return "preBacktraceOnly";
            }
            case FrameNoneScopeFull: {
                return "preScopeOnly";
            }
            case FrameNoneScopeDummy: {
                return "preNoFrameDummyScope";
            }
            case FrameNoneScopeNone: {
                return "preNoop";
            }
        }
        throw new RuntimeException("Unknown call configuration");
    }

    private String getPreSignature(CallConfiguration callConfig) {
        switch (callConfig) {
            case FrameFullScopeFull: {
                return CodegenUtils.sig(Void.TYPE, CodegenUtils.params(ThreadContext.class, IRubyObject.class, String.class, Block.class));
            }
            case FrameFullScopeDummy: {
                return CodegenUtils.sig(Void.TYPE, CodegenUtils.params(ThreadContext.class, IRubyObject.class, String.class, Block.class));
            }
            case FrameFullScopeNone: {
                return CodegenUtils.sig(Void.TYPE, CodegenUtils.params(ThreadContext.class, IRubyObject.class, String.class, Block.class));
            }
            case FrameBacktraceScopeFull: {
                return CodegenUtils.sig(Void.TYPE, CodegenUtils.params(ThreadContext.class, String.class));
            }
            case FrameBacktraceScopeDummy: {
                return CodegenUtils.sig(Void.TYPE, CodegenUtils.params(ThreadContext.class, String.class));
            }
            case FrameBacktraceScopeNone: {
                return CodegenUtils.sig(Void.TYPE, CodegenUtils.params(ThreadContext.class, String.class));
            }
            case FrameNoneScopeFull: {
                return CodegenUtils.sig(Void.TYPE, CodegenUtils.params(ThreadContext.class));
            }
            case FrameNoneScopeDummy: {
                return CodegenUtils.sig(Void.TYPE, CodegenUtils.params(ThreadContext.class));
            }
            case FrameNoneScopeNone: {
                return CodegenUtils.sig(Void.TYPE, new Class[0]);
            }
        }
        throw new RuntimeException("Unknown call configuration");
    }

    public static String getPostMethod(CallConfiguration callConfig) {
        switch (callConfig) {
            case FrameFullScopeFull: {
                return "postFrameAndScope";
            }
            case FrameFullScopeDummy: {
                return "postFrameAndScope";
            }
            case FrameFullScopeNone: {
                return "postFrameOnly";
            }
            case FrameBacktraceScopeFull: {
                return "postBacktraceAndScope";
            }
            case FrameBacktraceScopeDummy: {
                return "postBacktraceDummyscope";
            }
            case FrameBacktraceScopeNone: {
                return "postBacktraceOnly";
            }
            case FrameNoneScopeFull: {
                return "postScopeOnly";
            }
            case FrameNoneScopeDummy: {
                return "postNoFrameDummyScope";
            }
            case FrameNoneScopeNone: {
                return "postNoop";
            }
        }
        throw new RuntimeException("Unknown call configuration");
    }

    private void loadArguments(SkinnyMethodAdapter mv, JavaMethodDescriptor desc, int specificArity) {
        switch (specificArity) {
            default: {
                mv.aload(5);
                break;
            }
            case 0: {
                break;
            }
            case 1: {
                this.loadArgumentWithCast(mv, 1, desc.argumentTypes[0]);
                break;
            }
            case 2: {
                this.loadArgumentWithCast(mv, 1, desc.argumentTypes[0]);
                this.loadArgumentWithCast(mv, 2, desc.argumentTypes[1]);
                break;
            }
            case 3: {
                this.loadArgumentWithCast(mv, 1, desc.argumentTypes[0]);
                this.loadArgumentWithCast(mv, 2, desc.argumentTypes[1]);
                this.loadArgumentWithCast(mv, 3, desc.argumentTypes[2]);
            }
        }
    }

    private void loadArgumentWithCast(SkinnyMethodAdapter mv, int argNumber, Class coerceType) {
        mv.aload(5 + (argNumber - 1));
        if (coerceType != IRubyObject.class && coerceType != IRubyObject[].class) {
            if (coerceType == RubyString.class) {
                mv.invokeinterface(CodegenUtils.p(IRubyObject.class), "convertToString", CodegenUtils.sig(RubyString.class, new Class[0]));
            } else {
                throw new RuntimeException("Unknown coercion target: " + coerceType);
            }
        }
    }

    private void loadBlockForPre(SkinnyMethodAdapter mv, int specificArity, boolean getsBlock) {
        switch (specificArity) {
            default: {
                if (getsBlock) {
                    mv.visitVarInsn(25, 6);
                    break;
                }
                mv.getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
                break;
            }
            case 0: {
                if (getsBlock) {
                    mv.visitVarInsn(25, 5);
                    break;
                }
                mv.getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
                break;
            }
            case 1: {
                if (getsBlock) {
                    mv.visitVarInsn(25, 6);
                    break;
                }
                mv.getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
                break;
            }
            case 2: {
                if (getsBlock) {
                    mv.visitVarInsn(25, 7);
                    break;
                }
                mv.getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
                break;
            }
            case 3: {
                if (getsBlock) {
                    mv.visitVarInsn(25, 8);
                    break;
                }
                mv.getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
            }
        }
    }

    private void loadBlock(SkinnyMethodAdapter mv, int specificArity, boolean getsBlock) {
        switch (specificArity) {
            default: {
                if (!getsBlock) break;
                mv.visitVarInsn(25, 6);
                break;
            }
            case 0: {
                if (!getsBlock) break;
                mv.visitVarInsn(25, 5);
                break;
            }
            case 1: {
                if (!getsBlock) break;
                mv.visitVarInsn(25, 6);
                break;
            }
            case 2: {
                if (!getsBlock) break;
                mv.visitVarInsn(25, 7);
                break;
            }
            case 3: {
                if (!getsBlock) break;
                mv.visitVarInsn(25, 8);
            }
        }
    }

    private void loadReceiver(String typePath, JavaMethodDescriptor desc, SkinnyMethodAdapter mv) {
        if (Modifier.isStatic(desc.modifiers)) {
            if (desc.hasContext) {
                mv.aload(1);
            }
            mv.aload(2);
        } else {
            mv.aload(2);
            mv.checkcast(typePath);
            if (desc.hasContext) {
                mv.aload(1);
            }
        }
    }

    private Class tryClass(String name2, Class targetClass) {
        try {
            Class<?> c = null;
            c = this.classLoader == null ? Class.forName(name2, true, this.classLoader) : this.classLoader.loadClass(name2);
            if (c != null && this.seenUndefinedClasses && !this.haveWarnedUser) {
                this.haveWarnedUser = true;
                System.err.println("WARNING: while creating new bindings for " + targetClass + ",\n" + "found an existing binding; you may want to run a clean build.");
            }
            return c;
        }
        catch (Exception e) {
            this.seenUndefinedClasses = true;
            return null;
        }
    }

    private Class tryClass(String name2) {
        try {
            return this.classLoader.loadClass(name2);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected Class endCall(ClassWriter cw, MethodVisitor mv, String name2) {
        this.endMethod(mv);
        return this.endClass(cw, name2);
    }

    protected void endMethod(MethodVisitor mv) {
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected Class endClass(ClassWriter cw, String name2) {
        cw.visitEnd();
        byte[] code = cw.toByteArray();
        return this.classLoader.defineClass(name2, code);
    }

    private SkinnyMethodAdapter beginMethod(ClassWriter cw, String methodName, int specificArity, boolean block) {
        switch (specificArity) {
            default: {
                if (block) {
                    return new SkinnyMethodAdapter(cw.visitMethod(1, methodName, COMPILED_CALL_SIG_BLOCK, null, null));
                }
                return new SkinnyMethodAdapter(cw.visitMethod(1, methodName, COMPILED_CALL_SIG, null, null));
            }
            case 0: {
                if (block) {
                    return new SkinnyMethodAdapter(cw.visitMethod(1, methodName, COMPILED_CALL_SIG_ZERO_BLOCK, null, null));
                }
                return new SkinnyMethodAdapter(cw.visitMethod(1, methodName, COMPILED_CALL_SIG_ZERO, null, null));
            }
            case 1: {
                if (block) {
                    return new SkinnyMethodAdapter(cw.visitMethod(1, methodName, COMPILED_CALL_SIG_ONE_BLOCK, null, null));
                }
                return new SkinnyMethodAdapter(cw.visitMethod(1, methodName, COMPILED_CALL_SIG_ONE, null, null));
            }
            case 2: {
                if (block) {
                    return new SkinnyMethodAdapter(cw.visitMethod(1, methodName, COMPILED_CALL_SIG_TWO_BLOCK, null, null));
                }
                return new SkinnyMethodAdapter(cw.visitMethod(1, methodName, COMPILED_CALL_SIG_TWO, null, null));
            }
            case 3: 
        }
        if (block) {
            return new SkinnyMethodAdapter(cw.visitMethod(1, methodName, COMPILED_CALL_SIG_THREE_BLOCK, null, null));
        }
        return new SkinnyMethodAdapter(cw.visitMethod(1, methodName, COMPILED_CALL_SIG_THREE, null, null));
    }

    private Class selectSuperClass(int specificArity, boolean block) {
        switch (specificArity) {
            default: {
                if (block) {
                    return JavaMethod.class;
                }
                return JavaMethod.JavaMethodN.class;
            }
            case 0: {
                if (block) {
                    return JavaMethod.JavaMethodZeroBlock.class;
                }
                return JavaMethod.JavaMethodZero.class;
            }
            case 1: {
                if (block) {
                    return JavaMethod.JavaMethodOneBlock.class;
                }
                return JavaMethod.JavaMethodOne.class;
            }
            case 2: {
                if (block) {
                    return JavaMethod.JavaMethodTwoBlock.class;
                }
                return JavaMethod.JavaMethodTwo.class;
            }
            case 3: 
        }
        if (block) {
            return JavaMethod.JavaMethodThreeBlock.class;
        }
        return JavaMethod.JavaMethodThree.class;
    }

    private void createAnnotatedMethodInvocation(JavaMethodDescriptor desc, SkinnyMethodAdapter method2, String superClass, int specificArity, boolean block) {
        String typePath = desc.declaringClassPath;
        String javaMethodName = desc.name;
        this.checkArity(desc.anno, method2, specificArity);
        CallConfiguration callConfig = CallConfiguration.getCallConfigByAnno(desc.anno);
        if (!callConfig.isNoop()) {
            this.invokeCallConfigPre(method2, superClass, specificArity, block, callConfig);
        }
        if (RubyInstanceConfig.FULL_TRACE_ENABLED) {
            this.invokeCCallTrace(method2);
        }
        Label tryBegin = new Label();
        Label tryEnd = new Label();
        Label doFinally = new Label();
        if (!callConfig.isNoop()) {
            method2.trycatch(tryBegin, tryEnd, doFinally, null);
        }
        method2.label(tryBegin);
        this.loadReceiver(typePath, desc, method2);
        this.loadArguments(method2, desc, specificArity);
        this.loadBlock(method2, specificArity, block);
        if (Modifier.isStatic(desc.modifiers)) {
            method2.invokestatic(typePath, javaMethodName, desc.signature);
        } else {
            method2.invokevirtual(typePath, javaMethodName, desc.signature);
        }
        if (desc.getReturnClass() == Void.TYPE) {
            method2.aload(1);
            method2.invokevirtual(CodegenUtils.p(ThreadContext.class), "getRuntime", CodegenUtils.sig(Ruby.class, new Class[0]));
            method2.invokevirtual(CodegenUtils.p(Ruby.class), "getNil", CodegenUtils.sig(IRubyObject.class, new Class[0]));
        }
        method2.label(tryEnd);
        if (RubyInstanceConfig.FULL_TRACE_ENABLED) {
            this.invokeCReturnTrace(method2);
        }
        if (!callConfig.isNoop()) {
            this.invokeCallConfigPost(method2, superClass, callConfig);
        }
        method2.visitInsn(176);
        if (!callConfig.isNoop()) {
            method2.label(doFinally);
            if (RubyInstanceConfig.FULL_TRACE_ENABLED) {
                this.invokeCReturnTrace(method2);
            }
            if (!callConfig.isNoop()) {
                this.invokeCallConfigPost(method2, superClass, callConfig);
            }
            method2.athrow();
        }
    }

    private void invokeCCallTrace(SkinnyMethodAdapter method2) {
        method2.aload(0);
        method2.aload(1);
        method2.aload(4);
        method2.invokevirtual(CodegenUtils.p(JavaMethod.class), "callTrace", CodegenUtils.sig(Void.TYPE, ThreadContext.class, String.class));
    }

    private void invokeCReturnTrace(SkinnyMethodAdapter method2) {
        method2.aload(0);
        method2.aload(1);
        method2.aload(4);
        method2.invokevirtual(CodegenUtils.p(JavaMethod.class), "returnTrace", CodegenUtils.sig(Void.TYPE, ThreadContext.class, String.class));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DescriptorInfo {
        private int min = Integer.MAX_VALUE;
        private int max = 0;
        private boolean frame = false;
        private boolean scope = false;
        private boolean backtrace = false;
        private boolean rest = false;
        private boolean block = false;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public DescriptorInfo(List<JavaMethodDescriptor> descs) {
            for (JavaMethodDescriptor desc : descs) {
                int specificArity = -1;
                if (desc.hasVarArgs) {
                    if (desc.optional == 0 && !desc.rest) {
                        throw new RuntimeException("IRubyObject[] args but neither of optional or rest specified for method " + desc.declaringClassName + "." + desc.name);
                    }
                    this.rest = true;
                } else {
                    if (desc.optional == 0 && !desc.rest) {
                        if (desc.required == 0) {
                            if (desc.actualRequired > 3) throw new RuntimeException("Invalid specific-arity number of arguments (" + desc.actualRequired + ") on method " + desc.declaringClassName + "." + desc.name);
                            specificArity = desc.actualRequired;
                        } else if (desc.required >= 0 && desc.required <= 3) {
                            if (desc.actualRequired != desc.required) {
                                throw new RuntimeException("Specified required args does not match actual on method " + desc.declaringClassName + "." + desc.name);
                            }
                            specificArity = desc.required;
                        }
                    }
                    if (specificArity < this.min) {
                        this.min = specificArity;
                    }
                    if (specificArity > this.max) {
                        this.max = specificArity;
                    }
                }
                this.frame |= desc.anno.frame();
                this.scope |= desc.anno.scope();
                this.backtrace |= desc.anno.backtrace();
                this.block |= desc.hasBlock;
            }
        }

        public boolean isBacktrace() {
            return this.backtrace;
        }

        public boolean isFrame() {
            return this.frame;
        }

        public int getMax() {
            return this.max;
        }

        public int getMin() {
            return this.min;
        }

        public boolean isScope() {
            return this.scope;
        }

        public boolean isRest() {
            return this.rest;
        }

        public boolean isBlock() {
            return this.block;
        }
    }
}

