/*
 * Decompiled with CFR 0.152.
 */
package jruby.joda.time.base;

import java.io.Serializable;
import java.util.Locale;
import jruby.joda.time.Chronology;
import jruby.joda.time.DateTimeField;
import jruby.joda.time.DateTimeUtils;
import jruby.joda.time.ReadablePartial;
import jruby.joda.time.base.AbstractPartial;
import jruby.joda.time.convert.ConverterManager;
import jruby.joda.time.convert.PartialConverter;
import jruby.joda.time.format.DateTimeFormat;
import jruby.joda.time.format.DateTimeFormatter;

public abstract class BasePartial
extends AbstractPartial
implements ReadablePartial,
Serializable {
    private static final long serialVersionUID = 2353678632973660L;
    private Chronology iChronology;
    private int[] iValues;

    protected BasePartial() {
        this(DateTimeUtils.currentTimeMillis(), (Chronology)null);
    }

    protected BasePartial(Chronology chronology) {
        this(DateTimeUtils.currentTimeMillis(), chronology);
    }

    protected BasePartial(long l) {
        this(l, (Chronology)null);
    }

    protected BasePartial(long l, Chronology chronology) {
        chronology = DateTimeUtils.getChronology(chronology);
        this.iChronology = chronology.withUTC();
        this.iValues = chronology.get(this, l);
    }

    protected BasePartial(Object object, Chronology chronology) {
        PartialConverter partialConverter = ConverterManager.getInstance().getPartialConverter(object);
        chronology = partialConverter.getChronology(object, chronology);
        chronology = DateTimeUtils.getChronology(chronology);
        this.iChronology = chronology.withUTC();
        this.iValues = partialConverter.getPartialValues(this, object, chronology);
    }

    protected BasePartial(Object object, Chronology chronology, DateTimeFormatter dateTimeFormatter) {
        PartialConverter partialConverter = ConverterManager.getInstance().getPartialConverter(object);
        chronology = partialConverter.getChronology(object, chronology);
        chronology = DateTimeUtils.getChronology(chronology);
        this.iChronology = chronology.withUTC();
        this.iValues = partialConverter.getPartialValues(this, object, chronology, dateTimeFormatter);
    }

    protected BasePartial(int[] nArray, Chronology chronology) {
        chronology = DateTimeUtils.getChronology(chronology);
        this.iChronology = chronology.withUTC();
        chronology.validate(this, nArray);
        this.iValues = nArray;
    }

    protected BasePartial(BasePartial basePartial, int[] nArray) {
        this.iChronology = basePartial.iChronology;
        this.iValues = nArray;
    }

    protected BasePartial(BasePartial basePartial, Chronology chronology) {
        this.iChronology = chronology.withUTC();
        this.iValues = basePartial.iValues;
    }

    public int getValue(int n) {
        return this.iValues[n];
    }

    public int[] getValues() {
        return (int[])this.iValues.clone();
    }

    public Chronology getChronology() {
        return this.iChronology;
    }

    protected void setValue(int n, int n2) {
        DateTimeField dateTimeField = this.getField(n);
        this.iValues = dateTimeField.set(this, n, this.iValues, n2);
    }

    protected void setValues(int[] nArray) {
        this.getChronology().validate(this, nArray);
        this.iValues = nArray;
    }

    public String toString(String string2) {
        if (string2 == null) {
            return this.toString();
        }
        return DateTimeFormat.forPattern(string2).print(this);
    }

    public String toString(String string2, Locale locale) throws IllegalArgumentException {
        if (string2 == null) {
            return this.toString();
        }
        return DateTimeFormat.forPattern(string2).withLocale(locale).print(this);
    }
}

