/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.lexer.yacc;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.lexer.yacc.InputStreamLexerSource;
import org.jruby.lexer.yacc.SimplePositionFactory;
import org.jruby.parser.ParserConfiguration;
import org.jruby.util.ByteList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LexerSource {
    private SimplePositionFactory positionFactory;
    private final String sourceName;
    protected int line = 0;
    protected int offset = 0;
    private List<String> list;
    private StringBuilder lineBuffer;
    private StringBuilder sourceLine;

    protected LexerSource(String sourceName, List<String> list2, int line, boolean extraPositionInformation) {
        this.sourceName = sourceName;
        this.line = line;
        this.positionFactory = new SimplePositionFactory(this, line);
        this.list = list2;
        this.lineBuffer = new StringBuilder();
        this.sourceLine = new StringBuilder();
    }

    public String getFilename() {
        return this.sourceName;
    }

    public int getLine() {
        return this.line;
    }

    public int getOffset() {
        return this.offset <= 0 ? 0 : this.offset;
    }

    public ISourcePosition getPosition(ISourcePosition startPosition) {
        return this.positionFactory.getPosition(startPosition);
    }

    public ISourcePosition getPosition() {
        return this.positionFactory.getPosition(null);
    }

    public static LexerSource getSource(String name2, InputStream content, List<String> list2, ParserConfiguration configuration) {
        return new InputStreamLexerSource(name2, content, list2, configuration.getLineNumber(), configuration.hasExtraPositionInformation());
    }

    private void captureFeatureNewline() {
        StringBuilder temp = this.sourceLine;
        this.sourceLine = this.lineBuffer;
        if (this.list != null && this.lineBuffer.length() > 0) {
            this.list.add(this.sourceLine.toString());
        }
        temp.setLength(0);
        this.lineBuffer = temp;
    }

    protected void captureFeature(int c) {
        switch (c) {
            case 10: {
                this.lineBuffer.append((char)c);
            }
            case -1: {
                this.captureFeatureNewline();
                break;
            }
            default: {
                this.lineBuffer.append((char)c);
            }
        }
    }

    public String getCurrentLine() {
        int errorLocation = this.lineBuffer.length() - 1;
        try {
            this.readLineBytes();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.sourceLine.toString() + this.makePointer(errorLocation);
    }

    private String makePointer(int length2) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < length2; ++i) {
            buf.append(' ');
        }
        buf.append('^');
        return buf.toString();
    }

    public abstract boolean matchMarker(ByteList var1, boolean var2, boolean var3) throws IOException;

    public abstract int read() throws IOException;

    public abstract ByteList readUntil(char var1) throws IOException;

    public abstract ByteList readLineBytes() throws IOException;

    public abstract int skipUntil(int var1) throws IOException;

    public abstract void unread(int var1);

    public abstract void unreadMany(CharSequence var1);

    public abstract boolean peek(int var1) throws IOException;

    public abstract boolean lastWasBeginOfLine();

    public abstract boolean wasBeginOfLine();
}

