/*
 * Decompiled with CFR 0.152.
 */
package jruby.joda.time.tz;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import jruby.joda.time.Chronology;
import jruby.joda.time.DateTime;
import jruby.joda.time.DateTimeField;
import jruby.joda.time.DateTimeZone;
import jruby.joda.time.MutableDateTime;
import jruby.joda.time.chrono.ISOChronology;
import jruby.joda.time.chrono.LenientChronology;
import jruby.joda.time.format.DateTimeFormatter;
import jruby.joda.time.format.ISODateTimeFormat;
import jruby.joda.time.tz.DateTimeZoneBuilder;

public class ZoneInfoCompiler {
    static DateTimeOfYear cStartOfYear;
    static Chronology cLenientISO;
    private Map iRuleSets = new HashMap();
    private List iZones = new ArrayList();
    private List iLinks = new ArrayList();

    public static void main(String[] stringArray) throws Exception {
        int n;
        if (stringArray.length == 0) {
            ZoneInfoCompiler.printUsage();
            return;
        }
        File file2 = null;
        File file3 = null;
        for (n = 0; n < stringArray.length; ++n) {
            try {
                if ("-src".equals(stringArray[n])) {
                    file2 = new File(stringArray[++n]);
                    continue;
                }
                if ("-dst".equals(stringArray[n])) {
                    file3 = new File(stringArray[++n]);
                    continue;
                }
                if (!"-?".equals(stringArray[n])) break;
                ZoneInfoCompiler.printUsage();
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                ZoneInfoCompiler.printUsage();
                return;
            }
        }
        if (n >= stringArray.length) {
            ZoneInfoCompiler.printUsage();
            return;
        }
        File[] fileArray = new File[stringArray.length - n];
        int n2 = 0;
        while (n < stringArray.length) {
            fileArray[n2] = file2 == null ? new File(stringArray[n]) : new File(file2, stringArray[n]);
            ++n;
            ++n2;
        }
        ZoneInfoCompiler zoneInfoCompiler = new ZoneInfoCompiler();
        zoneInfoCompiler.compile(file3, fileArray);
    }

    private static void printUsage() {
        System.out.println("Usage: java org.joda.time.tz.ZoneInfoCompiler <options> <source files>");
        System.out.println("where possible options include:");
        System.out.println("  -src <directory>    Specify where to read source files");
        System.out.println("  -dst <directory>    Specify where to write generated files");
    }

    static DateTimeOfYear getStartOfYear() {
        if (cStartOfYear == null) {
            cStartOfYear = new DateTimeOfYear();
        }
        return cStartOfYear;
    }

    static Chronology getLenientISOChronology() {
        if (cLenientISO == null) {
            cLenientISO = LenientChronology.getInstance(ISOChronology.getInstanceUTC());
        }
        return cLenientISO;
    }

    static void writeZoneInfoMap(DataOutputStream dataOutputStream, Map map) throws IOException {
        String string2;
        Map.Entry entry;
        HashMap<String, Short> hashMap = new HashMap<String, Short>(map.size());
        TreeMap<Short, String> treeMap = new TreeMap<Short, String>();
        Iterator iterator = map.entrySet().iterator();
        short s = 0;
        while (iterator.hasNext()) {
            Short s2;
            entry = iterator.next();
            string2 = (String)entry.getKey();
            if (!hashMap.containsKey(string2)) {
                s2 = new Short(s);
                hashMap.put(string2, s2);
                treeMap.put(s2, string2);
                s = (short)(s + 1);
                if (s == 0) {
                    throw new InternalError("Too many time zone ids");
                }
            }
            if (hashMap.containsKey(string2 = ((DateTimeZone)entry.getValue()).getID())) continue;
            s2 = new Short(s);
            hashMap.put(string2, s2);
            treeMap.put(s2, string2);
            if ((s = (short)(s + 1)) != 0) continue;
            throw new InternalError("Too many time zone ids");
        }
        dataOutputStream.writeShort(treeMap.size());
        iterator = treeMap.values().iterator();
        while (iterator.hasNext()) {
            dataOutputStream.writeUTF((String)((Object)iterator.next()));
        }
        dataOutputStream.writeShort(map.size());
        iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            string2 = (String)entry.getKey();
            dataOutputStream.writeShort(((Short)hashMap.get(string2)).shortValue());
            string2 = ((DateTimeZone)entry.getValue()).getID();
            dataOutputStream.writeShort(((Short)hashMap.get(string2)).shortValue());
        }
    }

    static int parseYear(String string2, int n) {
        if ((string2 = string2.toLowerCase()).equals("minimum") || string2.equals("min")) {
            return Integer.MIN_VALUE;
        }
        if (string2.equals("maximum") || string2.equals("max")) {
            return Integer.MAX_VALUE;
        }
        if (string2.equals("only")) {
            return n;
        }
        return Integer.parseInt(string2);
    }

    static int parseMonth(String string2) {
        DateTimeField dateTimeField = ISOChronology.getInstanceUTC().monthOfYear();
        return dateTimeField.get(dateTimeField.set(0L, string2, Locale.ENGLISH));
    }

    static int parseDayOfWeek(String string2) {
        DateTimeField dateTimeField = ISOChronology.getInstanceUTC().dayOfWeek();
        return dateTimeField.get(dateTimeField.set(0L, string2, Locale.ENGLISH));
    }

    static String parseOptional(String string2) {
        return string2.equals("-") ? null : string2;
    }

    static int parseTime(String string2) {
        int n;
        DateTimeFormatter dateTimeFormatter = ISODateTimeFormat.hourMinuteSecondFraction();
        MutableDateTime mutableDateTime = new MutableDateTime(0L, ZoneInfoCompiler.getLenientISOChronology());
        int n2 = 0;
        if (string2.startsWith("-")) {
            n2 = 1;
        }
        if ((n = dateTimeFormatter.parseInto(mutableDateTime, string2, n2)) == ~n2) {
            throw new IllegalArgumentException(string2);
        }
        int n3 = (int)mutableDateTime.getMillis();
        if (n2 == 1) {
            n3 = -n3;
        }
        return n3;
    }

    static char parseZoneChar(char c) {
        switch (c) {
            case 'S': 
            case 's': {
                return 's';
            }
            case 'G': 
            case 'U': 
            case 'Z': 
            case 'g': 
            case 'u': 
            case 'z': {
                return 'u';
            }
        }
        return 'w';
    }

    static boolean test(String string2, DateTimeZone dateTimeZone) {
        long l;
        long l2;
        if (!string2.equals(dateTimeZone.getID())) {
            return true;
        }
        long l3 = ISOChronology.getInstanceUTC().year().set(0L, 1850);
        long l4 = ISOChronology.getInstanceUTC().year().set(0L, 2050);
        int n = dateTimeZone.getOffset(l3);
        String string3 = dateTimeZone.getNameKey(l3);
        ArrayList<Long> arrayList = new ArrayList<Long>();
        while ((l2 = dateTimeZone.nextTransition(l3)) != l3 && l2 <= l4) {
            l3 = l2;
            int n2 = dateTimeZone.getOffset(l3);
            String string4 = dateTimeZone.getNameKey(l3);
            if (n == n2 && string3.equals(string4)) {
                System.out.println("*d* Error in " + dateTimeZone.getID() + " " + new DateTime(l3, (Chronology)ISOChronology.getInstanceUTC()));
                return false;
            }
            if (string4 == null || string4.length() < 3 && !"??".equals(string4)) {
                System.out.println("*s* Error in " + dateTimeZone.getID() + " " + new DateTime(l3, (Chronology)ISOChronology.getInstanceUTC()) + ", nameKey=" + string4);
                return false;
            }
            arrayList.add(new Long(l3));
            n = n2;
            string3 = string4;
        }
        l3 = ISOChronology.getInstanceUTC().year().set(0L, 2050);
        l4 = ISOChronology.getInstanceUTC().year().set(0L, 1850);
        int n3 = arrayList.size();
        while (--n3 >= 0 && (l = dateTimeZone.previousTransition(l3)) != l3 && l >= l4) {
            l3 = l;
            long l5 = (Long)arrayList.get(n3);
            if (l5 - 1L == l3) continue;
            System.out.println("*r* Error in " + dateTimeZone.getID() + " " + new DateTime(l3, (Chronology)ISOChronology.getInstanceUTC()) + " != " + new DateTime(l5 - 1L, (Chronology)ISOChronology.getInstanceUTC()));
            return false;
        }
        return true;
    }

    public Map compile(File file2, File[] fileArray) throws IOException {
        DateTimeZone dateTimeZone;
        TreeMap<Object, DateTimeZone> treeMap;
        Object object;
        int n;
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(fileArray[i]));
                this.parseDataFile(bufferedReader);
                bufferedReader.close();
            }
        }
        if (file2 != null) {
            if (!file2.exists()) {
                throw new IOException("Destination directory doesn't exist: " + file2);
            }
            if (!file2.isDirectory()) {
                throw new IOException("Destination is not a directory: " + file2);
            }
        }
        TreeMap<Object, DateTimeZone> treeMap2 = new TreeMap<Object, DateTimeZone>();
        for (n = 0; n < this.iZones.size(); ++n) {
            Zone zone2 = (Zone)this.iZones.get(n);
            object = new DateTimeZoneBuilder();
            zone2.addToBuilder((DateTimeZoneBuilder)object, this.iRuleSets);
            treeMap = ((DateTimeZoneBuilder)object).toDateTimeZone(zone2.iName, true);
            dateTimeZone = treeMap;
            if (!ZoneInfoCompiler.test(dateTimeZone.getID(), dateTimeZone)) continue;
            treeMap2.put(dateTimeZone.getID(), dateTimeZone);
            if (file2 == null) continue;
            System.out.println("Writing " + dateTimeZone.getID());
            File file3 = new File(file2, dateTimeZone.getID());
            if (!file3.getParentFile().exists()) {
                file3.getParentFile().mkdirs();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file3);
            ((DateTimeZoneBuilder)object).writeTo(zone2.iName, fileOutputStream);
            ((OutputStream)fileOutputStream).close();
            FileInputStream fileInputStream = new FileInputStream(file3);
            DateTimeZone dateTimeZone2 = DateTimeZoneBuilder.readFrom(fileInputStream, dateTimeZone.getID());
            ((InputStream)fileInputStream).close();
            if (((DateTimeZone)((Object)treeMap)).equals(dateTimeZone2)) continue;
            System.out.println("*e* Error in " + dateTimeZone.getID() + ": Didn't read properly from file");
        }
        for (n = 0; n < 2; ++n) {
            for (int i = 0; i < this.iLinks.size(); i += 2) {
                object = (String)this.iLinks.get(i);
                treeMap = (String)this.iLinks.get(i + 1);
                dateTimeZone = (DateTimeZone)treeMap2.get(object);
                if (dateTimeZone == null) {
                    if (n <= 0) continue;
                    System.out.println("Cannot find time zone '" + (String)object + "' to link alias '" + treeMap + "' to");
                    continue;
                }
                treeMap2.put(treeMap, dateTimeZone);
            }
        }
        if (file2 != null) {
            System.out.println("Writing ZoneInfoMap");
            File file4 = new File(file2, "ZoneInfoMap");
            if (!file4.getParentFile().exists()) {
                file4.getParentFile().mkdirs();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file4);
            object = new DataOutputStream(fileOutputStream);
            treeMap = new TreeMap<Object, DateTimeZone>(String.CASE_INSENSITIVE_ORDER);
            treeMap.putAll(treeMap2);
            ZoneInfoCompiler.writeZoneInfoMap((DataOutputStream)object, treeMap);
            ((FilterOutputStream)object).close();
        }
        return treeMap2;
    }

    public void parseDataFile(BufferedReader bufferedReader) throws IOException {
        String string2;
        Zone zone2 = null;
        while ((string2 = bufferedReader.readLine()) != null) {
            String string3 = string2.trim();
            if (string3.length() == 0 || string3.charAt(0) == '#') continue;
            int n = string2.indexOf(35);
            if (n >= 0) {
                string2 = string2.substring(0, n);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " \t");
            if (Character.isWhitespace(string2.charAt(0)) && stringTokenizer.hasMoreTokens()) {
                if (zone2 == null) continue;
                zone2.chain(stringTokenizer);
                continue;
            }
            if (zone2 != null) {
                this.iZones.add(zone2);
            }
            zone2 = null;
            if (!stringTokenizer.hasMoreTokens()) continue;
            String string4 = stringTokenizer.nextToken();
            if (string4.equalsIgnoreCase("Rule")) {
                Rule rule = new Rule(stringTokenizer);
                RuleSet ruleSet = (RuleSet)this.iRuleSets.get(rule.iName);
                if (ruleSet == null) {
                    ruleSet = new RuleSet(rule);
                    this.iRuleSets.put(rule.iName, ruleSet);
                    continue;
                }
                ruleSet.addRule(rule);
                continue;
            }
            if (string4.equalsIgnoreCase("Zone")) {
                zone2 = new Zone(stringTokenizer);
                continue;
            }
            if (string4.equalsIgnoreCase("Link")) {
                this.iLinks.add(stringTokenizer.nextToken());
                this.iLinks.add(stringTokenizer.nextToken());
                continue;
            }
            System.out.println("Unknown line: " + string2);
        }
        if (zone2 != null) {
            this.iZones.add(zone2);
        }
    }

    private static class Zone {
        public final String iName;
        public final int iOffsetMillis;
        public final String iRules;
        public final String iFormat;
        public final int iUntilYear;
        public final DateTimeOfYear iUntilDateTimeOfYear;
        private Zone iNext;

        Zone(StringTokenizer stringTokenizer) {
            this(stringTokenizer.nextToken(), stringTokenizer);
        }

        private Zone(String string2, StringTokenizer stringTokenizer) {
            this.iName = string2.intern();
            this.iOffsetMillis = ZoneInfoCompiler.parseTime(stringTokenizer.nextToken());
            this.iRules = ZoneInfoCompiler.parseOptional(stringTokenizer.nextToken());
            this.iFormat = stringTokenizer.nextToken().intern();
            int n = Integer.MAX_VALUE;
            DateTimeOfYear dateTimeOfYear = ZoneInfoCompiler.getStartOfYear();
            if (stringTokenizer.hasMoreTokens()) {
                n = Integer.parseInt(stringTokenizer.nextToken());
                if (stringTokenizer.hasMoreTokens()) {
                    dateTimeOfYear = new DateTimeOfYear(stringTokenizer);
                }
            }
            this.iUntilYear = n;
            this.iUntilDateTimeOfYear = dateTimeOfYear;
        }

        void chain(StringTokenizer stringTokenizer) {
            if (this.iNext != null) {
                this.iNext.chain(stringTokenizer);
            } else {
                this.iNext = new Zone(this.iName, stringTokenizer);
            }
        }

        public void addToBuilder(DateTimeZoneBuilder dateTimeZoneBuilder, Map map) {
            Zone.addToBuilder(this, dateTimeZoneBuilder, map);
        }

        private static void addToBuilder(Zone zone2, DateTimeZoneBuilder dateTimeZoneBuilder, Map map) {
            while (zone2 != null) {
                dateTimeZoneBuilder.setStandardOffset(zone2.iOffsetMillis);
                if (zone2.iRules == null) {
                    dateTimeZoneBuilder.setFixedSavings(zone2.iFormat, 0);
                } else {
                    try {
                        int n = ZoneInfoCompiler.parseTime(zone2.iRules);
                        dateTimeZoneBuilder.setFixedSavings(zone2.iFormat, n);
                    }
                    catch (Exception exception2) {
                        RuleSet ruleSet = (RuleSet)map.get(zone2.iRules);
                        if (ruleSet == null) {
                            throw new IllegalArgumentException("Rules not found: " + zone2.iRules);
                        }
                        ruleSet.addRecurring(dateTimeZoneBuilder, zone2.iFormat);
                    }
                }
                if (zone2.iUntilYear == Integer.MAX_VALUE) break;
                zone2.iUntilDateTimeOfYear.addCutover(dateTimeZoneBuilder, zone2.iUntilYear);
                zone2 = zone2.iNext;
            }
        }

        public String toString() {
            String string2 = "[Zone]\nName: " + this.iName + "\n" + "OffsetMillis: " + this.iOffsetMillis + "\n" + "Rules: " + this.iRules + "\n" + "Format: " + this.iFormat + "\n" + "UntilYear: " + this.iUntilYear + "\n" + this.iUntilDateTimeOfYear;
            if (this.iNext == null) {
                return string2;
            }
            return string2 + "...\n" + this.iNext.toString();
        }
    }

    private static class RuleSet {
        private List iRules = new ArrayList();

        RuleSet(Rule rule) {
            this.iRules.add(rule);
        }

        void addRule(Rule rule) {
            if (!rule.iName.equals(((Rule)this.iRules.get((int)0)).iName)) {
                throw new IllegalArgumentException("Rule name mismatch");
            }
            this.iRules.add(rule);
        }

        public void addRecurring(DateTimeZoneBuilder dateTimeZoneBuilder, String string2) {
            for (int i = 0; i < this.iRules.size(); ++i) {
                Rule rule = (Rule)this.iRules.get(i);
                rule.addRecurring(dateTimeZoneBuilder, string2);
            }
        }
    }

    private static class Rule {
        public final String iName;
        public final int iFromYear;
        public final int iToYear;
        public final String iType;
        public final DateTimeOfYear iDateTimeOfYear;
        public final int iSaveMillis;
        public final String iLetterS;

        Rule(StringTokenizer stringTokenizer) {
            this.iName = stringTokenizer.nextToken().intern();
            this.iFromYear = ZoneInfoCompiler.parseYear(stringTokenizer.nextToken(), 0);
            this.iToYear = ZoneInfoCompiler.parseYear(stringTokenizer.nextToken(), this.iFromYear);
            if (this.iToYear < this.iFromYear) {
                throw new IllegalArgumentException();
            }
            this.iType = ZoneInfoCompiler.parseOptional(stringTokenizer.nextToken());
            this.iDateTimeOfYear = new DateTimeOfYear(stringTokenizer);
            this.iSaveMillis = ZoneInfoCompiler.parseTime(stringTokenizer.nextToken());
            this.iLetterS = ZoneInfoCompiler.parseOptional(stringTokenizer.nextToken());
        }

        public void addRecurring(DateTimeZoneBuilder dateTimeZoneBuilder, String string2) {
            String string3 = this.formatName(string2);
            this.iDateTimeOfYear.addRecurring(dateTimeZoneBuilder, string3, this.iSaveMillis, this.iFromYear, this.iToYear);
        }

        private String formatName(String string2) {
            int n = string2.indexOf(47);
            if (n > 0) {
                if (this.iSaveMillis == 0) {
                    return string2.substring(0, n).intern();
                }
                return string2.substring(n + 1).intern();
            }
            n = string2.indexOf("%s");
            if (n < 0) {
                return string2;
            }
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 2);
            String string5 = this.iLetterS == null ? string3.concat(string4) : string3 + this.iLetterS + string4;
            return string5.intern();
        }

        public String toString() {
            return "[Rule]\nName: " + this.iName + "\n" + "FromYear: " + this.iFromYear + "\n" + "ToYear: " + this.iToYear + "\n" + "Type: " + this.iType + "\n" + this.iDateTimeOfYear + "SaveMillis: " + this.iSaveMillis + "\n" + "LetterS: " + this.iLetterS + "\n";
        }
    }

    private static class DateTimeOfYear {
        public final int iMonthOfYear;
        public final int iDayOfMonth;
        public final int iDayOfWeek;
        public final boolean iAdvanceDayOfWeek;
        public final int iMillisOfDay;
        public final char iZoneChar;

        DateTimeOfYear() {
            this.iMonthOfYear = 1;
            this.iDayOfMonth = 1;
            this.iDayOfWeek = 0;
            this.iAdvanceDayOfWeek = false;
            this.iMillisOfDay = 0;
            this.iZoneChar = (char)119;
        }

        DateTimeOfYear(StringTokenizer stringTokenizer) {
            int n = 1;
            int n2 = 1;
            int n3 = 0;
            int n4 = 0;
            boolean bl = false;
            int n5 = 119;
            if (stringTokenizer.hasMoreTokens()) {
                n = ZoneInfoCompiler.parseMonth(stringTokenizer.nextToken());
                if (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    if (string2.startsWith("last")) {
                        n2 = -1;
                        n3 = ZoneInfoCompiler.parseDayOfWeek(string2.substring(4));
                        bl = false;
                    } else {
                        try {
                            n2 = Integer.parseInt(string2);
                            n3 = 0;
                            bl = false;
                        }
                        catch (NumberFormatException numberFormatException) {
                            int n6 = string2.indexOf(">=");
                            if (n6 > 0) {
                                n2 = Integer.parseInt(string2.substring(n6 + 2));
                                n3 = ZoneInfoCompiler.parseDayOfWeek(string2.substring(0, n6));
                                bl = true;
                            }
                            n6 = string2.indexOf("<=");
                            if (n6 > 0) {
                                n2 = Integer.parseInt(string2.substring(n6 + 2));
                                n3 = ZoneInfoCompiler.parseDayOfWeek(string2.substring(0, n6));
                                bl = false;
                            }
                            throw new IllegalArgumentException(string2);
                        }
                    }
                    if (stringTokenizer.hasMoreTokens()) {
                        string2 = stringTokenizer.nextToken();
                        n5 = ZoneInfoCompiler.parseZoneChar(string2.charAt(string2.length() - 1));
                        n4 = ZoneInfoCompiler.parseTime(string2);
                    }
                }
            }
            this.iMonthOfYear = n;
            this.iDayOfMonth = n2;
            this.iDayOfWeek = n3;
            this.iAdvanceDayOfWeek = bl;
            this.iMillisOfDay = n4;
            this.iZoneChar = (char)n5;
        }

        public void addRecurring(DateTimeZoneBuilder dateTimeZoneBuilder, String string2, int n, int n2, int n3) {
            dateTimeZoneBuilder.addRecurringSavings(string2, n, n2, n3, this.iZoneChar, this.iMonthOfYear, this.iDayOfMonth, this.iDayOfWeek, this.iAdvanceDayOfWeek, this.iMillisOfDay);
        }

        public void addCutover(DateTimeZoneBuilder dateTimeZoneBuilder, int n) {
            dateTimeZoneBuilder.addCutover(n, this.iZoneChar, this.iMonthOfYear, this.iDayOfMonth, this.iDayOfWeek, this.iAdvanceDayOfWeek, this.iMillisOfDay);
        }

        public String toString() {
            return "MonthOfYear: " + this.iMonthOfYear + "\n" + "DayOfMonth: " + this.iDayOfMonth + "\n" + "DayOfWeek: " + this.iDayOfWeek + "\n" + "AdvanceDayOfWeek: " + this.iAdvanceDayOfWeek + "\n" + "MillisOfDay: " + this.iMillisOfDay + "\n" + "ZoneChar: " + this.iZoneChar + "\n";
        }
    }
}

