/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.builtin;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InstanceVariableTable {
    private static final boolean USE_PACKED_FIELDS = true;
    private static final boolean USE_PACKED_ARRAY = false;
    private static final int MAX_PACKED = 5;
    private static final int DEFAULT_CAPACITY = 8;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final float LOAD_FACTOR = 0.75f;
    private VariableTableEntry[] vTable;
    private Object[] packedVTable;
    private PackedFields packedVFields;
    private int vTableSize;
    private int vTableThreshold;

    public InstanceVariableTable(String name2, Object value2) {
        this.packedVFields = new PackedFields(name2, value2);
        this.vTableSize = 1;
    }

    public InstanceVariableTable(List<Variable<IRubyObject>> vars) {
        this.sync(vars);
    }

    public int getSize() {
        return this.vTableSize;
    }

    public VariableTableEntry[] getVariableTable() {
        return this.vTable;
    }

    public Object[] getPackageTable() {
        return this.packedVTable;
    }

    public void visit(Visitor visitor) {
        if (this.packedVFields != null) {
            this.packedVFields.visit(visitor);
            return;
        }
        VariableTableEntry[] table = this.vTable;
        int i = table.length;
        while (--i >= 0) {
            VariableTableEntry e = table[i];
            while (e != null) {
                visitor.visit(e.name, e.value);
                e = e.next;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visit(TryLockVisitor visitor) {
        if (this.packedVFields != null) {
            this.packedVFields.visit(visitor);
            return;
        }
        VariableTableEntry[] table = this.vTable;
        int i = table.length;
        while (--i >= 0) {
            VariableTableEntry e = table[i];
            while (e != null) {
                Object readValue = e.value;
                if (readValue == null) {
                    Object object = visitor.object;
                    synchronized (object) {
                        readValue = e.value;
                    }
                }
                visitor.visit(e.name, readValue);
                e = e.next;
            }
        }
    }

    private void unpack() {
        VariableTableEntry[] table = new VariableTableEntry[8];
        Object[] packed = this.packedVTable;
        for (int i = 0; i < 5; ++i) {
            String name2 = (String)packed[i];
            int hash2 = name2.hashCode();
            int index2 = hash2 & table.length - 1;
            VariableTableEntry e = table[index2];
            while (e != null) {
                e = e.next;
            }
            table[index2] = e = new VariableTableEntry(hash2, name2, packed[i + 5], table[index2]);
        }
        this.packedVTable = null;
        this.vTableThreshold = 6;
        this.vTable = table;
    }

    private VariableTableEntry[] rehash() {
        VariableTableEntry[] oldTable = this.vTable;
        int oldCapacity = oldTable.length;
        if (oldCapacity >= 0x40000000) {
            return oldTable;
        }
        int newCapacity = oldCapacity << 1;
        VariableTableEntry[] newTable = new VariableTableEntry[newCapacity];
        this.vTableThreshold = (int)((float)newCapacity * 0.75f);
        int sizeMask = newCapacity - 1;
        int i = oldCapacity;
        while (--i >= 0) {
            int k;
            VariableTableEntry e = oldTable[i];
            if (e == null) continue;
            VariableTableEntry next2 = e.next;
            int idx = e.hash & sizeMask;
            if (next2 == null) {
                newTable[idx] = e;
                continue;
            }
            VariableTableEntry lastRun = e;
            int lastIdx = idx;
            VariableTableEntry last2 = next2;
            while (last2 != null) {
                k = last2.hash & sizeMask;
                if (k != lastIdx) {
                    lastIdx = k;
                    lastRun = last2;
                }
                last2 = last2.next;
            }
            newTable[lastIdx] = lastRun;
            VariableTableEntry p2 = e;
            while (p2 != lastRun) {
                VariableTableEntry m;
                k = p2.hash & sizeMask;
                newTable[k] = m = new VariableTableEntry(p2.hash, p2.name, p2.value, newTable[k]);
                p2 = p2.next;
            }
        }
        this.vTable = newTable;
        return newTable;
    }

    public Object store(String name2, Object value2) {
        if (this.packedVFields != null) {
            return this.packedVFields.store(name2, value2);
        }
        return this.hashStore(name2, value2);
    }

    private Object packedInsert(Object[] table, int index2, String internedName, Object value2) {
        assert (internedName == internedName.intern()) : internedName + " is not interned";
        if (index2 == 5) {
            this.unpack();
            return this.hashStore(internedName, value2);
        }
        table[index2] = internedName;
        table[index2 + 5] = value2;
        ++this.vTableSize;
        return value2;
    }

    private Object packedStore(String name2, Object value2) {
        Object[] table = this.packedVTable;
        int hash2 = name2.hashCode();
        int i = 0;
        for (i = 0; i < this.vTableSize; ++i) {
            String n = (String)table[i];
            if (n.hashCode() != hash2 || !name2.equals(n)) continue;
            table[i + 5] = value2;
            return value2;
        }
        return this.packedInsert(table, i, name2.intern(), value2);
    }

    private Object hashStore(String name2, Object value2) {
        VariableTableEntry[] table = this.vTableSize + 1 > this.vTableThreshold ? this.rehash() : this.vTable;
        int hash2 = name2.hashCode();
        int index2 = hash2 & table.length - 1;
        VariableTableEntry e = table[index2];
        while (e != null) {
            if (hash2 == e.hash && name2.equals(e.name)) {
                e.value = value2;
                return value2;
            }
            e = e.next;
        }
        table[index2] = e = new VariableTableEntry(hash2, name2.intern(), value2, table[index2]);
        ++this.vTableSize;
        this.vTable = table;
        return value2;
    }

    public Object fastStore(String internedName, Object value2) {
        if (this.packedVFields != null) {
            return this.packedVFields.fastStore(internedName, value2);
        }
        return this.fastHashStore(internedName, value2);
    }

    private Object fastPackedStore(String internedName, Object value2) {
        int i;
        Object[] table = this.packedVTable;
        for (i = 0; i < this.vTableSize; ++i) {
            if (table[i] != internedName) continue;
            table[i + 5] = value2;
            return value2;
        }
        return this.packedInsert(table, i, internedName, value2);
    }

    private Object fastHashStore(String internedName, Object value2) {
        VariableTableEntry[] table = this.vTableSize + 1 > this.vTableThreshold ? this.rehash() : this.vTable;
        int hash2 = internedName.hashCode();
        int index2 = hash2 & table.length - 1;
        VariableTableEntry e = table[index2];
        while (e != null) {
            if (internedName == e.name) {
                e.value = value2;
                return value2;
            }
            e = e.next;
        }
        table[index2] = e = new VariableTableEntry(hash2, internedName, value2, table[index2]);
        ++this.vTableSize;
        this.vTable = table;
        return value2;
    }

    public Object remove(String name2) {
        if (this.packedVFields != null) {
            return this.packedVFields.remove(name2);
        }
        return this.hashRemove(name2);
    }

    private Object packedRemove(String name2) {
        Object[] table = this.packedVTable;
        int hash2 = name2.hashCode();
        int i = 0;
        for (i = 0; i < this.vTableSize; ++i) {
            String n = (String)table[i];
            if (n.hashCode() != hash2 || !name2.equals(n)) continue;
            Object value2 = table[i + 5];
            for (int j = i; j < this.vTableSize - 1; ++j) {
                table[j] = table[j + 1];
                table[j + 5] = table[j + 1 + 5];
            }
            --this.vTableSize;
            return value2;
        }
        return null;
    }

    private Object hashRemove(String name2) {
        VariableTableEntry first2;
        VariableTableEntry[] table = this.vTable;
        int hash2 = name2.hashCode();
        int index2 = hash2 & table.length - 1;
        VariableTableEntry e = first2 = table[index2];
        while (e != null) {
            if (hash2 == e.hash && name2.equals(e.name)) {
                Object oldValue = e.value;
                VariableTableEntry newFirst = e.next;
                VariableTableEntry p2 = first2;
                while (p2 != e) {
                    newFirst = new VariableTableEntry(p2.hash, p2.name, p2.value, newFirst);
                    p2 = p2.next;
                }
                table[index2] = newFirst;
                --this.vTableSize;
                this.vTable = table;
                return oldValue;
            }
            e = e.next;
        }
        return null;
    }

    public void sync(List<Variable<IRubyObject>> vars) {
        if (vars.size() <= 5) {
            this.packedVFields = new PackedFields();
            for (Variable<IRubyObject> var : vars) {
                String name2 = var.getName();
                assert (name2 == name2.intern()) : name2 + " is not interned";
                this.packedVFields.insert(name2, var.getValue());
            }
        } else {
            this.vTableThreshold = 6;
            this.vTable = new VariableTableEntry[8];
            for (Variable<IRubyObject> var : vars) {
                this.store(var.getName(), var.getValue());
            }
        }
    }

    protected synchronized Object readLocked(VariableTableEntry entry) {
        return entry.value;
    }

    public Map getMap(IRubyObject object) {
        return this.getMap(object, new HashMap());
    }

    public Map getMap(Object object, final Map map) {
        this.visit(new TryLockVisitor(object){

            public void visit(String name2, Object value2) {
                map.put(name2, value2);
            }
        });
        return map;
    }

    public boolean contains(String name2) {
        if (this.packedVFields != null) {
            return this.packedVFields.contains(name2);
        }
        return this.hashContains(name2);
    }

    private boolean packedContains(String name2) {
        Object[] table = this.packedVTable;
        int hash2 = name2.hashCode();
        for (int i = 0; i < this.vTableSize; ++i) {
            String n = (String)table[i];
            if (n.hashCode() != hash2 || !name2.equals(n)) continue;
            return true;
        }
        return false;
    }

    private boolean hashContains(String name2) {
        VariableTableEntry[] table = this.vTable;
        int hash2 = name2.hashCode();
        VariableTableEntry e = table[hash2 & table.length - 1];
        while (e != null) {
            if (hash2 == e.hash && name2.equals(e.name)) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public boolean fastContains(String name2) {
        if (this.packedVFields != null) {
            return this.packedVFields.fastContains(name2);
        }
        return this.fastHashContains(name2);
    }

    private boolean fastPackedContains(String name2) {
        Object[] table = this.packedVTable;
        for (int i = 0; i < this.vTableSize; ++i) {
            if (table[i] != name2) continue;
            return true;
        }
        return false;
    }

    private boolean fastHashContains(String internedName) {
        VariableTableEntry[] table = this.vTable;
        VariableTableEntry e = table[internedName.hashCode() & table.length - 1];
        while (e != null) {
            if (internedName == e.name) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public Object fetch(String name2) {
        if (this.packedVFields != null) {
            return this.packedVFields.fetch(name2);
        }
        return this.hashFetch(name2);
    }

    private Object packedFetch(String name2) {
        Object[] table = this.packedVTable;
        int hash2 = name2.hashCode();
        for (int i = 0; i < this.vTableSize; ++i) {
            String n = (String)table[i];
            if (n.hashCode() != hash2 || !name2.equals(n)) continue;
            return table[i + 5];
        }
        return null;
    }

    private Object hashFetch(String name2) {
        VariableTableEntry[] table = this.vTable;
        int hash2 = name2.hashCode();
        VariableTableEntry e = table[hash2 & table.length - 1];
        while (e != null) {
            if (hash2 == e.hash && name2.equals(e.name)) {
                Object readValue = e.value;
                if (readValue != null) {
                    return readValue;
                }
                return this.readLocked(e);
            }
            e = e.next;
        }
        return null;
    }

    public Object fastFetch(String name2) {
        if (this.packedVFields != null) {
            return this.packedVFields.fastFetch(name2);
        }
        return this.fastHashFetch(name2);
    }

    private Object fastPackedFetch(String name2) {
        Object[] table = this.packedVTable;
        for (int i = 0; i < this.vTableSize; ++i) {
            if (table[i] != name2) continue;
            return table[i + 5];
        }
        return null;
    }

    private Object fastHashFetch(String internedName) {
        VariableTableEntry[] table = this.vTable;
        VariableTableEntry e = table[internedName.hashCode() & table.length - 1];
        while (e != null) {
            if (internedName == e.name) {
                Object readValue = e.value;
                if (readValue != null) {
                    return readValue;
                }
                return this.readLocked(e);
            }
            e = e.next;
        }
        return null;
    }

    static /* synthetic */ VariableTableEntry[] access$202(InstanceVariableTable x0, VariableTableEntry[] x1) {
        x0.vTable = x1;
        return x1;
    }

    private final class PackedFields {
        String name1;
        String name2;
        String name3;
        String name4;
        String name5;
        Object value1;
        Object value2;
        Object value3;
        Object value4;
        Object value5;

        PackedFields() {
        }

        PackedFields(String internedName, Object value2) {
            this.name1 = internedName;
            this.value1 = value2;
        }

        Object fastStore(String internedName, Object value2) {
            assert (internedName == internedName.intern()) : internedName + " is not interned";
            if (internedName == this.name1) {
                this.value1 = value2;
                return this.value1;
            }
            if (internedName == this.name2) {
                this.value2 = value2;
                return this.value2;
            }
            if (internedName == this.name3) {
                this.value3 = value2;
                return this.value3;
            }
            if (internedName == this.name4) {
                this.value4 = value2;
                return this.value4;
            }
            if (internedName == this.name5) {
                this.value5 = value2;
                return this.value5;
            }
            return this.insert(internedName, value2);
        }

        Object store(String name2, Object value2) {
            int hash2 = name2.hashCode();
            if (this.name1 != null && this.name1.hashCode() == hash2 && name2.equals(this.name1)) {
                this.value1 = value2;
                return this.value1;
            }
            if (this.name2 != null && this.name2.hashCode() == hash2 && name2.equals(this.name2)) {
                this.value2 = value2;
                return this.value2;
            }
            if (this.name3 != null && this.name3.hashCode() == hash2 && name2.equals(this.name3)) {
                this.value3 = value2;
                return this.value3;
            }
            if (this.name4 != null && this.name4.hashCode() == hash2 && name2.equals(this.name4)) {
                this.value4 = value2;
                return this.value4;
            }
            if (this.name5 != null && this.name5.hashCode() == hash2 && name2.equals(this.name5)) {
                this.value5 = value2;
                return this.value5;
            }
            return this.insert(name2.intern(), value2);
        }

        void unpack() {
            VariableTableEntry[] table = new VariableTableEntry[8];
            this.unpackOne(table, this.name1, this.value1);
            this.unpackOne(table, this.name2, this.value2);
            this.unpackOne(table, this.name3, this.value3);
            this.unpackOne(table, this.name4, this.value4);
            this.unpackOne(table, this.name5, this.value5);
            InstanceVariableTable.this.packedVFields = null;
            InstanceVariableTable.this.vTableThreshold = 6;
            InstanceVariableTable.access$202(InstanceVariableTable.this, table);
        }

        void unpackOne(VariableTableEntry[] table, String name2, Object value2) {
            int hash2 = name2.hashCode();
            int index2 = hash2 & table.length - 1;
            VariableTableEntry e = table[index2];
            while (e != null) {
                e = e.next;
            }
            table[index2] = e = new VariableTableEntry(hash2, name2, value2, table[index2]);
        }

        Object insert(String internedName, Object value2) {
            switch (InstanceVariableTable.this.vTableSize) {
                case 0: {
                    this.name1 = internedName;
                    this.value1 = value2;
                    break;
                }
                case 1: {
                    this.name2 = internedName;
                    this.value2 = value2;
                    break;
                }
                case 2: {
                    this.name3 = internedName;
                    this.value3 = value2;
                    break;
                }
                case 3: {
                    this.name4 = internedName;
                    this.value4 = value2;
                    break;
                }
                case 4: {
                    this.name5 = internedName;
                    this.value5 = value2;
                    break;
                }
                case 5: {
                    this.unpack();
                    return InstanceVariableTable.this.fastHashStore(internedName, value2);
                }
            }
            InstanceVariableTable.this.vTableSize++;
            return value2;
        }

        boolean contains(String name2) {
            int hash2 = name2.hashCode();
            return this.name1 != null && this.name1.hashCode() == hash2 && name2.equals(this.name1) || this.name2 != null && this.name2.hashCode() == hash2 && name2.equals(this.name2) || this.name3 != null && this.name3.hashCode() == hash2 && name2.equals(this.name3) || this.name4 != null && this.name4.hashCode() == hash2 && name2.equals(this.name4) || this.name5 != null && this.name5.hashCode() == hash2 && name2.equals(this.name5);
        }

        boolean fastContains(String name2) {
            return name2 == this.name1 || name2 == this.name2 || name2 == this.name3 || name2 == this.name4 || name2 == this.name5;
        }

        Object fetch(String name2) {
            int hash2 = name2.hashCode();
            if (this.name1 != null && this.name1.hashCode() == hash2 && name2.equals(this.name1)) {
                return this.value1;
            }
            if (this.name2 != null && this.name2.hashCode() == hash2 && name2.equals(this.name2)) {
                return this.value2;
            }
            if (this.name3 != null && this.name3.hashCode() == hash2 && name2.equals(this.name3)) {
                return this.value3;
            }
            if (this.name4 != null && this.name4.hashCode() == hash2 && name2.equals(this.name4)) {
                return this.value4;
            }
            if (this.name5 != null && this.name5.hashCode() == hash2 && name2.equals(this.name5)) {
                return this.value5;
            }
            return null;
        }

        Object fastFetch(String name2) {
            if (name2 == this.name1) {
                return this.value1;
            }
            if (name2 == this.name2) {
                return this.value2;
            }
            if (name2 == this.name3) {
                return this.value3;
            }
            if (name2 == this.name4) {
                return this.value4;
            }
            if (name2 == this.name5) {
                return this.value5;
            }
            return null;
        }

        Object remove(String name2) {
            int hash2 = name2.hashCode();
            if (this.name1 != null && this.name1.hashCode() == hash2 && name2.equals(this.name1)) {
                return this.remove(1, this.value1);
            }
            if (this.name2 != null && this.name2.hashCode() == hash2 && name2.equals(this.name2)) {
                return this.remove(2, this.value2);
            }
            if (this.name3 != null && this.name3.hashCode() == hash2 && name2.equals(this.name3)) {
                return this.remove(3, this.value3);
            }
            if (this.name4 != null && this.name4.hashCode() == hash2 && name2.equals(this.name4)) {
                return this.remove(4, this.value4);
            }
            if (this.name5 != null && this.name5.hashCode() == hash2 && name2.equals(this.name5)) {
                return this.remove(5, this.value5);
            }
            return null;
        }

        Object remove(int num, Object value2) {
            switch (num) {
                case 1: {
                    this.name1 = this.name2;
                    this.value1 = this.value2;
                }
                case 2: {
                    this.name2 = this.name3;
                    this.value2 = this.value3;
                }
                case 3: {
                    this.name3 = this.name4;
                    this.value3 = this.value4;
                }
                case 4: {
                    this.name4 = this.name5;
                    this.value4 = this.value5;
                }
                case 5: {
                    this.name5 = null;
                    this.value5 = null;
                }
            }
            InstanceVariableTable.this.vTableSize--;
            return value2;
        }

        void visit(Visitor visitor) {
            if (this.name1 != null) {
                visitor.visit(this.name1, this.value1);
            }
            if (this.name2 != null) {
                visitor.visit(this.name2, this.value2);
            }
            if (this.name3 != null) {
                visitor.visit(this.name3, this.value3);
            }
            if (this.name4 != null) {
                visitor.visit(this.name4, this.value4);
            }
            if (this.name5 != null) {
                visitor.visit(this.name5, this.value5);
            }
        }
    }

    public static final class VariableTableEntry {
        public final int hash;
        public final String name;
        public volatile Object value;
        public final VariableTableEntry next;

        VariableTableEntry(int hash2, String name2, Object value2, VariableTableEntry next2) {
            assert (name2 == name2.intern()) : name2 + " is not interned";
            this.hash = hash2;
            this.name = name2;
            this.value = value2;
            this.next = next2;
        }
    }

    public static abstract class TryLockVisitor
    extends Visitor {
        private Object object;

        public TryLockVisitor(Object object) {
            this.object = object;
        }
    }

    public static abstract class Visitor {
        public abstract void visit(String var1, Object var2);
    }
}

