/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jcodings.specific.ASCIIEncoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyClass;
import org.jruby.RubyComplex;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyMatchData;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.runtime.Arity;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.Numeric;

@JRubyClass(name={"Rational"}, parent="Numeric", include={"Precision"})
public class RubyRational
extends RubyNumeric {
    private static ObjectAllocator RATIONAL_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            RubyFixnum zero = RubyFixnum.zero(runtime2);
            return new RubyRational(runtime2, klass, zero, zero);
        }
    };
    private IRubyObject num;
    private IRubyObject den;
    private static boolean canonicalization = false;
    private static long ML = (long)(Math.log(Double.MAX_VALUE) / Math.log(2.0) - 1.0);

    public static RubyClass createRationalClass(Ruby runtime2) {
        RubyClass rationalc = runtime2.defineClass("Rational", runtime2.getNumeric(), RATIONAL_ALLOCATOR);
        runtime2.setRational(rationalc);
        rationalc.index = 21;
        rationalc.kindOf = new RubyModule.KindOf(){

            public boolean isKindOf(IRubyObject obj, RubyModule type2) {
                return obj instanceof RubyRational;
            }
        };
        rationalc.defineAnnotatedMethods(RubyRational.class);
        rationalc.getSingletonClass().undefineMethod("allocate");
        rationalc.getSingletonClass().undefineMethod("new");
        return rationalc;
    }

    private RubyRational(Ruby runtime2, IRubyObject clazz, IRubyObject num, IRubyObject den) {
        super(runtime2, (RubyClass)clazz);
        this.num = num;
        this.den = den;
    }

    static RubyRational newRationalRaw(Ruby runtime2, IRubyObject x, RubyObject y) {
        return new RubyRational(runtime2, (IRubyObject)runtime2.getRational(), x, y);
    }

    static RubyRational newRationalRaw(Ruby runtime2, IRubyObject x) {
        return new RubyRational(runtime2, (IRubyObject)runtime2.getRational(), x, RubyFixnum.one(runtime2));
    }

    static IRubyObject newRationalCanonicalize(ThreadContext context, IRubyObject x) {
        return RubyRational.newRationalCanonicalize(context, x, RubyFixnum.one(context.getRuntime()));
    }

    private static IRubyObject newRationalCanonicalize(ThreadContext context, IRubyObject x, IRubyObject y) {
        return RubyRational.canonicalizeInternal(context, context.getRuntime().getRational(), x, y);
    }

    private static IRubyObject newRational(ThreadContext context, IRubyObject clazz, IRubyObject x, IRubyObject y) {
        assert (!(x instanceof RubyRational) && !(y instanceof RubyRational));
        return RubyRational.canonicalizeInternal(context, clazz, x, y);
    }

    private static IRubyObject newRational(ThreadContext context, IRubyObject clazz, IRubyObject x) {
        assert (!(x instanceof RubyRational));
        return RubyRational.canonicalizeInternal(context, clazz, x, RubyFixnum.one(context.getRuntime()));
    }

    private static IRubyObject newRationalNoReduce(ThreadContext context, IRubyObject clazz, IRubyObject x, IRubyObject y) {
        assert (!(x instanceof RubyRational) && !(y instanceof RubyRational));
        return RubyRational.canonicalizeInternalNoReduce(context, clazz, x, y);
    }

    private static IRubyObject newRationalNoReduce(ThreadContext context, IRubyObject clazz, IRubyObject x) {
        assert (!(x instanceof RubyRational));
        return RubyRational.canonicalizeInternalNoReduce(context, clazz, x, RubyFixnum.one(context.getRuntime()));
    }

    private static RubyRational newRationalBang(ThreadContext context, IRubyObject clazz, IRubyObject x, IRubyObject y) {
        assert (!Numeric.f_negative_p(context, y) && !Numeric.f_zero_p(context, y));
        return new RubyRational(context.getRuntime(), clazz, x, y);
    }

    private static RubyRational newRationalBang(ThreadContext context, IRubyObject clazz, IRubyObject x) {
        return RubyRational.newRationalBang(context, clazz, x, RubyFixnum.one(context.getRuntime()));
    }

    @Deprecated
    public static IRubyObject newInstanceBang(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        switch (args2.length) {
            case 1: {
                return RubyRational.newInstanceBang(context, recv2, args2[0]);
            }
            case 2: {
                return RubyRational.newInstanceBang(context, recv2, args2[0], args2[1]);
            }
        }
        Arity.raiseArgumentError(context.getRuntime(), args2.length, 1, 1);
        return null;
    }

    @JRubyMethod(name={"new!"}, meta=true, visibility=Visibility.PRIVATE)
    public static IRubyObject newInstanceBang(ThreadContext context, IRubyObject recv2, IRubyObject num) {
        return RubyRational.newInstanceBang(context, recv2, num, RubyFixnum.one(context.getRuntime()));
    }

    @JRubyMethod(name={"new!"}, meta=true, visibility=Visibility.PRIVATE)
    public static IRubyObject newInstanceBang(ThreadContext context, IRubyObject recv2, IRubyObject num, IRubyObject den) {
        Ruby runtime2;
        IRubyObject res;
        if (!(num instanceof RubyInteger)) {
            num = Numeric.f_to_i(context, num);
        }
        if (!(den instanceof RubyInteger)) {
            den = Numeric.f_to_i(context, den);
        }
        if ((res = Numeric.f_cmp(context, den, RubyFixnum.zero(runtime2 = context.getRuntime()))) == RubyFixnum.minus_one(runtime2)) {
            num = Numeric.f_negate(context, num);
            den = Numeric.f_negate(context, den);
        } else if (res == RubyFixnum.zero(runtime2)) {
            throw runtime2.newZeroDivisionError();
        }
        return new RubyRational(runtime2, recv2, num, den);
    }

    static void intCheck(ThreadContext context, IRubyObject num) {
        if (num instanceof RubyFixnum || num instanceof RubyBignum) {
            return;
        }
        if (!(num instanceof RubyNumeric) || !num.callMethod(context, "integer?").isTrue()) {
            throw num.getRuntime().newArgumentError("not an integer");
        }
    }

    static IRubyObject intValue(ThreadContext context, IRubyObject num) {
        RubyRational.intCheck(context, num);
        if (!(num instanceof RubyInteger)) {
            num = num.callMethod(context, "to_f");
        }
        return num;
    }

    private static IRubyObject canonicalizeInternal(ThreadContext context, IRubyObject clazz, IRubyObject num, IRubyObject den) {
        Ruby runtime2 = context.getRuntime();
        IRubyObject res = Numeric.f_cmp(context, den, RubyFixnum.zero(runtime2));
        if (res == RubyFixnum.minus_one(runtime2)) {
            num = Numeric.f_negate(context, num);
            den = Numeric.f_negate(context, den);
        } else if (res == RubyFixnum.zero(runtime2)) {
            throw runtime2.newZeroDivisionError();
        }
        IRubyObject gcd2 = Numeric.f_gcd(context, num, den);
        num = Numeric.f_idiv(context, num, gcd2);
        den = Numeric.f_idiv(context, den, gcd2);
        if (Numeric.f_one_p(context, den) && canonicalization) {
            return num;
        }
        return new RubyRational(context.getRuntime(), clazz, num, den);
    }

    private static IRubyObject canonicalizeInternalNoReduce(ThreadContext context, IRubyObject clazz, IRubyObject num, IRubyObject den) {
        Ruby runtime2 = context.getRuntime();
        IRubyObject res = Numeric.f_cmp(context, den, RubyFixnum.zero(runtime2));
        if (res == RubyFixnum.minus_one(runtime2)) {
            num = Numeric.f_negate(context, num);
            den = Numeric.f_negate(context, den);
        } else if (res == RubyFixnum.zero(runtime2)) {
            throw runtime2.newZeroDivisionError();
        }
        if (Numeric.f_one_p(context, den) && canonicalization) {
            return num;
        }
        return new RubyRational(context.getRuntime(), clazz, num, den);
    }

    @Deprecated
    public static IRubyObject newInstance(ThreadContext context, IRubyObject clazz, IRubyObject[] args2) {
        switch (args2.length) {
            case 1: {
                return RubyRational.newInstance(context, clazz, args2[0]);
            }
            case 2: {
                return RubyRational.newInstance(context, clazz, args2[0], args2[1]);
            }
        }
        Arity.raiseArgumentError(context.getRuntime(), args2.length, 1, 1);
        return null;
    }

    public static IRubyObject newInstance(ThreadContext context, IRubyObject clazz, IRubyObject num) {
        num = RubyRational.intValue(context, num);
        return RubyRational.canonicalizeInternal(context, clazz, num, RubyFixnum.one(context.getRuntime()));
    }

    public static IRubyObject newInstance(ThreadContext context, IRubyObject clazz, IRubyObject num, IRubyObject den) {
        num = RubyRational.intValue(context, num);
        den = RubyRational.intValue(context, den);
        return RubyRational.canonicalizeInternal(context, clazz, num, den);
    }

    public static IRubyObject newRationalConvert(ThreadContext context, IRubyObject x) {
        return RubyRational.newRationalConvert(context, x, RubyFixnum.one(context.getRuntime()));
    }

    public static IRubyObject newRationalConvert(ThreadContext context, IRubyObject x, IRubyObject y) {
        return RubyRational.convert(context, context.getRuntime().getRational(), x, y);
    }

    @Deprecated
    public static IRubyObject convert(ThreadContext context, IRubyObject clazz, IRubyObject[] args2) {
        switch (args2.length) {
            case 1: {
                return RubyRational.convert(context, clazz, args2[0]);
            }
            case 2: {
                return RubyRational.convert(context, clazz, args2[0], args2[1]);
            }
        }
        Arity.raiseArgumentError(context.getRuntime(), args2.length, 1, 1);
        return null;
    }

    @JRubyMethod(name={"convert"}, meta=true, visibility=Visibility.PRIVATE)
    public static IRubyObject convert(ThreadContext context, IRubyObject recv2, IRubyObject a1) {
        return RubyRational.convertCommon(context, recv2, a1, context.getRuntime().getNil());
    }

    @JRubyMethod(name={"convert"}, meta=true, visibility=Visibility.PRIVATE)
    public static IRubyObject convert(ThreadContext context, IRubyObject recv2, IRubyObject a1, IRubyObject a2) {
        return RubyRational.convertCommon(context, recv2, a1, a2);
    }

    private static IRubyObject convertCommon(ThreadContext context, IRubyObject recv2, IRubyObject a1, IRubyObject a2) {
        DynamicScope scope;
        IRubyObject backref;
        RubyComplex a2Complex;
        RubyComplex a1Complex;
        if (a1 instanceof RubyComplex && Numeric.k_exact_p((a1Complex = (RubyComplex)a1).getImage()) && Numeric.f_zero_p(context, a1Complex.getImage())) {
            a1 = a1Complex.getReal();
        }
        if (a2 instanceof RubyComplex && Numeric.k_exact_p((a2Complex = (RubyComplex)a2).getImage()) && Numeric.f_zero_p(context, a2Complex.getImage())) {
            a2 = a2Complex.getReal();
        }
        if ((backref = (scope = context.getCurrentScope()).getBackRef(context.getRuntime())) instanceof RubyMatchData) {
            ((RubyMatchData)backref).use();
        }
        if (a1 instanceof RubyFloat) {
            a1 = Numeric.f_to_r(context, a1);
        } else if (a1 instanceof RubyString) {
            a1 = RubyRational.str_to_r_strict(context, a1);
        }
        if (a2 instanceof RubyFloat) {
            a2 = Numeric.f_to_r(context, a2);
        } else if (a2 instanceof RubyString) {
            a2 = RubyRational.str_to_r_strict(context, a2);
        }
        scope.setBackRef(backref);
        if (a1 instanceof RubyRational && (a2.isNil() || Numeric.k_exact_p(a2) && Numeric.f_one_p(context, a2))) {
            return a1;
        }
        if (a2.isNil()) {
            if (a1 instanceof RubyNumeric && !Numeric.f_integer_p(context, a1).isTrue()) {
                return a1;
            }
            return RubyRational.newInstance(context, recv2, a1);
        }
        if (a1 instanceof RubyNumeric && a2 instanceof RubyNumeric && (!Numeric.f_integer_p(context, a1).isTrue() || !Numeric.f_integer_p(context, a2).isTrue())) {
            return Numeric.f_div(context, a1, a2);
        }
        return RubyRational.newInstance(context, recv2, a1, a2);
    }

    @JRubyMethod(name={"numerator"})
    public IRubyObject numerator(ThreadContext context) {
        return this.num;
    }

    @JRubyMethod(name={"denominator"})
    public IRubyObject denominator(ThreadContext context) {
        return this.den;
    }

    private static IRubyObject f_imul(ThreadContext context, long a, long b) {
        Ruby runtime2 = context.getRuntime();
        if (a == 0L || b == 0L) {
            return RubyFixnum.zero(runtime2);
        }
        if (a == 1L) {
            return RubyFixnum.newFixnum(runtime2, b);
        }
        if (b == 1L) {
            return RubyFixnum.newFixnum(runtime2, a);
        }
        long c = a * b;
        if (c / a != b) {
            return RubyBignum.newBignum(runtime2, a).op_mul(context, RubyBignum.newBignum(runtime2, b));
        }
        return RubyFixnum.newFixnum(runtime2, c);
    }

    private IRubyObject f_addsub(ThreadContext context, IRubyObject anum, IRubyObject aden, IRubyObject bnum, IRubyObject bden, boolean plus) {
        IRubyObject b;
        IRubyObject a;
        IRubyObject g;
        Ruby runtime2 = context.getRuntime();
        if (anum instanceof RubyFixnum && aden instanceof RubyFixnum && bnum instanceof RubyFixnum && bden instanceof RubyFixnum) {
            long an = ((RubyFixnum)anum).getLongValue();
            long ad = ((RubyFixnum)aden).getLongValue();
            long bn = ((RubyFixnum)bnum).getLongValue();
            long bd = ((RubyFixnum)bden).getLongValue();
            long ig = Numeric.i_gcd(ad, bd);
            g = RubyFixnum.newFixnum(runtime2, ig);
            a = RubyRational.f_imul(context, an, bd / ig);
            b = RubyRational.f_imul(context, bn, ad / ig);
        } else {
            g = Numeric.f_gcd(context, aden, bden);
            a = Numeric.f_mul(context, anum, Numeric.f_idiv(context, bden, g));
            b = Numeric.f_mul(context, bnum, Numeric.f_idiv(context, aden, g));
        }
        IRubyObject c = plus ? Numeric.f_add(context, a, b) : Numeric.f_sub(context, a, b);
        b = Numeric.f_idiv(context, aden, g);
        g = Numeric.f_gcd(context, c, g);
        IRubyObject num = Numeric.f_idiv(context, c, g);
        a = Numeric.f_idiv(context, bden, g);
        IRubyObject den = Numeric.f_mul(context, a, b);
        return RubyRational.newRationalNoReduce(context, this.getMetaClass(), num, den);
    }

    @JRubyMethod(name={"+"})
    public IRubyObject op_add(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum || other instanceof RubyBignum) {
            return this.f_addsub(context, this.num, this.den, other, RubyFixnum.one(context.getRuntime()), true);
        }
        if (other instanceof RubyFloat) {
            return Numeric.f_add(context, Numeric.f_to_f(context, this), other);
        }
        if (other instanceof RubyRational) {
            RubyRational otherRational = (RubyRational)other;
            return this.f_addsub(context, this.num, this.den, otherRational.num, otherRational.den, true);
        }
        return this.coerceBin(context, "+", other);
    }

    @JRubyMethod(name={"-"})
    public IRubyObject op_sub(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum || other instanceof RubyBignum) {
            return this.f_addsub(context, this.num, this.den, other, RubyFixnum.one(context.getRuntime()), false);
        }
        if (other instanceof RubyFloat) {
            return Numeric.f_sub(context, Numeric.f_to_f(context, this), other);
        }
        if (other instanceof RubyRational) {
            RubyRational otherRational = (RubyRational)other;
            return this.f_addsub(context, this.num, this.den, otherRational.num, otherRational.den, false);
        }
        return this.coerceBin(context, "-", other);
    }

    private IRubyObject f_muldiv(ThreadContext context, IRubyObject anum, IRubyObject aden, IRubyObject bnum, IRubyObject bden, boolean mult) {
        IRubyObject den;
        IRubyObject num;
        if (!mult) {
            if (Numeric.f_negative_p(context, bnum)) {
                anum = Numeric.f_negate(context, anum);
                bnum = Numeric.f_negate(context, bnum);
            }
            IRubyObject tmp = bnum;
            bnum = bden;
            bden = tmp;
        }
        if (anum instanceof RubyFixnum && aden instanceof RubyFixnum && bnum instanceof RubyFixnum && bden instanceof RubyFixnum) {
            long an = ((RubyFixnum)anum).getLongValue();
            long ad = ((RubyFixnum)aden).getLongValue();
            long bn = ((RubyFixnum)bnum).getLongValue();
            long bd = ((RubyFixnum)bden).getLongValue();
            long g1 = Numeric.i_gcd(an, bd);
            long g2 = Numeric.i_gcd(ad, bn);
            num = RubyRational.f_imul(context, an / g1, bn / g2);
            den = RubyRational.f_imul(context, ad / g2, bd / g1);
        } else {
            IRubyObject g1 = Numeric.f_gcd(context, anum, bden);
            IRubyObject g2 = Numeric.f_gcd(context, aden, bnum);
            num = Numeric.f_mul(context, Numeric.f_idiv(context, anum, g1), Numeric.f_idiv(context, bnum, g2));
            den = Numeric.f_mul(context, Numeric.f_idiv(context, aden, g2), Numeric.f_idiv(context, bden, g1));
        }
        return RubyRational.newRationalNoReduce(context, this.getMetaClass(), num, den);
    }

    @JRubyMethod(name={"*"})
    public IRubyObject op_mul(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum || other instanceof RubyBignum) {
            return this.f_muldiv(context, this.num, this.den, other, RubyFixnum.one(context.getRuntime()), true);
        }
        if (other instanceof RubyFloat) {
            return Numeric.f_mul(context, Numeric.f_to_f(context, this), other);
        }
        if (other instanceof RubyRational) {
            RubyRational otherRational = (RubyRational)other;
            return this.f_muldiv(context, this.num, this.den, otherRational.num, otherRational.den, true);
        }
        return this.coerceBin(context, "*", other);
    }

    @JRubyMethod(name={"/", "quo"})
    public IRubyObject op_div(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum || other instanceof RubyBignum) {
            if (Numeric.f_zero_p(context, other)) {
                throw context.getRuntime().newZeroDivisionError();
            }
            return this.f_muldiv(context, this.num, this.den, other, RubyFixnum.one(context.getRuntime()), false);
        }
        if (other instanceof RubyFloat) {
            return Numeric.f_to_f(context, this).callMethod(context, "/", other);
        }
        if (other instanceof RubyRational) {
            if (Numeric.f_zero_p(context, other)) {
                throw context.getRuntime().newZeroDivisionError();
            }
            RubyRational otherRational = (RubyRational)other;
            return this.f_muldiv(context, this.num, this.den, otherRational.num, otherRational.den, false);
        }
        return this.coerceBin(context, "/", other);
    }

    @JRubyMethod(name={"fdiv"})
    public IRubyObject op_fdiv(ThreadContext context, IRubyObject other) {
        return Numeric.f_div(context, Numeric.f_to_f(context, this), other);
    }

    @JRubyMethod(name={"**"})
    public IRubyObject op_expt(ThreadContext context, IRubyObject other) {
        Ruby runtime2 = context.getRuntime();
        if (Numeric.k_exact_p(other) && Numeric.f_zero_p(context, other)) {
            return RubyRational.newRationalBang(context, this.getMetaClass(), RubyFixnum.one(runtime2));
        }
        if (other instanceof RubyRational) {
            RubyRational otherRational = (RubyRational)other;
            if (Numeric.f_one_p(context, otherRational.den)) {
                other = otherRational.num;
            }
        }
        if (other instanceof RubyFixnum || other instanceof RubyBignum) {
            IRubyObject tden;
            IRubyObject tnum;
            IRubyObject res = Numeric.f_cmp(context, other, RubyFixnum.zero(runtime2));
            if (res == RubyFixnum.one(runtime2)) {
                tnum = Numeric.f_expt(context, this.num, other);
                tden = Numeric.f_expt(context, this.den, other);
            } else if (res == RubyFixnum.minus_one(runtime2)) {
                tnum = Numeric.f_expt(context, this.den, Numeric.f_negate(context, other));
                tden = Numeric.f_expt(context, this.num, Numeric.f_negate(context, other));
            } else {
                tden = RubyFixnum.one(runtime2);
                tnum = tden;
            }
            return RubyRational.newRational(context, this.getMetaClass(), tnum, tden);
        }
        if (other instanceof RubyFloat || other instanceof RubyRational) {
            return Numeric.f_expt(context, Numeric.f_to_f(context, this), other);
        }
        return this.coerceBin(context, "**", other);
    }

    @JRubyMethod(name={"<=>"})
    public IRubyObject op_cmp(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum || other instanceof RubyBignum) {
            if (this.den instanceof RubyFixnum && ((RubyFixnum)this.den).getLongValue() == 1L) {
                return Numeric.f_cmp(context, this.num, other);
            }
            return Numeric.f_cmp(context, this, RubyRational.newRationalBang(context, this.getMetaClass(), other));
        }
        if (other instanceof RubyFloat) {
            return Numeric.f_cmp(context, Numeric.f_to_f(context, this), other);
        }
        if (other instanceof RubyRational) {
            IRubyObject num2;
            IRubyObject num1;
            RubyRational otherRational = (RubyRational)other;
            if (this.num instanceof RubyFixnum && this.den instanceof RubyFixnum && otherRational.num instanceof RubyFixnum && otherRational.den instanceof RubyFixnum) {
                num1 = RubyRational.f_imul(context, ((RubyFixnum)this.num).getLongValue(), ((RubyFixnum)otherRational.den).getLongValue());
                num2 = RubyRational.f_imul(context, ((RubyFixnum)otherRational.num).getLongValue(), ((RubyFixnum)this.den).getLongValue());
            } else {
                num1 = Numeric.f_mul(context, this.num, otherRational.den);
                num2 = Numeric.f_mul(context, otherRational.num, this.den);
            }
            return Numeric.f_cmp(context, Numeric.f_sub(context, num1, num2), RubyFixnum.zero(context.getRuntime()));
        }
        return this.coerceBin(context, "<=>", other);
    }

    @JRubyMethod(name={"=="})
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        Ruby runtime2 = context.getRuntime();
        if (other instanceof RubyFixnum || other instanceof RubyBignum) {
            if (Numeric.f_zero_p(context, this.num) && Numeric.f_zero_p(context, other)) {
                return runtime2.getTrue();
            }
            if (!(this.den instanceof RubyFixnum) || ((RubyFixnum)this.den).getLongValue() != 1L) {
                return runtime2.getFalse();
            }
            if (Numeric.f_equal_p(context, this.num, other)) {
                return runtime2.getTrue();
            }
            return runtime2.getFalse();
        }
        if (other instanceof RubyFloat) {
            return Numeric.f_equal_p(context, Numeric.f_to_f(context, this), other) ? runtime2.getTrue() : runtime2.getFalse();
        }
        if (other instanceof RubyRational) {
            RubyRational otherRational = (RubyRational)other;
            if (Numeric.f_zero_p(context, this.num) && Numeric.f_zero_p(context, otherRational.num)) {
                return runtime2.getTrue();
            }
            if (Numeric.f_equal_p(context, this.num, otherRational.num) && Numeric.f_equal_p(context, this.den, otherRational.den)) {
                return runtime2.getTrue();
            }
            return runtime2.getFalse();
        }
        return Numeric.f_equal_p(context, other, this) ? runtime2.getTrue() : runtime2.getFalse();
    }

    @JRubyMethod(name={"coerce"})
    public IRubyObject op_coerce(ThreadContext context, IRubyObject other) {
        Ruby runtime2 = context.getRuntime();
        if (other instanceof RubyFixnum || other instanceof RubyBignum) {
            return runtime2.newArray((IRubyObject)RubyRational.newRationalBang(context, this.getMetaClass(), other), (IRubyObject)this);
        }
        if (other instanceof RubyFloat) {
            return runtime2.newArray(other, Numeric.f_to_f(context, this));
        }
        throw runtime2.newTypeError(other.getMetaClass() + " can't be coerced into " + this.getMetaClass());
    }

    @JRubyMethod(name={"div"})
    public IRubyObject op_idiv(ThreadContext context, IRubyObject other) {
        return Numeric.f_floor(context, Numeric.f_div(context, this, other));
    }

    @JRubyMethod(name={"modulo", "%"})
    public IRubyObject op_mod(ThreadContext context, IRubyObject other) {
        IRubyObject val = Numeric.f_floor(context, Numeric.f_div(context, this, other));
        return Numeric.f_sub(context, this, Numeric.f_mul(context, other, val));
    }

    @JRubyMethod(name={"divmod"})
    public IRubyObject op_divmod(ThreadContext context, IRubyObject other) {
        IRubyObject val = Numeric.f_floor(context, Numeric.f_div(context, this, other));
        return context.getRuntime().newArray(val, Numeric.f_sub(context, this, Numeric.f_mul(context, other, val)));
    }

    @JRubyMethod(name={"remainder"})
    public IRubyObject op_rem(ThreadContext context, IRubyObject other) {
        IRubyObject val = Numeric.f_truncate(context, Numeric.f_div(context, this, other));
        return Numeric.f_sub(context, this, Numeric.f_mul(context, other, val));
    }

    @JRubyMethod(name={"abs"})
    public IRubyObject op_abs(ThreadContext context) {
        if (!Numeric.f_negative_p(context, this)) {
            return this;
        }
        return Numeric.f_negate(context, this);
    }

    private IRubyObject op_roundCommonPre(ThreadContext context, IRubyObject n) {
        Ruby runtime2 = context.getRuntime();
        if (!(n instanceof RubyInteger)) {
            throw runtime2.newTypeError("not an integer");
        }
        return Numeric.f_expt(context, RubyFixnum.newFixnum(runtime2, 10L), n);
    }

    private IRubyObject op_roundCommonPost(ThreadContext context, IRubyObject s, IRubyObject n, IRubyObject b) {
        s = Numeric.f_div(context, RubyRational.newRationalBang(context, this.getMetaClass(), s), b);
        if (Numeric.f_lt_p(context, n, RubyFixnum.one(context.getRuntime())).isTrue()) {
            s = Numeric.f_to_i(context, s);
        }
        return s;
    }

    @JRubyMethod(name={"floor"})
    public IRubyObject op_floor(ThreadContext context) {
        return Numeric.f_idiv(context, this.num, this.den);
    }

    @JRubyMethod(name={"floor"})
    public IRubyObject op_floor(ThreadContext context, IRubyObject n) {
        IRubyObject b = this.op_roundCommonPre(context, n);
        return this.op_roundCommonPost(context, ((RubyRational)Numeric.f_mul(context, this, b)).op_floor(context), n, b);
    }

    @JRubyMethod(name={"ceil"})
    public IRubyObject op_ceil(ThreadContext context) {
        return Numeric.f_negate(context, Numeric.f_idiv(context, Numeric.f_negate(context, this.num), this.den));
    }

    @JRubyMethod(name={"ceil"})
    public IRubyObject op_ceil(ThreadContext context, IRubyObject n) {
        IRubyObject b = this.op_roundCommonPre(context, n);
        return this.op_roundCommonPost(context, ((RubyRational)Numeric.f_mul(context, this, b)).op_ceil(context), n, b);
    }

    @JRubyMethod(name={"truncate", "to_i"})
    public IRubyObject op_truncate(ThreadContext context) {
        if (Numeric.f_negative_p(context, this.num)) {
            return Numeric.f_negate(context, Numeric.f_idiv(context, Numeric.f_negate(context, this.num), this.den));
        }
        return Numeric.f_idiv(context, this.num, this.den);
    }

    @JRubyMethod(name={"truncate"})
    public IRubyObject op_truncate(ThreadContext context, IRubyObject n) {
        IRubyObject b = this.op_roundCommonPre(context, n);
        return this.op_roundCommonPost(context, ((RubyRational)Numeric.f_mul(context, this, b)).op_truncate(context), n, b);
    }

    @JRubyMethod(name={"round"})
    public IRubyObject op_round(ThreadContext context) {
        IRubyObject num = this.num;
        boolean neg = Numeric.f_negative_p(context, num);
        if (neg) {
            num = Numeric.f_negate(context, num);
        }
        IRubyObject den = this.den;
        RubyFixnum two = RubyFixnum.two(context.getRuntime());
        num = Numeric.f_add(context, Numeric.f_mul(context, num, two), den);
        den = Numeric.f_mul(context, den, two);
        num = Numeric.f_idiv(context, num, den);
        if (neg) {
            num = Numeric.f_negate(context, num);
        }
        return num;
    }

    @JRubyMethod(name={"round"})
    public IRubyObject op_round(ThreadContext context, IRubyObject n) {
        IRubyObject b = this.op_roundCommonPre(context, n);
        return this.op_roundCommonPost(context, ((RubyRational)Numeric.f_mul(context, this, b)).op_round(context), n, b);
    }

    @JRubyMethod(name={"to_f"})
    public IRubyObject to_f(ThreadContext context) {
        long e;
        Ruby runtime2 = context.getRuntime();
        if (Numeric.f_zero_p(context, this.num)) {
            return runtime2.newFloat(0.0);
        }
        IRubyObject num = this.num;
        IRubyObject den = this.den;
        boolean minus = false;
        if (Numeric.f_negative_p(context, num)) {
            num = Numeric.f_negate(context, num);
            minus = true;
        }
        long nl = Numeric.i_ilog2(context, num);
        long dl = Numeric.i_ilog2(context, den);
        long ne = 0L;
        if (nl > ML) {
            ne = nl - ML;
            num = Numeric.f_rshift(context, num, RubyFixnum.newFixnum(runtime2, ne));
        }
        long de = 0L;
        if (dl > ML) {
            de = dl - ML;
            den = Numeric.f_rshift(context, den, RubyFixnum.newFixnum(runtime2, de));
        }
        if ((e = ne - de) > 1023L || e < -1022L) {
            runtime2.getWarnings().warn(IRubyWarnings.ID.FLOAT_OUT_OF_RANGE, "out of Float range", this.getMetaClass());
            return runtime2.newFloat(e > 0L ? Double.MAX_VALUE : 0.0);
        }
        double f = RubyNumeric.num2dbl(num) / RubyNumeric.num2dbl(den);
        if (minus) {
            f = -f;
        }
        if (Double.isInfinite(f = Numeric.ldexp(f, e)) || Double.isNaN(f)) {
            runtime2.getWarnings().warn(IRubyWarnings.ID.FLOAT_OUT_OF_RANGE, "out of Float range", this.getMetaClass());
        }
        return runtime2.newFloat(f);
    }

    @JRubyMethod(name={"to_r"})
    public IRubyObject to_r(ThreadContext context) {
        return this;
    }

    @JRubyMethod(name={"hash"})
    public IRubyObject hash(ThreadContext context) {
        return Numeric.f_xor(context, this.num.callMethod(context, "hash"), this.den.callMethod(context, "hash"));
    }

    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s(ThreadContext context) {
        RubyString str = context.getRuntime().newString();
        str.append(Numeric.f_to_s(context, this.num));
        str.cat((byte)47);
        str.append(Numeric.f_to_s(context, this.den));
        return str;
    }

    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect(ThreadContext context) {
        RubyString str = context.getRuntime().newString();
        str.cat((byte)40);
        str.append(Numeric.f_inspect(context, this.num));
        str.cat((byte)47);
        str.append(Numeric.f_inspect(context, this.den));
        str.cat((byte)41);
        return str;
    }

    @JRubyMethod(name={"marshal_dump"})
    public IRubyObject marshal_dump(ThreadContext context) {
        RubyArray dump2 = context.getRuntime().newArray(this.num, this.den);
        if (this.hasVariables()) {
            dump2.syncVariables(this.getVariableList());
        }
        return dump2;
    }

    @JRubyMethod(name={"marshal_load"})
    public IRubyObject marshal_load(ThreadContext context, IRubyObject arg2) {
        RubyArray load2 = arg2.convertToArray();
        this.num = load2.size() > 0 ? load2.eltInternal(0) : context.getRuntime().getNil();
        IRubyObject iRubyObject = this.den = load2.size() > 1 ? load2.eltInternal(1) : context.getRuntime().getNil();
        if (Numeric.f_zero_p(context, this.den)) {
            throw context.getRuntime().newZeroDivisionError();
        }
        if (load2.hasVariables()) {
            this.syncVariables(load2.getVariableList());
        }
        return this;
    }

    static RubyArray str_to_r_internal(ThreadContext context, IRubyObject recv2) {
        RubyString s = recv2.convertToString();
        ByteList bytes2 = s.getByteList();
        Ruby runtime2 = context.getRuntime();
        if (bytes2.realSize == 0) {
            return runtime2.newArray(runtime2.getNil(), recv2);
        }
        IRubyObject m = RubyRegexp.newDummyRegexp(runtime2, Numeric.RationalPatterns.rat_pat).callMethod(context, "match", (IRubyObject)s);
        if (!m.isNil()) {
            ByteList siBytes;
            IRubyObject si = m.callMethod(context, "[]", RubyFixnum.one(runtime2));
            IRubyObject nu = m.callMethod(context, "[]", RubyFixnum.two(runtime2));
            IRubyObject de = m.callMethod(context, "[]", RubyFixnum.three(runtime2));
            IRubyObject re = m.callMethod(context, "post_match");
            RubyArray a = nu.callMethod(context, "split", RubyRegexp.newDummyRegexp(runtime2, Numeric.RationalPatterns.an_e_pat)).convertToArray();
            IRubyObject ifp = a.eltInternal(0);
            IRubyObject exp2 = a.size() != 2 ? runtime2.getNil() : a.eltInternal(1);
            a = ifp.callMethod(context, "split", RubyRegexp.newDummyRegexp(runtime2, Numeric.RationalPatterns.a_dot_pat)).convertToArray();
            IRubyObject ip = a.eltInternal(0);
            IRubyObject fp = a.size() != 2 ? runtime2.getNil() : a.eltInternal(1);
            IRubyObject v = RubyRational.newRationalCanonicalize(context, Numeric.f_to_i(context, ip));
            if (!fp.isNil()) {
                int i;
                bytes2 = fp.convertToString().getByteList();
                int count2 = 0;
                byte[] buf = bytes2.bytes;
                int end2 = i + bytes2.realSize;
                for (i = bytes2.begin; i < end2; ++i) {
                    if (!ASCIIEncoding.INSTANCE.isDigit(buf[i])) continue;
                    ++count2;
                }
                IRubyObject l = Numeric.f_expt(context, RubyFixnum.newFixnum(runtime2, 10L), RubyFixnum.newFixnum(runtime2, count2));
                v = Numeric.f_mul(context, v, l);
                v = Numeric.f_add(context, v, Numeric.f_to_i(context, fp));
                v = Numeric.f_div(context, v, l);
            }
            if (!si.isNil() && (siBytes = si.convertToString().getByteList()).length() > 0 && siBytes.get(0) == 45) {
                v = Numeric.f_negate(context, v);
            }
            if (!exp2.isNil()) {
                v = Numeric.f_mul(context, v, Numeric.f_expt(context, RubyFixnum.newFixnum(runtime2, 10L), Numeric.f_to_i(context, exp2)));
            }
            if (!de.isNil()) {
                v = Numeric.f_div(context, v, Numeric.f_to_i(context, de));
            }
            return runtime2.newArray(v, re);
        }
        return runtime2.newArray(runtime2.getNil(), recv2);
    }

    private static IRubyObject str_to_r_strict(ThreadContext context, IRubyObject recv2) {
        RubyArray a = RubyRational.str_to_r_internal(context, recv2);
        if (a.eltInternal(0).isNil() || a.eltInternal(1).convertToString().getByteList().length() > 0) {
            IRubyObject s = recv2.callMethod(context, "inspect");
            throw context.getRuntime().newArgumentError("invalid value for convert(): " + s.convertToString());
        }
        return a.eltInternal(0);
    }
}

