/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.win32;

import com.sun.jna.FunctionMapper;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.NativeMapped;
import com.sun.jna.NativeMappedConverter;
import com.sun.jna.Pointer;
import java.lang.reflect.Method;

public class StdCallFunctionMapper
implements FunctionMapper {
    protected int getArgumentNativeStackSize(Class cls) {
        if (NativeMapped.class.isAssignableFrom(cls)) {
            cls = NativeMappedConverter.getInstance(cls).nativeType();
        }
        if (cls.isArray()) {
            return Pointer.SIZE;
        }
        try {
            return Native.getNativeSize(cls);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Unknown native stack allocation size for " + cls);
        }
    }

    public String getFunctionName(NativeLibrary library2, Method method2) {
        String name2 = method2.getName();
        int pop2 = 0;
        Class<?>[] argTypes = method2.getParameterTypes();
        for (int i = 0; i < argTypes.length; ++i) {
            pop2 += this.getArgumentNativeStackSize(argTypes[i]);
        }
        String decorated = name2 + "@" + pop2;
        int conv2 = 1;
        try {
            name2 = library2.getFunction(decorated, conv2).getName();
        }
        catch (UnsatisfiedLinkError e) {
            try {
                name2 = library2.getFunction("_" + decorated, conv2).getName();
            }
            catch (UnsatisfiedLinkError e2) {
                // empty catch block
            }
        }
        return name2;
    }
}

