/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.variable;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyObject;
import org.jruby.embed.BiVariable;
import org.jruby.embed.internal.BiVariableMap;
import org.jruby.embed.variable.AbstractVariable;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.InstanceVariables;

public class InstanceVariable
extends AbstractVariable {
    public static BiVariable getInstance(Ruby runtime2, String name2, Object ... javaObject) {
        String pattern = "@([a-zA-Z]|_)([a-zA-Z]|_|\\d)*";
        if (name2.matches(pattern)) {
            return new InstanceVariable(runtime2, name2, javaObject);
        }
        return null;
    }

    private InstanceVariable(Ruby runtime2, String name2, Object ... javaObject) {
        super(runtime2, name2, javaObject);
    }

    public InstanceVariable(String name2, IRubyObject irubyObject) {
        super(name2, irubyObject);
    }

    public static void retrieve(Ruby runtime2, IRubyObject receiver2, BiVariableMap vars) {
        if (receiver2 == null) {
            receiver2 = runtime2.getTopSelf();
        }
        InstanceVariables ivars = receiver2.getInstanceVariables();
        List<String> names2 = ivars.getInstanceVariableNameList();
        for (String name2 : names2) {
            BiVariable var;
            IRubyObject value2 = ivars.fastGetInstanceVariable(name2);
            if (vars.containsKey(name2)) {
                var = vars.getVariable(name2);
                var.setRubyObject(value2);
                continue;
            }
            var = new InstanceVariable(name2, value2);
            vars.update(name2, var);
        }
    }

    public BiVariable.Type getType() {
        return BiVariable.Type.InstanceVariable;
    }

    public void inject(Ruby runtime2, IRubyObject receiver2) {
        ThreadContext context = runtime2.getCurrentContext();
        IRubyObject rubyReceiver = receiver2 != null ? receiver2 : context.getFrameSelf();
        IRubyObject rubyName = JavaEmbedUtils.javaToRuby(runtime2, this.name);
        ((RubyObject)rubyReceiver).instance_variable_set(rubyName, this.irubyObject);
    }

    public void remove(Ruby runtime2) {
        ThreadContext context = runtime2.getCurrentContext();
        IRubyObject self = context.getFrameSelf();
        self.getInstanceVariables().removeInstanceVariable(this.name);
    }
}

