/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.RubyModule;
import org.jruby.internal.runtime.JumpTarget;
import org.jruby.runtime.Block;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public final class Frame
implements JumpTarget {
    private RubyModule klazz;
    private IRubyObject self;
    private String name;
    private Block block = Block.NULL_BLOCK;
    private boolean isBindingFrame = false;
    private Visibility visibility = Visibility.PUBLIC;
    private final JumpTarget jumpTarget;
    private String fileName;
    private int line;

    public Frame() {
        this.jumpTarget = this;
    }

    private Frame(Frame frame) {
        assert (frame.block != null) : "Block uses null object pattern.  It should NEVER be null";
        this.self = frame.self;
        this.name = frame.name;
        this.klazz = frame.klazz;
        this.fileName = frame.fileName;
        this.line = frame.line;
        this.block = frame.block;
        this.visibility = frame.visibility;
        this.isBindingFrame = frame.isBindingFrame;
        this.jumpTarget = frame.jumpTarget;
    }

    public void updateFrame(String fileName, int line) {
        this.updateFrame(null, null, null, Block.NULL_BLOCK, fileName, line);
    }

    public void updateFrame(String name2, String fileName, int line) {
        this.name = name2;
        this.fileName = fileName;
        this.line = line;
    }

    public void updateFrame(Frame frame) {
        assert (frame.block != null) : "Block uses null object pattern.  It should NEVER be null";
        this.self = frame.self;
        this.name = frame.name;
        this.klazz = frame.klazz;
        this.fileName = frame.fileName;
        this.line = frame.line;
        this.block = frame.block;
        this.visibility = frame.visibility;
        this.isBindingFrame = frame.isBindingFrame;
    }

    public void updateFrame(RubyModule klazz, IRubyObject self, String name2, Block block, String fileName, int line) {
        assert (block != null) : "Block uses null object pattern.  It should NEVER be null";
        this.self = self;
        this.name = name2;
        this.klazz = klazz;
        this.fileName = fileName;
        this.line = line;
        this.block = block;
        this.visibility = Visibility.PUBLIC;
        this.isBindingFrame = false;
    }

    public void updateFrameForEval(IRubyObject self, String fileName, int line) {
        this.self = self;
        this.name = null;
        this.fileName = fileName;
        this.line = line;
        this.visibility = Visibility.PRIVATE;
        this.isBindingFrame = false;
    }

    public void clear() {
        this.self = null;
        this.klazz = null;
        this.block = Block.NULL_BLOCK;
    }

    public Frame duplicate() {
        return new Frame(this);
    }

    public JumpTarget getJumpTarget() {
        return this.jumpTarget;
    }

    @Deprecated
    public void setJumpTarget(JumpTarget jumpTarget) {
    }

    public String getFile() {
        return this.fileName;
    }

    public void setFile(String fileName) {
        this.fileName = fileName;
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public void setFileAndLine(String file2, int line) {
        this.fileName = file2;
        this.line = line;
    }

    public RubyModule getKlazz() {
        return this.klazz;
    }

    public void setKlazz(RubyModule klazz) {
        this.klazz = klazz;
    }

    public void setName(String name2) {
        this.name = name2;
    }

    public String getName() {
        return this.name;
    }

    IRubyObject getSelf() {
        return this.self;
    }

    public void setSelf(IRubyObject self) {
        this.self = self;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public boolean isBindingFrame() {
        return this.isBindingFrame;
    }

    public void setIsBindingFrame(boolean isBindingFrame) {
        this.isBindingFrame = isBindingFrame;
    }

    public Block getBlock() {
        return this.block;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(50);
        sb.append(this.fileName).append(':').append(this.line + 1).append(':').append(this.klazz);
        if (this.name != null) {
            sb.append(" in ").append(this.name);
        }
        return sb.toString();
    }
}

