/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jna;

import com.sun.jna.Function;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.AbstractInvoker;
import org.jruby.ext.ffi.NativeParam;
import org.jruby.ext.ffi.NativeType;
import org.jruby.ext.ffi.jna.CallbackMarshaller;
import org.jruby.ext.ffi.jna.CallbackMethodWithBlock;
import org.jruby.ext.ffi.jna.DynamicLibrary;
import org.jruby.ext.ffi.jna.DynamicMethodOneArg;
import org.jruby.ext.ffi.jna.DynamicMethodThreeArg;
import org.jruby.ext.ffi.jna.DynamicMethodTwoArg;
import org.jruby.ext.ffi.jna.DynamicMethodZeroArg;
import org.jruby.ext.ffi.jna.FunctionInvoker;
import org.jruby.ext.ffi.jna.Invocation;
import org.jruby.ext.ffi.jna.JNAProvider;
import org.jruby.ext.ffi.jna.Marshaller;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public final class JNAInvoker
extends AbstractInvoker {
    private final Function function;
    private final FunctionInvoker functionInvoker;
    private final Marshaller[] marshallers;

    public static RubyClass createInvokerClass(Ruby runtime2, RubyModule module) {
        RubyClass result = module.defineClassUnder("Invoker", runtime2.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        result.defineAnnotatedMethods(AbstractInvoker.class);
        result.defineAnnotatedMethods(JNAInvoker.class);
        result.defineAnnotatedConstants(JNAInvoker.class);
        return result;
    }

    @JRubyMethod(name={"new"}, meta=true, required=4)
    public static IRubyObject newInstance(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        if (!(args2[0] instanceof DynamicLibrary.Symbol)) {
            throw context.getRuntime().newArgumentError("Invalid function address");
        }
        if (!(args2[1] instanceof RubyArray)) {
            throw context.getRuntime().newArgumentError("Invalid parameter types array");
        }
        DynamicLibrary.Symbol symbol = (DynamicLibrary.Symbol)args2[0];
        RubyArray paramTypes = (RubyArray)args2[1];
        NativeType returnType = NativeType.valueOf(args2[2]);
        int conv2 = "stdcall".equals(args2[3].toString()) ? 1 : 0;
        NativeParam[] parameterTypes = JNAInvoker.getNativeParameterTypes(context.getRuntime(), paramTypes);
        Marshaller[] marshallers = new Marshaller[parameterTypes.length];
        for (int i = 0; i < marshallers.length; ++i) {
            marshallers[i] = JNAProvider.getMarshaller(parameterTypes[i], conv2);
        }
        Function function = symbol.getNativeLibrary().getFunction(symbol.getName(), conv2);
        FunctionInvoker functionInvoker = JNAProvider.getFunctionInvoker(returnType);
        return new JNAInvoker(context.getRuntime(), (RubyClass)recv2, function, functionInvoker, marshallers);
    }

    public JNAInvoker(Ruby runtime2, RubyClass klass, Function function, FunctionInvoker functionInvoker, Marshaller[] marshallers) {
        super(runtime2, klass, marshallers.length);
        this.function = function;
        this.functionInvoker = functionInvoker;
        this.marshallers = marshallers;
    }

    @JRubyMethod(name={"invoke", "call", "call0", "call1", "call2", "call3"}, rest=true)
    public IRubyObject invoke(ThreadContext context, IRubyObject[] rubyArgs) {
        Object[] args2 = new Object[rubyArgs.length];
        Invocation invocation = new Invocation(context);
        for (int i = 0; i < args2.length; ++i) {
            args2[i] = this.marshallers[i].marshal(invocation, rubyArgs[i]);
        }
        IRubyObject retVal = this.functionInvoker.invoke(context.getRuntime(), this.function, args2);
        invocation.finish();
        return retVal;
    }

    public DynamicMethod createDynamicMethod(RubyModule module) {
        if (this.marshallers.length > 0) {
            int cbcount = 0;
            int cbindex = -1;
            for (int i = 0; i < this.marshallers.length; ++i) {
                if (!(this.marshallers[i] instanceof CallbackMarshaller)) continue;
                ++cbcount;
                cbindex = i;
            }
            if (cbcount == 1) {
                return new CallbackMethodWithBlock(module, this.function, this.functionInvoker, this.marshallers, cbindex);
            }
        }
        if (Arity.NO_ARGUMENTS.equals(this.arity)) {
            return new DynamicMethodZeroArg(module, this.function, this.functionInvoker);
        }
        if (Arity.ONE_ARGUMENT.equals(this.arity)) {
            return new DynamicMethodOneArg(module, this.function, this.functionInvoker, this.marshallers);
        }
        if (Arity.TWO_ARGUMENTS.equals(this.arity)) {
            return new DynamicMethodTwoArg(module, this.function, this.functionInvoker, this.marshallers);
        }
        if (Arity.THREE_ARGUMENTS.equals(this.arity)) {
            return new DynamicMethodThreeArg(module, this.function, this.functionInvoker, this.marshallers);
        }
        return new DynamicMethod(module, Visibility.PUBLIC, CallConfiguration.FrameNoneScopeNone){

            public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
                JNAInvoker.this.arity.checkArity(context.getRuntime(), args2);
                return JNAInvoker.this.invoke(context, args2);
            }

            public DynamicMethod dup() {
                return this;
            }

            public Arity getArity() {
                return JNAInvoker.this.getArity();
            }

            public boolean isNative() {
                return true;
            }
        };
    }
}

