/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.java.proxies;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyMethod;
import org.jruby.java.invokers.InstanceFieldGetter;
import org.jruby.java.invokers.InstanceFieldSetter;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaProxy
extends RubyObject {
    protected final RubyClass.VariableAccessor objectAccessor;

    public JavaProxy(Ruby runtime2, RubyClass klazz) {
        super(runtime2, klazz);
        this.objectAccessor = klazz.getVariableAccessorForWrite("__wrap_struct__");
    }

    @Override
    public Object dataGetStruct() {
        return this.objectAccessor.get(this);
    }

    @Override
    public void dataWrapStruct(Object object) {
        this.objectAccessor.set(this, object);
    }

    public static RubyClass createJavaProxy(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        RubyClass javaProxy = runtime2.defineClass("JavaProxy", runtime2.getObject(), new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime2, RubyClass klazz) {
                return new JavaProxy(runtime2, klazz);
            }
        });
        RubyClass singleton = javaProxy.getSingletonClass();
        singleton.addReadWriteAttribute(context, "java_class");
        javaProxy.defineAnnotatedMethods(JavaProxy.class);
        javaProxy.includeModule(runtime2.fastGetModule("JavaProxyMethods"));
        return javaProxy;
    }

    @JRubyMethod(frame=true, meta=true)
    public static IRubyObject inherited(ThreadContext context, IRubyObject recv2, IRubyObject subclass) {
        IRubyObject subJavaClass = RuntimeHelpers.invoke(context, subclass, "java_class");
        if (subJavaClass.isNil()) {
            subJavaClass = RuntimeHelpers.invoke(context, recv2, "java_class");
            RuntimeHelpers.invoke(context, subclass, "java_class=", subJavaClass);
        }
        return RuntimeHelpers.invokeSuper(context, recv2, subclass, Block.NULL_BLOCK);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject singleton_class(IRubyObject recv2) {
        return ((RubyClass)recv2).getSingletonClass();
    }

    @JRubyMethod(name={"[]"}, meta=true, rest=true)
    public static IRubyObject op_aref(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        IRubyObject javaClass = RuntimeHelpers.invoke(context, recv2, "java_class");
        if (args2.length > 0) {
            IRubyObject[] newArgs = new IRubyObject[args2.length + 1];
            newArgs[0] = javaClass;
            System.arraycopy(args2, 0, newArgs, 1, args2.length);
            return context.getRuntime().fastGetClass("ArrayJavaProxyCreator").newInstance(context, newArgs, Block.NULL_BLOCK);
        }
        return Java.get_proxy_class(javaClass, RuntimeHelpers.invoke(context, javaClass, "array_class"));
    }

    private static Class<?> getJavaClass(ThreadContext context, RubyModule module) {
        try {
            IRubyObject jClass = RuntimeHelpers.invoke(context, module, "java_class");
            return !(jClass instanceof JavaClass) ? null : ((JavaClass)jClass).javaClass();
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Map<String, String> getFieldListFromArgs(IRubyObject[] args2) {
        final HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < args2.length; ++i) {
            if (args2[i] instanceof RubyHash) {
                ((RubyHash)args2[i]).visitAll(new RubyHash.Visitor(){

                    public void visit(IRubyObject key2, IRubyObject value2) {
                        map.put(key2.asString().toString(), value2.asString().toString());
                    }
                });
                continue;
            }
            String value2 = args2[i].asString().toString();
            map.put(value2, value2);
        }
        return map;
    }

    private static void installField(ThreadContext context, Map<String, String> fieldMap, Field field2, RubyModule module, boolean asReader, boolean asWriter) {
        boolean isFinal = Modifier.isFinal(field2.getModifiers());
        for (String key2 : fieldMap.keySet()) {
            if (!key2.equals(field2.getName())) continue;
            if (Ruby.isSecurityRestricted() && !Modifier.isPublic(field2.getModifiers())) {
                throw context.getRuntime().newSecurityError("Cannot change accessibility on fields in a restricted mode: field '" + field2.getName() + "'");
            }
            String asName = fieldMap.get(key2);
            if (asReader) {
                module.addMethod(asName, new InstanceFieldGetter(key2, module, field2));
            }
            if (asWriter) {
                if (isFinal) {
                    throw context.getRuntime().newSecurityError("Cannot change final field '" + field2.getName() + "'");
                }
                module.addMethod(asName + "=", new InstanceFieldSetter(key2, module, field2));
            }
            fieldMap.remove(key2);
            break;
        }
    }

    private static void findFields(ThreadContext context, RubyModule topModule, IRubyObject[] args2, boolean asReader, boolean asWriter) {
        Map<String, String> fieldMap = JavaProxy.getFieldListFromArgs(args2);
        for (RubyModule module = topModule; module != null; module = module.getSuperClass()) {
            Class<?> javaClass = JavaProxy.getJavaClass(context, module);
            if (javaClass == null) continue;
            Field[] fields2 = JavaClass.getDeclaredFields(javaClass);
            for (int j = 0; j < fields2.length; ++j) {
                JavaProxy.installField(context, fieldMap, fields2[j], module, asReader, asWriter);
            }
        }
        if (!fieldMap.isEmpty()) {
            throw JavaClass.undefinedFieldError(context.getRuntime(), topModule.getName(), fieldMap.keySet().iterator().next());
        }
    }

    @JRubyMethod(meta=true, rest=true)
    public static IRubyObject field_accessor(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        JavaProxy.findFields(context, (RubyModule)recv2, args2, true, true);
        return context.getRuntime().getNil();
    }

    @JRubyMethod(meta=true, rest=true)
    public static IRubyObject field_reader(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        JavaProxy.findFields(context, (RubyModule)recv2, args2, true, false);
        return context.getRuntime().getNil();
    }

    @JRubyMethod(meta=true, rest=true)
    public static IRubyObject field_writer(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        JavaProxy.findFields(context, (RubyModule)recv2, args2, false, true);
        return context.getRuntime().getNil();
    }

    @JRubyMethod(meta=true)
    public static IRubyObject new_instance_for(IRubyObject recv2, IRubyObject arg0) {
        return Java.new_instance_for(recv2, arg0);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject to_java_object(IRubyObject recv2) {
        return Java.to_java_object(recv2);
    }

    @Override
    @JRubyMethod(name={"equal?"})
    public IRubyObject equal_p(ThreadContext context, IRubyObject other) {
        Ruby runtime2 = context.getRuntime();
        if (other.dataGetStruct() instanceof JavaObject) {
            boolean equal = this.unwrap() == ((JavaObject)other.dataGetStruct()).getValue();
            return runtime2.newBoolean(equal);
        }
        return runtime2.getFalse();
    }

    public Object unwrap() {
        return ((JavaObject)this.dataGetStruct()).getValue();
    }
}

