/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.Node;
import org.jruby.compiler.ASTInspector;
import org.jruby.exceptions.JumpException;
import org.jruby.internal.runtime.JumpTarget;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.MethodArgs;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class InterpretedMethod
extends DynamicMethod
implements JumpTarget,
MethodArgs {
    private StaticScope staticScope;
    private Node body;
    private ArgsNode argsNode;
    private ISourcePosition position;
    private boolean needsScope;

    public InterpretedMethod(RubyModule implementationClass, StaticScope staticScope, Node body, ArgsNode argsNode, Visibility visibility, ISourcePosition position) {
        super(implementationClass, visibility, CallConfiguration.FrameFullScopeFull);
        this.body = body;
        this.staticScope = staticScope;
        this.argsNode = argsNode;
        this.position = position;
        ASTInspector inspector = new ASTInspector();
        inspector.inspect(body);
        inspector.inspect(argsNode);
        this.needsScope = inspector.hasClosure() || inspector.hasScopeAwareMethods() || staticScope.getNumberOfVariables() != 0;
        assert (argsNode != null);
    }

    public Node getBodyNode() {
        return this.body;
    }

    public ArgsNode getArgsNode() {
        return this.argsNode;
    }

    public StaticScope getStaticScope() {
        return this.staticScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
        assert (args2 != null);
        Ruby runtime2 = context.getRuntime();
        try {
            this.pre(context, name2, self, block, runtime2);
            this.argsNode.checkArgCount(runtime2, args2.length);
            this.argsNode.prepare(context, runtime2, self, args2, block);
            IRubyObject iRubyObject = this.body.interpret(runtime2, context, self, block);
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime2);
            return iRubyObject;
        }
        finally {
            this.post(runtime2, context, name2);
        }
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2) {
        return this.call(context, self, clazz, name2, args2, Block.NULL_BLOCK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2) {
        Ruby runtime2 = context.getRuntime();
        try {
            this.pre(context, name2, self, Block.NULL_BLOCK, runtime2);
            this.argsNode.checkArgCount(runtime2, 0);
            this.argsNode.prepare(context, runtime2, self, Block.NULL_BLOCK);
            IRubyObject iRubyObject = this.body.interpret(runtime2, context, self, Block.NULL_BLOCK);
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime2);
            return iRubyObject;
        }
        finally {
            this.post(runtime2, context, name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, Block block) {
        Ruby runtime2 = context.getRuntime();
        try {
            this.pre(context, name2, self, block, runtime2);
            this.argsNode.checkArgCount(runtime2, 0);
            this.argsNode.prepare(context, runtime2, self, block);
            IRubyObject iRubyObject = this.body.interpret(runtime2, context, self, block);
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime2);
            return iRubyObject;
        }
        finally {
            this.post(runtime2, context, name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0) {
        Ruby runtime2 = context.getRuntime();
        try {
            this.pre(context, name2, self, Block.NULL_BLOCK, runtime2);
            this.argsNode.checkArgCount(runtime2, 1);
            this.argsNode.prepare(context, runtime2, self, arg0, Block.NULL_BLOCK);
            IRubyObject iRubyObject = this.body.interpret(runtime2, context, self, Block.NULL_BLOCK);
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime2);
            return iRubyObject;
        }
        finally {
            this.post(runtime2, context, name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, Block block) {
        Ruby runtime2 = context.getRuntime();
        try {
            this.pre(context, name2, self, block, runtime2);
            this.argsNode.checkArgCount(runtime2, 1);
            this.argsNode.prepare(context, runtime2, self, arg0, block);
            IRubyObject iRubyObject = this.body.interpret(runtime2, context, self, block);
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime2);
            return iRubyObject;
        }
        finally {
            this.post(runtime2, context, name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1) {
        Ruby runtime2 = context.getRuntime();
        try {
            this.pre(context, name2, self, Block.NULL_BLOCK, runtime2);
            this.argsNode.checkArgCount(runtime2, 2);
            this.argsNode.prepare(context, runtime2, self, arg0, arg1, Block.NULL_BLOCK);
            IRubyObject iRubyObject = this.body.interpret(runtime2, context, self, Block.NULL_BLOCK);
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime2);
            return iRubyObject;
        }
        finally {
            this.post(runtime2, context, name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
        Ruby runtime2 = context.getRuntime();
        try {
            this.pre(context, name2, self, block, runtime2);
            this.argsNode.checkArgCount(runtime2, 2);
            this.argsNode.prepare(context, runtime2, self, arg0, arg1, block);
            IRubyObject iRubyObject = this.body.interpret(runtime2, context, self, block);
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime2);
            return iRubyObject;
        }
        finally {
            this.post(runtime2, context, name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        Ruby runtime2 = context.getRuntime();
        try {
            this.pre(context, name2, self, Block.NULL_BLOCK, runtime2);
            this.argsNode.checkArgCount(runtime2, 3);
            this.argsNode.prepare(context, runtime2, self, arg0, arg1, arg2, Block.NULL_BLOCK);
            IRubyObject iRubyObject = this.body.interpret(runtime2, context, self, Block.NULL_BLOCK);
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime2);
            return iRubyObject;
        }
        finally {
            this.post(runtime2, context, name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        Ruby runtime2 = context.getRuntime();
        try {
            this.pre(context, name2, self, block, runtime2);
            this.argsNode.checkArgCount(runtime2, 3);
            this.argsNode.prepare(context, runtime2, self, arg0, arg1, arg2, block);
            IRubyObject iRubyObject = this.body.interpret(runtime2, context, self, block);
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime2);
            return iRubyObject;
        }
        finally {
            this.post(runtime2, context, name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        Ruby runtime2 = context.getRuntime();
        try {
            this.pre(context, name2, self, Block.NULL_BLOCK, runtime2);
            this.argsNode.checkArgCount(runtime2, 4);
            this.argsNode.prepare(context, runtime2, self, arg0, arg1, arg2, arg3, Block.NULL_BLOCK);
            IRubyObject iRubyObject = this.body.interpret(runtime2, context, self, Block.NULL_BLOCK);
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime2);
            return iRubyObject;
        }
        finally {
            this.post(runtime2, context, name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, Block block) {
        Ruby runtime2 = context.getRuntime();
        try {
            this.pre(context, name2, self, block, runtime2);
            this.argsNode.checkArgCount(runtime2, 4);
            this.argsNode.prepare(context, runtime2, self, arg0, arg1, arg2, arg3, block);
            IRubyObject iRubyObject = this.body.interpret(runtime2, context, self, block);
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime2);
            return iRubyObject;
        }
        finally {
            this.post(runtime2, context, name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4) {
        Ruby runtime2 = context.getRuntime();
        try {
            this.pre(context, name2, self, Block.NULL_BLOCK, runtime2);
            this.argsNode.checkArgCount(runtime2, 5);
            this.argsNode.prepare(context, runtime2, self, arg0, arg1, arg2, arg3, arg4, Block.NULL_BLOCK);
            IRubyObject iRubyObject = this.body.interpret(runtime2, context, self, Block.NULL_BLOCK);
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime2);
            return iRubyObject;
        }
        finally {
            this.post(runtime2, context, name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, Block block) {
        Ruby runtime2 = context.getRuntime();
        try {
            this.pre(context, name2, self, block, runtime2);
            this.argsNode.checkArgCount(runtime2, 5);
            this.argsNode.prepare(context, runtime2, self, arg0, arg1, arg2, arg3, arg4, block);
            IRubyObject iRubyObject = this.body.interpret(runtime2, context, self, block);
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime2);
            return iRubyObject;
        }
        finally {
            this.post(runtime2, context, name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, IRubyObject arg5) {
        Ruby runtime2 = context.getRuntime();
        try {
            this.pre(context, name2, self, Block.NULL_BLOCK, runtime2);
            this.argsNode.checkArgCount(runtime2, 6);
            this.argsNode.prepare(context, runtime2, self, arg0, arg1, arg2, arg3, arg4, arg5, Block.NULL_BLOCK);
            IRubyObject iRubyObject = this.body.interpret(runtime2, context, self, Block.NULL_BLOCK);
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime2);
            return iRubyObject;
        }
        finally {
            this.post(runtime2, context, name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, IRubyObject arg5, Block block) {
        Ruby runtime2 = context.getRuntime();
        try {
            this.pre(context, name2, self, block, runtime2);
            this.argsNode.checkArgCount(runtime2, 6);
            this.argsNode.prepare(context, runtime2, self, arg0, arg1, arg2, arg3, arg4, arg5, block);
            IRubyObject iRubyObject = this.body.interpret(runtime2, context, self, block);
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime2);
            return iRubyObject;
        }
        finally {
            this.post(runtime2, context, name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, IRubyObject arg5, IRubyObject arg6) {
        Ruby runtime2 = context.getRuntime();
        try {
            this.pre(context, name2, self, Block.NULL_BLOCK, runtime2);
            this.argsNode.checkArgCount(runtime2, 7);
            this.argsNode.prepare(context, runtime2, self, arg0, arg1, arg2, arg3, arg4, arg5, arg6, Block.NULL_BLOCK);
            IRubyObject iRubyObject = this.body.interpret(runtime2, context, self, Block.NULL_BLOCK);
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime2);
            return iRubyObject;
        }
        finally {
            this.post(runtime2, context, name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, IRubyObject arg5, IRubyObject arg6, Block block) {
        Ruby runtime2 = context.getRuntime();
        try {
            this.pre(context, name2, self, block, runtime2);
            this.argsNode.checkArgCount(runtime2, 7);
            this.argsNode.prepare(context, runtime2, self, arg0, arg1, arg2, arg3, arg4, arg5, arg6, block);
            IRubyObject iRubyObject = this.body.interpret(runtime2, context, self, block);
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime2);
            return iRubyObject;
        }
        finally {
            this.post(runtime2, context, name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, IRubyObject arg5, IRubyObject arg6, IRubyObject arg7) {
        Ruby runtime2 = context.getRuntime();
        try {
            this.pre(context, name2, self, Block.NULL_BLOCK, runtime2);
            this.argsNode.checkArgCount(runtime2, 8);
            this.argsNode.prepare(context, runtime2, self, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, Block.NULL_BLOCK);
            IRubyObject iRubyObject = this.body.interpret(runtime2, context, self, Block.NULL_BLOCK);
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime2);
            return iRubyObject;
        }
        finally {
            this.post(runtime2, context, name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, IRubyObject arg5, IRubyObject arg6, IRubyObject arg7, Block block) {
        Ruby runtime2 = context.getRuntime();
        try {
            this.pre(context, name2, self, block, runtime2);
            this.argsNode.checkArgCount(runtime2, 8);
            this.argsNode.prepare(context, runtime2, self, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, block);
            IRubyObject iRubyObject = this.body.interpret(runtime2, context, self, block);
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime2);
            return iRubyObject;
        }
        finally {
            this.post(runtime2, context, name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, IRubyObject arg5, IRubyObject arg6, IRubyObject arg7, IRubyObject arg8) {
        Ruby runtime2 = context.getRuntime();
        try {
            this.pre(context, name2, self, Block.NULL_BLOCK, runtime2);
            this.argsNode.checkArgCount(runtime2, 9);
            this.argsNode.prepare(context, runtime2, self, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, Block.NULL_BLOCK);
            IRubyObject iRubyObject = this.body.interpret(runtime2, context, self, Block.NULL_BLOCK);
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime2);
            return iRubyObject;
        }
        finally {
            this.post(runtime2, context, name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, IRubyObject arg5, IRubyObject arg6, IRubyObject arg7, IRubyObject arg8, Block block) {
        Ruby runtime2 = context.getRuntime();
        try {
            this.pre(context, name2, self, block, runtime2);
            this.argsNode.checkArgCount(runtime2, 9);
            this.argsNode.prepare(context, runtime2, self, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, block);
            IRubyObject iRubyObject = this.body.interpret(runtime2, context, self, block);
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime2);
            return iRubyObject;
        }
        finally {
            this.post(runtime2, context, name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, IRubyObject arg5, IRubyObject arg6, IRubyObject arg7, IRubyObject arg8, IRubyObject arg9) {
        Ruby runtime2 = context.getRuntime();
        try {
            this.pre(context, name2, self, Block.NULL_BLOCK, runtime2);
            this.argsNode.checkArgCount(runtime2, 10);
            this.argsNode.prepare(context, runtime2, self, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, Block.NULL_BLOCK);
            IRubyObject iRubyObject = this.body.interpret(runtime2, context, self, Block.NULL_BLOCK);
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime2);
            return iRubyObject;
        }
        finally {
            this.post(runtime2, context, name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, IRubyObject arg5, IRubyObject arg6, IRubyObject arg7, IRubyObject arg8, IRubyObject arg9, Block block) {
        Ruby runtime2 = context.getRuntime();
        try {
            this.pre(context, name2, self, block, runtime2);
            this.argsNode.checkArgCount(runtime2, 10);
            this.argsNode.prepare(context, runtime2, self, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, block);
            IRubyObject iRubyObject = this.body.interpret(runtime2, context, self, block);
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime2);
            return iRubyObject;
        }
        finally {
            this.post(runtime2, context, name2);
        }
    }

    protected void pre(ThreadContext context, String name2, IRubyObject self, Block block, Ruby runtime2) {
        if (this.needsScope) {
            context.preMethodFrameAndScope(this.getImplementationClass(), name2, self, block, this.staticScope);
        } else {
            context.preMethodFrameAndDummyScope(this.getImplementationClass(), name2, self, block, this.staticScope);
        }
    }

    protected void post(Ruby runtime2, ThreadContext context, String name2) {
        context.postMethodFrameAndScope();
    }

    public ISourcePosition getPosition() {
        return this.position;
    }

    public Arity getArity() {
        return this.argsNode.getArity();
    }

    public DynamicMethod dup() {
        return new InterpretedMethod(this.getImplementationClass(), this.staticScope, this.body, this.argsNode, this.getVisibility(), this.position);
    }
}

