/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jna;

import com.sun.jna.Native;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.LongByReference;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.AllocatedDirectMemoryIO;
import org.jruby.ext.ffi.CallbackInfo;
import org.jruby.ext.ffi.CallbackManager;
import org.jruby.ext.ffi.DirectMemoryIO;
import org.jruby.ext.ffi.Platform;
import org.jruby.ext.ffi.Pointer;
import org.jruby.ext.ffi.jna.AllocatedNativeMemoryIO;
import org.jruby.ext.ffi.jna.DynamicLibrary;
import org.jruby.ext.ffi.jna.JNAInvoker;
import org.jruby.ext.ffi.jna.JNAVariadicInvoker;
import org.jruby.ext.ffi.jna.NativeMemoryIO;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Factory
extends org.jruby.ext.ffi.Factory {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(Ruby runtime2, RubyModule ffi2) {
        super.init(runtime2, ffi2);
        RubyModule rubyModule = ffi2;
        synchronized (rubyModule) {
            if (ffi2.fastGetClass("DynamicLibrary") == null) {
                DynamicLibrary.createDynamicLibraryClass(runtime2, ffi2);
            }
            if (ffi2.fastGetClass("Invoker") == null) {
                JNAInvoker.createInvokerClass(runtime2, ffi2);
            }
            if (ffi2.fastGetClass("VariadicInvoker") == null) {
                JNAVariadicInvoker.createVariadicInvokerClass(runtime2, ffi2);
            }
            ffi2.defineModuleUnder("LastError").defineAnnotatedMethods(LastError.class);
        }
    }

    @Override
    public <T> T loadLibrary(String libraryName, Class<T> libraryClass) {
        try {
            return libraryClass.cast(Native.loadLibrary(libraryName, libraryClass));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public AllocatedDirectMemoryIO allocateDirectMemory(Ruby runtime2, int size2, boolean clear2) {
        return AllocatedNativeMemoryIO.allocate(size2, clear2);
    }

    @Override
    public DirectMemoryIO wrapDirectMemory(long address2) {
        com.sun.jna.Pointer ptr;
        if (Platform.getPlatform().addressSize() == 32) {
            IntByReference ref = new IntByReference((int)address2);
            ptr = ref.getPointer().getPointer(0L);
        } else {
            LongByReference ref = new LongByReference(address2);
            ptr = ref.getPointer().getPointer(0L);
        }
        return ptr != null ? new NativeMemoryIO(ptr) : null;
    }

    @Override
    public CallbackManager getCallbackManager() {
        return new CallbackManager(){

            public Pointer getCallback(Ruby runtime2, CallbackInfo cbInfo, Object proc2) {
                throw runtime2.newNotImplementedError("Not implemented");
            }
        };
    }

    private static final class LastError {
        private LastError() {
        }

        @JRubyMethod(name={"error"}, meta=true)
        public static final IRubyObject error(ThreadContext context, IRubyObject recv2) {
            return context.getRuntime().newFixnum(Native.getLastError());
        }
    }
}

