/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jffi;

import com.kenai.jffi.Function;
import com.kenai.jffi.MemoryIO;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.ext.ffi.BasePointer;
import org.jruby.ext.ffi.DirectMemoryIO;
import org.jruby.ext.ffi.NativeParam;
import org.jruby.ext.ffi.NativeType;
import org.jruby.ext.ffi.NullMemoryIO;
import org.jruby.ext.ffi.Platform;
import org.jruby.ext.ffi.Pointer;
import org.jruby.ext.ffi.Struct;
import org.jruby.ext.ffi.Type;
import org.jruby.ext.ffi.Util;
import org.jruby.ext.ffi.jffi.FastIntMethodOneArg;
import org.jruby.ext.ffi.jffi.FastIntMethodThreeArg;
import org.jruby.ext.ffi.jffi.FastIntMethodTwoArg;
import org.jruby.ext.ffi.jffi.FastIntMethodZeroArg;
import org.jruby.ext.ffi.jffi.IntParameterConverter;
import org.jruby.ext.ffi.jffi.IntResultConverter;
import org.jruby.ext.ffi.jffi.NativeMemoryIO;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class FastIntMethodFactory {
    private FastIntMethodFactory() {
    }

    public static final FastIntMethodFactory getFactory() {
        return SingletonHolder.INSTANCE;
    }

    final boolean isFastIntMethod(Type returnType, Type[] parameterTypes) {
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (this.isFastIntParam(parameterTypes[i])) continue;
            return false;
        }
        return parameterTypes.length <= 3 && this.isFastIntResult(returnType);
    }

    final boolean isFastIntResult(Type type2) {
        if (type2 instanceof Type.Builtin) {
            switch (type2.getNativeType()) {
                case VOID: 
                case INT8: 
                case UINT8: 
                case INT16: 
                case UINT16: 
                case INT32: 
                case UINT32: {
                    return true;
                }
                case POINTER: 
                case STRING: {
                    return Platform.getPlatform().addressSize() == 32;
                }
                case LONG: 
                case ULONG: {
                    return Platform.getPlatform().longSize() == 32;
                }
            }
        }
        return false;
    }

    final boolean isFastIntParam(Type paramType) {
        if (paramType instanceof Type.Builtin) {
            switch (paramType.getNativeType()) {
                case INT8: 
                case UINT8: 
                case INT16: 
                case UINT16: 
                case INT32: 
                case UINT32: {
                    return true;
                }
                case LONG: 
                case ULONG: {
                    return Platform.getPlatform().longSize() == 32;
                }
            }
        }
        return false;
    }

    DynamicMethod createMethod(RubyModule module, Function function, Type returnType, Type[] parameterTypes) {
        FastIntMethodFactory factory = this;
        IntParameterConverter[] parameterConverters = new IntParameterConverter[parameterTypes.length];
        IntResultConverter resultConverter = factory.getIntResultConverter(returnType);
        for (int i = 0; i < parameterConverters.length; ++i) {
            parameterConverters[i] = factory.getIntParameterConverter(parameterTypes[i]);
        }
        switch (parameterTypes.length) {
            case 0: {
                return new FastIntMethodZeroArg(module, function, resultConverter, parameterConverters);
            }
            case 1: {
                return new FastIntMethodOneArg(module, function, resultConverter, parameterConverters);
            }
            case 2: {
                return new FastIntMethodTwoArg(module, function, resultConverter, parameterConverters);
            }
            case 3: {
                return new FastIntMethodThreeArg(module, function, resultConverter, parameterConverters);
            }
        }
        throw module.getRuntime().newRuntimeError("Arity " + parameterTypes.length + " not implemented");
    }

    final IntParameterConverter getIntParameterConverter(Type type2) {
        return type2 instanceof Type.Builtin ? this.getIntParameterConverter(type2.getNativeType()) : null;
    }

    final IntParameterConverter getIntParameterConverter(NativeParam type2) {
        switch ((NativeType)type2) {
            case INT8: {
                return Signed8ParameterConverter.INSTANCE;
            }
            case UINT8: {
                return Unsigned8ParameterConverter.INSTANCE;
            }
            case INT16: {
                return Signed16ParameterConverter.INSTANCE;
            }
            case UINT16: {
                return Unsigned16ParameterConverter.INSTANCE;
            }
            case INT32: {
                return Signed32ParameterConverter.INSTANCE;
            }
            case UINT32: {
                return Unsigned32ParameterConverter.INSTANCE;
            }
            case FLOAT32: {
                return Float32ParameterConverter.INSTANCE;
            }
            case LONG: {
                if (Platform.getPlatform().longSize() == 32) {
                    return Signed32ParameterConverter.INSTANCE;
                }
                throw new IllegalArgumentException("Long is too big for int parameter");
            }
            case ULONG: {
                if (Platform.getPlatform().longSize() == 32) {
                    return Unsigned32ParameterConverter.INSTANCE;
                }
                throw new IllegalArgumentException("Long is too big for int parameter");
            }
            case POINTER: 
            case BUFFER_IN: 
            case BUFFER_OUT: 
            case BUFFER_INOUT: {
                if (Platform.getPlatform().addressSize() == 32) {
                    return PointerParameterConverter.INSTANCE;
                }
                throw new IllegalArgumentException("Pointer is too big for int parameter");
            }
        }
        throw new IllegalArgumentException("Unknown type " + type2);
    }

    final IntResultConverter getIntResultConverter(Type type2) {
        return type2 instanceof Type.Builtin ? this.getIntResultConverter(type2.getNativeType()) : null;
    }

    final IntResultConverter getIntResultConverter(NativeType type2) {
        switch (type2) {
            case VOID: {
                return VoidResultConverter.INSTANCE;
            }
            case INT8: {
                return Signed8ResultConverter.INSTANCE;
            }
            case UINT8: {
                return Unsigned8ResultConverter.INSTANCE;
            }
            case INT16: {
                return Signed16ResultConverter.INSTANCE;
            }
            case UINT16: {
                return Unsigned16ResultConverter.INSTANCE;
            }
            case INT32: {
                return Signed32ResultConverter.INSTANCE;
            }
            case UINT32: {
                return Unsigned32ResultConverter.INSTANCE;
            }
            case FLOAT32: {
                return Float32ResultConverter.INSTANCE;
            }
            case LONG: {
                if (Platform.getPlatform().longSize() == 32) {
                    return Signed32ResultConverter.INSTANCE;
                }
                throw new IllegalArgumentException("Long is too big for int parameter");
            }
            case ULONG: {
                if (Platform.getPlatform().longSize() == 32) {
                    return Unsigned32ResultConverter.INSTANCE;
                }
                throw new IllegalArgumentException("Long is too big for int parameter");
            }
            case POINTER: {
                if (Platform.getPlatform().addressSize() == 32) {
                    return PointerResultConverter.INSTANCE;
                }
                throw new IllegalArgumentException("Pointer is too big for int parameter");
            }
            case STRING: {
                if (Platform.getPlatform().addressSize() == 32) {
                    return StringResultConverter.INSTANCE;
                }
                throw new IllegalArgumentException("Long is too big for int parameter");
            }
        }
        throw new IllegalArgumentException("Unknown type " + type2);
    }

    private static final int getAddress(Pointer ptr) {
        return (int)((DirectMemoryIO)ptr.getMemoryIO()).getAddress();
    }

    static final class PointerParameterConverter
    extends BaseParameterConverter {
        public static final IntParameterConverter INSTANCE = new PointerParameterConverter();

        PointerParameterConverter() {
        }

        public final int intValue(ThreadContext context, IRubyObject parameter) {
            if (parameter instanceof Pointer) {
                return FastIntMethodFactory.getAddress((Pointer)parameter);
            }
            if (parameter instanceof Struct) {
                IRubyObject memory = ((Struct)parameter).getMemory();
                if (memory instanceof Pointer) {
                    return FastIntMethodFactory.getAddress((Pointer)memory);
                }
                if (memory == null || memory.isNil()) {
                    return 0;
                }
            } else if (parameter.isNil()) {
                return 0;
            }
            throw context.getRuntime().newArgumentError("Cannot convert pointer to 32bit integer");
        }

        public boolean isConvertible(ThreadContext context, IRubyObject parameter) {
            return parameter instanceof Pointer || parameter instanceof Struct && ((Struct)parameter).getMemory() instanceof Pointer || parameter.isNil();
        }
    }

    static final class Float32ParameterConverter
    extends BaseParameterConverter {
        public static final IntParameterConverter INSTANCE = new Float32ParameterConverter();

        Float32ParameterConverter() {
        }

        public final int intValue(ThreadContext context, IRubyObject obj) {
            return Float.floatToRawIntBits((float)RubyNumeric.num2dbl(obj));
        }
    }

    static final class Unsigned32ParameterConverter
    extends BaseParameterConverter {
        public static final IntParameterConverter INSTANCE = new Unsigned32ParameterConverter();

        Unsigned32ParameterConverter() {
        }

        public final int intValue(ThreadContext context, IRubyObject obj) {
            return (int)Util.uint32Value(obj);
        }
    }

    static final class Signed32ParameterConverter
    extends BaseParameterConverter {
        public static final IntParameterConverter INSTANCE = new Signed32ParameterConverter();

        Signed32ParameterConverter() {
        }

        public final int intValue(ThreadContext context, IRubyObject obj) {
            return Util.int32Value(obj);
        }
    }

    static final class Unsigned16ParameterConverter
    extends BaseParameterConverter {
        public static final IntParameterConverter INSTANCE = new Unsigned16ParameterConverter();

        Unsigned16ParameterConverter() {
        }

        public final int intValue(ThreadContext context, IRubyObject obj) {
            return Util.uint16Value(obj);
        }
    }

    static final class Signed16ParameterConverter
    extends BaseParameterConverter {
        public static final IntParameterConverter INSTANCE = new Signed16ParameterConverter();

        Signed16ParameterConverter() {
        }

        public final int intValue(ThreadContext context, IRubyObject obj) {
            return Util.int16Value(obj);
        }
    }

    static final class Unsigned8ParameterConverter
    extends BaseParameterConverter {
        public static final IntParameterConverter INSTANCE = new Unsigned8ParameterConverter();

        Unsigned8ParameterConverter() {
        }

        public final int intValue(ThreadContext context, IRubyObject obj) {
            return Util.uint8Value(obj);
        }
    }

    static final class Signed8ParameterConverter
    extends BaseParameterConverter {
        public static final IntParameterConverter INSTANCE = new Signed8ParameterConverter();

        Signed8ParameterConverter() {
        }

        public final int intValue(ThreadContext context, IRubyObject obj) {
            return Util.int8Value(obj);
        }
    }

    static abstract class BaseParameterConverter
    implements IntParameterConverter {
        static final MemoryIO IO = MemoryIO.getInstance();

        BaseParameterConverter() {
        }

        public boolean isConvertible(ThreadContext context, IRubyObject value2) {
            return true;
        }
    }

    static final class StringResultConverter
    implements IntResultConverter {
        private static final MemoryIO IO = MemoryIO.getInstance();
        public static final IntResultConverter INSTANCE = new StringResultConverter();

        StringResultConverter() {
        }

        public final IRubyObject fromNative(ThreadContext context, int value2) {
            long address2 = (long)value2 & PointerResultConverter.ADDRESS_MASK;
            if (address2 == 0L) {
                return context.getRuntime().getNil();
            }
            int len = (int)IO.getStringLength(address2);
            if (len == 0) {
                return RubyString.newEmptyString(context.getRuntime());
            }
            byte[] bytes2 = new byte[len];
            IO.getByteArray(address2, bytes2, 0, len);
            RubyString s = RubyString.newStringShared(context.getRuntime(), bytes2);
            s.setTaint(true);
            return s;
        }
    }

    static final class PointerResultConverter
    implements IntResultConverter {
        static final long ADDRESS_MASK = Platform.getPlatform().addressSize() == 32 ? 0xFFFFFFFFL : -1L;
        public static final IntResultConverter INSTANCE = new PointerResultConverter();

        PointerResultConverter() {
        }

        public final IRubyObject fromNative(ThreadContext context, int value2) {
            long address2 = (long)value2 & ADDRESS_MASK;
            return new BasePointer(context.getRuntime(), address2 != 0L ? new NativeMemoryIO(address2) : new NullMemoryIO(context.getRuntime()));
        }
    }

    static final class Float32ResultConverter
    implements IntResultConverter {
        public static final IntResultConverter INSTANCE = new Float32ResultConverter();

        Float32ResultConverter() {
        }

        public final IRubyObject fromNative(ThreadContext context, int value2) {
            return context.getRuntime().newFloat(Float.intBitsToFloat(value2));
        }
    }

    static final class Unsigned32ResultConverter
    implements IntResultConverter {
        public static final IntResultConverter INSTANCE = new Unsigned32ResultConverter();

        Unsigned32ResultConverter() {
        }

        public final IRubyObject fromNative(ThreadContext context, int value2) {
            return Util.newUnsigned32(context.getRuntime(), value2);
        }
    }

    static final class Signed32ResultConverter
    implements IntResultConverter {
        public static final IntResultConverter INSTANCE = new Signed32ResultConverter();

        Signed32ResultConverter() {
        }

        public final IRubyObject fromNative(ThreadContext context, int value2) {
            return Util.newSigned32(context.getRuntime(), value2);
        }
    }

    static final class Unsigned16ResultConverter
    implements IntResultConverter {
        public static final IntResultConverter INSTANCE = new Unsigned16ResultConverter();

        Unsigned16ResultConverter() {
        }

        public final IRubyObject fromNative(ThreadContext context, int value2) {
            return Util.newUnsigned16(context.getRuntime(), value2);
        }
    }

    static final class Signed16ResultConverter
    implements IntResultConverter {
        public static final IntResultConverter INSTANCE = new Signed16ResultConverter();

        Signed16ResultConverter() {
        }

        public final IRubyObject fromNative(ThreadContext context, int value2) {
            return Util.newSigned16(context.getRuntime(), value2);
        }
    }

    static final class Unsigned8ResultConverter
    implements IntResultConverter {
        public static final IntResultConverter INSTANCE = new Unsigned8ResultConverter();

        Unsigned8ResultConverter() {
        }

        public final IRubyObject fromNative(ThreadContext context, int value2) {
            return Util.newUnsigned8(context.getRuntime(), value2);
        }
    }

    static final class Signed8ResultConverter
    implements IntResultConverter {
        public static final IntResultConverter INSTANCE = new Signed8ResultConverter();

        Signed8ResultConverter() {
        }

        public final IRubyObject fromNative(ThreadContext context, int value2) {
            return Util.newSigned8(context.getRuntime(), value2);
        }
    }

    static final class VoidResultConverter
    implements IntResultConverter {
        public static final IntResultConverter INSTANCE = new VoidResultConverter();

        VoidResultConverter() {
        }

        public final IRubyObject fromNative(ThreadContext context, int value2) {
            return context.getRuntime().getNil();
        }
    }

    private static final class SingletonHolder {
        private static final FastIntMethodFactory INSTANCE = new FastIntMethodFactory();

        private SingletonHolder() {
        }
    }
}

