/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.NativeType;
import org.jruby.ext.ffi.Platform;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"FFI::Type"}, parent="Object")
public abstract class Type
extends RubyObject {
    protected final NativeType nativeType;
    protected final int size;
    protected final int alignment;
    static final int LONG_SIZE = Platform.getPlatform().longSize();
    static final int ADDRESS_SIZE = Platform.getPlatform().addressSize();
    static final int REGISTER_SIZE = Platform.getPlatform().addressSize();
    static final long LONG_MASK = LONG_SIZE == 32 ? Integer.MAX_VALUE : Long.MAX_VALUE;
    static final int LONG_ALIGN = Type.isSparc() ? 64 : LONG_SIZE;
    static final int ADDRESS_ALIGN = Type.isSparc() ? 64 : REGISTER_SIZE;
    static final int DOUBLE_ALIGN = Type.isSparc() ? 64 : REGISTER_SIZE;
    static final int FLOAT_ALIGN = Type.isSparc() ? 64 : 32;

    public static RubyClass createTypeClass(Ruby runtime2, RubyModule ffiModule) {
        RubyClass typeClass = ffiModule.defineClassUnder("Type", runtime2.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        typeClass.defineAnnotatedMethods(Type.class);
        typeClass.defineAnnotatedConstants(Type.class);
        RubyClass builtinClass = typeClass.defineClassUnder("Builtin", typeClass, ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        builtinClass.defineAnnotatedMethods(Builtin.class);
        RubyModule nativeType = ffiModule.defineModuleUnder("NativeType");
        for (NativeType t : NativeType.values()) {
            try {
                Builtin b = new Builtin(runtime2, builtinClass, t);
                typeClass.fastSetConstant(t.name(), b);
                nativeType.fastSetConstant(t.name(), b);
                ffiModule.fastSetConstant("TYPE_" + t.name(), b);
            }
            catch (UnsupportedOperationException ex) {
                // empty catch block
            }
        }
        return typeClass;
    }

    public final NativeType getNativeType() {
        return this.nativeType;
    }

    public final int getNativeSize() {
        return this.size;
    }

    public final int getNativeAlignment() {
        return this.alignment;
    }

    protected Type(Ruby runtime2, RubyClass klass, NativeType type2, int size2, int alignment) {
        super(runtime2, klass);
        this.nativeType = type2;
        this.size = size2;
        this.alignment = alignment;
    }

    protected Type(Ruby runtime2, RubyClass klass, NativeType type2) {
        super(runtime2, klass);
        this.nativeType = type2;
        this.size = Type.getNativeSize(type2);
        this.alignment = Type.getNativeAlignment(type2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isSparc() {
        Platform.CPU cpu = Platform.getPlatform().getCPU();
        if (cpu == Platform.CPU.SPARC) return true;
        if (cpu != Platform.CPU.SPARCV9) return false;
        return true;
    }

    private static final int getNativeAlignment(NativeType type2) {
        switch (type2) {
            case VOID: {
                return 0;
            }
            case INT8: 
            case UINT8: {
                return 1;
            }
            case INT16: 
            case UINT16: {
                return 2;
            }
            case INT32: 
            case UINT32: {
                return 4;
            }
            case INT64: 
            case UINT64: {
                return LONG_ALIGN / 8;
            }
            case LONG: 
            case ULONG: {
                return LONG_ALIGN / 8;
            }
            case FLOAT32: {
                return FLOAT_ALIGN / 8;
            }
            case FLOAT64: {
                return DOUBLE_ALIGN / 8;
            }
            case BUFFER_IN: 
            case BUFFER_INOUT: 
            case BUFFER_OUT: 
            case POINTER: 
            case STRING: 
            case RBXSTRING: {
                return ADDRESS_ALIGN / 8;
            }
        }
        return 0;
    }

    private static final int getNativeSize(NativeType type2) {
        switch (type2) {
            case VOID: {
                return 0;
            }
            case INT8: 
            case UINT8: {
                return 1;
            }
            case INT16: 
            case UINT16: {
                return 2;
            }
            case INT32: 
            case UINT32: {
                return 4;
            }
            case INT64: 
            case UINT64: {
                return 8;
            }
            case LONG: 
            case ULONG: {
                return Platform.getPlatform().longSize() >> 3;
            }
            case FLOAT32: {
                return 4;
            }
            case FLOAT64: {
                return 8;
            }
            case BUFFER_IN: 
            case BUFFER_INOUT: 
            case BUFFER_OUT: 
            case POINTER: 
            case STRING: 
            case RBXSTRING: {
                return Platform.getPlatform().addressSize() >> 3;
            }
        }
        return 0;
    }

    @JRubyClass(name={"FFI::Type::Builtin"}, parent="FFI::Type")
    public static final class Builtin
    extends Type {
        private Builtin(Ruby runtime2, RubyClass klass, NativeType nativeType) {
            super(runtime2, klass, nativeType, Type.getNativeSize(nativeType), Type.getNativeAlignment(nativeType));
        }

        @JRubyMethod(name={"to_s"})
        public final IRubyObject to_s(ThreadContext context) {
            return RubyString.newString(context.getRuntime(), String.format("#<FFI::Type::Builtin:%s>", this.nativeType.name()));
        }

        public final String toString() {
            return this.nativeType.name();
        }

        public boolean equals(Object obj) {
            return obj instanceof Builtin && ((Builtin)obj).nativeType.equals(this.nativeType);
        }

        public int hashCode() {
            int hash2 = 5;
            hash2 = 23 * hash2 + this.nativeType.hashCode();
            return hash2;
        }
    }
}

