/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyRegexp;
import org.jruby.RubyThread;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;

public class Timeout
implements Library {
    public void load(Ruby runtime2, boolean wrap2) throws IOException {
        RubyModule timeout2 = runtime2.defineModule("Timeout");
        RubyClass timeoutError = runtime2.defineClassUnder("Error", runtime2.getInterrupt(), runtime2.getInterrupt().getAllocator(), timeout2);
        runtime2.defineClassUnder("ExitException", runtime2.getException(), runtime2.getInterrupt().getAllocator(), timeout2);
        timeout2.defineConstant("THIS_FILE", RubyRegexp.newRegexp(runtime2, "timeout\\.rb", 0));
        timeout2.defineConstant("CALLER_OFFSET", RubyFixnum.newFixnum(runtime2, 0L));
        timeout2.defineAnnotatedMethods(Timeout.class);
        runtime2.getObject().defineConstant("TimeoutError", timeoutError);
        runtime2.getObject().defineAnnotatedMethods(TimeoutToplevel.class);
    }

    @JRubyMethod(module=true)
    public static IRubyObject timeout(ThreadContext context, IRubyObject timeout2, IRubyObject seconds, Block block) {
        if (seconds.isNil() || RuntimeHelpers.invoke(context, seconds, "zero?").isTrue()) {
            return block.yieldSpecific(context);
        }
        Ruby runtime2 = context.getRuntime();
        if (runtime2.getThreadService().getCritical()) {
            return Timeout.raiseBecauseCritical(context);
        }
        long waitTime = 1000L * seconds.convertToInteger().getLongValue();
        RubyThread currentThread = context.getThread();
        Object monitor = new Object();
        AtomicBoolean doRaise = new AtomicBoolean(true);
        Thread timeoutThread = Timeout.prepareThread(monitor, waitTime, doRaise, currentThread, runtime2);
        try {
            timeoutThread.start();
            IRubyObject iRubyObject = block.yield(context, seconds);
            return iRubyObject;
        }
        catch (RaiseException re) {
            if (re.getException().getMetaClass() == runtime2.getClassFromPath("Timeout::ExitException")) {
                IRubyObject iRubyObject = Timeout.raiseTimeoutError(context, re);
                return iRubyObject;
            }
            throw re;
        }
        finally {
            Timeout.killTimeoutThread(context, timeoutThread, monitor, doRaise);
        }
    }

    @JRubyMethod(module=true)
    public static IRubyObject timeout(ThreadContext context, IRubyObject timeout2, IRubyObject seconds, IRubyObject exceptionType, Block block) {
        if (seconds.isNil() || RuntimeHelpers.invoke(context, seconds, "zero?").isTrue()) {
            return block.yieldSpecific(context);
        }
        Ruby runtime2 = context.getRuntime();
        if (runtime2.getThreadService().getCritical()) {
            return Timeout.raiseBecauseCritical(context);
        }
        IRubyObject exception2 = exceptionType.isNil() ? runtime2.getClassFromPath("Timeout::ExitException") : exceptionType;
        long waitTime = 1000L * seconds.convertToInteger().getLongValue();
        RubyThread currentThread = context.getThread();
        Object monitor = new Object();
        AtomicBoolean doRaise = new AtomicBoolean(true);
        Thread timeoutThread = Timeout.prepareThreadWithException(monitor, waitTime, doRaise, currentThread, exception2, runtime2);
        try {
            timeoutThread.start();
            IRubyObject iRubyObject = block.yield(context, seconds);
            return iRubyObject;
        }
        catch (RaiseException re) {
            if (re.getException().getMetaClass() == exception2 && exceptionType.isNil()) {
                IRubyObject iRubyObject = Timeout.raiseTimeoutError(context, re);
                return iRubyObject;
            }
            throw re;
        }
        finally {
            Timeout.killTimeoutThread(context, timeoutThread, monitor, doRaise);
        }
    }

    private static Thread prepareThread(final Object monitor, final long waitTime, final AtomicBoolean doRaise, final RubyThread currentThread, final Ruby runtime2) {
        Thread timeoutThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = monitor;
                synchronized (object) {
                    Timeout.doTimedWait(waitTime, doRaise, monitor);
                    if (doRaise.get()) {
                        Timeout.raiseInThread(runtime2, currentThread, runtime2.getClassFromPath("Timeout::ExitException"));
                    }
                }
            }
        };
        timeoutThread.setDaemon(true);
        return timeoutThread;
    }

    private static Thread prepareThreadWithException(final Object monitor, final long waitTime, final AtomicBoolean doRaise, final RubyThread currentThread, final IRubyObject exception2, final Ruby runtime2) {
        Thread timeoutThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = monitor;
                synchronized (object) {
                    Timeout.doTimedWait(waitTime, doRaise, monitor);
                    if (doRaise.get()) {
                        Timeout.raiseInThread(runtime2, currentThread, exception2);
                    }
                }
            }
        };
        timeoutThread.setDaemon(true);
        return timeoutThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void killTimeoutThread(ThreadContext context, Thread timeoutThread, Object monitor, AtomicBoolean doRaise) {
        Object object = monitor;
        synchronized (object) {
            if (timeoutThread.isAlive()) {
                doRaise.set(false);
                timeoutThread.interrupt();
            }
            context.pollThreadEvents();
        }
    }

    private static void doTimedWait(long waitTime, AtomicBoolean doRaise, Object monitor) {
        try {
            long remain;
            long end2 = System.currentTimeMillis() + waitTime;
            while (doRaise.get() && (remain = end2 - System.currentTimeMillis()) > 0L) {
                monitor.wait(remain);
            }
        }
        catch (InterruptedException ie) {
            doRaise.set(false);
        }
    }

    private static void raiseInThread(Ruby runtime2, RubyThread currentThread, IRubyObject exception2) {
        if (currentThread.alive_p().isTrue()) {
            currentThread.internalRaise(new IRubyObject[]{runtime2.getClassFromPath("Timeout::ExitException"), runtime2.newString("execution expired")});
        }
    }

    private static IRubyObject raiseBecauseCritical(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        return RubyKernel.raise(context, runtime2.getKernel(), new IRubyObject[]{runtime2.getThreadError(), runtime2.newString("timeout within critical section")}, Block.NULL_BLOCK);
    }

    private static IRubyObject raiseTimeoutError(ThreadContext context, RaiseException re) {
        Ruby runtime2 = context.getRuntime();
        return RubyKernel.raise(context, runtime2.getKernel(), new IRubyObject[]{runtime2.getClassFromPath("Timeout::Error"), re.getException().callMethod(context, "message"), re.getException().callMethod(context, "backtrace")}, Block.NULL_BLOCK);
    }

    public static class TimeoutToplevel {
        @JRubyMethod(required=1, optional=1)
        public static IRubyObject timeout(ThreadContext context, IRubyObject self, IRubyObject[] args2, Block block) {
            RubyModule timeout2 = context.getRuntime().getModule("Timeout");
            switch (args2.length) {
                case 1: {
                    return Timeout.timeout(context, timeout2, args2[0], block);
                }
                case 2: {
                    return Timeout.timeout(context, timeout2, args2[0], args2[1], block);
                }
            }
            Arity.raiseArgumentError(context.getRuntime(), args2.length, 1, 2);
            return context.getRuntime().getNil();
        }
    }
}

