/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.UnsupportedEncodingException;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyString;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class ZlibInflate {
    private final Ruby runtime;
    private Inflater flater = new Inflater(false);
    private ByteList collected = new ByteList(100);
    private ByteList appended;
    public static final int BASE_SIZE = 100;

    public ZlibInflate(IRubyObject caller2) {
        this.runtime = caller2.getRuntime();
        this.appended = new ByteList();
    }

    public static IRubyObject s_inflate(IRubyObject caller2, ByteList str) throws DataFormatException {
        ZlibInflate zstream = new ZlibInflate(caller2);
        IRubyObject result = zstream.inflate(str);
        zstream.finish();
        zstream.close();
        return result;
    }

    public Inflater getInflater() {
        return this.flater;
    }

    public IRubyObject sync_point() {
        return this.runtime.getFalse();
    }

    public IRubyObject sync(IRubyObject str) {
        this.append(str);
        return this.runtime.getFalse();
    }

    public void append(IRubyObject obj) {
        this.append(obj.convertToString().getByteList());
    }

    public void append(ByteList obj) {
        this.flater.setInput(obj.unsafeBytes(), obj.begin, obj.realSize);
        this.appended.append(obj);
        this.run();
    }

    private void run() {
        byte[] outp = new byte[1024];
        int resultLength = -1;
        while (!this.flater.finished() && resultLength != 0) {
            try {
                resultLength = this.flater.inflate(outp);
                if (this.flater.needsDictionary()) {
                    RubyClass errorClass = this.runtime.fastGetModule("Zlib").fastGetClass("NeedDict");
                    throw new RaiseException(RubyException.newException(this.runtime, errorClass, "need dictionary"));
                }
            }
            catch (DataFormatException ex) {
                this.flater = new Inflater(true);
                this.flater.setInput(this.appended.unsafeBytes(), this.appended.begin, this.appended.realSize);
                this.appended = new ByteList();
                this.run();
                return;
            }
            this.collected.append(outp, 0, resultLength);
            if (resultLength != outp.length) continue;
            outp = new byte[outp.length * 2];
        }
    }

    public IRubyObject set_dictionary(IRubyObject str) throws UnsupportedEncodingException {
        this.flater.setDictionary(str.convertToString().getBytes());
        this.run();
        return str;
    }

    public IRubyObject inflate(ByteList str) {
        if (null == str) {
            return this.finish();
        }
        this.append(str);
        if (this.flater.finished()) {
            return this.finish();
        }
        return RubyString.newEmptyString(this.runtime);
    }

    public IRubyObject flush() {
        IRubyObject ro = this.inflate(new ByteList(0));
        this.collected = new ByteList(0);
        return ro;
    }

    public IRubyObject finish() {
        this.flater.end();
        this.run();
        return RubyString.newString(this.runtime, this.collected);
    }

    public void close() {
    }
}

