/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.util.Arrays;

public class CodegenUtils {
    public static String c(String p2) {
        return p2.replace('/', '.');
    }

    public static String p(Class n) {
        return n.getName().replace('.', '/');
    }

    public static String ci(Class n) {
        if (n.isArray()) {
            if ((n = n.getComponentType()).isPrimitive()) {
                if (n == Byte.TYPE) {
                    return "[B";
                }
                if (n == Boolean.TYPE) {
                    return "[Z";
                }
                if (n == Short.TYPE) {
                    return "[S";
                }
                if (n == Character.TYPE) {
                    return "[C";
                }
                if (n == Integer.TYPE) {
                    return "[I";
                }
                if (n == Float.TYPE) {
                    return "[F";
                }
                if (n == Double.TYPE) {
                    return "[D";
                }
                if (n == Long.TYPE) {
                    return "[J";
                }
                throw new RuntimeException("Unrecognized type in compiler: " + n.getName());
            }
            return "[" + CodegenUtils.ci(n);
        }
        if (n.isPrimitive()) {
            if (n == Byte.TYPE) {
                return "B";
            }
            if (n == Boolean.TYPE) {
                return "Z";
            }
            if (n == Short.TYPE) {
                return "S";
            }
            if (n == Character.TYPE) {
                return "C";
            }
            if (n == Integer.TYPE) {
                return "I";
            }
            if (n == Float.TYPE) {
                return "F";
            }
            if (n == Double.TYPE) {
                return "D";
            }
            if (n == Long.TYPE) {
                return "J";
            }
            if (n == Void.TYPE) {
                return "V";
            }
            throw new RuntimeException("Unrecognized type in compiler: " + n.getName());
        }
        return "L" + CodegenUtils.p(n) + ";";
    }

    public static String human(Class n) {
        return n.getCanonicalName();
    }

    public static String sig(Class retval, Class ... params2) {
        return CodegenUtils.sigParams(params2) + CodegenUtils.ci(retval);
    }

    public static String sigParams(Class ... params2) {
        StringBuilder signature = new StringBuilder("(");
        for (int i = 0; i < params2.length; ++i) {
            signature.append(CodegenUtils.ci(params2[i]));
        }
        signature.append(")");
        return signature.toString();
    }

    public static String pretty(Class retval, Class ... params2) {
        return CodegenUtils.prettyParams(params2) + CodegenUtils.human(retval);
    }

    public static String prettyParams(Class ... params2) {
        StringBuilder signature = new StringBuilder("(");
        for (int i = 0; i < params2.length; ++i) {
            signature.append(CodegenUtils.human(params2[i]));
            if (i >= params2.length - 1) continue;
            signature.append(',');
        }
        signature.append(")");
        return signature.toString();
    }

    public static Class[] params(Class ... classes2) {
        return classes2;
    }

    public static Class[] params(Class cls, int times2) {
        Object[] classes2 = new Class[times2];
        Arrays.fill(classes2, cls);
        return classes2;
    }

    public static Class[] params(Class cls1, Class clsFill, int times2) {
        Object[] classes2 = new Class[times2 + 1];
        Arrays.fill(classes2, clsFill);
        classes2[0] = cls1;
        return classes2;
    }

    public static String getAnnotatedBindingClassName(String javaMethodName, String typeName, boolean isStatic, int required, int optional, boolean multi, boolean framed) {
        String marker;
        String string2 = marker = framed ? "$RUBYFRAMEDINVOKER$" : "$RUBYINVOKER$";
        String commonClassSuffix = multi ? (isStatic ? "$s" : "$i") + "_method_multi" + marker + javaMethodName : (isStatic ? "$s" : "$i") + "_method_" + required + "_" + optional + marker + javaMethodName;
        return typeName + commonClassSuffix;
    }
}

