/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jffi;

import com.kenai.jffi.CallingConvention;
import com.kenai.jffi.Function;
import com.kenai.jffi.Library;
import com.kenai.jffi.Platform;
import com.kenai.jffi.Type;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.AbstractInvoker;
import org.jruby.ext.ffi.BasePointer;
import org.jruby.ext.ffi.CallbackInfo;
import org.jruby.ext.ffi.FFIProvider;
import org.jruby.ext.ffi.NativeParam;
import org.jruby.ext.ffi.NativeType;
import org.jruby.ext.ffi.Util;
import org.jruby.ext.ffi.jffi.DefaultMethodFactory;
import org.jruby.ext.ffi.jffi.DynamicLibrary;
import org.jruby.ext.ffi.jffi.FastIntMethodFactory;
import org.jruby.ext.ffi.jffi.FastLongMethodFactory;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class JFFIInvoker
extends AbstractInvoker {
    private static final Map<DynamicMethod, Library> libraryRefMap = Collections.synchronizedMap(new WeakHashMap());
    private final Library library;
    private final Function function;
    private final NativeType returnType;
    private final NativeParam[] parameterTypes;
    private final int parameterCount;
    private final CallingConvention convention;
    private final RubyModule callModule;
    private final DynamicMethod callMethod;

    public static RubyClass createInvokerClass(Ruby runtime2, RubyModule module) {
        RubyClass result = module.defineClassUnder("Invoker", runtime2.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        result.defineAnnotatedMethods(AbstractInvoker.class);
        result.defineAnnotatedMethods(JFFIInvoker.class);
        result.defineAnnotatedConstants(JFFIInvoker.class);
        return result;
    }

    public JFFIInvoker(Ruby runtime2, String libraryName, String functionName, NativeType returnType, NativeParam[] parameterTypes, String convention) {
        this(runtime2, FFIProvider.getModule(runtime2).fastGetClass("Invoker"), Library.getCachedInstance(libraryName, 1), Library.getCachedInstance(libraryName, 1).getSymbolAddress(functionName), returnType, parameterTypes, convention);
    }

    public JFFIInvoker(Ruby runtime2, RubyClass klass, Library library, long address2, NativeType returnType, NativeParam[] parameterTypes, String convention) {
        super(runtime2, klass, parameterTypes.length);
        Type jffiReturnType = JFFIInvoker.getFFIType(returnType);
        Type[] jffiParamTypes = new Type[parameterTypes.length];
        for (int i = 0; i < jffiParamTypes.length; ++i) {
            jffiParamTypes[i] = JFFIInvoker.getFFIType(parameterTypes[i]);
        }
        this.function = new Function(address2, jffiReturnType, jffiParamTypes);
        this.parameterTypes = new NativeParam[parameterTypes.length];
        System.arraycopy(parameterTypes, 0, this.parameterTypes, 0, parameterTypes.length);
        this.library = library;
        this.parameterCount = parameterTypes.length;
        this.returnType = returnType;
        this.convention = "stdcall".equals(convention) ? CallingConvention.STDCALL : CallingConvention.DEFAULT;
        this.callModule = RubyModule.newModule(runtime2);
        this.callMethod = this.createDynamicMethod(this.callModule);
        this.callModule.addModuleFunction("call", this.callMethod);
    }

    @JRubyMethod(name={"new"}, meta=true, required=5)
    public static IRubyObject newInstance(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        String convention = args2[4].toString();
        DynamicLibrary library = (DynamicLibrary)args2[0];
        BasePointer ptr = (BasePointer)args2[1];
        RubyArray paramTypes = (RubyArray)args2[2];
        NativeParam[] parameterTypes = JFFIInvoker.getNativeParameterTypes(context.getRuntime(), paramTypes);
        NativeType returnType = NativeType.valueOf(Util.int32Value(args2[3]));
        return new JFFIInvoker(context.getRuntime(), (RubyClass)recv2, library.getNativeLibrary(), ptr.getAddress(), returnType, parameterTypes, convention);
    }

    @JRubyMethod(name={"invoke", "call", "call0", "call1", "call2", "call3"}, rest=true)
    public IRubyObject invoke(ThreadContext context, IRubyObject[] args2) {
        return this.callMethod.call(context, (IRubyObject)this.callModule, (RubyModule)this.callModule.getSingletonClass(), "call", args2, Block.NULL_BLOCK);
    }

    public DynamicMethod createDynamicMethod(RubyModule module) {
        DynamicMethod dm = this.convention == CallingConvention.DEFAULT && FastIntMethodFactory.getFactory().isFastIntMethod(this.returnType, this.parameterTypes) ? FastIntMethodFactory.getFactory().createMethod(module, this.function, this.returnType, this.parameterTypes) : (this.convention == CallingConvention.DEFAULT && FastLongMethodFactory.getFactory().isFastLongMethod(this.returnType, this.parameterTypes) ? FastLongMethodFactory.getFactory().createMethod(module, this.function, this.returnType, this.parameterTypes) : DefaultMethodFactory.getFactory().createMethod(module, this.function, this.returnType, this.parameterTypes, this.convention));
        libraryRefMap.put(dm, this.library);
        return dm;
    }

    private static final Type getFFIType(NativeParam type2) {
        if (type2 instanceof NativeType) {
            switch ((NativeType)type2) {
                case VOID: {
                    return Type.VOID;
                }
                case INT8: {
                    return Type.SINT8;
                }
                case UINT8: {
                    return Type.UINT8;
                }
                case INT16: {
                    return Type.SINT16;
                }
                case UINT16: {
                    return Type.UINT16;
                }
                case INT32: {
                    return Type.SINT32;
                }
                case UINT32: {
                    return Type.UINT32;
                }
                case INT64: {
                    return Type.SINT64;
                }
                case UINT64: {
                    return Type.UINT64;
                }
                case LONG: {
                    return Platform.getPlatform().addressSize() == 32 ? Type.SINT32 : Type.SINT64;
                }
                case ULONG: {
                    return Platform.getPlatform().addressSize() == 32 ? Type.UINT32 : Type.UINT64;
                }
                case FLOAT32: {
                    return Type.FLOAT;
                }
                case FLOAT64: {
                    return Type.DOUBLE;
                }
                case POINTER: {
                    return Type.POINTER;
                }
                case BUFFER_IN: 
                case BUFFER_OUT: 
                case BUFFER_INOUT: {
                    return Type.POINTER;
                }
                case STRING: {
                    return Type.POINTER;
                }
            }
            throw new IllegalArgumentException("Unknown type " + type2);
        }
        if (type2 instanceof CallbackInfo) {
            return Type.POINTER;
        }
        throw new IllegalArgumentException("Unknown type " + type2);
    }
}

