/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.yaml;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.DateTime;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyRange;
import org.jruby.RubyString;
import org.jruby.RubyStruct;
import org.jruby.RubyTime;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jvyamlb.Composer;
import org.jvyamlb.ComposerImpl;
import org.jvyamlb.Constructor;
import org.jvyamlb.ConstructorImpl;
import org.jvyamlb.ParserImpl;
import org.jvyamlb.ResolverImpl;
import org.jvyamlb.SafeConstructorImpl;
import org.jvyamlb.ScannerImpl;
import org.jvyamlb.YAML;
import org.jvyamlb.exceptions.ConstructorException;
import org.jvyamlb.nodes.LinkNode;
import org.jvyamlb.nodes.Node;
import org.jvyamlb.nodes.ScalarNode;

public class JRubyConstructor
extends ConstructorImpl {
    private static final Map yamlConstructors = new HashMap();
    private static final Map yamlMultiConstructors = new HashMap();
    private static final Map yamlMultiRegexps = new HashMap();
    private final Ruby runtime;

    public Constructor.YamlConstructor getYamlConstructor(Object key2) {
        return (Constructor.YamlConstructor)yamlConstructors.get(key2);
    }

    public Constructor.YamlMultiConstructor getYamlMultiConstructor(Object key2) {
        return (Constructor.YamlMultiConstructor)yamlMultiConstructors.get(key2);
    }

    public Pattern getYamlMultiRegexp(Object key2) {
        return (Pattern)yamlMultiRegexps.get(key2);
    }

    public Set getYamlMultiRegexps() {
        return yamlMultiRegexps.keySet();
    }

    public static void addConstructor(String tag, Constructor.YamlConstructor ctor) {
        yamlConstructors.put(tag, ctor);
    }

    public static void addMultiConstructor(String tagPrefix, Constructor.YamlMultiConstructor ctor) {
        yamlMultiConstructors.put(tagPrefix, ctor);
        yamlMultiRegexps.put(tagPrefix, Pattern.compile("^" + tagPrefix));
    }

    public JRubyConstructor(IRubyObject receiver2, Composer composer) {
        this(receiver2.getRuntime(), composer);
    }

    public JRubyConstructor(Ruby runtime2, Composer composer) {
        super(composer);
        this.runtime = runtime2;
    }

    public Object constructRubyScalar(Node node) {
        if (node instanceof ScalarNode) {
            ByteList sc = (ByteList)super.constructScalar(node);
            if (sc.length() > 1 && sc.charAt(0) == ':' && ((ScalarNode)node).getStyle() == '\u0000') {
                int first2 = sc.get(1);
                int last2 = sc.get(sc.realSize - 1);
                if (first2 == 34 && last2 == 34 || first2 == 39 && last2 == 39) {
                    ScannerImpl scn = new ScannerImpl(sc.makeShared(1, sc.realSize - 1));
                    JRubyConstructor ctor = new JRubyConstructor(this.runtime, (Composer)new ComposerImpl(new ParserImpl(scn, YAML.config().version("1.0")), new ResolverImpl()));
                    ctor.checkData();
                    return ((RubyString)ctor.getData()).intern();
                }
                return this.runtime.newSymbol(new String(sc.bytes, sc.begin + 1, sc.realSize - 1));
            }
            return RubyString.newString(this.runtime, (ByteList)super.constructScalar(node));
        }
        Map val = (Map)this.constructMapping(node);
        RubyString str = (RubyString)val.get(this.runtime.newString("str"));
        HashMap props = new HashMap();
        Iterator iter = val.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry em = iter.next();
            if (!em.getKey().toString().startsWith("@")) continue;
            props.put(em.getKey(), em.getValue());
            iter.remove();
        }
        for (Map.Entry em : props.entrySet()) {
            str.instance_variable_set((IRubyObject)em.getKey(), (IRubyObject)em.getValue());
        }
        return str;
    }

    public Object constructPrivateType(Node node) {
        Object val = null;
        val = node.getValue() instanceof Map ? this.constructRubyMapping(node) : (node.getValue() instanceof List ? this.constructRubySequence(node) : this.constructRubyScalar(node));
        return RuntimeHelpers.invoke(this.runtime.getCurrentContext(), this.runtime.fastGetModule("YAML").fastGetConstant("PrivateType"), "new", (IRubyObject)this.runtime.newString(node.getTag()), (IRubyObject)val);
    }

    public Object constructRubySequence(Node node) {
        final RubyArray arr = this.runtime.newArray();
        List l = (List)super.constructSequence(node);
        this.doRecursionFix(node, arr);
        int i = 0;
        for (Object oo : l) {
            if (oo instanceof LinkNode) {
                arr.append(this.runtime.getNil());
                final RubyFixnum ix = this.runtime.newFixnum(i);
                this.addFixer((Node)((LinkNode)oo).getValue(), new Constructor.RecursiveFixer(){

                    public void replace(Node node, Object real2) {
                        arr.aset(ix, (IRubyObject)real2);
                    }
                });
            } else {
                arr.append((IRubyObject)oo);
            }
            ++i;
        }
        return arr;
    }

    public Object constructRubyMapping(Node node) {
        RubyHash h1 = RubyHash.newHash(this.runtime, (Map)super.constructMapping(node), this.runtime.getNil());
        return h1;
    }

    public Object constructRubyPairs(Node node) {
        return this.runtime.newArray((List)super.constructPairs(node));
    }

    public static Object constructYamlNull(Constructor ctor, Node node) {
        return ((JRubyConstructor)ctor).runtime.getNil();
    }

    public static Object constructYamlBool(Constructor ctor, Node node) {
        return SafeConstructorImpl.constructYamlBool(ctor, node) == Boolean.TRUE ? ((JRubyConstructor)ctor).runtime.getTrue() : ((JRubyConstructor)ctor).runtime.getFalse();
    }

    public static Object constructYamlOmap(Constructor ctor, Node node) {
        Ruby runtime2 = ((JRubyConstructor)ctor).runtime;
        RubyArray arr = (RubyArray)runtime2.fastGetModule("YAML").fastGetConstant("Omap").callMethod(runtime2.getCurrentContext(), "new");
        List l = (List)ctor.constructSequence(node);
        ctor.doRecursionFix(node, arr);
        for (IRubyObject v : l) {
            if (v instanceof RubyHash) {
                arr.concat(((RubyHash)v).to_a());
                continue;
            }
            throw new ConstructorException(null, "Invalid !omap entry: " + l, null);
        }
        return arr;
    }

    public static Object constructYamlPairs(Constructor ctor, Node node) {
        return ((JRubyConstructor)ctor).constructRubyPairs(node);
    }

    public static Object constructYamlSet(Constructor ctor, Node node) {
        return SafeConstructorImpl.constructYamlSet(ctor, node);
    }

    public static Object constructYamlStr(Constructor ctor, Node node) {
        Object _str = ((JRubyConstructor)ctor).constructRubyScalar(node);
        if (_str instanceof RubyString) {
            RubyString str = (RubyString)_str;
            return str.getByteList().realSize == 0 && ((ScalarNode)node).getStyle() == '\u0000' ? str.getRuntime().getNil() : str;
        }
        return _str;
    }

    public static Object constructYamlSeq(Constructor ctor, Node node) {
        return ((JRubyConstructor)ctor).constructRubySequence(node);
    }

    public static Object constructYamlMap(Constructor ctor, Node node) {
        return ((JRubyConstructor)ctor).constructRubyMapping(node);
    }

    public static Object constructUndefined(Constructor ctor, Node node) {
        throw new ConstructorException(null, "could not determine a constructor for the tag " + node.getTag(), null);
    }

    public static Object constructYamlTimestamp(Constructor ctor, Node node) {
        Object[] value2 = (Object[])SafeConstructorImpl.constructYamlTimestamp(ctor, node);
        DateTime dt = (DateTime)value2[0];
        RubyTime rt = RubyTime.newTime(((JRubyConstructor)ctor).runtime, dt);
        rt.setUSec(((Integer)value2[1]).intValue());
        return rt;
    }

    public static Object constructYamlTimestampYMD(Constructor ctor, Node node) {
        DateTime dt = (DateTime)((Object[])SafeConstructorImpl.constructYamlTimestamp(ctor, node))[0];
        Ruby runtime2 = ((JRubyConstructor)ctor).runtime;
        return RuntimeHelpers.invoke(runtime2.getCurrentContext(), (IRubyObject)runtime2.fastGetClass("Date"), "new", (IRubyObject)runtime2.newFixnum(dt.getYear()), (IRubyObject)runtime2.newFixnum(dt.getMonthOfYear()), runtime2.newFixnum(dt.getDayOfMonth()));
    }

    public static Object constructYamlInt(Constructor ctor, Node node) {
        return JavaUtil.convertJavaToRuby(((JRubyConstructor)ctor).runtime, SafeConstructorImpl.constructYamlInt(ctor, node));
    }

    public static Object constructYamlFloat(Constructor ctor, Node node) {
        return ((JRubyConstructor)ctor).runtime.newFloat((Double)SafeConstructorImpl.constructYamlFloat(ctor, node));
    }

    public static Object constructYamlBinary(Constructor ctor, Node node) {
        Object b = SafeConstructorImpl.constructYamlBinary(ctor, node);
        if (b instanceof byte[]) {
            return RubyString.newString(((JRubyConstructor)ctor).runtime, new ByteList((byte[])b, false));
        }
        return ((JRubyConstructor)ctor).runtime.newString((String)b);
    }

    public static Object constructJava(Constructor ctor, String pref, Node node) {
        return SafeConstructorImpl.constructJava(ctor, pref, node);
    }

    public static Object constructRubyException(Constructor ctor, String tag, Node node) {
        Ruby runtime2 = ((JRubyConstructor)ctor).runtime;
        RubyModule objClass = runtime2.getObject();
        if (tag != null) {
            String[] nms = tag.split("::");
            try {
                int j = nms.length;
                for (int i = 0; i < j; ++i) {
                    objClass = (RubyModule)objClass.getConstant(nms[i]);
                }
            }
            catch (Exception e) {
                objClass = (RubyClass)runtime2.fastGetModule("YAML").fastGetConstant("Object");
                RubyHash vars = (RubyHash)((JRubyConstructor)ctor).constructRubyMapping(node);
                return RuntimeHelpers.invoke(runtime2.getCurrentContext(), (IRubyObject)objClass, "new", (IRubyObject)runtime2.newString(tag), vars);
            }
        }
        RubyClass theCls = objClass;
        final RubyObject oo = (RubyObject)theCls.getAllocator().allocate(runtime2, theCls);
        Map vars = (Map)ctor.constructMapping(node);
        ctor.doRecursionFix(node, oo);
        for (IRubyObject key2 : vars.keySet()) {
            Object val = vars.get(key2);
            if (val instanceof LinkNode) {
                final String KEY = "@" + key2.toString();
                ctor.addFixer((Node)((LinkNode)val).getValue(), new Constructor.RecursiveFixer(){

                    public void replace(Node node, Object real2) {
                        oo.setInstanceVariable(KEY, (IRubyObject)real2);
                    }
                });
                continue;
            }
            oo.setInstanceVariable("@" + key2.toString(), (IRubyObject)val);
        }
        return oo;
    }

    public static Object constructRubyStruct(Constructor ctor, String tag, Node node) {
        RubyClass struct_type;
        Ruby runtime2 = ((JRubyConstructor)ctor).runtime;
        RubyModule sClass = runtime2.fastGetModule("Struct");
        String[] nms = tag.split("::");
        int j = nms.length;
        for (int i = 0; i < j && sClass != null; sClass = (RubyModule)sClass.getConstant(nms[i]), ++i) {
        }
        HashMap props = new HashMap();
        Map val = (Map)ctor.constructMapping(node);
        Iterator iter = val.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry em = iter.next();
            if (!em.getKey().toString().startsWith("@")) continue;
            props.put(em.getKey(), em.getValue());
            iter.remove();
        }
        if (sClass == null) {
            IRubyObject[] params2 = new IRubyObject[val.size() + 1];
            params2[0] = runtime2.newString(tag);
            int i = 1;
            for (Map.Entry em : val.entrySet()) {
                params2[i] = ((RubyString)em.getKey()).intern();
                ++i;
            }
            struct_type = RubyStruct.newInstance(runtime2.fastGetModule("Struct"), params2, Block.NULL_BLOCK);
        } else {
            struct_type = (RubyClass)sClass;
        }
        IRubyObject st = struct_type.callMethod(runtime2.getCurrentContext(), "new");
        RubyArray members2 = RubyStruct.members(struct_type, Block.NULL_BLOCK);
        int j2 = members2.size();
        for (int i = 0; i < j2; ++i) {
            IRubyObject m = members2.eltInternal(i);
            st.callMethod(runtime2.getCurrentContext(), m.toString() + "=", (IRubyObject)val.get(m));
        }
        for (Map.Entry em : props.entrySet()) {
            ((RubyObject)st).instance_variable_set((IRubyObject)em.getKey(), (IRubyObject)em.getValue());
        }
        return st;
    }

    public static Object constructRuby(Constructor ctor, RubyClass theCls, Node node) {
        Ruby runtime2 = ((JRubyConstructor)ctor).runtime;
        if (theCls.respondsTo("yaml_new")) {
            RubyHash vars = (RubyHash)((JRubyConstructor)ctor).constructRubyMapping(node);
            return RuntimeHelpers.invoke(runtime2.getCurrentContext(), (IRubyObject)theCls, "yaml_new", (IRubyObject)theCls, (IRubyObject)runtime2.newString(node.getTag()), vars);
        }
        final RubyObject oo = (RubyObject)theCls.getAllocator().allocate(runtime2, theCls);
        if (oo.respondsTo("yaml_initialize")) {
            RubyHash vars = (RubyHash)((JRubyConstructor)ctor).constructRubyMapping(node);
            RuntimeHelpers.invoke(runtime2.getCurrentContext(), (IRubyObject)oo, "yaml_initialize", (IRubyObject)runtime2.newString(node.getTag()), vars);
        } else {
            Map vars = (Map)ctor.constructMapping(node);
            ctor.doRecursionFix(node, oo);
            for (IRubyObject key2 : vars.keySet()) {
                Object val = vars.get(key2);
                if (val instanceof LinkNode) {
                    final String KEY = "@" + key2.toString();
                    ctor.addFixer((Node)((LinkNode)val).getValue(), new Constructor.RecursiveFixer(){

                        public void replace(Node node, Object real2) {
                            oo.setInstanceVariable(KEY, (IRubyObject)real2);
                        }
                    });
                    continue;
                }
                oo.setInstanceVariable("@" + key2.toString(), (IRubyObject)val);
            }
        }
        return oo;
    }

    public static Object constructRuby(Constructor ctor, String tag, Node node) {
        Ruby runtime2 = ((JRubyConstructor)ctor).runtime;
        RubyModule objClass = runtime2.getObject();
        if (tag != null) {
            String[] nms = tag.split("::");
            try {
                int j = nms.length;
                for (int i = 0; i < j; ++i) {
                    objClass = (RubyModule)objClass.getConstant(nms[i]);
                }
            }
            catch (Exception e) {
                objClass = (RubyClass)runtime2.fastGetModule("YAML").fastGetConstant("Object");
                RubyHash vars = (RubyHash)((JRubyConstructor)ctor).constructRubyMapping(node);
                return RuntimeHelpers.invoke(runtime2.getCurrentContext(), (IRubyObject)objClass, "new", (IRubyObject)runtime2.newString(tag), vars);
            }
        }
        RubyClass theCls = objClass;
        return JRubyConstructor.constructRuby(ctor, theCls, node);
    }

    public static Object constructRubyRegexp(Constructor ctor, Node node) {
        Ruby runtime2 = ((JRubyConstructor)ctor).runtime;
        String s1 = ctor.constructScalar(node).toString();
        return runtime2.evalScriptlet(s1);
    }

    public static Object constructRubyRange(Constructor ctor, Node node) {
        Ruby runtime2 = ((JRubyConstructor)ctor).runtime;
        ThreadContext context = runtime2.getCurrentContext();
        if (node instanceof ScalarNode) {
            String second;
            String first2;
            String s1 = ctor.constructScalar(node).toString();
            boolean exc = false;
            int ix = -1;
            ix = s1.indexOf("...");
            if (ix != -1) {
                first2 = s1.substring(0, ix);
                second = s1.substring(ix + 3);
                exc = true;
            } else {
                ix = s1.indexOf("..");
                first2 = s1.substring(0, ix);
                second = s1.substring(ix + 2);
            }
            IRubyObject fist = runtime2.fastGetModule("YAML").callMethod(context, "load", runtime2.newString(first2));
            IRubyObject sic = runtime2.fastGetModule("YAML").callMethod(context, "load", runtime2.newString(second));
            return RubyRange.newRange(runtime2, context, fist, sic, exc);
        }
        Map vars = (Map)ctor.constructMapping(node);
        IRubyObject beg = (IRubyObject)vars.get(runtime2.newString("begin"));
        IRubyObject end2 = (IRubyObject)vars.get(runtime2.newString("end"));
        boolean excl = ((IRubyObject)vars.get(runtime2.newString("excl"))).isTrue();
        return RubyRange.newRange(runtime2, context, beg, end2, excl);
    }

    public static Object findAndCreateFromCustomTagging(Constructor ctor, Node node) {
        String tag = node.getTag();
        Ruby runtime2 = ((JRubyConstructor)ctor).runtime;
        IRubyObject _cl = runtime2.fastGetModule("YAML").callMethod(runtime2.getCurrentContext(), "tagged_classes").callMethod(runtime2.getCurrentContext(), "[]", runtime2.newString(tag));
        if (!(_cl instanceof RubyClass)) {
            return null;
        }
        RubyClass clazz = (RubyClass)_cl;
        if (clazz != null && !clazz.isNil()) {
            return JRubyConstructor.constructRuby(ctor, clazz, node);
        }
        return null;
    }

    public static Object constructRubyInt(Constructor ctor, String tag, Node node) {
        Ruby runtime2 = ((JRubyConstructor)ctor).runtime;
        RubyModule objClass = runtime2.getObject();
        if (tag != null) {
            String[] nms = tag.split("::");
            int j = nms.length;
            for (int i = 0; i < j; ++i) {
                objClass = (RubyModule)objClass.getConstant(nms[i]);
            }
        }
        RubyClass theCls = objClass;
        RubyObject oo = (RubyObject)theCls.getAllocator().allocate(runtime2, theCls);
        IRubyObject val = (IRubyObject)JRubyConstructor.constructYamlInt(ctor, node);
        oo.callInit(new IRubyObject[]{val}, Block.NULL_BLOCK);
        return oo;
    }

    public static Object constructRubyString(Constructor ctor, String tag, Node node) {
        Ruby runtime2 = ((JRubyConstructor)ctor).runtime;
        RubyModule objClass = runtime2.getObject();
        if (tag != null) {
            String[] nms = tag.split("::");
            int j = nms.length;
            for (int i = 0; i < j; ++i) {
                objClass = (RubyModule)objClass.getConstant(nms[i]);
            }
        }
        RubyClass theCls = objClass;
        RubyObject oo = (RubyObject)theCls.getAllocator().allocate(runtime2, theCls);
        IRubyObject val = (IRubyObject)JRubyConstructor.constructYamlStr(ctor, node);
        oo.callInit(new IRubyObject[]{val}, Block.NULL_BLOCK);
        return oo;
    }

    public static Object constructRubyMap(Constructor ctor, String tag, Node node) {
        Ruby runtime2 = ((JRubyConstructor)ctor).runtime;
        RubyModule objClass = runtime2.getObject();
        if (tag != null) {
            String[] nms = tag.split("::");
            int j = nms.length;
            for (int i = 0; i < j; ++i) {
                objClass = (RubyModule)objClass.getConstant(nms[i]);
            }
        }
        RubyClass theCls = objClass;
        RubyObject oo = (RubyObject)theCls.getAllocator().allocate(runtime2, theCls);
        Map vars = (Map)ctor.constructMapping(node);
        for (IRubyObject key2 : vars.keySet()) {
            RuntimeHelpers.invoke(oo.getRuntime().getCurrentContext(), (IRubyObject)oo, "[]=", key2, (IRubyObject)vars.get(key2));
        }
        return oo;
    }

    public static Object constructRubySequence(Constructor ctor, String tag, Node node) {
        Ruby runtime2 = ((JRubyConstructor)ctor).runtime;
        RubyModule objClass = runtime2.getObject();
        if (tag != null) {
            String[] nms = tag.split("::");
            int j = nms.length;
            for (int i = 0; i < j; ++i) {
                objClass = (RubyModule)objClass.getConstant(nms[i]);
            }
        }
        RubyClass theCls = objClass;
        RubyObject oo = (RubyObject)theCls.getAllocator().allocate(runtime2, theCls);
        List vars = (List)ctor.constructSequence(node);
        Iterator iter = vars.iterator();
        while (iter.hasNext()) {
            RuntimeHelpers.invoke(oo.getRuntime().getCurrentContext(), (IRubyObject)oo, "<<", (IRubyObject)iter.next());
        }
        return oo;
    }

    static {
        JRubyConstructor.addConstructor("tag:yaml.org,2002:null", new Constructor.YamlConstructor(){

            public Object call(Constructor self, Node node) {
                return JRubyConstructor.constructYamlNull(self, node);
            }
        });
        JRubyConstructor.addConstructor("tag:yaml.org,2002:bool", new Constructor.YamlConstructor(){

            public Object call(Constructor self, Node node) {
                return JRubyConstructor.constructYamlBool(self, node);
            }
        });
        JRubyConstructor.addConstructor("tag:yaml.org,2002:omap", new Constructor.YamlConstructor(){

            public Object call(Constructor self, Node node) {
                return JRubyConstructor.constructYamlOmap(self, node);
            }
        });
        JRubyConstructor.addConstructor("tag:yaml.org,2002:pairs", new Constructor.YamlConstructor(){

            public Object call(Constructor self, Node node) {
                return JRubyConstructor.constructYamlPairs(self, node);
            }
        });
        JRubyConstructor.addConstructor("tag:yaml.org,2002:set", new Constructor.YamlConstructor(){

            public Object call(Constructor self, Node node) {
                return JRubyConstructor.constructYamlSet(self, node);
            }
        });
        JRubyConstructor.addConstructor("tag:yaml.org,2002:int", new Constructor.YamlConstructor(){

            public Object call(Constructor self, Node node) {
                return JRubyConstructor.constructYamlInt(self, node);
            }
        });
        JRubyConstructor.addConstructor("tag:yaml.org,2002:float", new Constructor.YamlConstructor(){

            public Object call(Constructor self, Node node) {
                return JRubyConstructor.constructYamlFloat(self, node);
            }
        });
        JRubyConstructor.addConstructor("tag:yaml.org,2002:timestamp", new Constructor.YamlConstructor(){

            public Object call(Constructor self, Node node) {
                Matcher match2 = SafeConstructorImpl.YMD_REGEXP.matcher(node.getValue().toString());
                if (match2.matches()) {
                    return JRubyConstructor.constructYamlTimestampYMD(self, node);
                }
                return JRubyConstructor.constructYamlTimestamp(self, node);
            }
        });
        JRubyConstructor.addConstructor("tag:yaml.org,2002:timestamp#ymd", new Constructor.YamlConstructor(){

            public Object call(Constructor self, Node node) {
                return JRubyConstructor.constructYamlTimestampYMD(self, node);
            }
        });
        JRubyConstructor.addConstructor("tag:yaml.org,2002:str", new Constructor.YamlConstructor(){

            public Object call(Constructor self, Node node) {
                return JRubyConstructor.constructYamlStr(self, node);
            }
        });
        JRubyConstructor.addConstructor("tag:yaml.org,2002:binary", new Constructor.YamlConstructor(){

            public Object call(Constructor self, Node node) {
                return JRubyConstructor.constructYamlBinary(self, node);
            }
        });
        JRubyConstructor.addConstructor("tag:yaml.org,2002:seq", new Constructor.YamlConstructor(){

            public Object call(Constructor self, Node node) {
                return JRubyConstructor.constructYamlSeq(self, node);
            }
        });
        JRubyConstructor.addConstructor("tag:yaml.org,2002:map", new Constructor.YamlConstructor(){

            public Object call(Constructor self, Node node) {
                return JRubyConstructor.constructYamlMap(self, node);
            }
        });
        JRubyConstructor.addConstructor("tag:ruby.yaml.org,2002:range", new Constructor.YamlConstructor(){

            public Object call(Constructor self, Node node) {
                return JRubyConstructor.constructRubyRange(self, node);
            }
        });
        JRubyConstructor.addConstructor("tag:ruby.yaml.org,2002:regexp", new Constructor.YamlConstructor(){

            public Object call(Constructor self, Node node) {
                return JRubyConstructor.constructRubyRegexp(self, node);
            }
        });
        JRubyConstructor.addConstructor(null, new Constructor.YamlConstructor(){

            public Object call(Constructor self, Node node) {
                Object v1 = JRubyConstructor.findAndCreateFromCustomTagging(self, node);
                if (null != v1) {
                    return v1;
                }
                return self.constructPrivateType(node);
            }
        });
        JRubyConstructor.addMultiConstructor("tag:yaml.org,2002:map:", new Constructor.YamlMultiConstructor(){

            public Object call(Constructor self, String pref, Node node) {
                return JRubyConstructor.constructRubyMap(self, pref, node);
            }
        });
        JRubyConstructor.addMultiConstructor("tag:ruby.yaml.org,2002:hash:", new Constructor.YamlMultiConstructor(){

            public Object call(Constructor self, String pref, Node node) {
                return JRubyConstructor.constructRubyMap(self, pref, node);
            }
        });
        JRubyConstructor.addMultiConstructor("tag:yaml.org,2002:int:", new Constructor.YamlMultiConstructor(){

            public Object call(Constructor self, String pref, Node node) {
                return JRubyConstructor.constructRubyInt(self, pref, node);
            }
        });
        JRubyConstructor.addMultiConstructor("tag:yaml.org,2002:seq:", new Constructor.YamlMultiConstructor(){

            public Object call(Constructor self, String pref, Node node) {
                return JRubyConstructor.constructRubySequence(self, pref, node);
            }
        });
        JRubyConstructor.addMultiConstructor("tag:ruby.yaml.org,2002:array:", new Constructor.YamlMultiConstructor(){

            public Object call(Constructor self, String pref, Node node) {
                return JRubyConstructor.constructRubySequence(self, pref, node);
            }
        });
        JRubyConstructor.addMultiConstructor("tag:yaml.org,2002:str:", new Constructor.YamlMultiConstructor(){

            public Object call(Constructor self, String pref, Node node) {
                return JRubyConstructor.constructRubyString(self, pref, node);
            }
        });
        JRubyConstructor.addMultiConstructor("tag:ruby.yaml.org,2002:string:", new Constructor.YamlMultiConstructor(){

            public Object call(Constructor self, String pref, Node node) {
                return JRubyConstructor.constructRubyString(self, pref, node);
            }
        });
        JRubyConstructor.addMultiConstructor("tag:yaml.org,2002:ruby/object:", new Constructor.YamlMultiConstructor(){

            public Object call(Constructor self, String pref, Node node) {
                return JRubyConstructor.constructRuby(self, pref, node);
            }
        });
        JRubyConstructor.addMultiConstructor("tag:ruby.yaml.org,2002:object:", new Constructor.YamlMultiConstructor(){

            public Object call(Constructor self, String pref, Node node) {
                return JRubyConstructor.constructRuby(self, pref, node);
            }
        });
        JRubyConstructor.addMultiConstructor("tag:yaml.org,2002:java/object:", new Constructor.YamlMultiConstructor(){

            public Object call(Constructor self, String pref, Node node) {
                return JRubyConstructor.constructJava(self, pref, node);
            }
        });
        JRubyConstructor.addMultiConstructor("tag:java.yaml.org,2002:object:", new Constructor.YamlMultiConstructor(){

            public Object call(Constructor self, String pref, Node node) {
                return JRubyConstructor.constructJava(self, pref, node);
            }
        });
        JRubyConstructor.addMultiConstructor("tag:ruby.yaml.org,2002:struct:", new Constructor.YamlMultiConstructor(){

            public Object call(Constructor self, String pref, Node node) {
                return JRubyConstructor.constructRubyStruct(self, pref, node);
            }
        });
        JRubyConstructor.addMultiConstructor("tag:ruby.yaml.org,2002:exception:", new Constructor.YamlMultiConstructor(){

            public Object call(Constructor self, String pref, Node node) {
                return JRubyConstructor.constructRuby(self, pref, node);
            }
        });
    }
}

