/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.AbstractMemory;
import org.jruby.ext.ffi.DirectMemoryIO;
import org.jruby.ext.ffi.FFIProvider;
import org.jruby.ext.ffi.NullMemoryIO;
import org.jruby.ext.ffi.Pointer;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"FFI::BasePointer"}, parent="FFI::Pointer")
public class BasePointer
extends Pointer {
    public static final String BASE_POINTER_NAME = "BasePointer";

    public static RubyClass createBasePointerClass(Ruby runtime2, RubyModule module) {
        RubyClass result = module.defineClassUnder(BASE_POINTER_NAME, module.getClass("Pointer"), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        result.defineAnnotatedMethods(BasePointer.class);
        result.defineAnnotatedConstants(BasePointer.class);
        return result;
    }

    public static final RubyClass getBasePointerClass(Ruby runtime2) {
        return FFIProvider.getModule(runtime2).fastGetClass(BASE_POINTER_NAME);
    }

    public BasePointer(Ruby runtime2, DirectMemoryIO io2) {
        super(runtime2, BasePointer.getBasePointerClass(runtime2), io2);
    }

    public BasePointer(Ruby runtime2, DirectMemoryIO io2, long size2) {
        super(runtime2, BasePointer.getBasePointerClass(runtime2), io2, size2);
    }

    public BasePointer(Ruby runtime2, RubyClass klass, DirectMemoryIO io2, long size2) {
        super(runtime2, klass, io2, size2);
    }

    public final long getAddress() {
        return ((DirectMemoryIO)this.getMemoryIO()).getAddress();
    }

    @JRubyMethod(name={"to_s"}, optional=1)
    public IRubyObject to_s(ThreadContext context, IRubyObject[] args2) {
        return RubyString.newString(context.getRuntime(), String.format("Pointer [address=%x]", this.getAddress()));
    }

    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect(ThreadContext context) {
        String hex2 = Long.toHexString(this.getAddress());
        return RubyString.newString(context.getRuntime(), String.format("#<Pointer address=0x%s>", hex2));
    }

    @JRubyMethod(name={"address"})
    public IRubyObject address(ThreadContext context) {
        return context.getRuntime().newFixnum(this.getAddress());
    }

    protected final AbstractMemory slice(Ruby runtime2, long offset2) {
        return new BasePointer(runtime2, BasePointer.getBasePointerClass(runtime2), (DirectMemoryIO)this.getMemoryIO().slice(offset2), this.size == Long.MAX_VALUE ? Long.MAX_VALUE : this.size - offset2);
    }

    protected BasePointer getPointer(Ruby runtime2, long offset2) {
        DirectMemoryIO ptr = this.getMemoryIO().getMemoryIO(offset2);
        return new BasePointer(runtime2, ptr != null && !ptr.isNull() ? ptr : new NullMemoryIO(runtime2), Long.MAX_VALUE);
    }
}

