/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.IArityNode;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.common.IRubyWarnings;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstVarNode
extends Node
implements IArityNode,
INameNode {
    private String name;

    public InstVarNode(ISourcePosition position, String name2) {
        super(position);
        this.name = name2;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.INSTVARNODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitInstVarNode(this);
    }

    @Override
    public Arity getArity() {
        return Arity.noArguments();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Node> childNodes() {
        return EMPTY_LIST;
    }

    public void setName(String name2) {
        this.name = name2;
    }

    @Override
    public IRubyObject interpret(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        IRubyObject variable = self.getInstanceVariables().fastGetInstanceVariable(this.name);
        if (variable != null) {
            return variable;
        }
        if (runtime2.isVerbose()) {
            this.warnAboutUninitializedIvar(runtime2);
        }
        return runtime2.getNil();
    }

    private void warnAboutUninitializedIvar(Ruby runtime2) {
        runtime2.getWarnings().warning(IRubyWarnings.ID.IVAR_NOT_INITIALIZED, this.getPosition(), "instance variable " + this.name + " not initialized", this.name);
    }

    @Override
    public String definition(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        return self.getInstanceVariables().fastHasInstanceVariable(this.name) ? "instance-variable" : null;
    }

    @Override
    public String toString() {
        return "InstVarnode: " + this.name;
    }
}

