/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jruby.CompatVersion;
import org.jruby.Finalizable;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNil;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.InstanceVariableTable;
import org.jruby.runtime.builtin.InstanceVariables;
import org.jruby.runtime.builtin.InternalVariables;
import org.jruby.runtime.builtin.Variable;
import org.jruby.runtime.component.VariableEntry;
import org.jruby.runtime.marshal.CoreObjectType;
import org.jruby.util.IdUtil;
import org.jruby.util.TypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RubyBasicObject
implements Cloneable,
IRubyObject,
Serializable,
Comparable<IRubyObject>,
CoreObjectType,
InstanceVariables,
InternalVariables {
    protected transient RubyClass metaClass;
    protected int flags;
    protected volatile transient InstanceVariableTable variables;
    protected static final String ERR_INSECURE_SET_INST_VAR = "Insecure: can't modify instance variable";
    public static final int ALL_F = -1;
    public static final int FALSE_F = 1;
    public static final int NIL_F = 2;
    public static final int FROZEN_F = 4;
    public static final int TAINTED_F = 8;
    public static final int UNTRUSTED_F = 16;
    public static final int FL_USHIFT = 5;
    public static final int USER0_F = 32;
    public static final int USER1_F = 64;
    public static final int USER2_F = 128;
    public static final int USER3_F = 256;
    public static final int USER4_F = 512;
    public static final int USER5_F = 1024;
    public static final int USER6_F = 2048;
    public static final int USER7_F = 4096;
    public static final IRubyObject NEVER = new RubyBasicObject();
    public static final IRubyObject UNDEF = new RubyBasicObject();
    public static final ObjectAllocator OBJECT_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new RubyBasicObject(runtime2, klass);
        }
    };

    private RubyBasicObject() {
    }

    public static RubyClass createBasicObjectClass(Ruby runtime2, RubyClass objectClass) {
        objectClass.index = 14;
        objectClass.defineAnnotatedMethods(RubyBasicObject.class);
        return objectClass;
    }

    public RubyBasicObject(Ruby runtime2, RubyClass metaClass) {
        assert (metaClass != null) : "NULL Metaclass!!?!?!";
        this.metaClass = metaClass;
        if (runtime2.isObjectSpaceEnabled()) {
            this.addToObjectSpace(runtime2);
        }
        if (runtime2.getSafeLevel() >= 3) {
            this.taint(runtime2);
        }
    }

    protected RubyBasicObject(Ruby runtime2, RubyClass metaClass, boolean useObjectSpace, boolean canBeTainted) {
        this.metaClass = metaClass;
        if (useObjectSpace) {
            this.addToObjectSpace(runtime2);
        }
        if (canBeTainted && runtime2.getSafeLevel() >= 3) {
            this.taint(runtime2);
        }
    }

    protected RubyBasicObject(Ruby runtime2, RubyClass metaClass, boolean useObjectSpace) {
        this.metaClass = metaClass;
        if (useObjectSpace) {
            this.addToObjectSpace(runtime2);
        }
        if (runtime2.getSafeLevel() >= 3) {
            this.taint(runtime2);
        }
    }

    private void addToObjectSpace(Ruby runtime2) {
        assert (runtime2.isObjectSpaceEnabled());
        runtime2.getObjectSpace().add(this);
    }

    protected void taint(Ruby runtime2) {
        runtime2.secure(4);
        if (!this.isTaint()) {
            this.testFrozen();
            this.setTaint(true);
        }
    }

    protected final void testFrozen(String message2) {
        if (this.isFrozen()) {
            throw this.getRuntime().newFrozenError(message2);
        }
    }

    protected final void testFrozen() {
        if (this.isFrozen()) {
            throw this.getRuntime().newFrozenError("object");
        }
    }

    public final void setFlag(int flag, boolean set) {
        this.flags = set ? (this.flags |= flag) : (this.flags &= ~flag);
    }

    public final boolean getFlag(int flag) {
        return (this.flags & flag) != 0;
    }

    @Override
    @Deprecated
    public IRubyObject callSuper(ThreadContext context, IRubyObject[] args2, Block block) {
        return RuntimeHelpers.invokeSuper(context, (IRubyObject)this, args2, block);
    }

    @Override
    public final IRubyObject callMethod(ThreadContext context, String name2) {
        return RuntimeHelpers.invoke(context, this, name2);
    }

    @Override
    public final IRubyObject callMethod(ThreadContext context, String name2, IRubyObject arg2) {
        return RuntimeHelpers.invoke(context, (IRubyObject)this, name2, arg2);
    }

    @Override
    public final IRubyObject callMethod(ThreadContext context, String name2, IRubyObject[] args2) {
        return RuntimeHelpers.invoke(context, (IRubyObject)this, name2, args2);
    }

    @Override
    public final IRubyObject callMethod(ThreadContext context, String name2, IRubyObject[] args2, Block block) {
        return RuntimeHelpers.invoke(context, (IRubyObject)this, name2, args2, block);
    }

    @Override
    @Deprecated
    public final IRubyObject callMethod(ThreadContext context, int methodIndex, String name2) {
        return RuntimeHelpers.invoke(context, this, name2);
    }

    @Override
    @Deprecated
    public final IRubyObject callMethod(ThreadContext context, int methodIndex, String name2, IRubyObject arg2) {
        return RuntimeHelpers.invoke(context, (IRubyObject)this, name2, arg2, Block.NULL_BLOCK);
    }

    @Override
    public final boolean isNil() {
        return (this.flags & 2) != 0;
    }

    @Override
    public final boolean isTrue() {
        return (this.flags & 1) == 0;
    }

    public final boolean isFalse() {
        return (this.flags & 1) != 0;
    }

    @Override
    public boolean isTaint() {
        return (this.flags & 8) != 0;
    }

    @Override
    public void setTaint(boolean taint2) {
        this.flags = taint2 ? (this.flags |= 8) : (this.flags &= 0xFFFFFFF7);
    }

    @Override
    public IRubyObject infectBy(IRubyObject obj) {
        if (obj.isTaint()) {
            this.setTaint(true);
        }
        if (obj.isUntrusted()) {
            this.setUntrusted(true);
        }
        return this;
    }

    final RubyBasicObject infectBy(RubyBasicObject obj) {
        this.flags |= obj.flags & 0x18;
        return this;
    }

    final RubyBasicObject infectBy(int tuFlags) {
        this.flags |= tuFlags & 0x18;
        return this;
    }

    @Override
    public boolean isFrozen() {
        return (this.flags & 4) != 0;
    }

    @Override
    public void setFrozen(boolean frozen) {
        this.flags = frozen ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
    }

    @Override
    public boolean isUntrusted() {
        return (this.flags & 0x10) != 0;
    }

    @Override
    public void setUntrusted(boolean untrusted) {
        this.flags = untrusted ? (this.flags |= 0x10) : (this.flags &= 0xFFFFFFEF);
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    @Override
    public final RubyClass getMetaClass() {
        return this.metaClass;
    }

    @Override
    public RubyClass getSingletonClass() {
        RubyClass klass = this.getMetaClass().isSingleton() && ((MetaClass)this.getMetaClass()).getAttached() == this ? this.getMetaClass() : this.makeMetaClass(this.getMetaClass());
        klass.setTaint(this.isTaint());
        if (this.isFrozen()) {
            klass.setFrozen(true);
        }
        return klass;
    }

    public RubyClass makeMetaClass(RubyClass superClass) {
        MetaClass klass = new MetaClass(this.getRuntime(), superClass);
        this.setMetaClass(klass);
        klass.setAttached(this);
        klass.setMetaClass(superClass.getRealClass().getMetaClass());
        superClass.addSubclass(klass);
        return klass;
    }

    public void setMetaClass(RubyClass metaClass) {
        this.metaClass = metaClass;
    }

    @Override
    public RubyClass getType() {
        return this.getMetaClass().getRealClass();
    }

    @Override
    public final boolean respondsTo(String name2) {
        if (this.getMetaClass().searchMethod("respond_to?") == this.getRuntime().getRespondToMethod()) {
            return this.getMetaClass().isMethodBound(name2, false);
        }
        return this.callMethod(this.getRuntime().getCurrentContext(), "respond_to?", this.getRuntime().newSymbol(name2)).isTrue();
    }

    @Override
    public final Ruby getRuntime() {
        return this.getMetaClass().getClassRuntime();
    }

    @Override
    public Class getJavaClass() {
        if (this.dataGetStruct() instanceof JavaObject) {
            return ((JavaObject)this.dataGetStruct()).getValue().getClass();
        }
        return this.getClass();
    }

    @Override
    public String asJavaString() {
        IRubyObject asString = this.checkStringType();
        if (!asString.isNil()) {
            return ((RubyString)asString).asJavaString();
        }
        throw this.getRuntime().newTypeError(this.inspect().toString() + " is not a symbol");
    }

    @Override
    public RubyString asString() {
        IRubyObject str = RuntimeHelpers.invoke(this.getRuntime().getCurrentContext(), this, "to_s");
        if (!(str instanceof RubyString)) {
            return (RubyString)this.anyToString();
        }
        if (this.isTaint()) {
            str.setTaint(true);
        }
        return (RubyString)str;
    }

    @Override
    public RubyArray convertToArray() {
        return (RubyArray)TypeConverter.convertToType(this, this.getRuntime().getArray(), "to_ary");
    }

    @Override
    public RubyHash convertToHash() {
        return (RubyHash)TypeConverter.convertToType(this, this.getRuntime().getHash(), "to_hash");
    }

    @Override
    public RubyFloat convertToFloat() {
        return (RubyFloat)TypeConverter.convertToType(this, this.getRuntime().getFloat(), "to_f");
    }

    @Override
    public RubyInteger convertToInteger() {
        return this.convertToInteger("to_int");
    }

    @Override
    @Deprecated
    public RubyInteger convertToInteger(int methodIndex, String convertMethod) {
        return this.convertToInteger(convertMethod);
    }

    @Override
    public RubyInteger convertToInteger(String convertMethod) {
        IRubyObject val = TypeConverter.convertToType((IRubyObject)this, this.getRuntime().getInteger(), convertMethod, true);
        if (!(val instanceof RubyInteger)) {
            throw this.getRuntime().newTypeError(this.getMetaClass().getName() + "#" + convertMethod + " should return Integer");
        }
        return (RubyInteger)val;
    }

    @Override
    public RubyString convertToString() {
        return (RubyString)TypeConverter.convertToType(this, this.getRuntime().getString(), "to_str");
    }

    @Override
    public IRubyObject anyToString() {
        String cname = this.getMetaClass().getRealClass().getName();
        RubyString str = this.getRuntime().newString("#<" + cname + ":0x" + Integer.toHexString(System.identityHashCode(this)) + ">");
        str.setTaint(this.isTaint());
        return str;
    }

    @Override
    public IRubyObject checkStringType() {
        IRubyObject str = TypeConverter.convertToTypeWithCheck(this, this.getRuntime().getString(), "to_str");
        if (!str.isNil() && !(str instanceof RubyString)) {
            str = RubyString.newEmptyString(this.getRuntime());
        }
        return str;
    }

    @Override
    public IRubyObject checkArrayType() {
        return TypeConverter.convertToTypeWithCheck(this, this.getRuntime().getArray(), "to_ary");
    }

    IRubyObject checkIntegerType(Ruby runtime2, IRubyObject obj, String method2) {
        if (obj instanceof RubyFixnum) {
            return obj;
        }
        IRubyObject conv2 = TypeConverter.convertToType(obj, this.getRuntime().getInteger(), method2, false);
        return conv2 instanceof RubyInteger ? conv2 : obj.getRuntime().getNil();
    }

    @Override
    public IRubyObject dup() {
        if (this.isImmediate()) {
            throw this.getRuntime().newTypeError("can't dup " + this.getMetaClass().getName());
        }
        IRubyObject dup2 = this.getMetaClass().getRealClass().allocate();
        if (this.isTaint()) {
            dup2.setTaint(true);
        }
        if (this.isUntrusted()) {
            dup2.setUntrusted(true);
        }
        RubyBasicObject.initCopy(dup2, this);
        return dup2;
    }

    private static void initCopy(IRubyObject clone, IRubyObject original) {
        assert (!clone.isFrozen()) : "frozen object (" + clone.getMetaClass().getName() + ") allocated";
        original.copySpecialInstanceVariables(clone);
        if (original.hasVariables()) {
            clone.syncVariables(original.getVariableList());
        }
        if (original instanceof RubyModule) {
            ((RubyModule)clone).syncConstants((RubyModule)original);
        }
        clone.callMethod(clone.getRuntime().getCurrentContext(), "initialize_copy", original);
    }

    @Override
    public void copySpecialInstanceVariables(IRubyObject clone) {
    }

    static RubyString inspect(ThreadContext context, IRubyObject object) {
        return RubyString.objAsString(context, object.callMethod(context, "inspect"));
    }

    @Override
    public IRubyObject rbClone() {
        if (this.isImmediate()) {
            throw this.getRuntime().newTypeError("can't clone " + this.getMetaClass().getName());
        }
        RubyObject clone = (RubyObject)this.getMetaClass().getRealClass().allocate();
        clone.setMetaClass(this.getSingletonClassClone());
        if (this.isTaint()) {
            clone.setTaint(true);
        }
        RubyBasicObject.initCopy(clone, this);
        if (this.isFrozen()) {
            clone.setFrozen(true);
        }
        if (this.isUntrusted()) {
            clone.setUntrusted(true);
        }
        return clone;
    }

    protected RubyClass getSingletonClassClone() {
        RubyClass klass = this.getMetaClass();
        if (!klass.isSingleton()) {
            return klass;
        }
        MetaClass clone = new MetaClass(this.getRuntime());
        clone.flags = this.flags;
        if (this instanceof RubyClass) {
            clone.setMetaClass(clone);
        } else {
            clone.setMetaClass(klass.getSingletonClassClone());
        }
        clone.setSuperClass(klass.getSuperClass());
        if (klass.hasVariables()) {
            clone.syncVariables(klass.getVariableList());
        }
        clone.syncConstants(klass);
        klass.cloneMethods(clone);
        ((MetaClass)clone.getMetaClass()).setAttached(clone);
        clone.setAttached(((MetaClass)klass).getAttached());
        return clone;
    }

    @Override
    public boolean isModule() {
        return false;
    }

    @Override
    public boolean isClass() {
        return false;
    }

    @Override
    public synchronized void dataWrapStruct(Object obj) {
        if (obj == null) {
            this.removeInternalVariable("__wrap_struct__");
        } else {
            this.fastSetInternalVariable("__wrap_struct__", obj);
        }
    }

    @Override
    public synchronized Object dataGetStruct() {
        return this.fastGetInternalVariable("__wrap_struct__");
    }

    @Override
    public synchronized IRubyObject id() {
        return this.getRuntime().newFixnum(this.getRuntime().getObjectSpace().idOf(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject inspect() {
        Ruby runtime2 = this.getRuntime();
        if (!this.isImmediate() && !(this instanceof RubyModule) && this.hasVariables()) {
            StringBuilder part = new StringBuilder();
            String cname = this.getMetaClass().getRealClass().getName();
            part.append("#<").append(cname).append(":0x");
            part.append(Integer.toHexString(System.identityHashCode(this)));
            if (runtime2.isInspecting(this)) {
                part.append(" ...>");
                return runtime2.newString(part.toString());
            }
            try {
                runtime2.registerInspecting(this);
                RubyString rubyString = runtime2.newString(this.inspectObj(part).toString());
                return rubyString;
            }
            finally {
                runtime2.unregisterInspecting(this);
            }
        }
        if (this.isNil()) {
            return RubyNil.inspect(this);
        }
        return RuntimeHelpers.invoke(runtime2.getCurrentContext(), this, "to_s");
    }

    private StringBuilder inspectObj(StringBuilder part) {
        ThreadContext context = this.getRuntime().getCurrentContext();
        String sep = "";
        for (Variable<IRubyObject> ivar : this.getInstanceVariableList()) {
            part.append(sep).append(" ").append(ivar.getName()).append("=");
            part.append(ivar.getValue().callMethod(context, "inspect"));
            sep = ",";
        }
        part.append(">");
        return part;
    }

    @JRubyMethod(name={"!"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_not(ThreadContext context) {
        return context.getRuntime().newBoolean(!this.isTrue());
    }

    @JRubyMethod(name={"!="}, required=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_not_equal(ThreadContext context, IRubyObject other) {
        return context.getRuntime().newBoolean(!RubyBasicObject.equalInternal(context, this, other));
    }

    @Override
    public int compareTo(IRubyObject other) {
        return (int)this.callMethod(this.getRuntime().getCurrentContext(), "<=>", other).convertToInteger().getLongValue();
    }

    @Override
    @JRubyMethod(name={"=="}, required=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_equal(ThreadContext context, IRubyObject obj) {
        return this == obj ? context.getRuntime().getTrue() : context.getRuntime().getFalse();
    }

    @Override
    @JRubyMethod(name={"equal?"}, required=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_eqq(ThreadContext context, IRubyObject other) {
        return context.getRuntime().newBoolean(RubyBasicObject.equalInternal(context, this, other));
    }

    protected static boolean equalInternal(ThreadContext context, IRubyObject that, IRubyObject other) {
        return that == other || that.callMethod(context, "==", other).isTrue();
    }

    @Override
    public boolean eql(IRubyObject other) {
        return this.callMethod(this.getRuntime().getCurrentContext(), "eql?", other).isTrue();
    }

    @Override
    public void addFinalizer(IRubyObject f) {
        Finalizer finalizer = (Finalizer)this.fastGetInternalVariable("__finalizer__");
        if (finalizer == null) {
            finalizer = new Finalizer(this.getRuntime().getObjectSpace().idOf(this));
            this.fastSetInternalVariable("__finalizer__", finalizer);
            this.getRuntime().addFinalizer(finalizer);
        }
        finalizer.addFinalizer(f);
    }

    @Override
    public void removeFinalizers() {
        Finalizer finalizer = (Finalizer)this.fastGetInternalVariable("__finalizer__");
        if (finalizer != null) {
            finalizer.removeFinalizers();
            this.removeInternalVariable("__finalizer__");
            this.getRuntime().removeFinalizer(finalizer);
        }
    }

    public InstanceVariableTable getVariables() {
        return this.variables;
    }

    @Override
    public boolean hasVariables() {
        return this.variableTableGetSize() > 0;
    }

    @Override
    public int getVariableCount() {
        return this.variableTableGetSize();
    }

    @Override
    public List<Variable<IRubyObject>> getVariableList() {
        final ArrayList<Variable<IRubyObject>> list2 = new ArrayList<Variable<IRubyObject>>();
        InstanceVariableTable variables = this.getVariables();
        if (variables != null) {
            variables.visit(new InstanceVariableTable.TryLockVisitor(this){

                public void visit(String name2, Object value2) {
                    list2.add(new VariableEntry<IRubyObject>(name2, (IRubyObject)value2));
                }
            });
        }
        return list2;
    }

    @Override
    public List<String> getVariableNameList() {
        final ArrayList<String> list2 = new ArrayList<String>();
        InstanceVariableTable variables = this.getVariables();
        if (variables != null) {
            variables.visit(new InstanceVariableTable.Visitor(){

                public void visit(String name2, Object value2) {
                    list2.add(name2);
                }
            });
        }
        return list2;
    }

    @Deprecated
    public Map getVariableMap() {
        return this.variableTableGetMap();
    }

    protected static final boolean isRubyVariable(String name2) {
        char c;
        return name2.length() > 0 && ((c = name2.charAt(0)) == '@' || c <= 'Z' && c >= 'A');
    }

    protected boolean variableTableContains(String name2) {
        return this.variables == null ? false : this.variables.contains(name2);
    }

    protected boolean variableTableFastContains(String internedName) {
        return this.variables == null ? false : this.variables.fastContains(internedName);
    }

    protected IRubyObject variableTableFetch(String name2) {
        return this.variables == null ? null : (IRubyObject)this.variables.fetch(name2);
    }

    protected Object variableTableFastFetch(String internedName) {
        return this.variables == null ? null : this.variables.fastFetch(internedName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object variableTableStore(String name2, Object value2) {
        RubyBasicObject rubyBasicObject = this;
        synchronized (rubyBasicObject) {
            if (this.variables == null) {
                this.variables = new InstanceVariableTable(name2.intern(), value2);
            } else {
                this.variables.store(name2, value2);
            }
        }
        return value2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object variableTableFastStore(String internedName, Object value2) {
        assert (internedName == internedName.intern()) : internedName + " not interned";
        RubyBasicObject rubyBasicObject = this;
        synchronized (rubyBasicObject) {
            if (this.variables == null) {
                this.variables = new InstanceVariableTable(internedName, value2);
            } else {
                this.variables.fastStore(internedName, value2);
            }
        }
        return value2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object variableTableRemove(String name2) {
        RubyBasicObject rubyBasicObject = this;
        synchronized (rubyBasicObject) {
            return this.variables == null ? null : this.variables.remove(name2);
        }
    }

    protected int variableTableGetSize() {
        return this.variables == null ? 0 : this.variables.getSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void variableTableSync(List<Variable<IRubyObject>> vars) {
        RubyBasicObject rubyBasicObject = this;
        synchronized (rubyBasicObject) {
            this.variables = new InstanceVariableTable(vars);
        }
    }

    protected Map variableTableGetMap() {
        HashMap map = new HashMap();
        if (this.variables != null) {
            this.variables.getMap(this, map);
        }
        return map;
    }

    protected Map variableTableGetMap(Map map) {
        if (this.variables != null) {
            this.variables.getMap(this, map);
        }
        return map;
    }

    @Override
    public InternalVariables getInternalVariables() {
        return this;
    }

    @Override
    public boolean hasInternalVariable(String name2) {
        assert (!RubyBasicObject.isRubyVariable(name2));
        return this.variableTableContains(name2);
    }

    @Override
    public boolean fastHasInternalVariable(String internedName) {
        assert (!RubyBasicObject.isRubyVariable(internedName));
        return this.variableTableFastContains(internedName);
    }

    @Override
    public IRubyObject getInternalVariable(String name2) {
        assert (!RubyBasicObject.isRubyVariable(name2));
        return this.variableTableFetch(name2);
    }

    @Override
    public Object fastGetInternalVariable(String internedName) {
        assert (!RubyBasicObject.isRubyVariable(internedName));
        return this.variableTableFastFetch(internedName);
    }

    @Override
    public void setInternalVariable(String name2, Object value2) {
        assert (!RubyBasicObject.isRubyVariable(name2));
        this.variableTableStore(name2, value2);
    }

    @Override
    public void fastSetInternalVariable(String internedName, Object value2) {
        assert (!RubyBasicObject.isRubyVariable(internedName));
        this.variableTableFastStore(internedName, value2);
    }

    @Override
    public Object removeInternalVariable(String name2) {
        assert (!RubyBasicObject.isRubyVariable(name2));
        return this.variableTableRemove(name2);
    }

    @Override
    public void syncVariables(List<Variable<IRubyObject>> variables) {
        this.variableTableSync(variables);
    }

    @Override
    public List<Variable<Object>> getInternalVariableList() {
        final ArrayList<Variable<Object>> list2 = new ArrayList<Variable<Object>>();
        InstanceVariableTable variables = this.getVariables();
        if (variables != null) {
            variables.visit(new InstanceVariableTable.TryLockVisitor(this){

                public void visit(String name2, Object value2) {
                    if (!RubyBasicObject.isRubyVariable(name2)) {
                        list2.add(new VariableEntry<Object>(name2, value2));
                    }
                }
            });
        }
        return list2;
    }

    @Override
    public InstanceVariables getInstanceVariables() {
        return this;
    }

    @Override
    public boolean hasInstanceVariable(String name2) {
        assert (IdUtil.isInstanceVariable(name2));
        return this.variableTableContains(name2);
    }

    @Override
    public boolean fastHasInstanceVariable(String internedName) {
        assert (IdUtil.isInstanceVariable(internedName));
        return this.variableTableFastContains(internedName);
    }

    @Override
    public IRubyObject getInstanceVariable(String name2) {
        assert (IdUtil.isInstanceVariable(name2));
        return this.variableTableFetch(name2);
    }

    @Override
    public IRubyObject fastGetInstanceVariable(String internedName) {
        assert (IdUtil.isInstanceVariable(internedName));
        return (IRubyObject)this.variableTableFastFetch(internedName);
    }

    @Override
    public IRubyObject setInstanceVariable(String name2, IRubyObject value2) {
        assert (IdUtil.isInstanceVariable(name2) && value2 != null);
        this.ensureInstanceVariablesSettable();
        return (IRubyObject)this.variableTableStore(name2, value2);
    }

    @Override
    public IRubyObject fastSetInstanceVariable(String internedName, IRubyObject value2) {
        assert (IdUtil.isInstanceVariable(internedName) && value2 != null);
        this.ensureInstanceVariablesSettable();
        return (IRubyObject)this.variableTableFastStore(internedName, value2);
    }

    @Override
    public IRubyObject removeInstanceVariable(String name2) {
        assert (IdUtil.isInstanceVariable(name2));
        this.ensureInstanceVariablesSettable();
        return (IRubyObject)this.variableTableRemove(name2);
    }

    @Override
    public List<Variable<IRubyObject>> getInstanceVariableList() {
        final ArrayList<Variable<IRubyObject>> list2 = new ArrayList<Variable<IRubyObject>>();
        InstanceVariableTable variables = this.getVariables();
        if (variables != null) {
            variables.visit(new InstanceVariableTable.TryLockVisitor(this){

                public void visit(String name2, Object value2) {
                    if (IdUtil.isInstanceVariable(name2)) {
                        list2.add(new VariableEntry<IRubyObject>(name2, (IRubyObject)value2));
                    }
                }
            });
        }
        return list2;
    }

    @Override
    public List<String> getInstanceVariableNameList() {
        final ArrayList<String> list2 = new ArrayList<String>();
        InstanceVariableTable variables = this.getVariables();
        if (variables != null) {
            variables.visit(new InstanceVariableTable.Visitor(){

                public void visit(String name2, Object value2) {
                    if (IdUtil.isInstanceVariable(name2)) {
                        list2.add(name2);
                    }
                }
            });
        }
        return list2;
    }

    @Override
    public void copyInstanceVariablesInto(final InstanceVariables other) {
        InstanceVariableTable variables = this.getVariables();
        if (variables != null) {
            variables.visit(new InstanceVariableTable.Visitor(){

                public void visit(String name2, Object value2) {
                    if (IdUtil.isInstanceVariable(name2)) {
                        other.setInstanceVariable(name2, (IRubyObject)value2);
                    }
                }
            });
        }
    }

    protected final void ensureInstanceVariablesSettable() {
        if (!this.isFrozen() && (this.getRuntime().getSafeLevel() < 4 || this.isTaint())) {
            return;
        }
        if (this.getRuntime().getSafeLevel() >= 4 && !this.isTaint()) {
            throw this.getRuntime().newSecurityError(ERR_INSECURE_SET_INST_VAR);
        }
        if (this.isFrozen()) {
            if (this instanceof RubyModule) {
                throw this.getRuntime().newFrozenError("class/module ");
            }
            throw this.getRuntime().newFrozenError("");
        }
    }

    @Override
    public int getNativeTypeIndex() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public class Finalizer
    implements Finalizable {
        private long id;
        private IRubyObject firstFinalizer;
        private List<IRubyObject> finalizers;
        private AtomicBoolean finalized;

        public Finalizer(long id2) {
            this.id = id2;
            this.finalized = new AtomicBoolean(false);
        }

        public void addFinalizer(IRubyObject finalizer) {
            if (this.firstFinalizer == null) {
                this.firstFinalizer = finalizer;
            } else {
                if (this.finalizers == null) {
                    this.finalizers = new ArrayList<IRubyObject>(4);
                }
                this.finalizers.add(finalizer);
            }
        }

        public void removeFinalizers() {
            this.firstFinalizer = null;
            this.finalizers = null;
        }

        public void finalize() {
            if (this.finalized.compareAndSet(false, true)) {
                if (this.firstFinalizer != null) {
                    this.callFinalizer(this.firstFinalizer);
                }
                if (this.finalizers != null) {
                    for (int i = 0; i < this.finalizers.size(); ++i) {
                        this.callFinalizer(this.finalizers.get(i));
                    }
                }
            }
        }

        private void callFinalizer(IRubyObject finalizer) {
            RuntimeHelpers.invoke(finalizer.getRuntime().getCurrentContext(), finalizer, "call", RubyBasicObject.this.id());
        }
    }

    public static class BasicObjectMethods {
        @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
        public static IRubyObject intialize(IRubyObject self) {
            return self.getRuntime().getNil();
        }
    }
}

