/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.CallingConvention;
import com.kenai.jffi.Closure;
import com.kenai.jffi.Foreign;
import com.kenai.jffi.MemoryIO;
import com.kenai.jffi.Platform;
import com.kenai.jffi.Type;
import java.lang.reflect.Method;

public class ClosureManager {
    private static final long ADDRESS_MASK = Platform.getPlatform().addressMask();

    public static final ClosureManager getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private ClosureManager() {
    }

    public final Closure.Handle newClosure(Closure closure, Type returnType, Type[] parameterTypes, CallingConvention convention) {
        Proxy proxy2 = new Proxy(closure);
        int[] nativeParamTypes = new int[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            nativeParamTypes[i] = parameterTypes[i].value();
        }
        return new Handle(Foreign.getInstance().newClosure(proxy2, Proxy.METHOD, returnType.value(), nativeParamTypes, 0));
    }

    private static final class DirectBuffer
    implements Closure.Buffer {
        private static final MemoryIO IO = MemoryIO.getInstance();
        private static final int PARAM_SIZE = Platform.getPlatform().addressSize() / 8;
        private final long retval;
        private final long parameters;

        public DirectBuffer(long retval, long parameters) {
            this.retval = retval;
            this.parameters = parameters;
        }

        @Deprecated
        public int getInt8(int index2) {
            return this.getByte(index2);
        }

        @Deprecated
        public int getInt16(int index2) {
            return this.getShort(index2);
        }

        @Deprecated
        public int getInt32(int index2) {
            return this.getInt(index2);
        }

        @Deprecated
        public long getInt64(int index2) {
            return this.getLong(index2);
        }

        @Deprecated
        public void setInt8Return(int value2) {
            this.setByteReturn((byte)value2);
        }

        @Deprecated
        public void setInt16Return(int value2) {
            this.setShortReturn((short)value2);
        }

        @Deprecated
        public void setInt32Return(int value2) {
            this.setIntReturn(value2);
        }

        @Deprecated
        public final void setInt64Return(long value2) {
            this.setLongReturn(value2);
        }

        public final byte getByte(int index2) {
            return IO.getByte(IO.getAddress(this.parameters + (long)(index2 * PARAM_SIZE)));
        }

        public final short getShort(int index2) {
            return IO.getShort(IO.getAddress(this.parameters + (long)(index2 * PARAM_SIZE)));
        }

        public final int getInt(int index2) {
            return IO.getInt(IO.getAddress(this.parameters + (long)(index2 * PARAM_SIZE)));
        }

        public final long getLong(int index2) {
            return IO.getLong(IO.getAddress(this.parameters + (long)(index2 * PARAM_SIZE)));
        }

        public final float getFloat(int index2) {
            return IO.getFloat(IO.getAddress(this.parameters + (long)(index2 * PARAM_SIZE)));
        }

        public final double getDouble(int index2) {
            return IO.getDouble(IO.getAddress(this.parameters + (long)(index2 * PARAM_SIZE)));
        }

        public final long getAddress(int index2) {
            return IO.getAddress(IO.getAddress(this.parameters + (long)(index2 * PARAM_SIZE))) & ADDRESS_MASK;
        }

        public final void setByteReturn(byte value2) {
            IO.putByte(this.retval, value2);
        }

        public final void setShortReturn(short value2) {
            IO.putShort(this.retval, value2);
        }

        public final void setIntReturn(int value2) {
            IO.putInt(this.retval, value2);
        }

        public final void setLongReturn(long value2) {
            IO.putLong(this.retval, value2);
        }

        public final void setFloatReturn(float value2) {
            IO.putFloat(this.retval, value2);
        }

        public final void setDoubleReturn(double value2) {
            IO.putDouble(this.retval, value2);
        }

        public final void setAddressReturn(long address2) {
            IO.putAddress(this.retval, address2);
        }
    }

    private static final class Proxy {
        static final Method METHOD = Proxy.getMethod();
        final Closure closure;

        private static final Method getMethod() {
            try {
                return Proxy.class.getDeclaredMethod("invoke", Long.TYPE, Long.TYPE);
            }
            catch (Throwable ex) {
                throw new RuntimeException(ex);
            }
        }

        Proxy(Closure closure) {
            this.closure = closure;
        }

        void invoke(long retvalAddress, long paramAddress) {
            this.closure.invoke(new DirectBuffer(retvalAddress, paramAddress));
        }
    }

    private static final class Handle
    implements Closure.Handle {
        private static final MemoryIO IO = MemoryIO.getInstance();
        final long handle;
        final long cbAddress;

        Handle(long handle) {
            this.handle = handle;
            this.cbAddress = IO.getAddress(handle);
        }

        public long getAddress() {
            return this.cbAddress;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                Foreign.getInstance().freeClosure(this.handle);
            }
            finally {
                super.finalize();
            }
        }
    }

    private static final class SingletonHolder {
        static final ClosureManager INSTANCE = new ClosureManager();

        private SingletonHolder() {
        }
    }
}

