/*
 * Decompiled with CFR 0.152.
 */
package org.jvyamlb;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jruby.RubyHash;
import org.jruby.util.ByteList;
import org.jvyamlb.EmitterImpl;
import org.jvyamlb.Representer;
import org.jvyamlb.ResolverImpl;
import org.jvyamlb.Serializer;
import org.jvyamlb.SerializerImpl;
import org.jvyamlb.YAML;
import org.jvyamlb.YAMLConfig;
import org.jvyamlb.YAMLNodeCreator;
import org.jvyamlb.nodes.LinkNode;
import org.jvyamlb.nodes.MappingNode;
import org.jvyamlb.nodes.Node;
import org.jvyamlb.nodes.ScalarNode;
import org.jvyamlb.nodes.SequenceNode;

public class RepresenterImpl
implements Representer {
    private final Serializer serializer;
    private final char defaultStyle;
    private final Map representedObjects;
    private final Map links;

    public RepresenterImpl(Serializer serializer, YAMLConfig opts) {
        this.serializer = serializer;
        this.defaultStyle = (char)(opts.useDouble() ? 34 : (opts.useSingle() ? 39 : 0));
        this.representedObjects = new IdentityHashMap();
        this.links = new IdentityHashMap();
    }

    private Node representData(Object data) throws IOException {
        Node node = null;
        boolean ignoreAlias = this.ignoreAliases(data);
        if (!ignoreAlias) {
            if (this.representedObjects.containsKey(data)) {
                node = (Node)this.representedObjects.get(data);
                if (null == node) {
                    node = new LinkNode();
                    ArrayList<Node> ll = (ArrayList<Node>)this.links.get(data);
                    if (ll == null) {
                        ll = new ArrayList<Node>();
                        this.links.put(data, ll);
                    }
                    ll.add(node);
                }
                return node;
            }
            this.representedObjects.put(data, null);
        }
        node = this.getNodeCreatorFor(data).toYamlNode(this);
        if (!ignoreAlias) {
            this.representedObjects.put(data, node);
            List ll = (List)this.links.remove(data);
            if (ll != null) {
                Iterator iter = ll.iterator();
                while (iter.hasNext()) {
                    ((LinkNode)iter.next()).setAnchor(node);
                }
            }
        }
        return node;
    }

    @Override
    public Node scalar(String tag, ByteList value, char style) throws IOException {
        return this.representScalar(tag, value, style);
    }

    public Node representScalar(String tag, ByteList value, char style) throws IOException {
        char realStyle = style == '\u0000' ? this.defaultStyle : style;
        return new ScalarNode(tag, value, style);
    }

    @Override
    public Node seq(String tag, List sequence, boolean flowStyle) throws IOException {
        return this.representSequence(tag, sequence, flowStyle);
    }

    public Node representSequence(String tag, List sequence, boolean flowStyle) throws IOException {
        ArrayList<Node> value = new ArrayList<Node>(sequence.size());
        Iterator iter = sequence.iterator();
        while (iter.hasNext()) {
            value.add(this.representData(iter.next()));
        }
        return new SequenceNode(tag, value, flowStyle);
    }

    @Override
    public Node map(String tag, Map mapping, boolean flowStyle) throws IOException {
        return this.representMapping(tag, mapping, flowStyle);
    }

    public Node representMapping(String tag, Map mapping, boolean flowStyle) throws IOException {
        Iterator iter;
        HashMap<Node, Node> value = new HashMap<Node, Node>();
        Iterator iterator = iter = mapping instanceof RubyHash ? ((RubyHash)mapping).directEntrySet().iterator() : mapping.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            value.put(this.representData(entry.getKey()), this.representData(entry.getValue()));
        }
        return new MappingNode(tag, value, flowStyle);
    }

    @Override
    public void represent(Object data) throws IOException {
        Node node = this.representData(data);
        this.serializer.serialize(node);
        this.representedObjects.clear();
    }

    protected boolean ignoreAliases(Object data) {
        return false;
    }

    protected YAMLNodeCreator getNodeCreatorFor(Object data) {
        if (data instanceof YAMLNodeCreator) {
            return (YAMLNodeCreator)data;
        }
        if (data instanceof Map) {
            return new MappingYAMLNodeCreator(data);
        }
        if (data instanceof List) {
            return new SequenceYAMLNodeCreator(data);
        }
        if (data instanceof Set) {
            return new SetYAMLNodeCreator(data);
        }
        if (data instanceof Date) {
            return new DateYAMLNodeCreator(data);
        }
        if (data instanceof String) {
            return new StringYAMLNodeCreator(data);
        }
        if (data instanceof ByteList) {
            return new ByteListYAMLNodeCreator(data);
        }
        if (data instanceof Number) {
            return new NumberYAMLNodeCreator(data);
        }
        if (data instanceof Boolean) {
            return new ScalarYAMLNodeCreator("tag:yaml.org,2002:bool", data);
        }
        if (data == null) {
            return new ScalarYAMLNodeCreator("tag:yaml.org,2002:null", "");
        }
        if (data.getClass().isArray()) {
            return new ArrayYAMLNodeCreator(data);
        }
        return new JavaBeanYAMLNodeCreator(data);
    }

    public static void main(String[] args) throws IOException {
        YAMLConfig cfg = YAML.config();
        SerializerImpl s = new SerializerImpl(new EmitterImpl(System.out, cfg), new ResolverImpl(), cfg);
        s.open();
        RepresenterImpl r = new RepresenterImpl(s, cfg);
        HashMap<Object, Object> test1 = new HashMap<Object, Object>();
        LinkedList<Object> test1Val = new LinkedList<Object>();
        test1Val.add("hello");
        test1Val.add(Boolean.TRUE);
        test1Val.add(new Integer(31337));
        test1.put("val1", test1Val);
        ArrayList<Object> test2Val = new ArrayList<Object>();
        test2Val.add("hello");
        test2Val.add(Boolean.FALSE);
        test2Val.add(new Integer(31337));
        test1.put("val2", test2Val);
        test1.put("afsdf", "hmm");
        TestJavaBean bean1 = new TestJavaBean();
        bean1.setName("Ola");
        bean1.setSurName("Bini");
        bean1.setAge(24);
        test1.put(new Integer(25), bean1);
        r.represent(test1);
        s.close();
    }

    private static class TestJavaBean
    implements Serializable {
        private String val1;
        private String val2;
        private int val3;

        public void setName(String name) {
            this.val1 = name;
        }

        public String getName() {
            return this.val1;
        }

        public void setSurName(String sname) {
            this.val2 = sname;
        }

        public String getSurName() {
            return this.val2;
        }

        public void setAge(int age) {
            this.val3 = age;
        }

        public int getAge() {
            return this.val3;
        }
    }

    public static class JavaBeanYAMLNodeCreator
    implements YAMLNodeCreator {
        private final Object data;

        public JavaBeanYAMLNodeCreator(Object data) {
            this.data = data;
        }

        @Override
        public String taguri() {
            return "!java/object:" + this.data.getClass().getName();
        }

        @Override
        public Node toYamlNode(Representer representer) throws IOException {
            HashMap<String, Object> values = new HashMap<String, Object>();
            Method[] ems = this.data.getClass().getMethods();
            int j = ems.length;
            for (int i = 0; i < j; ++i) {
                String name;
                if (ems[i].getParameterTypes().length != 0 || (name = ems[i].getName()).equals("getClass")) continue;
                String pname = null;
                if (name.startsWith("get")) {
                    pname = "" + Character.toLowerCase(name.charAt(3)) + name.substring(4);
                } else if (name.startsWith("is")) {
                    pname = "" + Character.toLowerCase(name.charAt(2)) + name.substring(3);
                }
                if (null == pname) continue;
                try {
                    values.put(pname, ems[i].invoke(this.data, new Object[0]));
                    continue;
                }
                catch (Exception exe) {
                    values.put(pname, null);
                }
            }
            return representer.map(this.taguri(), values, false);
        }
    }

    public static class MappingYAMLNodeCreator
    implements YAMLNodeCreator {
        private final Map data;

        public MappingYAMLNodeCreator(Object data) {
            this.data = (Map)data;
        }

        @Override
        public String taguri() {
            if (this.data instanceof HashMap) {
                return "tag:yaml.org,2002:map";
            }
            return "tag:yaml.org,2002:map:" + this.data.getClass().getName();
        }

        @Override
        public Node toYamlNode(Representer representer) throws IOException {
            return representer.map(this.taguri(), this.data, false);
        }
    }

    public static class SequenceYAMLNodeCreator
    implements YAMLNodeCreator {
        private final List data;

        public SequenceYAMLNodeCreator(Object data) {
            this.data = (List)data;
        }

        @Override
        public String taguri() {
            if (this.data instanceof ArrayList) {
                return "tag:yaml.org,2002:seq";
            }
            return "tag:yaml.org,2002:seq:" + this.data.getClass().getName();
        }

        @Override
        public Node toYamlNode(Representer representer) throws IOException {
            return representer.seq(this.taguri(), this.data, false);
        }
    }

    public static class ByteListYAMLNodeCreator
    implements YAMLNodeCreator {
        private final Object data;

        public ByteListYAMLNodeCreator(Object data) {
            this.data = data;
        }

        @Override
        public String taguri() {
            return "tag:yaml.org,2002:str";
        }

        @Override
        public Node toYamlNode(Representer representer) throws IOException {
            return representer.scalar(this.taguri(), (ByteList)this.data, '\u0000');
        }
    }

    public static class StringYAMLNodeCreator
    implements YAMLNodeCreator {
        private final Object data;

        public StringYAMLNodeCreator(Object data) {
            this.data = data;
        }

        @Override
        public String taguri() {
            if (this.data instanceof String) {
                return "tag:yaml.org,2002:str";
            }
            return "tag:yaml.org,2002:str:" + this.data.getClass().getName();
        }

        @Override
        public Node toYamlNode(Representer representer) throws IOException {
            return representer.scalar(this.taguri(), ByteList.create(this.data.toString()), '\u0000');
        }
    }

    public static class ScalarYAMLNodeCreator
    implements YAMLNodeCreator {
        private final String tag;
        private final Object data;

        public ScalarYAMLNodeCreator(String tag, Object data) {
            this.tag = tag;
            this.data = data;
        }

        @Override
        public String taguri() {
            return this.tag;
        }

        @Override
        public Node toYamlNode(Representer representer) throws IOException {
            return representer.scalar(this.taguri(), ByteList.create(this.data.toString()), '\u0000');
        }
    }

    public static class NumberYAMLNodeCreator
    implements YAMLNodeCreator {
        private final Number data;

        public NumberYAMLNodeCreator(Object data) {
            this.data = (Number)data;
        }

        @Override
        public String taguri() {
            if (this.data instanceof Float || this.data instanceof Double || this.data instanceof BigDecimal) {
                return "tag:yaml.org,2002:float";
            }
            return "tag:yaml.org,2002:int";
        }

        @Override
        public Node toYamlNode(Representer representer) throws IOException {
            String str = this.data.toString();
            if (str.equals("Infinity")) {
                str = ".inf";
            } else if (str.equals("-Infinity")) {
                str = "-.inf";
            } else if (str.equals("NaN")) {
                str = ".nan";
            }
            return representer.scalar(this.taguri(), ByteList.create(str), '\u0000');
        }
    }

    public static class ArrayYAMLNodeCreator
    implements YAMLNodeCreator {
        private final Object data;

        public ArrayYAMLNodeCreator(Object data) {
            this.data = data;
        }

        @Override
        public String taguri() {
            return "tag:yaml.org,2002:seq";
        }

        @Override
        public Node toYamlNode(Representer representer) throws IOException {
            int l = Array.getLength(this.data);
            ArrayList<Object> lst = new ArrayList<Object>(l);
            for (int i = 0; i < l; ++i) {
                lst.add(Array.get(this.data, i));
            }
            return representer.seq(this.taguri(), lst, false);
        }
    }

    public static class SetYAMLNodeCreator
    implements YAMLNodeCreator {
        private final Set data;

        public SetYAMLNodeCreator(Object data) {
            this.data = (Set)data;
        }

        @Override
        public String taguri() {
            return "tag:yaml.org,2002:set";
        }

        @Override
        public Node toYamlNode(Representer representer) throws IOException {
            HashMap entries = new HashMap();
            Iterator iter = this.data.iterator();
            while (iter.hasNext()) {
                entries.put(iter.next(), null);
            }
            return representer.map(this.taguri(), entries, false);
        }
    }

    public static class DateYAMLNodeCreator
    implements YAMLNodeCreator {
        private final Date data;
        private static DateFormat dateOutput = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
        private static DateFormat dateOutputUsec = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS Z");

        public DateYAMLNodeCreator(Object data) {
            this.data = (Date)data;
        }

        @Override
        public String taguri() {
            return "tag:yaml.org,2002:timestamp";
        }

        @Override
        public Node toYamlNode(Representer representer) throws IOException {
            Calendar c = Calendar.getInstance();
            c.setTime(this.data);
            String out = null;
            out = c.get(14) != 0 ? dateOutputUsec.format(this.data) : dateOutput.format(this.data);
            out = out.substring(0, 23) + ":" + out.substring(23);
            return representer.scalar(this.taguri(), ByteList.create(out), '\u0000');
        }
    }
}

