/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import org.jruby.regexp.RegexpMatcher;
import org.jruby.regexp.RegexpPattern;

public class StringScanner {
    private String string;
    private RegexpMatcher matcher;
    private int pos = 0;
    private int lastPos = -1;
    private int matchStart = -1;
    private int matchEnd = -1;

    public StringScanner() {
        this("");
    }

    public StringScanner(CharSequence string) {
        this.string = string.toString();
    }

    public boolean isEndOfString() {
        return this.pos == this.string.length();
    }

    public boolean isBeginningOfLine() {
        return this.pos == 0 || this.string.charAt(this.pos - 1) == '\n';
    }

    public CharSequence getString() {
        return this.string;
    }

    private void resetMatchData() {
        this.matcher = null;
        this.matchStart = -1;
        this.matchEnd = -1;
    }

    public void terminate() {
        this.pos = this.string.length();
        this.lastPos = -1;
        this.resetMatchData();
    }

    public void reset() {
        this.pos = 0;
        this.lastPos = -1;
        this.resetMatchData();
    }

    public void setString(CharSequence string) {
        this.string = string.toString();
        this.reset();
    }

    public void append(CharSequence string) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.string);
        buf.append(string);
        this.string = buf.toString();
    }

    public CharSequence rest() {
        return this.string.subSequence(this.pos, this.string.length());
    }

    public int getPos() {
        return this.pos;
    }

    public void setPos(int pos) {
        if (pos > this.string.length()) {
            throw new IllegalArgumentException("index out of range.");
        }
        this.pos = pos;
    }

    public char getChar() {
        if (this.isEndOfString()) {
            return '\u0000';
        }
        this.matcher = null;
        this.matchStart = this.pos;
        this.matchEnd = this.pos + 1;
        this.lastPos = this.pos;
        return this.string.charAt(this.pos++);
    }

    public boolean matched() {
        return this.matchStart > -1;
    }

    public CharSequence group(int n) {
        if (!this.matched()) {
            return null;
        }
        if (this.matcher == null && this.matchEnd - this.matchStart == 1) {
            return this.string.subSequence(this.matchStart, this.matchEnd);
        }
        if (n >= this.matcher.groupCount()) {
            return null;
        }
        return this.matcher.group(n);
    }

    public CharSequence preMatch() {
        if (this.matched()) {
            return this.string.subSequence(0, this.matchStart);
        }
        return null;
    }

    public CharSequence postMatch() {
        if (this.matched()) {
            return this.string.subSequence(this.matchEnd, this.string.length());
        }
        return null;
    }

    public CharSequence matchedValue() {
        if (this.matched()) {
            return this.string.subSequence(this.matchStart, this.matchEnd);
        }
        return null;
    }

    public int matchedSize() {
        if (this.matcher == null) {
            return -1;
        }
        return this.matchEnd - this.matchStart;
    }

    public void unscan() {
        if (this.lastPos == -1) {
            throw new IllegalStateException("unscan() cannot be called after an unmached scan.");
        }
        this.pos = this.lastPos;
        this.resetMatchData();
    }

    public int matches(RegexpPattern pattern) {
        if (!this.isEndOfString()) {
            this.matcher = pattern.matcher(this.string.subSequence(this.pos, this.string.length()).toString());
            if (this.matcher.find() && this.matcher.start() == 0) {
                this.matchStart = this.pos;
                this.matchEnd = this.matcher.end();
                return this.matchEnd;
            }
            this.resetMatchData();
        }
        return -1;
    }

    public CharSequence scanUntil(RegexpPattern pattern) {
        if (!this.isEndOfString()) {
            this.matcher = pattern.matcher(this.string);
            this.matcher.setOffset(this.pos);
            if (this.matcher.find()) {
                this.lastPos = this.pos;
                this.matchStart = this.matcher.start() + this.pos;
                this.pos = this.matchEnd = this.matcher.end() + this.pos;
                return this.string.subSequence(this.lastPos, this.pos);
            }
            this.lastPos = -1;
            this.resetMatchData();
        }
        return null;
    }

    public CharSequence scan(RegexpPattern pattern) {
        if (!this.isEndOfString()) {
            this.matcher = pattern.matcher(this.string.subSequence(this.pos, this.string.length()).toString());
            if (this.matcher.find() && this.matcher.start() == 0) {
                this.lastPos = this.pos;
                this.matchStart = this.pos;
                this.pos += this.matcher.end();
                this.matchEnd = this.pos;
                return this.matcher.group(0);
            }
            this.lastPos = -1;
            this.resetMatchData();
        }
        return null;
    }

    public CharSequence check(RegexpPattern pattern) {
        if (!this.isEndOfString()) {
            this.matcher = pattern.matcher(this.string.subSequence(this.pos, this.string.length()).toString());
            if (this.matcher.find() && this.matcher.start() == 0) {
                this.matchStart = this.pos;
                this.matchEnd = this.matchStart + this.matcher.end();
                return this.matcher.group(0);
            }
            this.resetMatchData();
        }
        return null;
    }

    public CharSequence checkUntil(RegexpPattern pattern) {
        if (!this.isEndOfString()) {
            this.matcher = pattern.matcher(this.string);
            this.matcher.setOffset(this.pos);
            if (this.matcher.find()) {
                this.matchStart = this.matcher.start() + this.pos;
                this.matchEnd = this.matcher.end() + this.pos;
                return this.string.subSequence(this.pos, this.matcher.end() + this.pos);
            }
            this.resetMatchData();
        }
        return null;
    }

    public int skip(RegexpPattern pattern) {
        if (!this.isEndOfString()) {
            this.matcher = pattern.matcher(this.string.subSequence(this.pos, this.string.length()).toString());
            if (this.matcher.find() && this.matcher.start() == 0) {
                this.lastPos = this.pos;
                this.matchStart = this.pos;
                int end = this.matcher.end();
                this.pos += end;
                this.matchEnd = this.pos;
                return end;
            }
            this.resetMatchData();
        }
        return -1;
    }

    public int skipUntil(RegexpPattern pattern) {
        if (!this.isEndOfString()) {
            this.matcher = pattern.matcher(this.string);
            this.matcher.setOffset(this.pos);
            if (this.matcher.find()) {
                this.lastPos = this.pos;
                this.pos = this.matcher.end() + this.lastPos;
                this.matchStart = this.matcher.start() + this.lastPos;
                this.matchEnd = this.pos;
                return this.pos - this.lastPos;
            }
            this.resetMatchData();
        }
        return -1;
    }

    public int exists(RegexpPattern pattern) {
        if (!this.isEndOfString()) {
            this.matcher = pattern.matcher(this.string);
            this.matcher.setOffset(this.pos);
            if (this.matcher.find()) {
                this.matchStart = this.matcher.start() + this.pos;
                this.matchEnd = this.matcher.end() + this.pos;
                return this.matchEnd - this.pos;
            }
            this.resetMatchData();
        }
        return -1;
    }

    public CharSequence peek(int length) {
        int end = this.pos + length;
        if (end > this.string.length()) {
            end = this.string.length();
        }
        return this.string.subSequence(this.pos, end);
    }
}

