/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.jruby.Main;
import org.jruby.exceptions.MainExitException;
import org.jruby.util.KCode;

public class CommandlineParser {
    private final String[] arguments;
    private Main main;
    private ArrayList<String> loadPaths = new ArrayList();
    private StringBuffer inlineScript = new StringBuffer();
    private boolean hasInlineScript = false;
    private String scriptFileName = null;
    private ArrayList<String> requiredLibraries = new ArrayList();
    private boolean benchmarking = false;
    private boolean assumeLoop = false;
    private boolean assumePrinting = false;
    private boolean processLineEnds = false;
    private boolean split = false;
    private boolean verbose = false;
    private boolean debug = false;
    private boolean showVersion = false;
    private boolean endOfArguments = false;
    private String[] scriptArguments = null;
    private boolean shouldRunInterpreter = true;
    private boolean objectSpaceEnabled = false;
    private boolean compilerEnabled = false;
    private boolean yarv = false;
    private boolean rubinius = false;
    private boolean yarvCompile = false;
    private KCode kcode = KCode.NONE;
    public int argumentIndex = 0;
    public int characterIndex = 0;

    public CommandlineParser(Main main, String[] arguments) {
        this.arguments = arguments;
        this.main = main;
        this.processArguments();
    }

    private void processArguments() {
        while (this.argumentIndex < this.arguments.length && this.isInterpreterArgument(this.arguments[this.argumentIndex])) {
            this.processArgument();
            ++this.argumentIndex;
        }
        if (!this.hasInlineScript && this.argumentIndex < this.arguments.length) {
            this.setScriptFileName(this.arguments[this.argumentIndex]);
            ++this.argumentIndex;
        }
        this.scriptArguments = new String[this.arguments.length - this.argumentIndex];
        System.arraycopy(this.arguments, this.argumentIndex, this.getScriptArguments(), 0, this.getScriptArguments().length);
    }

    private boolean isInterpreterArgument(String argument) {
        return (argument.charAt(0) == '-' || argument.charAt(0) == '+') && !this.endOfArguments;
    }

    private void processArgument() {
        String argument = this.arguments[this.argumentIndex];
        this.characterIndex = 1;
        block22: while (this.characterIndex < argument.length()) {
            switch (argument.charAt(this.characterIndex)) {
                case 'h': {
                    this.main.printUsage();
                    this.shouldRunInterpreter = false;
                    break;
                }
                case 'I': {
                    String s = this.grabValue(" -I must be followed by a directory name to add to lib path");
                    String[] ls = s.split(File.pathSeparator);
                    for (int i = 0; i < ls.length; ++i) {
                        this.loadPaths.add(ls[i]);
                    }
                    break block22;
                }
                case 'r': {
                    this.requiredLibraries.add(this.grabValue("-r must be followed by a package to require"));
                    break block22;
                }
                case 'e': {
                    this.inlineScript.append(this.grabValue(" -e must be followed by an expression to evaluate"));
                    this.inlineScript.append('\n');
                    this.hasInlineScript = true;
                    break block22;
                }
                case 'b': {
                    this.benchmarking = true;
                    break;
                }
                case 'p': {
                    this.assumePrinting = true;
                    this.assumeLoop = true;
                    break;
                }
                case 'O': {
                    if (argument.charAt(0) == '-') {
                        this.objectSpaceEnabled = false;
                        break;
                    }
                    if (argument.charAt(0) != '+') break;
                    this.objectSpaceEnabled = true;
                    break;
                }
                case 'C': {
                    this.compilerEnabled = true;
                    break;
                }
                case 'y': {
                    this.yarv = true;
                    break;
                }
                case 'Y': {
                    this.yarvCompile = true;
                    break;
                }
                case 'R': {
                    this.rubinius = true;
                    break;
                }
                case 'n': {
                    this.assumeLoop = true;
                    break;
                }
                case 'a': {
                    this.split = true;
                    break;
                }
                case 'd': {
                    this.debug = true;
                    this.verbose = true;
                    break;
                }
                case 'l': {
                    this.processLineEnds = true;
                    break;
                }
                case 'v': {
                    this.verbose = true;
                    this.setShowVersion(true);
                    break;
                }
                case 'w': {
                    this.verbose = true;
                    break;
                }
                case 'K': {
                    String eArg = this.grabValue("provide a value for -K");
                    this.kcode = KCode.create(null, eArg);
                    break;
                }
                case 'S': {
                    this.runBinScript();
                    break block22;
                }
                case '-': {
                    if (argument.equals("--version")) {
                        this.setShowVersion(true);
                        break block22;
                    }
                    if (argument.equals("--debug")) {
                        this.debug = true;
                        this.verbose = true;
                        break;
                    }
                    if (argument.equals("--help")) {
                        this.main.printUsage();
                        this.shouldRunInterpreter = false;
                        break;
                    }
                    if (argument.equals("--command") || argument.equals("--bin")) {
                        this.characterIndex = argument.length();
                        this.runBinScript();
                        break;
                    }
                    if (argument.equals("--")) {
                        this.endOfArguments = true;
                        break;
                    }
                }
                default: {
                    throw new MainExitException(1, "unknown option " + argument.charAt(this.characterIndex));
                }
            }
            ++this.characterIndex;
        }
    }

    private void runBinScript() {
        this.requiredLibraries.add("jruby/commands");
        this.inlineScript.append("JRuby::Commands." + this.grabValue("provide a bin script to execute"));
        this.inlineScript.append("\n");
        this.hasInlineScript = true;
        this.endOfArguments = true;
    }

    private String grabValue(String errorMessage) {
        ++this.characterIndex;
        if (this.characterIndex < this.arguments[this.argumentIndex].length()) {
            return this.arguments[this.argumentIndex].substring(this.characterIndex);
        }
        ++this.argumentIndex;
        if (this.argumentIndex < this.arguments.length) {
            return this.arguments[this.argumentIndex];
        }
        MainExitException mee = new MainExitException(1, "invalid argument " + this.argumentIndex + "\n" + errorMessage);
        mee.setUsageError(true);
        throw mee;
    }

    public byte[] inlineScript() {
        try {
            return this.inlineScript.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return this.inlineScript.toString().getBytes();
        }
    }

    public List<String> requiredLibraries() {
        return this.requiredLibraries;
    }

    public List<String> loadPaths() {
        return this.loadPaths;
    }

    public boolean shouldRunInterpreter() {
        if (this.isShowVersion() && (this.hasInlineScript || this.scriptFileName != null)) {
            return true;
        }
        return this.isShouldRunInterpreter();
    }

    private boolean isSourceFromStdin() {
        return this.getScriptFileName() == null;
    }

    public boolean isInlineScript() {
        return this.hasInlineScript;
    }

    public InputStream getScriptSource() {
        try {
            if (this.hasInlineScript) {
                if (this.scriptFileName != null) {
                    File file = new File(this.getScriptFileName());
                    return new FileInputStream(file);
                }
                return new ByteArrayInputStream(this.inlineScript());
            }
            if (this.isSourceFromStdin()) {
                if (this.isShowVersion()) {
                    return null;
                }
                return System.in;
            }
            File file = new File(this.getScriptFileName());
            return new FileInputStream(file);
        }
        catch (IOException e) {
            throw new MainExitException(1, "Error opening script file: " + e.getMessage());
        }
    }

    public String displayedFileName() {
        if (this.hasInlineScript) {
            if (this.scriptFileName != null) {
                return this.scriptFileName;
            }
            return "-e";
        }
        if (this.isSourceFromStdin()) {
            return "-";
        }
        return this.getScriptFileName();
    }

    private void setScriptFileName(String scriptFileName) {
        this.scriptFileName = scriptFileName;
    }

    public String getScriptFileName() {
        return this.scriptFileName;
    }

    public boolean isBenchmarking() {
        return this.benchmarking;
    }

    public boolean isAssumeLoop() {
        return this.assumeLoop;
    }

    public boolean isAssumePrinting() {
        return this.assumePrinting;
    }

    public boolean isProcessLineEnds() {
        return this.processLineEnds;
    }

    public boolean isSplit() {
        return this.split;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isShowVersion() {
        return this.showVersion;
    }

    protected void setShowVersion(boolean showVersion) {
        this.showVersion = showVersion;
    }

    public String[] getScriptArguments() {
        return this.scriptArguments;
    }

    public boolean isShouldRunInterpreter() {
        return this.shouldRunInterpreter;
    }

    public boolean isObjectSpaceEnabled() {
        return this.objectSpaceEnabled;
    }

    public boolean isCompilerEnabled() {
        return this.compilerEnabled;
    }

    public boolean isYARVEnabled() {
        return this.yarv;
    }

    public boolean isRubiniusEnabled() {
        return this.rubinius;
    }

    public boolean isYARVCompileEnabled() {
        return this.yarvCompile;
    }

    public KCode getKCode() {
        return this.kcode;
    }
}

