/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.RubyMethod;
import org.jruby.RubyModule;
import org.jruby.RubyProc;
import org.jruby.exceptions.JumpException;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Frame;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callback.Callback;

public class MethodBlock
extends Block {
    private IRubyObject self;
    private RubyMethod method;
    private Callback callback;
    private final Arity arity;
    protected final Frame frame;
    private Visibility visibility;
    private final RubyModule klass;
    private final DynamicScope dynamicScope;
    private RubyProc proc = null;
    public boolean isLambda = false;

    public static MethodBlock createMethodBlock(ThreadContext context, DynamicScope dynamicScope, Callback callback, RubyMethod method, IRubyObject self) {
        return new MethodBlock(self, context.getCurrentFrame().duplicate(), context.getCurrentFrame().getVisibility(), context.getRubyClass(), dynamicScope, callback, method);
    }

    public MethodBlock(IRubyObject self, Frame frame, Visibility visibility, RubyModule klass, DynamicScope dynamicScope, Callback callback, RubyMethod method) {
        this.self = self;
        this.frame = frame;
        this.visibility = visibility;
        this.klass = klass;
        this.dynamicScope = dynamicScope;
        this.callback = callback;
        this.method = method;
        this.arity = Arity.createArity((int)method.arity().getLongValue());
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject[] args) {
        return this.yield(context, context.getRuntime().newArrayNoCopy(args), null, null, true);
    }

    @Override
    protected void pre(ThreadContext context, RubyModule klass) {
        context.preYieldSpecificBlock(this, klass);
    }

    @Override
    protected void post(ThreadContext context) {
        context.postYield(this);
    }

    @Override
    public IRubyObject yield(ThreadContext context, IRubyObject value) {
        return this.yield(context, value, null, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IRubyObject yield(ThreadContext context, IRubyObject value, IRubyObject self, RubyModule klass, boolean aValue) {
        if (klass == null) {
            self = this.self;
            this.frame.setSelf(self);
        }
        this.pre(context, klass);
        while (true) {
            try {
                IRubyObject iRubyObject = this.callback.execute(value, new IRubyObject[]{this.method, self}, NULL_BLOCK);
                return iRubyObject;
            }
            catch (JumpException.RedoJump rj) {
                try {
                    context.pollThreadEvents();
                    continue;
                    catch (JumpException.BreakJump bj) {
                        if (bj.getTarget() != null) throw bj;
                        bj.setTarget(this);
                        throw bj;
                    }
                }
                catch (JumpException.NextJump nj) {
                    IRubyObject iRubyObject = (IRubyObject)nj.getValue();
                    return iRubyObject;
                }
            }
            break;
        }
        finally {
            this.post(context);
        }
    }

    @Override
    public Block cloneBlock() {
        MethodBlock newBlock = new MethodBlock(this.self, this.frame.duplicate(), this.visibility, this.klass, this.dynamicScope.cloneScope(), this.callback, this.method);
        newBlock.type = this.type;
        return newBlock;
    }

    @Override
    public Arity arity() {
        return this.arity;
    }

    @Override
    public Visibility getVisibility() {
        return this.visibility;
    }

    @Override
    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    @Override
    public void setSelf(IRubyObject self) {
        this.self = self;
    }

    @Override
    public RubyProc getProcObject() {
        return this.proc;
    }

    @Override
    public void setProcObject(RubyProc procObject) {
        this.proc = procObject;
    }

    @Override
    public DynamicScope getDynamicScope() {
        return this.dynamicScope;
    }

    @Override
    public Frame getFrame() {
        return this.frame;
    }

    @Override
    public RubyModule getKlass() {
        return this.klass;
    }

    @Override
    public boolean isGiven() {
        return true;
    }
}

