/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.RubyClass;
import org.jruby.exceptions.JumpException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class CallAdapter {
    public final int methodID;
    public final String methodName;
    protected final CallType callType;

    public CallAdapter(int methodID, String methodName, CallType callType) {
        this.methodID = methodID;
        this.methodName = methodName;
        this.callType = callType;
    }

    public abstract IRubyObject call(ThreadContext var1, IRubyObject var2);

    public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, IRubyObject var3);

    public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, IRubyObject var3, IRubyObject var4);

    public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, IRubyObject var3, IRubyObject var4, IRubyObject var5);

    public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, IRubyObject[] var3);

    public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, Block var3);

    public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, IRubyObject var3, Block var4);

    public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, IRubyObject var3, IRubyObject var4, Block var5);

    public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, IRubyObject var3, IRubyObject var4, IRubyObject var5, Block var6);

    public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, IRubyObject[] var3, Block var4);

    public abstract void removeCachedMethod();

    public static class DefaultCallAdapter
    extends CallAdapter {
        DynamicMethod cachedMethod;
        RubyClass cachedType;

        public DefaultCallAdapter(String methodName, CallType callType) {
            super(MethodIndex.getIndex(methodName), methodName, callType);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self) {
            IRubyObject[] args = IRubyObject.NULL_ARRAY;
            Block block = Block.NULL_BLOCK;
            return this.call(context, self, args, block);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, IRubyObject arg1) {
            IRubyObject[] args = new IRubyObject[]{arg1};
            Block block = Block.NULL_BLOCK;
            return this.call(context, self, args, block);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, IRubyObject arg1, IRubyObject arg2) {
            IRubyObject[] args = new IRubyObject[]{arg1, arg2};
            Block block = Block.NULL_BLOCK;
            return this.call(context, self, args, block);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
            IRubyObject[] args = new IRubyObject[]{arg1, arg2, arg3};
            Block block = Block.NULL_BLOCK;
            return this.call(context, self, args, block);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, IRubyObject[] args) {
            Block block = Block.NULL_BLOCK;
            return this.call(context, self, args, block);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, Block block) {
            IRubyObject[] args = IRubyObject.NULL_ARRAY;
            return this.call(context, self, args, block);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, IRubyObject arg1, Block block) {
            IRubyObject[] args = new IRubyObject[]{arg1};
            return this.call(context, self, args, block);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, IRubyObject arg1, IRubyObject arg2, Block block) {
            IRubyObject[] args = new IRubyObject[]{arg1, arg2};
            return this.call(context, self, args, block);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, Block block) {
            IRubyObject[] args = new IRubyObject[]{arg1, arg2, arg3};
            return this.call(context, self, args, block);
        }

        /*
         * Loose catch block
         */
        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, IRubyObject[] args, Block block) {
            while (true) {
                try {
                    RubyClass selfType = self.getMetaClass();
                    if (this.cachedType == selfType && this.cachedMethod != null) {
                        return this.cachedMethod.call(context, self, selfType, this.methodName, args, block);
                    }
                    DynamicMethod method = selfType.searchMethod(this.methodName);
                    if (method.isUndefined() || !this.methodName.equals("method_missing") && !method.isCallableFrom(context.getFrameSelf(), this.callType)) {
                        return RuntimeHelpers.callMethodMissing(context, self, method, this.methodName, args, context.getFrameSelf(), this.callType, block);
                    }
                    this.cachedMethod = method;
                    this.cachedType = selfType;
                    selfType.getRuntime().getCacheMap().add(method, this);
                    return method.call(context, self, selfType, this.methodName, args, block);
                }
                catch (JumpException.BreakJump bj) {
                    if (bj.isBreakInKernelLoop()) {
                        if (block == bj.getTarget()) {
                            bj.setBreakInKernelLoop(false);
                        }
                        throw bj;
                    }
                    return (IRubyObject)bj.getValue();
                }
                catch (JumpException.RetryJump bj) {
                    continue;
                }
                break;
            }
            catch (StackOverflowError soe) {
                throw context.getRuntime().newSystemStackError("stack level too deep");
            }
        }

        @Override
        public void removeCachedMethod() {
            this.cachedType = null;
            this.cachedMethod = null;
        }
    }
}

