/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.regexp;

import java.util.regex.Matcher;
import org.jruby.regexp.RegexpMatcher;

public class JavaRegexpMatcher
extends RegexpMatcher {
    private Matcher matcher;
    private String target;
    private int position = -1;

    JavaRegexpMatcher(Matcher matcher, String target) {
        this.matcher = matcher;
        this.target = target;
    }

    @Override
    public void setPosition(int pos) {
        this.position = pos;
    }

    @Override
    public void setOffset(int pos) {
        this.position = pos;
    }

    @Override
    public boolean find() {
        if (this.position != -1) {
            return this.matcher.find(this.position);
        }
        return this.matcher.find();
    }

    @Override
    public int start() {
        return this.matcher.start();
    }

    @Override
    public int start(int pos) {
        return this.matcher.start(pos);
    }

    @Override
    public int end() {
        return this.matcher.end();
    }

    @Override
    public int end(int pos) {
        return this.matcher.end(pos);
    }

    @Override
    public int length(int pos) {
        return this.matcher.end(pos) - this.matcher.start(pos);
    }

    @Override
    public int groupCount() {
        return this.matcher.groupCount() + 1;
    }

    @Override
    public boolean isCaptured(int pos) {
        return this.matcher.start(pos) != -1;
    }

    @Override
    public boolean proceed() {
        return this.find();
    }

    @Override
    public String group(int pos) {
        return this.matcher.group(pos);
    }

    @Override
    public String prefix() {
        return this.target.substring(0, this.matcher.start());
    }

    @Override
    public String suffix() {
        return this.target.substring(this.matcher.end());
    }
}

