/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.libraries;

import java.io.IOException;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;

public class FiberLibrary
implements Library {
    @Override
    public void load(Ruby runtime) throws IOException {
        Fiber.setup(runtime);
    }

    public static class Fiber
    extends RubyObject {
        private Block block;
        private Object yieldLock = new Object();
        private IRubyObject result;
        private Thread thread;
        private boolean alive = false;

        public static Fiber newInstance(IRubyObject recv, IRubyObject[] args, Block block) {
            Fiber result = new Fiber(recv.getRuntime(), (RubyClass)recv);
            result.initialize(args, block);
            return result;
        }

        public IRubyObject initialize(IRubyObject[] args, Block block) {
            this.block = block;
            final Ruby runtime = this.getRuntime();
            this.result = runtime.getNil();
            this.thread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = yieldLock;
                    synchronized (object) {
                        alive = true;
                        ThreadContext context = runtime.getCurrentContext();
                        context.setFiber(this);
                        try {
                            result = block.yield(runtime.getCurrentContext(), result, null, null, true);
                        }
                        finally {
                            yieldLock.notify();
                        }
                    }
                }
            };
            this.thread.setDaemon(true);
            return this;
        }

        public Fiber(Ruby runtime, RubyClass type) {
            super(runtime, type);
        }

        public static void setup(Ruby runtime) {
            RubyClass cFiber = runtime.defineClass("Fiber", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
            CallbackFactory cb = runtime.callbackFactory(Fiber.class);
            cFiber.getMetaClass().defineMethod("new", cb.getOptSingletonMethod("newInstance"));
            cFiber.defineFastMethod("resume", cb.getFastOptMethod("resume"));
            cFiber.defineFastMethod("alive?", cb.getFastMethod("alive_p"));
            cFiber.getMetaClass().defineFastMethod("yield", cb.getFastSingletonMethod("yield", IRubyObject.class));
            cFiber.getMetaClass().defineFastMethod("current", cb.getFastSingletonMethod("current"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IRubyObject resume(IRubyObject[] args) throws InterruptedException {
            Object object = this.yieldLock;
            synchronized (object) {
                this.result = this.getRuntime().newArrayNoCopyLight(args);
                if (!this.alive) {
                    this.thread.start();
                    this.yieldLock.wait();
                } else {
                    this.yieldLock.notify();
                    this.yieldLock.wait();
                }
            }
            return this.result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IRubyObject transfer(IRubyObject[] args) throws InterruptedException {
            Object object = this.yieldLock;
            synchronized (object) {
                this.yieldLock.notify();
                this.yieldLock.wait();
            }
            return this.result;
        }

        public IRubyObject alive_p() {
            return this.getRuntime().newBoolean(this.alive);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static IRubyObject yield(IRubyObject recv, IRubyObject value) throws InterruptedException {
            Fiber fiber = recv.getRuntime().getCurrentContext().getFiber();
            fiber.result = value;
            Object object = fiber.yieldLock;
            synchronized (object) {
                fiber.yieldLock.notify();
                fiber.yieldLock.wait();
            }
            return recv.getRuntime().getNil();
        }

        public static IRubyObject current(IRubyObject recv) {
            return recv.getRuntime().getCurrentContext().getFiber();
        }
    }
}

