/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.lexer.yacc;

import java.io.IOException;
import org.jruby.ast.RegexpNode;
import org.jruby.ast.StrNode;
import org.jruby.lexer.yacc.LexerSource;
import org.jruby.lexer.yacc.RubyYaccLexer;
import org.jruby.lexer.yacc.StrTerm;
import org.jruby.lexer.yacc.SyntaxException;
import org.jruby.lexer.yacc.Token;
import org.jruby.util.ByteList;

public class StringTerm
extends StrTerm {
    private int flags;
    private final char begin;
    private final char end;
    private int nest;

    public StringTerm(int flags, char begin, char end) {
        this.flags = flags;
        this.end = end;
        this.begin = begin;
        this.nest = 0;
    }

    @Override
    public int parseString(RubyYaccLexer lexer, LexerSource src) throws IOException {
        boolean spaceSeen = false;
        if (this.flags == -1) {
            lexer.setValue(new Token("\"", lexer.getPosition()));
            return 374;
        }
        char c = src.read();
        if ((this.flags & 8) != 0 && Character.isWhitespace(c)) {
            while (Character.isWhitespace(c = src.read())) {
            }
            spaceSeen = true;
        }
        if (c == this.end && this.nest == 0) {
            if ((this.flags & 8) != 0) {
                this.flags = -1;
                lexer.getPosition();
                return 32;
            }
            if ((this.flags & 4) != 0) {
                lexer.setValue(new RegexpNode(src.getPosition(), ByteList.create(""), this.parseRegexpFlags(src)));
                return 315;
            }
            lexer.setValue(new Token("\"", lexer.getPosition()));
            return 374;
        }
        if (spaceSeen) {
            src.unread(c);
            lexer.getPosition();
            return 32;
        }
        if (this.begin == '\u0000' && this.flags == 0) {
            ByteList buffer = new ByteList();
            src.unread(c);
            if (this.parseSimpleStringIntoBuffer(lexer, src, buffer) == '\u0000') {
                throw new SyntaxException(src.getPosition(), "unterminated string meets end of file");
            }
            lexer.setValue(new StrNode(lexer.getPosition(), buffer));
            return 312;
        }
        ByteList buffer = new ByteList();
        if ((this.flags & 2) != 0 && c == '#') {
            c = src.read();
            switch (c) {
                case '$': 
                case '@': {
                    src.unread(c);
                    lexer.setValue(new Token("#" + c, lexer.getPosition()));
                    return 373;
                }
                case '{': {
                    lexer.setValue(new Token("#" + c, lexer.getPosition()));
                    return 372;
                }
            }
            buffer.append((byte)35);
        }
        src.unread(c);
        if (this.parseStringIntoBuffer(lexer, src, buffer) == '\u0000') {
            throw new SyntaxException(src.getPosition(), "unterminated string meets end of file");
        }
        lexer.setValue(new StrNode(lexer.getPosition(), buffer));
        return 312;
    }

    private int parseRegexpFlags(LexerSource src) throws IOException {
        int kcode = 0;
        int options = 0;
        StringBuilder unknownFlags = new StringBuilder(10);
        char c = src.read();
        while (c != '\u0000' && Character.isLetter(c)) {
            switch (c) {
                case 'i': {
                    options |= 1;
                    break;
                }
                case 'x': {
                    options |= 2;
                    break;
                }
                case 'm': {
                    options |= 4;
                    break;
                }
                case 'o': {
                    options |= 0x80;
                    break;
                }
                case 'n': {
                    kcode = 16;
                    break;
                }
                case 'e': {
                    kcode = 32;
                    break;
                }
                case 's': {
                    kcode = 48;
                    break;
                }
                case 'u': {
                    kcode = 64;
                    break;
                }
                case 'j': {
                    options |= 0x100;
                    break;
                }
                default: {
                    unknownFlags.append(c);
                }
            }
            c = src.read();
        }
        src.unread(c);
        if (unknownFlags.length() != 0) {
            throw new SyntaxException(src.getPosition(), "unknown regexp option" + (unknownFlags.length() > 1 ? "s" : "") + " - " + unknownFlags.toString());
        }
        return options | kcode;
    }

    public char parseSimpleStringIntoBuffer(RubyYaccLexer lexer, LexerSource src, ByteList buffer) throws IOException {
        char c;
        while ((c = src.read()) != '\u0000') {
            if (c == this.end) {
                src.unread(c);
                break;
            }
            if (c == '\\' && ((c = src.read()) == '\n' || c != this.end) && c != '\\') {
                buffer.append(92);
            }
            buffer.append(c);
        }
        return c;
    }

    public char parseStringIntoBuffer(RubyYaccLexer lexer, LexerSource src, ByteList buffer) throws IOException {
        char c;
        boolean regexp;
        boolean qwords = (this.flags & 8) != 0;
        boolean expand = (this.flags & 2) != 0;
        boolean escape = (this.flags & 1) != 0;
        boolean bl = regexp = (this.flags & 4) != 0;
        block4: while ((c = src.read()) != '\u0000') {
            block14: {
                block17: {
                    block16: {
                        block15: {
                            block13: {
                                if (this.begin == '\u0000' || c != this.begin) break block13;
                                ++this.nest;
                                break block14;
                            }
                            if (c != this.end) break block15;
                            if (this.nest == 0) {
                                src.unread(c);
                                break;
                            }
                            --this.nest;
                            break block14;
                        }
                        if (c != '#' || !expand || src.peek('\n')) break block16;
                        char c2 = src.read();
                        if (c2 == '$' || c2 == '@' || c2 == '{') {
                            src.unread(c2);
                            src.unread(c);
                            break;
                        }
                        src.unread(c2);
                        break block14;
                    }
                    if (c != '\\') break block17;
                    c = src.read();
                    switch (c) {
                        case '\n': {
                            if (qwords) break;
                            if (expand) continue block4;
                            buffer.append(92);
                            break;
                        }
                        case '\\': {
                            if (escape) {
                                buffer.append(c);
                                break;
                            }
                            break block14;
                        }
                        default: {
                            if (regexp) {
                                src.unread(c);
                                this.parseEscapeIntoBuffer(src, buffer);
                                continue block4;
                            }
                            if (expand) {
                                src.unread(c);
                                if (escape) {
                                    buffer.append(92);
                                }
                                c = lexer.readEscape();
                                break;
                            }
                            if (qwords && Character.isWhitespace(c)) break;
                            if (c != this.end && (this.begin == '\u0000' || c != this.begin)) {
                                buffer.append(92);
                                break;
                            }
                            break block14;
                        }
                    }
                    break block14;
                }
                if (qwords && Character.isWhitespace(c)) {
                    src.unread(c);
                    break;
                }
            }
            buffer.append(c);
        }
        return c;
    }

    private void escaped(LexerSource src, ByteList buffer) throws IOException {
        char c = src.read();
        switch (c) {
            case '\\': {
                this.parseEscapeIntoBuffer(src, buffer);
                break;
            }
            case '\u0000': {
                throw new SyntaxException(src.getPosition(), "Invalid escape character syntax");
            }
            default: {
                buffer.append(c);
            }
        }
    }

    private void parseEscapeIntoBuffer(LexerSource src, ByteList buffer) throws IOException {
        char c = src.read();
        block0 : switch (c) {
            case '\n': {
                break;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': {
                buffer.append(92);
                buffer.append(c);
                for (int i = 0; i < 2; ++i) {
                    c = src.read();
                    if (c == '\u0000') {
                        throw new SyntaxException(src.getPosition(), "Invalid escape character syntax");
                    }
                    if (!RubyYaccLexer.isOctChar(c)) {
                        src.unread(c);
                        break block0;
                    }
                    buffer.append(c);
                }
                break;
            }
            case 'x': {
                buffer.append(92);
                buffer.append(c);
                c = src.read();
                if (!RubyYaccLexer.isHexChar(c)) {
                    throw new SyntaxException(src.getPosition(), "Invalid escape character syntax");
                }
                buffer.append(c);
                c = src.read();
                if (RubyYaccLexer.isHexChar(c)) {
                    buffer.append(c);
                    break;
                }
                src.unread(c);
                break;
            }
            case 'M': {
                c = src.read();
                if (c != '-') {
                    throw new SyntaxException(src.getPosition(), "Invalid escape character syntax");
                }
                buffer.append(new byte[]{92, 77, 45});
                this.escaped(src, buffer);
                break;
            }
            case 'C': {
                c = src.read();
                if (c != '-') {
                    throw new SyntaxException(src.getPosition(), "Invalid escape character syntax");
                }
                buffer.append(new byte[]{92, 67, 45});
                this.escaped(src, buffer);
                break;
            }
            case 'c': {
                buffer.append(new byte[]{92, 99});
                this.escaped(src, buffer);
                break;
            }
            case '\u0000': {
                throw new SyntaxException(src.getPosition(), "Invalid escape character syntax");
            }
            default: {
                if (c != '\\' || c != this.end) {
                    buffer.append(92);
                }
                buffer.append(c);
            }
        }
    }
}

