/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.lexer.yacc;

import java.io.IOException;
import java.math.BigInteger;
import java.util.HashMap;
import org.jruby.ast.BackRefNode;
import org.jruby.ast.BignumNode;
import org.jruby.ast.CommentNode;
import org.jruby.ast.FixnumNode;
import org.jruby.ast.FloatNode;
import org.jruby.ast.NthRefNode;
import org.jruby.common.IRubyWarnings;
import org.jruby.lexer.yacc.HeredocTerm;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.lexer.yacc.ISourcePositionFactory;
import org.jruby.lexer.yacc.LexerSource;
import org.jruby.lexer.yacc.StackState;
import org.jruby.lexer.yacc.StrTerm;
import org.jruby.lexer.yacc.StringTerm;
import org.jruby.lexer.yacc.SyntaxException;
import org.jruby.lexer.yacc.Token;
import org.jruby.parser.ParserSupport;
import org.jruby.util.ByteList;

public class RubyYaccLexer {
    private static ByteList END_MARKER = new ByteList(new byte[]{95, 69, 78, 68, 95, 95});
    private static ByteList BEGIN_DOC_MARKER = new ByteList(new byte[]{98, 101, 103, 105, 110});
    private static ByteList END_DOC_MARKER = new ByteList(new byte[]{101, 110, 100});
    private static HashMap<String, Keyword> map = new HashMap();
    private int token;
    Object yaccValue;
    private LexerSource src;
    private ParserSupport parserSupport = null;
    private IRubyWarnings warnings;
    private LexState lex_state;
    private StringBuilder tokenBuffer = new StringBuilder(60);
    private StackState conditionState = new StackState();
    private StackState cmdArgumentState = new StackState();
    private StrTerm lex_strterm;
    private boolean commandStart;
    static final int EOF = 0;
    static final int STR_FUNC_ESCAPE = 1;
    static final int STR_FUNC_EXPAND = 2;
    static final int STR_FUNC_REGEXP = 4;
    static final int STR_FUNC_QWORDS = 8;
    static final int STR_FUNC_SYMBOL = 16;
    static final int STR_FUNC_INDENT = 32;
    private final int str_squote = 0;
    private final int str_dquote = 2;
    private final int str_xquote = 2;
    private final int str_regexp = 7;
    private final int str_ssym = 16;
    private final int str_dsym = 18;
    static int acount;
    static int aCount;

    public static Keyword getKeyword(String str) {
        return map.get(str);
    }

    public RubyYaccLexer() {
        this.reset();
    }

    public void reset() {
        this.token = 0;
        this.yaccValue = null;
        this.src = null;
        this.lex_state = null;
        this.resetStacks();
        this.lex_strterm = null;
        this.commandStart = true;
    }

    public boolean advance() throws IOException {
        this.token = this.yylex();
        return this.token != 0;
    }

    public int token() {
        return this.token;
    }

    public StringBuilder getTokenBuffer() {
        return this.tokenBuffer;
    }

    public Object value() {
        return this.yaccValue;
    }

    public ISourcePositionFactory getPositionFactory() {
        return this.src.getPositionFactory();
    }

    public ISourcePosition getPosition(ISourcePosition startPosition, boolean inclusive) {
        return this.src.getPosition(startPosition, inclusive);
    }

    public ISourcePosition getPosition() {
        return this.src.getPosition(null, false);
    }

    public void setParserSupport(ParserSupport parserSupport) {
        this.parserSupport = parserSupport;
    }

    public void setSource(LexerSource source) {
        this.src = source;
    }

    public StrTerm getStrTerm() {
        return this.lex_strterm;
    }

    public void setStrTerm(StrTerm strterm) {
        this.lex_strterm = strterm;
    }

    public void resetStacks() {
        this.conditionState.reset();
        this.cmdArgumentState.reset();
    }

    public void setWarnings(IRubyWarnings warnings) {
        this.warnings = warnings;
    }

    public void setState(LexState state) {
        this.lex_state = state;
    }

    public StackState getCmdArgumentState() {
        return this.cmdArgumentState;
    }

    public StackState getConditionState() {
        return this.conditionState;
    }

    public void setValue(Object yaccValue) {
        this.yaccValue = yaccValue;
    }

    private boolean isNext_identchar() throws IOException {
        char c = this.src.read();
        this.src.unread(c);
        return c != '\u0000' && (Character.isLetterOrDigit(c) || c == '_');
    }

    private void determineExpressionState() {
        switch (this.lex_state) {
            case EXPR_FNAME: 
            case EXPR_DOT: {
                this.lex_state = LexState.EXPR_ARG;
                break;
            }
            default: {
                this.lex_state = LexState.EXPR_BEG;
            }
        }
    }

    private Object getInteger(String value, int radix) {
        try {
            return new FixnumNode(this.getPosition(), Long.parseLong(value, radix));
        }
        catch (NumberFormatException e) {
            return new BignumNode(this.getPosition(), new BigInteger(value, radix));
        }
    }

    static final boolean isHexChar(char c) {
        return Character.isDigit(c) || 'a' <= c && c <= 'f' || 'A' <= c && c <= 'F';
    }

    static final boolean isOctChar(char c) {
        return '0' <= c && c <= '7';
    }

    public static final boolean isIdentifierChar(int c) {
        return Character.isLetterOrDigit(c) || c == 95;
    }

    private int parseQuote(char c) throws IOException {
        char end;
        boolean shortHand;
        char begin;
        if (!Character.isLetterOrDigit(c)) {
            begin = c;
            c = (char)81;
            shortHand = true;
        } else {
            shortHand = false;
            begin = this.src.read();
            if (Character.isLetterOrDigit(begin)) {
                throw new SyntaxException(this.getPosition(), "unknown type of %string");
            }
        }
        if (c == '\u0000' || begin == '\u0000') {
            throw new SyntaxException(this.getPosition(), "unterminated quoted string meets end of file");
        }
        switch (begin) {
            case '(': {
                end = ')';
                break;
            }
            case '[': {
                end = ']';
                break;
            }
            case '{': {
                end = '}';
                break;
            }
            case '<': {
                end = '>';
                break;
            }
            default: {
                end = begin;
                begin = '\u0000';
            }
        }
        switch (c) {
            case 'Q': {
                this.lex_strterm = new StringTerm(2, begin, end);
                this.yaccValue = new Token("%" + (shortHand ? "" + end : "" + c + begin), this.getPosition());
                return 367;
            }
            case 'q': {
                this.lex_strterm = new StringTerm(0, begin, end);
                this.yaccValue = new Token("%" + c + begin, this.getPosition());
                return 367;
            }
            case 'W': {
                this.lex_strterm = new StringTerm(10, begin, end);
                while (Character.isWhitespace(c = this.src.read())) {
                }
                this.src.unread(c);
                this.yaccValue = new Token("%" + c + begin, this.getPosition());
                return 370;
            }
            case 'w': {
                this.lex_strterm = new StringTerm(8, begin, end);
                while (Character.isWhitespace(c = this.src.read())) {
                }
                this.src.unread(c);
                this.yaccValue = new Token("%" + c + begin, this.getPosition());
                return 371;
            }
            case 'x': {
                this.lex_strterm = new StringTerm(2, begin, end);
                this.yaccValue = new Token("%" + c + begin, this.getPosition());
                return 368;
            }
            case 'r': {
                this.lex_strterm = new StringTerm(7, begin, end);
                this.yaccValue = new Token("%" + c + begin, this.getPosition());
                return 369;
            }
            case 's': {
                this.lex_strterm = new StringTerm(16, begin, end);
                this.lex_state = LexState.EXPR_FNAME;
                this.yaccValue = new Token("%" + c + begin, this.getPosition());
                return 366;
            }
        }
        throw new SyntaxException(this.getPosition(), "Unknown type of %string. Expected 'Q', 'q', 'w', 'x', 'r' or any non letter character, but found '" + c + "'.");
    }

    private int hereDocumentIdentifier() throws IOException {
        char term;
        ByteList markerValue;
        char c;
        char c2 = this.src.read();
        int func = 0;
        if (c2 == '-') {
            c = this.src.read();
            func = 32;
        }
        if (c == '\'' || c == '\"' || c == '`') {
            char c3;
            func = c == '\'' ? (func |= 0) : (c == '\"' ? (func |= 2) : (func |= 2));
            markerValue = new ByteList();
            term = c;
            while ((c3 = this.src.read()) != '\u0000' && c3 != term) {
                markerValue.append(c3);
            }
            if (c3 == '\u0000') {
                throw new SyntaxException(this.getPosition(), "unterminated here document identifier");
            }
        } else {
            char c4;
            if (!RubyYaccLexer.isIdentifierChar(c)) {
                this.src.unread(c);
                if ((func & 0x20) != 0) {
                    this.src.unread('-');
                }
                return 0;
            }
            markerValue = new ByteList();
            term = '\"';
            func |= 2;
            do {
                markerValue.append(c4);
            } while ((c4 = this.src.read()) != '\u0000' && RubyYaccLexer.isIdentifierChar(c4));
            this.src.unread(c4);
        }
        ByteList lastLine = this.src.readLineBytes();
        lastLine.append(10);
        this.lex_strterm = new HeredocTerm(markerValue, func, lastLine);
        if (term == '`') {
            this.yaccValue = new Token("`", this.getPosition());
            return 368;
        }
        this.yaccValue = new Token("\"", this.getPosition());
        this.getPosition();
        return 367;
    }

    private void arg_ambiguous() {
        this.warnings.warning(this.getPosition(), "Ambiguous first argument; make sure.");
    }

    protected int readComment(char c) throws IOException {
        if (!this.parserSupport.getConfiguration().hasExtraPositionInformation()) {
            return this.src.skipUntil('\n');
        }
        ISourcePosition startPosition = this.src.getPosition();
        this.tokenBuffer.setLength(0);
        this.tokenBuffer.append(c);
        while ((c = this.src.read()) != '\n' && c != '\u0000') {
            this.tokenBuffer.append(c);
        }
        this.src.unread(c);
        ISourcePosition position = startPosition.union(this.getPosition());
        this.parserSupport.getResult().addComment(new CommentNode(position, this.tokenBuffer.toString()));
        return c;
    }

    private int yylex() throws IOException {
        char c;
        boolean spaceSeen = false;
        if (this.lex_strterm != null) {
            int tok = this.lex_strterm.parseString(this, this.src);
            if (tok == 374 || tok == 315) {
                this.lex_strterm = null;
                this.lex_state = LexState.EXPR_END;
            }
            return tok;
        }
        boolean commandState = this.commandStart;
        this.commandStart = false;
        block41: while (true) {
            c = this.src.read();
            switch (c) {
                case '\u0000': 
                case '\u0004': 
                case '\u001a': {
                    return 0;
                }
                case '\t': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case ' ': {
                    this.getPosition();
                    spaceSeen = true;
                    continue block41;
                }
                case '#': {
                    if (this.readComment(c) == 0) {
                        return 0;
                    }
                }
                case '\n': {
                    while ((c = this.src.read()) == '\n') {
                    }
                    this.src.unread(c);
                    this.getPosition();
                    switch (this.lex_state) {
                        case EXPR_FNAME: 
                        case EXPR_DOT: 
                        case EXPR_BEG: 
                        case EXPR_CLASS: {
                            continue block41;
                        }
                    }
                    this.commandStart = true;
                    this.lex_state = LexState.EXPR_BEG;
                    return 10;
                }
                case '*': {
                    return this.star(spaceSeen);
                }
                case '!': {
                    return this.bang();
                }
                case '=': {
                    if (this.src.wasBeginOfLine()) {
                        boolean doComments = this.parserSupport.getConfiguration().hasExtraPositionInformation();
                        String equalLabel = this.src.matchMarkerNoCase(BEGIN_DOC_MARKER);
                        if (equalLabel != null) {
                            if (doComments) {
                                this.tokenBuffer.setLength(0);
                                this.tokenBuffer.append(equalLabel);
                            }
                            if (Character.isWhitespace(c = this.src.read())) {
                                this.src.unread(c);
                                do {
                                    c = this.src.read();
                                    if (doComments) {
                                        this.tokenBuffer.append(c);
                                    }
                                    while (c == '\n') {
                                        c = this.src.read();
                                        if (!doComments) continue;
                                        this.tokenBuffer.append(c);
                                    }
                                    if (c != '\u0000') continue;
                                    throw new SyntaxException(this.getPosition(), "embedded document meets end of file");
                                } while (c != '=' || !this.src.wasBeginOfLine() || (equalLabel = this.src.matchMarkerNoCase(END_DOC_MARKER)) == null);
                                if (doComments) {
                                    this.tokenBuffer.append(equalLabel);
                                }
                                ByteList list = this.src.readLineBytes();
                                if (doComments) {
                                    this.tokenBuffer.append(list);
                                }
                                this.src.unread('\n');
                                if (!doComments) continue block41;
                                this.parserSupport.getResult().addComment(new CommentNode(this.getPosition(), this.tokenBuffer.toString()));
                                continue block41;
                            }
                            this.src.unread(c);
                        }
                    }
                    this.determineExpressionState();
                    c = this.src.read();
                    if (c == '=') {
                        c = this.src.read();
                        if (c == '=') {
                            this.yaccValue = new Token("===", this.getPosition());
                            return 322;
                        }
                        this.src.unread(c);
                        this.yaccValue = new Token("==", this.getPosition());
                        return 321;
                    }
                    if (c == '~') {
                        this.yaccValue = new Token("=~", this.getPosition());
                        return 328;
                    }
                    if (c == '>') {
                        this.yaccValue = new Token("=>", this.getPosition());
                        return 340;
                    }
                    this.src.unread(c);
                    this.yaccValue = new Token("=", this.getPosition());
                    return 61;
                }
                case '<': {
                    return this.lessThan(spaceSeen);
                }
                case '>': {
                    return this.greaterThan();
                }
                case '\"': {
                    return this.doubleQuote();
                }
                case '`': {
                    return this.backtick(commandState);
                }
                case '\'': {
                    return this.singleQuote();
                }
                case '?': {
                    return this.questionMark();
                }
                case '&': {
                    return this.ampersand(spaceSeen);
                }
                case '|': {
                    return this.pipe();
                }
                case '+': {
                    return this.plus(spaceSeen);
                }
                case '-': {
                    return this.minus(spaceSeen);
                }
                case '.': {
                    return this.dot();
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    return this.parseNumber(c);
                }
                case ')': {
                    return this.rightParen();
                }
                case ']': {
                    return this.rightBracket();
                }
                case '}': {
                    return this.rightCurly();
                }
                case ':': {
                    return this.colon(spaceSeen);
                }
                case '/': {
                    return this.slash(spaceSeen);
                }
                case '^': {
                    return this.caret();
                }
                case ';': {
                    this.commandStart = true;
                }
                case ',': {
                    return this.comma(c);
                }
                case '~': {
                    return this.tilde();
                }
                case '(': {
                    return this.leftParen(spaceSeen);
                }
                case '[': {
                    return this.leftBracket(spaceSeen);
                }
                case '{': {
                    return this.leftCurly();
                }
                case '\\': {
                    c = this.src.read();
                    if (c == '\n') {
                        spaceSeen = true;
                        continue block41;
                    }
                    this.src.unread(c);
                    this.yaccValue = new Token("\\", this.getPosition());
                    return 92;
                }
                case '%': {
                    return this.percent(spaceSeen);
                }
                case '$': {
                    return this.dollar();
                }
                case '@': {
                    return this.at();
                }
                case '_': {
                    if (this.src.wasBeginOfLine() && this.src.matchMarker(END_MARKER, false)) {
                        this.parserSupport.getResult().setEndOffset(this.src.getOffset());
                        return 0;
                    }
                    return this.identifier(c, commandState);
                }
            }
            break;
        }
        return this.identifier(c, commandState);
    }

    private int identifierToken(LexState last_state, int result, String value) {
        if (result == 304 && last_state != LexState.EXPR_DOT && this.parserSupport.getCurrentScope().isDefined(value) >= 0) {
            this.lex_state = LexState.EXPR_END;
        }
        this.yaccValue = new Token(value, result, this.getPosition());
        return result;
    }

    private char getIdentifier(char c) throws IOException {
        do {
            this.tokenBuffer.append(c);
        } while (RubyYaccLexer.isIdentifierChar(c = this.src.read()));
        return c;
    }

    private int ampersand(boolean spaceSeen) throws IOException {
        int c = this.src.read();
        switch (c) {
            case 38: {
                this.lex_state = LexState.EXPR_BEG;
                c = this.src.read();
                if (c == 61) {
                    this.yaccValue = new Token("&&", this.getPosition());
                    this.lex_state = LexState.EXPR_BEG;
                    return 339;
                }
                this.src.unread((char)c);
                this.yaccValue = new Token("&&", this.getPosition());
                return 326;
            }
            case 61: {
                this.yaccValue = new Token("&", this.getPosition());
                this.lex_state = LexState.EXPR_BEG;
                return 339;
            }
        }
        this.src.unread((char)c);
        ISourcePosition tmpPosition = this.getPosition();
        if ((this.lex_state == LexState.EXPR_ARG || this.lex_state == LexState.EXPR_CMDARG) && spaceSeen && !Character.isWhitespace((char)c)) {
            this.warnings.warning(tmpPosition, "`&' interpreted as argument prefix");
            c = 351;
        } else {
            c = this.lex_state == LexState.EXPR_BEG || this.lex_state == LexState.EXPR_MID ? 351 : 352;
        }
        this.determineExpressionState();
        this.yaccValue = new Token("&", tmpPosition);
        return c;
    }

    private int at() throws IOException {
        int result;
        char c = this.src.read();
        this.tokenBuffer.setLength(0);
        this.tokenBuffer.append('@');
        if (c == '@') {
            this.tokenBuffer.append('@');
            c = this.src.read();
            result = 309;
        } else {
            result = 307;
        }
        if (Character.isDigit(c)) {
            if (this.tokenBuffer.length() == 1) {
                throw new SyntaxException(this.getPosition(), "`@" + c + "' is not allowed as an instance variable name");
            }
            throw new SyntaxException(this.getPosition(), "`@@" + c + "' is not allowed as a class variable name");
        }
        if (!RubyYaccLexer.isIdentifierChar(c)) {
            this.src.unread(c);
            this.yaccValue = new Token("@", this.getPosition());
            return 64;
        }
        c = this.getIdentifier(c);
        this.src.unread(c);
        LexState last_state = this.lex_state;
        this.lex_state = LexState.EXPR_END;
        return this.identifierToken(last_state, result, this.tokenBuffer.toString().intern());
    }

    private int backtick(boolean commandState) throws IOException {
        this.yaccValue = new Token("`", this.getPosition());
        switch (this.lex_state) {
            case EXPR_FNAME: {
                this.lex_state = LexState.EXPR_END;
                return 365;
            }
            case EXPR_DOT: {
                this.lex_state = commandState ? LexState.EXPR_CMDARG : LexState.EXPR_ARG;
                return 365;
            }
        }
        this.lex_strterm = new StringTerm(2, '\u0000', '`');
        return 368;
    }

    private int bang() throws IOException {
        char c = this.src.read();
        this.lex_state = LexState.EXPR_BEG;
        switch (c) {
            case '=': {
                this.yaccValue = new Token("!=", this.getPosition());
                return 323;
            }
            case '~': {
                this.yaccValue = new Token("!~", this.getPosition());
                return 329;
            }
        }
        this.src.unread(c);
        this.yaccValue = new Token("!", this.getPosition());
        return 361;
    }

    private int caret() throws IOException {
        char c = this.src.read();
        if (c == '=') {
            this.lex_state = LexState.EXPR_BEG;
            this.yaccValue = new Token("^", this.getPosition());
            return 339;
        }
        this.determineExpressionState();
        this.src.unread(c);
        this.yaccValue = new Token("^", this.getPosition());
        return 362;
    }

    private int colon(boolean spaceSeen) throws IOException {
        char c = this.src.read();
        if (c == ':') {
            if (this.lex_state == LexState.EXPR_BEG || this.lex_state == LexState.EXPR_MID || this.lex_state == LexState.EXPR_CLASS || (this.lex_state == LexState.EXPR_ARG || this.lex_state == LexState.EXPR_CMDARG) && spaceSeen) {
                this.lex_state = LexState.EXPR_BEG;
                this.yaccValue = new Token("::", this.getPosition());
                return 338;
            }
            this.lex_state = LexState.EXPR_DOT;
            this.yaccValue = new Token(":", this.getPosition());
            return 337;
        }
        if (this.lex_state == LexState.EXPR_END || this.lex_state == LexState.EXPR_ENDARG || Character.isWhitespace(c)) {
            this.src.unread(c);
            this.lex_state = LexState.EXPR_BEG;
            this.yaccValue = new Token(":", this.getPosition());
            return 58;
        }
        switch (c) {
            case '\'': {
                this.lex_strterm = new StringTerm(16, '\u0000', c);
                break;
            }
            case '\"': {
                this.lex_strterm = new StringTerm(18, '\u0000', c);
                break;
            }
            default: {
                this.src.unread(c);
            }
        }
        this.lex_state = LexState.EXPR_FNAME;
        this.yaccValue = new Token(":", this.getPosition());
        return 366;
    }

    private int comma(char c) throws IOException {
        this.lex_state = LexState.EXPR_BEG;
        this.yaccValue = new Token(",", this.getPosition());
        return c;
    }

    private int dollar() throws IOException {
        LexState last_state = this.lex_state;
        this.lex_state = LexState.EXPR_END;
        char c = this.src.read();
        switch (c) {
            case '_': {
                c = this.src.read();
                if (RubyYaccLexer.isIdentifierChar(c)) {
                    this.tokenBuffer.setLength(0);
                    this.tokenBuffer.append("$_");
                    c = this.getIdentifier(c);
                    this.src.unread(c);
                    last_state = this.lex_state;
                    this.lex_state = LexState.EXPR_END;
                    return this.identifierToken(last_state, 306, this.tokenBuffer.toString().intern());
                }
                this.src.unread(c);
                c = '_';
            }
            case '!': 
            case '\"': 
            case '$': 
            case '*': 
            case ',': 
            case '.': 
            case '/': 
            case ':': 
            case ';': 
            case '<': 
            case '=': 
            case '>': 
            case '?': 
            case '@': 
            case '\\': 
            case '~': {
                this.yaccValue = new Token("$" + c, 306, this.getPosition());
                return 306;
            }
            case '-': {
                this.tokenBuffer.setLength(0);
                this.tokenBuffer.append('$');
                this.tokenBuffer.append(c);
                c = this.src.read();
                if (RubyYaccLexer.isIdentifierChar(c)) {
                    this.tokenBuffer.append(c);
                } else {
                    this.src.unread(c);
                }
                this.yaccValue = new Token(this.tokenBuffer.toString(), 306, this.getPosition());
                return 306;
            }
            case '&': 
            case '\'': 
            case '+': 
            case '`': {
                if (last_state == LexState.EXPR_FNAME) {
                    this.yaccValue = new Token("$" + c, 306, this.getPosition());
                    return 306;
                }
                this.yaccValue = new BackRefNode(this.getPosition(), c);
                return 311;
            }
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                this.tokenBuffer.setLength(0);
                this.tokenBuffer.append('$');
                do {
                    this.tokenBuffer.append(c);
                } while (Character.isDigit(c = this.src.read()));
                this.src.unread(c);
                if (last_state == LexState.EXPR_FNAME) {
                    this.yaccValue = new Token(this.tokenBuffer.toString(), 306, this.getPosition());
                    return 306;
                }
                this.yaccValue = new NthRefNode(this.getPosition(), Integer.parseInt(this.tokenBuffer.substring(1)));
                return 310;
            }
            case '0': {
                this.lex_state = LexState.EXPR_END;
                return this.identifierToken(last_state, 306, ("$" + c).intern());
            }
        }
        if (!RubyYaccLexer.isIdentifierChar(c)) {
            this.src.unread(c);
            this.yaccValue = new Token("$", this.getPosition());
            return 36;
        }
        this.tokenBuffer.setLength(0);
        this.tokenBuffer.append('$');
        char d = this.getIdentifier(c);
        this.src.unread(d);
        last_state = this.lex_state;
        this.lex_state = LexState.EXPR_END;
        return this.identifierToken(last_state, 306, this.tokenBuffer.toString().intern());
    }

    private int dot() throws IOException {
        this.lex_state = LexState.EXPR_BEG;
        char c = this.src.read();
        if (c == '.') {
            c = this.src.read();
            if (c == '.') {
                this.yaccValue = new Token("...", this.getPosition());
                return 332;
            }
            this.src.unread(c);
            this.yaccValue = new Token("..", this.getPosition());
            return 331;
        }
        this.src.unread(c);
        if (Character.isDigit(c)) {
            throw new SyntaxException(this.getPosition(), "no .<digit> floating literal anymore; put 0 before dot");
        }
        this.lex_state = LexState.EXPR_DOT;
        this.yaccValue = new Token(".", this.getPosition());
        return 330;
    }

    private int doubleQuote() throws IOException {
        this.lex_strterm = new StringTerm(2, '\u0000', '\"');
        this.yaccValue = new Token("\"", this.getPosition());
        return 367;
    }

    private int greaterThan() throws IOException {
        this.determineExpressionState();
        char c = this.src.read();
        switch (c) {
            case '=': {
                this.yaccValue = new Token(">=", this.getPosition());
                return 324;
            }
            case '>': {
                c = this.src.read();
                if (c == '=') {
                    this.lex_state = LexState.EXPR_BEG;
                    this.yaccValue = new Token(">>", this.getPosition());
                    return 339;
                }
                this.src.unread(c);
                this.yaccValue = new Token(">>", this.getPosition());
                return 336;
            }
        }
        this.src.unread(c);
        this.yaccValue = new Token(">", this.getPosition());
        return 359;
    }

    private int identifier(char c, boolean commandState) throws IOException {
        Keyword keyword;
        if (!RubyYaccLexer.isIdentifierChar(c)) {
            throw new SyntaxException(this.getPosition(), "Invalid char `\\" + Integer.toOctalString(c & 0xFF) + "' in expression");
        }
        this.tokenBuffer.setLength(0);
        char first = c;
        c = this.getIdentifier(c);
        boolean lastBangOrPredicate = false;
        if (c == '!' || c == '?') {
            if (!this.src.peek('=')) {
                lastBangOrPredicate = true;
                this.tokenBuffer.append(c);
            } else {
                this.src.unread(c);
            }
        } else {
            this.src.unread(c);
        }
        int result = 0;
        LexState last_state = this.lex_state;
        if (lastBangOrPredicate) {
            result = 305;
        } else {
            if (this.lex_state == LexState.EXPR_FNAME) {
                c = this.src.read();
                if (c == '=') {
                    char c2 = this.src.read();
                    if (c2 != '~' && c2 != '>' && (c2 != '=' || c2 == '\n' && this.src.peek('>'))) {
                        result = 304;
                        this.tokenBuffer.append(c);
                        this.src.unread(c2);
                    } else {
                        this.src.unread(c2);
                        this.src.unread(c);
                    }
                } else {
                    this.src.unread(c);
                }
            }
            result = result == 0 && Character.isUpperCase(first) ? 308 : 304;
        }
        String tempVal = this.tokenBuffer.toString().intern();
        if (this.lex_state != LexState.EXPR_DOT && (keyword = RubyYaccLexer.getKeyword(tempVal)) != null) {
            LexState state = this.lex_state;
            this.lex_state = keyword.state;
            this.yaccValue = this.lex_state == LexState.EXPR_FNAME ? new Token(keyword.name, this.getPosition()) : new Token(tempVal, this.getPosition());
            if (keyword.id0 == 280) {
                if (this.conditionState.isInState()) {
                    return 281;
                }
                if (state != LexState.EXPR_CMDARG && this.cmdArgumentState.isInState()) {
                    return 282;
                }
                if (state == LexState.EXPR_ENDARG) {
                    return 282;
                }
                return 280;
            }
            if (state == LexState.EXPR_BEG) {
                return keyword.id0;
            }
            if (keyword.id0 != keyword.id1) {
                this.lex_state = LexState.EXPR_BEG;
            }
            return keyword.id1;
        }
        switch (this.lex_state) {
            case EXPR_DOT: 
            case EXPR_BEG: 
            case EXPR_MID: 
            case EXPR_ARG: 
            case EXPR_CMDARG: {
                this.lex_state = commandState ? LexState.EXPR_CMDARG : LexState.EXPR_ARG;
                break;
            }
            default: {
                this.lex_state = LexState.EXPR_END;
            }
        }
        return this.identifierToken(last_state, result, tempVal);
    }

    private int leftBracket(boolean spaceSeen) throws IOException {
        char c = '[';
        switch (this.lex_state) {
            case EXPR_FNAME: 
            case EXPR_DOT: {
                this.lex_state = LexState.EXPR_ARG;
                char c2 = this.src.read();
                c = c2;
                if (c2 == ']') {
                    if (this.src.peek('=')) {
                        c = this.src.read();
                        this.yaccValue = new Token("[]=", this.getPosition());
                        return 334;
                    }
                    this.yaccValue = new Token("[]", this.getPosition());
                    return 333;
                }
                this.src.unread(c);
                this.yaccValue = new Token("[", this.getPosition());
                return 91;
            }
            case EXPR_BEG: 
            case EXPR_MID: {
                c = '\u0159';
                break;
            }
            case EXPR_ARG: 
            case EXPR_CMDARG: {
                if (!spaceSeen) break;
                c = '\u0159';
            }
        }
        this.lex_state = LexState.EXPR_BEG;
        this.conditionState.stop();
        this.cmdArgumentState.stop();
        this.yaccValue = new Token("[", this.getPosition());
        return c;
    }

    private int leftCurly() {
        int c;
        switch (this.lex_state) {
            case EXPR_ARG: 
            case EXPR_CMDARG: 
            case EXPR_END: {
                c = 363;
                break;
            }
            case EXPR_ENDARG: {
                c = 348;
                break;
            }
            default: {
                c = 347;
            }
        }
        this.conditionState.stop();
        this.cmdArgumentState.stop();
        this.lex_state = LexState.EXPR_BEG;
        this.yaccValue = new Token("{", this.getPosition());
        return c;
    }

    private int leftParen(boolean spaceSeen) throws IOException {
        int result;
        this.commandStart = true;
        switch (this.lex_state) {
            case EXPR_BEG: 
            case EXPR_MID: {
                result = 341;
                break;
            }
            case EXPR_CMDARG: {
                result = spaceSeen ? 344 : 342;
                break;
            }
            case EXPR_ARG: {
                if (spaceSeen) {
                    this.warnings.warn(this.getPosition(), "don't put space before argument parentheses");
                }
            }
            default: {
                result = 342;
            }
        }
        this.conditionState.stop();
        this.cmdArgumentState.stop();
        this.lex_state = LexState.EXPR_BEG;
        this.yaccValue = new Token("(", this.getPosition());
        return result;
    }

    private int lessThan(boolean spaceSeen) throws IOException {
        int tok;
        char c = this.src.read();
        if (c == '<' && this.lex_state != LexState.EXPR_END && this.lex_state != LexState.EXPR_DOT && this.lex_state != LexState.EXPR_ENDARG && this.lex_state != LexState.EXPR_CLASS && (this.lex_state != LexState.EXPR_ARG && this.lex_state != LexState.EXPR_CMDARG || spaceSeen) && (tok = this.hereDocumentIdentifier()) != 0) {
            return tok;
        }
        this.determineExpressionState();
        switch (c) {
            case '=': {
                c = this.src.read();
                if (c == '>') {
                    this.yaccValue = new Token("<=>", this.getPosition());
                    return 320;
                }
                this.src.unread(c);
                this.yaccValue = new Token("<=", this.getPosition());
                return 325;
            }
            case '<': {
                c = this.src.read();
                if (c == '=') {
                    this.lex_state = LexState.EXPR_BEG;
                    this.yaccValue = new Token("<<", this.getPosition());
                    return 339;
                }
                this.src.unread(c);
                this.yaccValue = new Token("<<", this.getPosition());
                return 335;
            }
        }
        this.yaccValue = new Token("<", this.getPosition());
        this.src.unread(c);
        return 358;
    }

    private int minus(boolean spaceSeen) throws IOException {
        char c = this.src.read();
        if (this.lex_state == LexState.EXPR_FNAME || this.lex_state == LexState.EXPR_DOT) {
            this.lex_state = LexState.EXPR_ARG;
            if (c == '@') {
                this.yaccValue = new Token("-@", this.getPosition());
                return 317;
            }
            this.src.unread(c);
            this.yaccValue = new Token("-", this.getPosition());
            return 357;
        }
        if (c == '=') {
            this.lex_state = LexState.EXPR_BEG;
            this.yaccValue = new Token("-", this.getPosition());
            return 339;
        }
        if (this.lex_state == LexState.EXPR_BEG || this.lex_state == LexState.EXPR_MID || (this.lex_state == LexState.EXPR_ARG || this.lex_state == LexState.EXPR_CMDARG) && spaceSeen && !Character.isWhitespace(c)) {
            if (this.lex_state == LexState.EXPR_ARG || this.lex_state == LexState.EXPR_CMDARG) {
                this.arg_ambiguous();
            }
            this.lex_state = LexState.EXPR_BEG;
            this.src.unread(c);
            this.yaccValue = new Token("-", this.getPosition());
            if (Character.isDigit(c)) {
                return 318;
            }
            return 317;
        }
        this.lex_state = LexState.EXPR_BEG;
        this.src.unread(c);
        this.yaccValue = new Token("-", this.getPosition());
        return 357;
    }

    private int percent(boolean spaceSeen) throws IOException {
        if (this.lex_state == LexState.EXPR_BEG || this.lex_state == LexState.EXPR_MID) {
            return this.parseQuote(this.src.read());
        }
        char c = this.src.read();
        if (c == '=') {
            this.lex_state = LexState.EXPR_BEG;
            this.yaccValue = new Token("%", this.getPosition());
            return 339;
        }
        if ((this.lex_state == LexState.EXPR_ARG || this.lex_state == LexState.EXPR_CMDARG) && spaceSeen && !Character.isWhitespace(c)) {
            return this.parseQuote(c);
        }
        this.determineExpressionState();
        this.src.unread(c);
        this.yaccValue = new Token("%", this.getPosition());
        return 354;
    }

    private int pipe() throws IOException {
        char c = this.src.read();
        switch (c) {
            case '|': {
                this.lex_state = LexState.EXPR_BEG;
                c = this.src.read();
                if (c == '=') {
                    this.lex_state = LexState.EXPR_BEG;
                    this.yaccValue = new Token("||", this.getPosition());
                    return 339;
                }
                this.src.unread(c);
                this.yaccValue = new Token("||", this.getPosition());
                return 327;
            }
            case '=': {
                this.lex_state = LexState.EXPR_BEG;
                this.yaccValue = new Token("|", this.getPosition());
                return 339;
            }
        }
        this.determineExpressionState();
        this.src.unread(c);
        this.yaccValue = new Token("|", this.getPosition());
        return 360;
    }

    private int plus(boolean spaceSeen) throws IOException {
        char c = this.src.read();
        if (this.lex_state == LexState.EXPR_FNAME || this.lex_state == LexState.EXPR_DOT) {
            this.lex_state = LexState.EXPR_ARG;
            if (c == '@') {
                this.yaccValue = new Token("+@", this.getPosition());
                return 316;
            }
            this.src.unread(c);
            this.yaccValue = new Token("+", this.getPosition());
            return 356;
        }
        if (c == '=') {
            this.lex_state = LexState.EXPR_BEG;
            this.yaccValue = new Token("+", this.getPosition());
            return 339;
        }
        if (this.lex_state == LexState.EXPR_BEG || this.lex_state == LexState.EXPR_MID || (this.lex_state == LexState.EXPR_ARG || this.lex_state == LexState.EXPR_CMDARG) && spaceSeen && !Character.isWhitespace(c)) {
            if (this.lex_state == LexState.EXPR_ARG || this.lex_state == LexState.EXPR_CMDARG) {
                this.arg_ambiguous();
            }
            this.lex_state = LexState.EXPR_BEG;
            this.src.unread(c);
            if (Character.isDigit(c)) {
                c = '+';
                return this.parseNumber(c);
            }
            this.yaccValue = new Token("+", this.getPosition());
            return 316;
        }
        this.lex_state = LexState.EXPR_BEG;
        this.src.unread(c);
        this.yaccValue = new Token("+", this.getPosition());
        return 356;
    }

    private int questionMark() throws IOException {
        if (this.lex_state == LexState.EXPR_END || this.lex_state == LexState.EXPR_ENDARG) {
            this.lex_state = LexState.EXPR_BEG;
            this.yaccValue = new Token("?", this.getPosition());
            return 63;
        }
        char c = this.src.read();
        if (c == '\u0000') {
            throw new SyntaxException(this.getPosition(), "incomplete character syntax");
        }
        if (Character.isWhitespace(c)) {
            if (this.lex_state != LexState.EXPR_ARG && this.lex_state != LexState.EXPR_CMDARG) {
                int c2 = 0;
                switch (c) {
                    case ' ': {
                        c2 = 115;
                        break;
                    }
                    case '\n': {
                        c2 = 110;
                        break;
                    }
                    case '\t': {
                        c2 = 116;
                        break;
                    }
                    case '\r': {
                        c2 = 114;
                        break;
                    }
                    case '\f': {
                        c2 = 102;
                    }
                }
                if (c2 != 0) {
                    this.warnings.warn(this.getPosition(), "invalid character syntax; use ?\\" + c2);
                }
            }
            this.src.unread(c);
            this.lex_state = LexState.EXPR_BEG;
            this.yaccValue = new Token("?", this.getPosition());
            return 63;
        }
        if (RubyYaccLexer.isIdentifierChar(c) && !this.src.peek('\n') && this.isNext_identchar()) {
            this.src.unread(c);
            this.lex_state = LexState.EXPR_BEG;
            this.yaccValue = new Token("?", this.getPosition());
            return 63;
        }
        if (c == '\\') {
            c = this.readEscape();
        }
        c = (char)(c & 0xFF);
        this.lex_state = LexState.EXPR_END;
        this.yaccValue = new FixnumNode(this.getPosition(), c);
        return 313;
    }

    private int rightBracket() {
        this.conditionState.restart();
        this.cmdArgumentState.restart();
        this.lex_state = LexState.EXPR_END;
        this.yaccValue = new Token(")", this.getPosition());
        return 346;
    }

    private int rightCurly() {
        this.conditionState.restart();
        this.cmdArgumentState.restart();
        this.lex_state = LexState.EXPR_END;
        this.yaccValue = new Token("}", this.getPosition());
        return 364;
    }

    private int rightParen() {
        this.conditionState.restart();
        this.cmdArgumentState.restart();
        this.lex_state = LexState.EXPR_END;
        this.yaccValue = new Token(")", this.getPosition());
        return 343;
    }

    private int singleQuote() throws IOException {
        this.lex_strterm = new StringTerm(0, '\u0000', '\'');
        this.yaccValue = new Token("'", this.getPosition());
        return 367;
    }

    private int slash(boolean spaceSeen) throws IOException {
        if (this.lex_state == LexState.EXPR_BEG || this.lex_state == LexState.EXPR_MID) {
            this.lex_strterm = new StringTerm(7, '\u0000', '/');
            this.yaccValue = new Token("/", this.getPosition());
            return 369;
        }
        char c = this.src.read();
        if (c == '=') {
            this.yaccValue = new Token("/", this.getPosition());
            this.lex_state = LexState.EXPR_BEG;
            return 339;
        }
        this.src.unread(c);
        if ((this.lex_state == LexState.EXPR_ARG || this.lex_state == LexState.EXPR_CMDARG) && spaceSeen && !Character.isWhitespace(c)) {
            this.arg_ambiguous();
            this.lex_strterm = new StringTerm(7, '\u0000', '/');
            this.yaccValue = new Token("/", this.getPosition());
            return 369;
        }
        this.determineExpressionState();
        this.yaccValue = new Token("/", this.getPosition());
        return 355;
    }

    private int star(boolean spaceSeen) throws IOException {
        int c = this.src.read();
        switch (c) {
            case 42: {
                c = this.src.read();
                if (c == 61) {
                    this.lex_state = LexState.EXPR_BEG;
                    this.yaccValue = new Token("**", this.getPosition());
                    return 339;
                }
                this.src.unread((char)c);
                this.yaccValue = new Token("**", this.getPosition());
                c = 319;
                break;
            }
            case 61: {
                this.lex_state = LexState.EXPR_BEG;
                this.yaccValue = new Token("*", this.getPosition());
                return 339;
            }
            default: {
                this.src.unread((char)c);
                if ((this.lex_state == LexState.EXPR_ARG || this.lex_state == LexState.EXPR_CMDARG) && spaceSeen && !Character.isWhitespace((char)c)) {
                    this.warnings.warning(this.getPosition(), "`*' interpreted as argument prefix");
                    c = 349;
                } else {
                    c = this.lex_state == LexState.EXPR_BEG || this.lex_state == LexState.EXPR_MID ? 349 : 350;
                }
                this.yaccValue = new Token("*", this.getPosition());
            }
        }
        this.determineExpressionState();
        return c;
    }

    private int tilde() throws IOException {
        char c;
        if ((this.lex_state == LexState.EXPR_FNAME || this.lex_state == LexState.EXPR_DOT) && (c = this.src.read()) != '@') {
            this.src.unread(c);
        }
        this.determineExpressionState();
        this.yaccValue = new Token("~", this.getPosition());
        return 353;
    }

    private int parseNumber(char c) throws IOException {
        this.lex_state = LexState.EXPR_END;
        this.tokenBuffer.setLength(0);
        if (c == '-') {
            this.tokenBuffer.append(c);
            c = this.src.read();
        } else if (c == '+') {
            c = this.src.read();
        }
        char nondigit = '\u0000';
        if (c == '0') {
            int startLen = this.tokenBuffer.length();
            c = this.src.read();
            switch (c) {
                case 'X': 
                case 'x': {
                    c = this.src.read();
                    if (RubyYaccLexer.isHexChar(c)) {
                        while (true) {
                            if (c == '_') {
                                if (nondigit != '\u0000') break;
                                nondigit = c;
                            } else {
                                if (!RubyYaccLexer.isHexChar(c)) break;
                                nondigit = '\u0000';
                                this.tokenBuffer.append(c);
                            }
                            c = this.src.read();
                        }
                    }
                    this.src.unread(c);
                    if (this.tokenBuffer.length() == startLen) {
                        throw new SyntaxException(this.getPosition(), "Hexadecimal number without hex-digits.");
                    }
                    if (nondigit != '\u0000') {
                        throw new SyntaxException(this.getPosition(), "Trailing '_' in number.");
                    }
                    this.yaccValue = this.getInteger(this.tokenBuffer.toString(), 16);
                    return 313;
                }
                case 'B': 
                case 'b': {
                    c = this.src.read();
                    if (c == '0' || c == '1') {
                        while (true) {
                            if (c == '_') {
                                if (nondigit != '\u0000') break;
                                nondigit = c;
                            } else {
                                if (c != '0' && c != '1') break;
                                nondigit = '\u0000';
                                this.tokenBuffer.append(c);
                            }
                            c = this.src.read();
                        }
                    }
                    this.src.unread(c);
                    if (this.tokenBuffer.length() == startLen) {
                        throw new SyntaxException(this.getPosition(), "Binary number without digits.");
                    }
                    if (nondigit != '\u0000') {
                        throw new SyntaxException(this.getPosition(), "Trailing '_' in number.");
                    }
                    this.yaccValue = this.getInteger(this.tokenBuffer.toString(), 2);
                    return 313;
                }
                case 'D': 
                case 'd': {
                    c = this.src.read();
                    if (Character.isDigit(c)) {
                        while (true) {
                            if (c == '_') {
                                if (nondigit != '\u0000') break;
                                nondigit = c;
                            } else {
                                if (!Character.isDigit(c)) break;
                                nondigit = '\u0000';
                                this.tokenBuffer.append(c);
                            }
                            c = this.src.read();
                        }
                    }
                    this.src.unread(c);
                    if (this.tokenBuffer.length() == startLen) {
                        throw new SyntaxException(this.getPosition(), "Binary number without digits.");
                    }
                    if (nondigit != '\u0000') {
                        throw new SyntaxException(this.getPosition(), "Trailing '_' in number.");
                    }
                    this.yaccValue = this.getInteger(this.tokenBuffer.toString(), 10);
                    return 313;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '_': {
                    while (true) {
                        if (c == '_') {
                            if (nondigit != '\u0000') break;
                            nondigit = c;
                        } else {
                            if (c < '0' || c > '7') break;
                            nondigit = '\u0000';
                            this.tokenBuffer.append(c);
                        }
                        c = this.src.read();
                    }
                    if (this.tokenBuffer.length() > startLen) {
                        this.src.unread(c);
                        if (nondigit != '\u0000') {
                            throw new SyntaxException(this.getPosition(), "Trailing '_' in number.");
                        }
                        this.yaccValue = this.getInteger(this.tokenBuffer.toString(), 8);
                        return 313;
                    }
                }
                case '8': 
                case '9': {
                    throw new SyntaxException(this.getPosition(), "Illegal octal digit.");
                }
                case '.': 
                case 'E': 
                case 'e': {
                    this.tokenBuffer.append('0');
                    break;
                }
                default: {
                    this.src.unread(c);
                    this.yaccValue = new FixnumNode(this.getPosition(), 0L);
                    return 313;
                }
            }
        }
        boolean seen_point = false;
        boolean seen_e = false;
        while (true) {
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    nondigit = '\u0000';
                    this.tokenBuffer.append(c);
                    break;
                }
                case '.': {
                    if (nondigit != '\u0000') {
                        this.src.unread(c);
                        throw new SyntaxException(this.getPosition(), "Trailing '_' in number.");
                    }
                    if (seen_point || seen_e) {
                        this.src.unread(c);
                        return this.getNumberToken(this.tokenBuffer.toString(), true, nondigit);
                    }
                    char c2 = this.src.read();
                    if (!Character.isDigit(c2)) {
                        this.src.unread(c2);
                        this.src.unread('.');
                        if (c == '_') break;
                        this.yaccValue = this.getInteger(this.tokenBuffer.toString(), 10);
                        return 313;
                    }
                    this.tokenBuffer.append('.');
                    this.tokenBuffer.append(c2);
                    seen_point = true;
                    nondigit = '\u0000';
                    break;
                }
                case 'E': 
                case 'e': {
                    if (nondigit != '\u0000') {
                        throw new SyntaxException(this.getPosition(), "Trailing '_' in number.");
                    }
                    if (seen_e) {
                        this.src.unread(c);
                        return this.getNumberToken(this.tokenBuffer.toString(), true, nondigit);
                    }
                    this.tokenBuffer.append(c);
                    seen_e = true;
                    nondigit = c;
                    c = this.src.read();
                    if (c == '-' || c == '+') {
                        this.tokenBuffer.append(c);
                        nondigit = c;
                        break;
                    }
                    this.src.unread(c);
                    break;
                }
                case '_': {
                    if (nondigit != '\u0000') {
                        throw new SyntaxException(this.getPosition(), "Trailing '_' in number.");
                    }
                    nondigit = c;
                    break;
                }
                default: {
                    this.src.unread(c);
                    return this.getNumberToken(this.tokenBuffer.toString(), seen_e || seen_point, nondigit);
                }
            }
            c = this.src.read();
        }
    }

    private int getNumberToken(String number, boolean isFloat, char nondigit) {
        if (nondigit != '\u0000') {
            throw new SyntaxException(this.getPosition(), "Trailing '_' in number.");
        }
        if (isFloat) {
            double d;
            try {
                d = Double.parseDouble(number);
            }
            catch (NumberFormatException e) {
                this.warnings.warn(this.getPosition(), "Float " + number + " out of range.");
                d = number.startsWith("-") ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            this.yaccValue = new FloatNode(this.getPosition(), d);
            return 314;
        }
        this.yaccValue = this.getInteger(number, 10);
        return 313;
    }

    public char readEscape() throws IOException {
        char c = this.src.read();
        switch (c) {
            case '\\': {
                return c;
            }
            case 'n': {
                return '\n';
            }
            case 't': {
                return '\t';
            }
            case 'r': {
                return '\r';
            }
            case 'f': {
                return '\f';
            }
            case 'v': {
                return '\u000b';
            }
            case 'a': {
                return '\u0007';
            }
            case 'e': {
                return '\u001b';
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': {
                this.src.unread(c);
                return this.scanOct(3);
            }
            case 'x': {
                int i;
                char hexValue = '\u0000';
                for (i = 0; i < 2; ++i) {
                    char h1 = this.src.read();
                    if (!RubyYaccLexer.isHexChar(h1)) {
                        this.src.unread(h1);
                        break;
                    }
                    hexValue = (char)(hexValue << 4);
                    hexValue = (char)(hexValue | Integer.parseInt("" + h1, 16) & 0xF);
                }
                if (i == 0) {
                    throw new SyntaxException(this.getPosition(), "Invalid escape character syntax");
                }
                return hexValue;
            }
            case 'b': {
                return '\b';
            }
            case 's': {
                return ' ';
            }
            case 'M': {
                c = this.src.read();
                if (c != '-') {
                    throw new SyntaxException(this.getPosition(), "Invalid escape character syntax");
                }
                c = this.src.read();
                if (c == '\\') {
                    return (char)(this.readEscape() | 0x80);
                }
                if (c == '\u0000') {
                    throw new SyntaxException(this.getPosition(), "Invalid escape character syntax");
                }
                return (char)(c & 0xFF | 0x80);
            }
            case 'C': {
                c = this.src.read();
                if (c != '-') {
                    throw new SyntaxException(this.getPosition(), "Invalid escape character syntax");
                }
            }
            case 'c': {
                c = this.src.read();
                if (c == '\\') {
                    c = this.readEscape();
                } else {
                    if (c == '?') {
                        return '\u0177';
                    }
                    if (c == '\u0000') {
                        throw new SyntaxException(this.getPosition(), "Invalid escape character syntax");
                    }
                }
                return (char)(c & 0x9F);
            }
            case '\u0000': {
                throw new SyntaxException(this.getPosition(), "Invalid escape character syntax");
            }
        }
        return c;
    }

    private char scanOct(int count) throws IOException {
        char value = '\u0000';
        for (int i = 0; i < count; ++i) {
            char c = this.src.read();
            if (!RubyYaccLexer.isOctChar(c)) {
                this.src.unread(c);
                break;
            }
            value = (char)(value << 3);
            value = (char)(value | Integer.parseInt("" + c, 8));
        }
        return value;
    }

    static {
        map.put("end", Keyword.END);
        map.put("else", Keyword.ELSE);
        map.put("case", Keyword.CASE);
        map.put("ensure", Keyword.ENSURE);
        map.put("module", Keyword.MODULE);
        map.put("elsif", Keyword.ELSIF);
        map.put("def", Keyword.DEF);
        map.put("rescue", Keyword.RESCUE);
        map.put("not", Keyword.NOT);
        map.put("then", Keyword.THEN);
        map.put("yield", Keyword.YIELD);
        map.put("for", Keyword.FOR);
        map.put("self", Keyword.SELF);
        map.put("false", Keyword.FALSE);
        map.put("retry", Keyword.RETRY);
        map.put("return", Keyword.RETURN);
        map.put("true", Keyword.TRUE);
        map.put("if", Keyword.IF);
        map.put("defined?", Keyword.DEFINED_P);
        map.put("super", Keyword.SUPER);
        map.put("undef", Keyword.UNDEF);
        map.put("break", Keyword.BREAK);
        map.put("in", Keyword.IN);
        map.put("do", Keyword.DO);
        map.put("nil", Keyword.NIL);
        map.put("until", Keyword.UNTIL);
        map.put("unless", Keyword.UNLESS);
        map.put("or", Keyword.OR);
        map.put("next", Keyword.NEXT);
        map.put("when", Keyword.WHEN);
        map.put("redo", Keyword.REDO);
        map.put("and", Keyword.AND);
        map.put("begin", Keyword.BEGIN);
        map.put("__LINE__", Keyword.__LINE__);
        map.put("class", Keyword.CLASS);
        map.put("__FILE__", Keyword.__FILE__);
        map.put("END", Keyword.LEND);
        map.put("BEGIN", Keyword.LBEGIN);
        map.put("while", Keyword.WHILE);
        map.put("alias", Keyword.ALIAS);
        acount = 0;
        aCount = 0;
    }

    public static enum LexState {
        EXPR_BEG,
        EXPR_END,
        EXPR_ARG,
        EXPR_CMDARG,
        EXPR_ENDARG,
        EXPR_MID,
        EXPR_FNAME,
        EXPR_DOT,
        EXPR_CLASS;

    }

    public static enum Keyword {
        END("end", 264, 264, LexState.EXPR_END),
        ELSE("else", 269, 269, LexState.EXPR_BEG),
        CASE("case", 270, 270, LexState.EXPR_BEG),
        ENSURE("ensure", 263, 263, LexState.EXPR_BEG),
        MODULE("module", 258, 258, LexState.EXPR_BEG),
        ELSIF("elsif", 268, 268, LexState.EXPR_BEG),
        DEF("def", 259, 259, LexState.EXPR_FNAME),
        RESCUE("rescue", 262, 297, LexState.EXPR_MID),
        NOT("not", 292, 292, LexState.EXPR_BEG),
        THEN("then", 267, 267, LexState.EXPR_BEG),
        YIELD("yield", 284, 284, LexState.EXPR_ARG),
        FOR("for", 274, 274, LexState.EXPR_BEG),
        SELF("self", 286, 286, LexState.EXPR_END),
        FALSE("false", 289, 289, LexState.EXPR_END),
        RETRY("retry", 278, 278, LexState.EXPR_END),
        RETURN("return", 283, 283, LexState.EXPR_MID),
        TRUE("true", 288, 288, LexState.EXPR_END),
        IF("if", 265, 293, LexState.EXPR_BEG),
        DEFINED_P("defined?", 299, 299, LexState.EXPR_ARG),
        SUPER("super", 285, 285, LexState.EXPR_ARG),
        UNDEF("undef", 260, 260, LexState.EXPR_FNAME),
        BREAK("break", 275, 275, LexState.EXPR_MID),
        IN("in", 279, 279, LexState.EXPR_BEG),
        DO("do", 280, 280, LexState.EXPR_BEG),
        NIL("nil", 287, 287, LexState.EXPR_END),
        UNTIL("until", 273, 296, LexState.EXPR_BEG),
        UNLESS("unless", 266, 294, LexState.EXPR_BEG),
        OR("or", 291, 291, LexState.EXPR_BEG),
        NEXT("next", 276, 276, LexState.EXPR_MID),
        WHEN("when", 271, 271, LexState.EXPR_BEG),
        REDO("redo", 277, 277, LexState.EXPR_END),
        AND("and", 290, 290, LexState.EXPR_BEG),
        BEGIN("begin", 261, 261, LexState.EXPR_BEG),
        __LINE__("__LINE__", 302, 302, LexState.EXPR_END),
        CLASS("class", 257, 257, LexState.EXPR_CLASS),
        __FILE__("__FILE__", 303, 303, LexState.EXPR_END),
        LEND("END", 301, 301, LexState.EXPR_END),
        LBEGIN("BEGIN", 300, 300, LexState.EXPR_END),
        WHILE("while", 272, 295, LexState.EXPR_BEG),
        ALIAS("alias", 298, 298, LexState.EXPR_FNAME);

        public final String name;
        public final int id0;
        public final int id1;
        public final LexState state;

        private Keyword(String name, int id0, int id1, LexState state) {
            this.name = name;
            this.id0 = id0;
            this.id1 = id1;
            this.state = state;
        }
    }
}

