/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.lexer.yacc;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.jruby.lexer.yacc.LexerSource;
import org.jruby.lexer.yacc.RubyYaccLexer;
import org.jruby.parser.ParserConfiguration;
import org.jruby.util.ByteList;

public class InputStreamLexerSource
extends LexerSource {
    private static final int INITIAL_PUSHBACK_SIZE = 100;
    private final InputStream in;
    private char[] buf = new char[100];
    private int bufLength = -1;
    private int oneAgo = 10;
    private int twoAgo = 0;

    public InputStreamLexerSource(String sourceName, InputStream in, List<String> list, int line, boolean extraPositionInformation) {
        super(sourceName, list, line, extraPositionInformation);
        this.in = in;
    }

    @Override
    public char read() throws IOException {
        int c;
        if (this.bufLength >= 0) {
            c = this.buf[this.bufLength--];
        } else {
            c = this.wrappedRead();
            if (c == -1) {
                return '\u0000';
            }
        }
        this.twoAgo = this.oneAgo;
        this.oneAgo = c;
        ++this.offset;
        if (c == 10) {
            ++this.line;
        }
        return (char)c;
    }

    @Override
    public void unread(char c) {
        if (c == '\u0000') {
            return;
        }
        --this.offset;
        this.oneAgo = this.twoAgo;
        this.twoAgo = 0;
        if (c == '\n') {
            --this.line;
        }
        this.buf[++this.bufLength] = c;
        if (this.bufLength + 1 == this.buf.length) {
            char[] newBuf = new char[this.buf.length + 100];
            System.arraycopy(this.buf, 0, newBuf, 0, this.buf.length);
            this.buf = newBuf;
        }
    }

    @Override
    public boolean peek(char to) throws IOException {
        char c = this.read();
        this.unread(c);
        return c == to;
    }

    private int wrappedRead() throws IOException {
        int c = this.in.read();
        if (c == 13) {
            c = this.in.read();
            if (c != 10) {
                this.unread((char)c);
                c = 10;
            } else {
                ++this.offset;
            }
        }
        this.captureFeature(c);
        return c;
    }

    public static LexerSource getSource(String name, InputStream content, List<String> list, ParserConfiguration configuration) {
        return new InputStreamLexerSource(name, content, list, configuration.getLineNumber(), configuration.hasExtraPositionInformation());
    }

    @Override
    public ByteList readLineBytes() throws IOException {
        ByteList bytelist = new ByteList(80);
        char c = this.read();
        while (c != '\n' && c != '\u0000') {
            bytelist.append(c);
            c = this.read();
        }
        return bytelist;
    }

    @Override
    public char skipUntil(char c) throws IOException {
        c = this.read();
        while (c != '\n' && c != '\u0000') {
            c = this.read();
        }
        return c;
    }

    @Override
    public void unreadMany(CharSequence buffer) {
        int length = buffer.length();
        for (int i = length - 1; i >= 0; --i) {
            this.unread(buffer.charAt(i));
        }
    }

    @Override
    public boolean matchMarker(ByteList match, boolean indent) throws IOException {
        char c;
        int length = match.length();
        ByteList buffer = new ByteList(length + 1);
        if (indent) {
            while ((c = this.read()) != '\u0000') {
                if (!Character.isWhitespace(c) || c == '\n') {
                    this.unread(c);
                    break;
                }
                buffer.append(c);
            }
        }
        for (int i = 0; i < length; ++i) {
            c = this.read();
            buffer.append(c);
            if (match.charAt(i) == c) continue;
            this.unreadMany(buffer);
            return false;
        }
        c = this.read();
        return c == '\u0000' || c == '\n';
    }

    @Override
    public String matchMarkerNoCase(ByteList match) throws IOException {
        ByteList buf = new ByteList(match.length());
        for (int i = 0; i < match.length(); ++i) {
            char c = match.charAt(i);
            char r = this.read();
            buf.append(r);
            if (Character.toLowerCase(c) == r || Character.toUpperCase(c) == r) continue;
            this.unreadMany(buf);
            return null;
        }
        return buf.toString();
    }

    @Override
    public boolean wasBeginOfLine() {
        return this.twoAgo == 10;
    }

    public String toString() {
        try {
            int i;
            ByteList buffer = new ByteList(20);
            for (i = 0; i < 20; ++i) {
                buffer.append(this.read());
            }
            for (i = 0; i < 20; ++i) {
                this.unread(buffer.charAt(buffer.length() - i - 1));
            }
            buffer.append(new byte[]{32, 46, 46, 46});
            return buffer.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public ByteList readUntil(char marker) throws IOException {
        ByteList list = new ByteList(20);
        char c = this.read();
        while (c != marker && c != '\u0000') {
            list.append(c);
            c = this.read();
        }
        if (c == '\u0000') {
            return null;
        }
        this.unread(c);
        return list;
    }

    @Override
    public ByteList readIdentifer() throws IOException {
        ByteList tokenBuffer = new ByteList();
        char c = this.read();
        while (RubyYaccLexer.isIdentifierChar(c)) {
            tokenBuffer.append(c);
            c = this.read();
        }
        if (c == '!' || c == '?') {
            if (!this.peek('=')) {
                tokenBuffer.append(c);
            } else {
                this.unread(c);
            }
        } else {
            this.unread(c);
        }
        return tokenBuffer;
    }
}

