/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.lexer.yacc;

import java.io.IOException;
import org.jruby.ast.StrNode;
import org.jruby.lexer.yacc.LexerSource;
import org.jruby.lexer.yacc.RubyYaccLexer;
import org.jruby.lexer.yacc.StrTerm;
import org.jruby.lexer.yacc.StringTerm;
import org.jruby.lexer.yacc.SyntaxException;
import org.jruby.lexer.yacc.Token;
import org.jruby.util.ByteList;

public class HeredocTerm
extends StrTerm {
    private final ByteList marker;
    private final int flags;
    private final ByteList lastLine;

    public HeredocTerm(ByteList marker, int func, ByteList lastLine) {
        this.marker = marker;
        this.flags = func;
        this.lastLine = lastLine;
    }

    @Override
    public int parseString(RubyYaccLexer lexer, LexerSource src) throws IOException {
        boolean indent = (this.flags & 0x20) != 0;
        ByteList str = new ByteList();
        if (src.peek('\u0000')) {
            this.syntaxError(src);
        }
        if (src.wasBeginOfLine() && src.matchMarker(this.marker, indent)) {
            src.unreadMany(this.lastLine);
            lexer.yaccValue = new Token(this.marker, lexer.getPosition());
            return 374;
        }
        if ((this.flags & 2) == 0) {
            do {
                str.append(src.readLineBytes());
                str.append(10);
                if (!src.peek('\u0000')) continue;
                this.syntaxError(src);
            } while (!src.matchMarker(this.marker, indent));
        } else {
            char c = src.read();
            ByteList buffer = new ByteList();
            if (c == '#') {
                c = src.read();
                switch (c) {
                    case '$': 
                    case '@': {
                        src.unread(c);
                        lexer.setValue(new Token("#" + c, lexer.getPosition()));
                        return 373;
                    }
                    case '{': {
                        lexer.setValue(new Token("#" + c, lexer.getPosition()));
                        return 372;
                    }
                }
                buffer.append(35);
            }
            src.unread(c);
            do {
                if ((c = new StringTerm(this.flags, '\u0000', '\n').parseStringIntoBuffer(lexer, src, buffer)) == '\u0000') {
                    this.syntaxError(src);
                }
                if (c != '\n') {
                    lexer.yaccValue = new StrNode(lexer.getPosition(), buffer);
                    return 312;
                }
                buffer.append(src.read());
                c = src.read();
                if (c == '\u0000') {
                    this.syntaxError(src);
                }
                src.unread(c);
            } while (!src.matchMarker(this.marker, indent));
            str = buffer;
        }
        src.unreadMany(this.lastLine);
        lexer.setStrTerm(new StringTerm(-1, '\u0000', '\u0000'));
        lexer.yaccValue = new StrNode(lexer.getPosition(), str);
        return 312;
    }

    private void syntaxError(LexerSource src) {
        throw new SyntaxException(src.getPosition(), "can't find string \"" + this.marker + "\" anywhere before EOF");
    }
}

