/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport.proxy;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyNil;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.proxy.InternalJavaProxy;
import org.jruby.javasupport.proxy.JavaProxyClassFactory;
import org.jruby.javasupport.proxy.JavaProxyConstructor;
import org.jruby.javasupport.proxy.JavaProxyInvocationHandler;
import org.jruby.javasupport.proxy.JavaProxyMethod;
import org.jruby.javasupport.proxy.JavaProxyReflectionObject;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;

public class JavaProxyClass
extends JavaProxyReflectionObject {
    static ThreadLocal runtimeTLS = new ThreadLocal();
    private final Class proxyClass;
    private ArrayList methods = new ArrayList();
    private HashMap methodMap = new HashMap();
    private static final HashSet<String> EXCLUDE_MODULES = new HashSet();
    private static final HashSet<String> EXCLUDE_METHODS;

    JavaProxyClass(Class proxyClass) {
        super(JavaProxyClass.getThreadLocalRuntime(), JavaProxyClass.getThreadLocalRuntime().fastGetModule("Java").fastGetClass("JavaProxyClass"));
        this.proxyClass = proxyClass;
    }

    public Object getValue() {
        return this;
    }

    private static Ruby getThreadLocalRuntime() {
        return (Ruby)runtimeTLS.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JavaProxyClass getProxyClass(Ruby runtime, Class superClass, Class[] interfaces, Set names) throws InvocationTargetException {
        Object save = runtimeTLS.get();
        runtimeTLS.set(runtime);
        try {
            ClassLoader loader = runtime.getJavaSupport().getJavaClassLoader();
            JavaProxyClass javaProxyClass = JavaProxyClassFactory.newProxyClass(loader, null, superClass, interfaces, names);
            return javaProxyClass;
        }
        finally {
            runtimeTLS.set(save);
        }
    }

    public static JavaProxyClass getProxyClass(Ruby runtime, Class superClass, Class[] interfaces) throws InvocationTargetException {
        return JavaProxyClass.getProxyClass(runtime, superClass, interfaces, null);
    }

    public static Object newProxyInstance(Ruby runtime, Class superClass, Class[] interfaces, Class[] constructorParameters, Object[] constructorArgs, JavaProxyInvocationHandler handler) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException {
        JavaProxyClass jpc = JavaProxyClass.getProxyClass(runtime, superClass, interfaces);
        JavaProxyConstructor cons = jpc.getConstructor(constructorParameters == null ? new Class[]{} : constructorParameters);
        return cons.newInstance(constructorArgs, handler);
    }

    public Class getSuperclass() {
        return this.proxyClass.getSuperclass();
    }

    public Class[] getInterfaces() {
        Class<?>[] ifaces = this.proxyClass.getInterfaces();
        Class[] result = new Class[ifaces.length - 1];
        int pos = 0;
        for (int i = 0; i < ifaces.length; ++i) {
            if (ifaces[i] == InternalJavaProxy.class) continue;
            result[pos++] = ifaces[i];
        }
        return result;
    }

    public JavaProxyConstructor[] getConstructors() {
        Constructor<?>[] cons = this.proxyClass.getConstructors();
        JavaProxyConstructor[] result = new JavaProxyConstructor[cons.length];
        for (int i = 0; i < cons.length; ++i) {
            result[i] = new JavaProxyConstructor(this.getRuntime(), this, cons[i]);
        }
        return result;
    }

    public JavaProxyConstructor getConstructor(Class[] args) throws SecurityException, NoSuchMethodException {
        Class[] realArgs = new Class[args.length + 1];
        System.arraycopy(args, 0, realArgs, 0, args.length);
        realArgs[args.length] = JavaProxyInvocationHandler.class;
        Constructor constructor = this.proxyClass.getConstructor(realArgs);
        return new JavaProxyConstructor(this.getRuntime(), this, constructor);
    }

    public JavaProxyMethod[] getMethods() {
        return this.methods.toArray(new JavaProxyMethod[this.methods.size()]);
    }

    public JavaProxyMethod getMethod(String name, Class[] parameterTypes) {
        List methods = (List)this.methodMap.get(name);
        if (methods != null) {
            int i = methods.size();
            while (--i >= 0) {
                ProxyMethodImpl jpm = (ProxyMethodImpl)methods.get(i);
                if (!jpm.matches(name, parameterTypes)) continue;
                return jpm;
            }
        }
        return null;
    }

    Class getProxyClass() {
        return this.proxyClass;
    }

    JavaProxyMethod initMethod(String name, String desc, boolean hasSuper) {
        Class proxy = this.proxyClass;
        try {
            Class[] parms = JavaProxyClass.parse(proxy.getClassLoader(), desc);
            Method m = proxy.getDeclaredMethod(name, parms);
            Method sm = null;
            if (hasSuper) {
                sm = proxy.getDeclaredMethod("__super$" + name, parms);
            }
            ProxyMethodImpl jpm = new ProxyMethodImpl(this.getRuntime(), this, m, sm);
            this.methods.add(jpm);
            ArrayList<ProxyMethodImpl> methodsWithName = (ArrayList<ProxyMethodImpl>)this.methodMap.get(name);
            if (methodsWithName == null) {
                methodsWithName = new ArrayList<ProxyMethodImpl>(2);
                this.methodMap.put(name, methodsWithName);
            }
            methodsWithName.add(jpm);
            return jpm;
        }
        catch (ClassNotFoundException e) {
            throw new InternalError(e.getMessage());
        }
        catch (SecurityException e) {
            throw new InternalError(e.getMessage());
        }
        catch (NoSuchMethodException e) {
            throw new InternalError(e.getMessage());
        }
    }

    private static Class[] parse(final ClassLoader loader, String desc) throws ClassNotFoundException {
        ArrayList<Class<Byte>> al = new ArrayList<Class<Byte>>();
        int idx = 1;
        while (desc.charAt(idx) != ')') {
            Class type;
            int arr = 0;
            while (desc.charAt(idx) == '[') {
                ++idx;
                ++arr;
            }
            switch (desc.charAt(idx)) {
                case 'L': {
                    int semi = desc.indexOf(59, idx);
                    final String name = desc.substring(idx + 1, semi);
                    idx = semi;
                    try {
                        type = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws ClassNotFoundException {
                                return Class.forName(name.replace('/', '.'), false, loader);
                            }
                        });
                        break;
                    }
                    catch (PrivilegedActionException e) {
                        throw (ClassNotFoundException)e.getException();
                    }
                }
                case 'B': {
                    type = Byte.TYPE;
                    break;
                }
                case 'C': {
                    type = Character.TYPE;
                    break;
                }
                case 'Z': {
                    type = Boolean.TYPE;
                    break;
                }
                case 'S': {
                    type = Short.TYPE;
                    break;
                }
                case 'I': {
                    type = Integer.TYPE;
                    break;
                }
                case 'J': {
                    type = Long.TYPE;
                    break;
                }
                case 'F': {
                    type = Float.TYPE;
                    break;
                }
                case 'D': {
                    type = Double.TYPE;
                    break;
                }
                default: {
                    throw new InternalError("cannot parse " + desc + "[" + idx + "]");
                }
            }
            ++idx;
            if (arr != 0) {
                type = Array.newInstance(type, new int[arr]).getClass();
            }
            al.add(type);
        }
        return al.toArray(new Class[al.size()]);
    }

    public static RubyClass createJavaProxyClassClass(Ruby runtime, RubyModule javaModule) {
        RubyClass result = javaModule.defineClassUnder("JavaProxyClass", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        CallbackFactory callbackFactory = runtime.callbackFactory(JavaProxyClass.class);
        JavaProxyReflectionObject.registerRubyMethods(runtime, result);
        result.defineFastMethod("constructors", callbackFactory.getFastMethod("constructors"));
        result.defineFastMethod("superclass", callbackFactory.getFastMethod("superclass"));
        result.defineFastMethod("interfaces", callbackFactory.getFastMethod("interfaces"));
        result.defineFastMethod("methods", callbackFactory.getFastMethod("methods"));
        result.getMetaClass().defineFastMethod("get", callbackFactory.getFastSingletonMethod("get", JavaClass.class));
        result.getMetaClass().defineFastMethod("get_with_class", callbackFactory.getFastSingletonMethod("get_with_class", RubyClass.class));
        return result;
    }

    public static RubyObject get(IRubyObject recv, JavaClass type) {
        try {
            return JavaProxyClass.getProxyClass(recv.getRuntime(), (Class)type.getValue(), new Class[0]);
        }
        catch (Error e) {
            RaiseException ex = recv.getRuntime().newArgumentError("unable to create proxy class for " + type.getValue());
            ex.initCause(e);
            throw ex;
        }
        catch (InvocationTargetException e) {
            RaiseException ex = recv.getRuntime().newArgumentError("unable to create proxy class for " + type.getValue());
            ex.initCause(e);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static RubyObject get_with_class(IRubyObject recv, RubyClass clazz) {
        runtime = recv.getRuntime();
        javaClass = null;
        names = new HashSet<String>();
        interfaceList = new ArrayList<Class>();
        ancestors = clazz.getAncestorList();
        skipRemainingClasses = false;
        iter = ancestors.iterator();
        block7: while (true) {
            block28: {
                block29: {
                    block26: {
                        block27: {
                            if (!iter.hasNext()) break block26;
                            var9_10 = (RubyModule)iter.next();
                            if (!(var9_10 instanceof RubyClass)) break block27;
                            if (skipRemainingClasses) continue;
                            if (!var9_10.fastHasInstanceVariable("@java_proxy_class")) {
                                skipRemainingClasses = true;
                                continue;
                            }
                            var = var9_10.fastGetInstanceVariable("@java_class");
                            if (var == null) {
                                throw runtime.newTypeError("no java_class defined for proxy (or ancestor): " + var9_10);
                            }
                            if (!(var instanceof JavaClass)) {
                                throw runtime.newTypeError("invalid java_class defined for proxy (or ancestor): " + var9_10 + ": " + var);
                            }
                            if (javaClass == null) {
                                javaClass = (JavaClass)var;
                            } else if (javaClass != var) {
                                throw runtime.newTypeError("java_class defined for " + clazz + " (" + javaClass + ") does not match java_class for ancestor " + var9_10 + " (" + var + ")");
                            }
                            var = var9_10.fastGetInstanceVariable("@java_interfaces");
                            if (var == null || var instanceof RubyNil) break block28;
                            if (!(var instanceof RubyArray)) {
                                throw runtime.newTypeError("invalid java_interfaces defined for proxy (or ancestor): " + var9_10 + ": " + var);
                            }
                            ifcArray = (RubyArray)var;
                            i = size = ifcArray.size();
                            break block29;
                        }
                        if (JavaProxyClass.EXCLUDE_MODULES.contains(var9_10.getName())) continue;
                        methods = var9_10.getMethods();
                        methodNames = methods;
                        // MONITORENTER : methods
                        for (String methodName : methods.keySet()) {
                            if (JavaProxyClass.EXCLUDE_METHODS.contains(methodName)) continue;
                            names.add(methodName);
                        }
                        // MONITOREXIT : methodNames
                        continue;
                    }
                    if (javaClass == null) {
                        throw runtime.newArgumentError("unable to create proxy class: no java_class defined for " + clazz);
                    }
                    interfaceCount = interfaceList.size();
                    var9_11 = new Class[interfaceCount];
                    i = interfaceCount;
                    while (--i >= 0) {
                        var9_11[i] = (Class)interfaceList.get(i);
                    }
                    try {
                        return JavaProxyClass.getProxyClass(recv.getRuntime(), javaClass.javaClass(), var9_11, names);
                    }
                    catch (Error e) {
                        ex = recv.getRuntime().newArgumentError("unable to create proxy class for " + javaClass.getValue() + " : " + e.getMessage());
                        ex.initCause(e);
                        throw ex;
                    }
                    catch (InvocationTargetException e) {
                        ex = recv.getRuntime().newArgumentError("unable to create proxy class for " + javaClass.getValue() + " : " + e.getMessage());
                        ex.initCause(e);
                        throw ex;
                    }
                }
                while (--i >= 0) {
                    ifc = ifcArray.eltInternal(i);
                    if (!(ifc instanceof JavaClass)) {
                        throw runtime.newTypeError("invalid java interface defined for proxy (or ancestor): " + var9_10 + ": " + ifc);
                    }
                    interfaceClass = ((JavaClass)ifc).javaClass();
                    if (!interfaceClass.isInterface()) {
                        throw runtime.newTypeError("invalid java interface defined for proxy (or ancestor): " + var9_10 + ": " + ifc + " (not an interface)");
                    }
                    if (interfaceList.contains(interfaceClass)) continue;
                    interfaceList.add(interfaceClass);
                }
            }
            if ((var = var9_10.fastGetInstanceVariable("@__java_ovrd_methods")) == null) {
                i = methods = var9_10.getMethods();
                // MONITORENTER : methods
                methodNames = RubyArray.newArrayLight(runtime, methods.size());
                for (String methodName : methods.keySet()) {
                    if (JavaProxyClass.EXCLUDE_METHODS.contains(methodName)) continue;
                    names.add(methodName);
                    methodNames.add(runtime.newString(methodName));
                }
                // MONITOREXIT : i
                var9_10.fastSetInstanceVariable("@__java_ovrd_methods", methodNames);
                continue;
            }
            if (!(var instanceof RubyArray)) {
                throw runtime.newTypeError("invalid @__java_ovrd_methods defined for proxy: " + var9_10 + ": " + var);
            }
            methodNames = (RubyArray)var;
            i = size = methodNames.size();
            while (true) {
                if (--i >= 0) ** break;
                continue block7;
                methodName = methodNames.eltInternal(i);
                if (!(methodName instanceof RubyString)) {
                    throw runtime.newTypeError("invalid method name defined for proxy (or ancestor): " + var9_10 + ": " + methodName);
                }
                names.add(methodName.asSymbol());
            }
            break;
        }
    }

    public RubyObject superclass() {
        return JavaClass.get(this.getRuntime(), this.getSuperclass());
    }

    public RubyArray methods() {
        return this.buildRubyArray(this.getMethods());
    }

    public RubyArray interfaces() {
        return this.buildRubyArray(this.getInterfaces());
    }

    public RubyArray constructors() {
        return this.buildRubyArray(this.getConstructors());
    }

    public static void createJavaProxyModule(Ruby runtime) {
        RubyModule javaProxyModule = runtime.getJavaSupport().getJavaModule();
        JavaProxyClass.createJavaProxyClassClass(runtime, javaProxyModule);
        ProxyMethodImpl.createJavaProxyMethodClass(runtime, javaProxyModule);
        JavaProxyConstructor.createJavaProxyConstructorClass(runtime, javaProxyModule);
    }

    public String nameOnInspection() {
        return "[Proxy:" + this.getSuperclass().getName() + "]";
    }

    static {
        EXCLUDE_MODULES.add("Kernel");
        EXCLUDE_MODULES.add("Java");
        EXCLUDE_MODULES.add("JavaProxyMethods");
        EXCLUDE_MODULES.add("Enumerable");
        EXCLUDE_METHODS = new HashSet();
        EXCLUDE_METHODS.add("class");
        EXCLUDE_METHODS.add("finalize");
        EXCLUDE_METHODS.add("initialize");
        EXCLUDE_METHODS.add("java_class");
        EXCLUDE_METHODS.add("java_object");
        EXCLUDE_METHODS.add("__jcreate!");
        EXCLUDE_METHODS.add("__jsend!");
    }

    public static class ProxyMethodImpl
    extends JavaProxyReflectionObject
    implements JavaProxyMethod {
        private final Method m;
        private Object state;
        private final Method sm;
        private final Class[] parameterTypes;
        private final JavaProxyClass clazz;

        public ProxyMethodImpl(Ruby runtime, JavaProxyClass clazz, Method m, Method sm) {
            super(runtime, runtime.getJavaSupport().getJavaModule().fastGetClass("JavaProxyMethod"));
            this.m = m;
            this.parameterTypes = m.getParameterTypes();
            this.sm = sm;
            this.clazz = clazz;
        }

        public Method getMethod() {
            return this.m;
        }

        @Override
        public Method getSuperMethod() {
            return this.sm;
        }

        @Override
        public int getModifiers() {
            return this.m.getModifiers();
        }

        @Override
        public String getName() {
            return this.m.getName();
        }

        @Override
        public Class[] getExceptionTypes() {
            return this.m.getExceptionTypes();
        }

        @Override
        public Class[] getParameterTypes() {
            return this.parameterTypes;
        }

        @Override
        public Object getState() {
            return this.state;
        }

        @Override
        public boolean hasSuperImplementation() {
            return this.sm != null;
        }

        @Override
        public Object invoke(Object proxy, Object[] args) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
            if (!this.hasSuperImplementation()) {
                throw new NoSuchMethodException();
            }
            return this.sm.invoke(proxy, args);
        }

        @Override
        public void setState(Object state) {
            this.state = state;
        }

        @Override
        public String toString() {
            return this.m.toString();
        }

        @Override
        public Object defaultResult() {
            Class<?> rt = this.m.getReturnType();
            if (rt == Void.TYPE) {
                return null;
            }
            if (rt == Boolean.TYPE) {
                return Boolean.FALSE;
            }
            if (rt == Byte.TYPE) {
                return new Byte(0);
            }
            if (rt == Short.TYPE) {
                return new Short(0);
            }
            if (rt == Integer.TYPE) {
                return new Integer(0);
            }
            if (rt == Long.TYPE) {
                return new Long(0L);
            }
            if (rt == Float.TYPE) {
                return new Float(0.0f);
            }
            if (rt == Double.TYPE) {
                return new Double(0.0);
            }
            return null;
        }

        public boolean matches(String name, Class[] parameterTypes) {
            return this.m.getName().equals(name) && Arrays.equals(this.parameterTypes, parameterTypes);
        }

        @Override
        public Class getReturnType() {
            return this.m.getReturnType();
        }

        public static RubyClass createJavaProxyMethodClass(Ruby runtime, RubyModule javaProxyModule) {
            RubyClass result = javaProxyModule.defineClassUnder("JavaProxyMethod", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
            CallbackFactory callbackFactory = runtime.callbackFactory(ProxyMethodImpl.class);
            JavaProxyReflectionObject.registerRubyMethods(runtime, result);
            result.defineFastMethod("argument_types", callbackFactory.getFastMethod("argument_types"));
            result.defineFastMethod("declaring_class", callbackFactory.getFastMethod("getDeclaringClass"));
            result.defineFastMethod("super?", callbackFactory.getFastMethod("super_p"));
            result.defineFastMethod("arity", callbackFactory.getFastMethod("arity"));
            result.defineFastMethod("name", callbackFactory.getFastMethod("name"));
            result.defineFastMethod("inspect", callbackFactory.getFastMethod("inspect"));
            result.defineFastMethod("invoke", callbackFactory.getFastOptMethod("do_invoke"));
            return result;
        }

        public RubyObject name() {
            return this.getRuntime().newString(this.getName());
        }

        @Override
        public JavaProxyClass getDeclaringClass() {
            return this.clazz;
        }

        public RubyArray argument_types() {
            return this.buildRubyArray(this.getParameterTypes());
        }

        public IRubyObject super_p() {
            return this.hasSuperImplementation() ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
        }

        public RubyFixnum arity() {
            return this.getRuntime().newFixnum(this.getArity());
        }

        protected String nameOnInspection() {
            return this.getDeclaringClass().nameOnInspection() + "/" + this.getName();
        }

        @Override
        public IRubyObject inspect() {
            StringBuffer result = new StringBuffer();
            result.append(this.nameOnInspection());
            result.append("(");
            Class[] parameterTypes = this.getParameterTypes();
            for (int i = 0; i < parameterTypes.length; ++i) {
                result.append(parameterTypes[i].getName());
                if (i >= parameterTypes.length - 1) continue;
                result.append(',');
            }
            result.append(")>");
            return this.getRuntime().newString(result.toString());
        }

        public IRubyObject do_invoke(IRubyObject[] nargs) {
            if (nargs.length != 1 + this.getArity()) {
                throw this.getRuntime().newArgumentError(nargs.length, 1 + this.getArity());
            }
            IRubyObject invokee = nargs[0];
            if (!(invokee instanceof JavaObject)) {
                throw this.getRuntime().newTypeError("invokee not a java object");
            }
            Object receiver_value = ((JavaObject)invokee).getValue();
            Object[] arguments = new Object[nargs.length - 1];
            System.arraycopy(nargs, 1, arguments, 0, arguments.length);
            Class[] parameterTypes = this.getParameterTypes();
            for (int i = 0; i < arguments.length; ++i) {
                arguments[i] = JavaUtil.convertRubyToJava((IRubyObject)arguments[i], parameterTypes[i]);
            }
            try {
                Object javaResult = this.sm.invoke(receiver_value, arguments);
                return JavaUtil.convertJavaToRuby(this.getRuntime(), javaResult, this.getReturnType());
            }
            catch (IllegalArgumentException e) {
                throw this.getRuntime().newTypeError("expected " + this.argument_types().inspect());
            }
            catch (IllegalAccessException iae) {
                throw this.getRuntime().newTypeError("illegal access on '" + this.sm.getName() + "': " + iae.getMessage());
            }
            catch (InvocationTargetException ite) {
                ite.getTargetException().printStackTrace();
                this.getRuntime().getJavaSupport().handleNativeException(ite.getTargetException());
                return this.getRuntime().getNil();
            }
        }

        private int getArity() {
            return this.getParameterTypes().length;
        }
    }
}

